/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report;

import com.stimulsoft.base.EventArgs;
import com.stimulsoft.base.StiAppFunctions;
import com.stimulsoft.base.StiConvert;
import com.stimulsoft.base.StiToken;
import com.stimulsoft.base.exception.StiParserException;
import com.stimulsoft.base.parser.StiCSharpScriptParser;
import com.stimulsoft.base.parser.StiCSharpScriptParserOptions;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiSystemVariablesHelper;
import com.stimulsoft.report.dictionary.StiUserFunction;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObject;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.dictionary.functions.StiFunction;
import com.stimulsoft.report.dictionary.functions.StiFunctionsData;
import com.stimulsoft.report.dictionary.userFunction.helpers.StiUserFunctionHelper;
import com.stimulsoft.report.engine.StiParserParameters;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.enums.StiCalculationMode;
import com.stimulsoft.report.enums.StiReportLanguageType;
import com.stimulsoft.report.events.StiEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class StiScriptHelper {
    private static final HashMap<String, TokenCache> tokensCacheDict = new HashMap();
    private static final HashMap<String, HashMap> typesCacheDict = new HashMap();
    private static boolean allowCaching;

    public static boolean getAllowCaching() {
        return allowCaching;
    }

    public static void setAllowCaching(boolean value) {
        allowCaching = value;
    }

    public static Object invokeEventScript(StiReport report, Object sender, StiEvent ev) {
        return StiScriptHelper.invokeEventScript(report, sender, ev, null);
    }

    public static Object invokeEventScript(StiReport report, Object sender, StiEvent ev, EventArgs args) {
        boolean allow;
        if (StiValidationUtil.isNullOrEmpty((String)ev.getScript())) {
            return null;
        }
        boolean bl = allow = ev == null || !ev.getScript().startsWith("<xml xmlns=\"https://developers.google.com/blockly/xml\">");
        if (report == null && StiOptions.Engine.allowScriptsToRun || StiScriptHelper.isAllowScriptsToRun(report) && allow) {
            if (args == null) {
                args = EventArgs.Empty;
            }
            String script = ev == null ? null : ev.getScript();
            StiCSharpScriptParser parser = StiScriptHelper.createParser(report, script);
            parser.setExternalObjectsProvider((StiCSharpScriptParser.IExternalObjectsProvider)(report != null ? new ObjectsProvider(report) : null));
            if (report != null) {
                parser.setExternalTypesCache(StiScriptHelper.getTypesCache(report));
            }
            if (report != null) {
                parser.setThisObject((Object)report);
            }
            if (sender != null) {
                parser.setVariable("sender", sender);
            }
            if (args != null) {
                parser.setVariable("e", (Object)args);
            }
            int timeout = StiScriptHelper.getScriptTimeout(report) * 1000;
            return parser.execute(timeout);
        }
        return null;
    }

    public static Object invokeScript(StiReport report, String script) {
        return StiScriptHelper.invokeScript(report, script, null);
    }

    public static Object invokeScript(StiReport report, String script, HashMap<String, Object> arguments) {
        return StiScriptHelper.invokeScript(report, script, arguments, null);
    }

    public static Object invokeScript(StiReport report, String script, HashMap<String, Object> arguments, StiCSharpScriptParserOptions options) {
        if (report == null && StiOptions.Engine.allowScriptsToRun || StiScriptHelper.isAllowScriptsToRun(report)) {
            StiCSharpScriptParser parser = StiScriptHelper.createParser(report, script, options);
            if (arguments != null) {
                for (String key : arguments.keySet()) {
                    parser.setVariable(key, arguments.get(key));
                }
            }
            parser.setExternalObjectsProvider((StiCSharpScriptParser.IExternalObjectsProvider)new ObjectsProvider(report));
            parser.setThisObject((Object)report);
            parser.setExternalTypesCache(StiScriptHelper.getTypesCache(report));
            int timeout = StiScriptHelper.getScriptTimeout(report) * 1000;
            return parser.execute(timeout);
        }
        return null;
    }

    private static StiCSharpScriptParser createParser(StiReport report, String script) {
        return StiScriptHelper.createParser(report, script, null);
    }

    private static StiCSharpScriptParser createParser(StiReport report, String script, StiCSharpScriptParserOptions options) {
        StiCSharpScriptParser parser;
        ArrayList tokens = null;
        StiRefObject tempOutTokens = new StiRefObject(tokens);
        ArrayList positions = null;
        StiRefObject tempOutPositions = new StiRefObject(positions);
        boolean hasCachedTokens = StiScriptHelper.tryGetTokensCache(report, script, (StiRefObject<ArrayList<StiToken>>)tempOutTokens, (StiRefObject<ArrayList<StiCSharpScriptParser.TokenPosition>>)tempOutPositions);
        positions = (ArrayList)tempOutPositions.argvalue;
        tokens = (ArrayList)tempOutTokens.argvalue;
        StiCSharpScriptParser stiCSharpScriptParser = parser = hasCachedTokens ? new StiCSharpScriptParser(script, tokens, positions, options) : new StiCSharpScriptParser(script, options);
        if (!hasCachedTokens && parser != null) {
            StiScriptHelper.saveTokensToCache(report, script, parser.getTokens(), parser.getTokenPositions());
        }
        return parser;
    }

    public static boolean isEventScript(StiReport report, StiEvent ev) {
        return ev != null && !StiValidationUtil.isNullOrEmpty((String)ev.getScript()) && !ev.getScript().startsWith("<xml xmlns=\"https://developers.google.com/blockly/xml\">") && StiScriptHelper.isAllowScriptsToRun(report);
    }

    private static int getScriptTimeout(StiReport report) {
        return report != null ? report.getScriptTimeout() * 1000 : 10000;
    }

    public static void clearCache() {
        StiScriptHelper.clearCache(null);
    }

    public static void clearCache(StiReport report) {
        StiScriptHelper.clearTokensCache(report);
        StiScriptHelper.clearTypesCache(report);
    }

    public static boolean isAllowScriptsToRun(StiReport report) {
        return report != null && report.getCalculationMode() == StiCalculationMode.Interpretation && report.isAllowScriptsToRun() && report.getScriptLanguage() == StiReportLanguageType.CSharp && StiOptions.Engine.allowScriptsToRun;
    }

    public static Object parseTextValue(String expression, StiComponent component) {
        if (StiScriptHelper.isScriptInExpression(expression, component)) {
            return StiScriptHelper.invokeScript(component.getReport(), expression);
        }
        return StiParser.ParseTextValue(expression, component);
    }

    public static Object parseTextValue(String expression, StiComponent component, Object sender) {
        if (StiScriptHelper.isScriptInExpression(expression, component)) {
            return StiScriptHelper.invokeScript(component.getReport(), expression);
        }
        return StiParser.parseTextValue(expression, component);
    }

    public static Object parseTextValue(String expression, StiComponent component, StiParserParameters parameters) {
        if (StiScriptHelper.isScriptInExpression(expression, component)) {
            return StiScriptHelper.invokeScript(component.getReport(), expression);
        }
        return StiParser.parseTextValue(expression, component, parameters);
    }

    public static Object parseTextValue(String expression, StiComponent component, StiRefObject<Boolean> storeToPrint, boolean executeIfStoreToPrint, boolean returnAsmList) {
        if (StiScriptHelper.isScriptInExpression(expression, component)) {
            return null;
        }
        return StiParser.parseTextValue(expression, component, storeToPrint, executeIfStoreToPrint, returnAsmList, false);
    }

    public static boolean isScriptInExpression(String expression, StiComponent component) {
        return StiScriptHelper.isScriptInExpression(expression, component == null ? null : component.getReport());
    }

    public static boolean isScriptInExpression(String expression, StiReport report) {
        return StiScriptHelper.isScriptInExpression(expression, report, true);
    }

    public static boolean isScriptInExpression(String expression, StiReport report, boolean checkBraces) {
        if (report != null && report.isAllowScriptsInExpressions() && StiScriptHelper.isAllowScriptsToRun(report) && !StiValidationUtil.isNullOrEmpty((String)expression)) {
            if (checkBraces) {
                int indexLeft = expression.indexOf("{");
                if (indexLeft == -1) {
                    return false;
                }
                int indexRight = expression.lastIndexOf("}");
                if (indexRight == -1) {
                    return false;
                }
                int indexReturn = expression.indexOf("return ");
                return indexReturn != -1 && indexLeft < indexReturn && indexReturn < indexRight;
            }
            return expression.contains("return ");
        }
        return false;
    }

    public static StiParserException checkExpression(String expression, StiComponent component, boolean useAliases, Class returnType) {
        return StiScriptHelper.checkExpression(expression, component, useAliases, returnType, null);
    }

    public static StiParserException checkExpression(String expression, StiComponent component, boolean useAliases) {
        return StiScriptHelper.checkExpression(expression, component, useAliases, null, null);
    }

    public static StiParserException checkExpression(String expression, StiComponent component) {
        return StiScriptHelper.checkExpression(expression, component, false, null, null);
    }

    public static StiParserException checkExpression(String expression, StiComponent component, boolean useAliases, Class returnType, HashMap<String, Object> constants) {
        if (StiScriptHelper.isScriptInExpression(expression, component)) {
            return null;
        }
        return StiParser.checkExpression(expression, component, useAliases);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearTypesCache(StiReport report) {
        HashMap<String, TokenCache> hashMap = tokensCacheDict;
        synchronized (hashMap) {
            if (report != null) {
                tokensCacheDict.keySet().stream().filter(k -> k == report.getReportGuid()).collect(Collectors.toList()).forEach(t -> tokensCacheDict.remove(t));
            } else {
                tokensCacheDict.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap getTypesCache(StiReport report) {
        HashMap<String, HashMap> hashMap = typesCacheDict;
        synchronized (hashMap) {
            HashMap hash;
            HashMap hashMap2 = hash = typesCacheDict.containsKey(report.getReportGuid()) ? typesCacheDict.get(report.getReportGuid()) : null;
            if (hash == null) {
                hash = new HashMap();
                typesCacheDict.put(report.getReportGuid(), hash);
            }
            return hash;
        }
    }

    private static String getTokensCacheKey(StiReport report, String script) {
        return String.format("%1$s_%2$s", report.getReportGuid(), (script == null ? null : Integer.valueOf(script.hashCode())) != null ? (script == null ? null : Integer.valueOf(script.hashCode())) : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tryGetTokensCache(StiReport report, String script, StiRefObject<ArrayList<StiToken>> tokens, StiRefObject<ArrayList<StiCSharpScriptParser.TokenPosition>> positions) {
        tokens.argvalue = null;
        positions.argvalue = null;
        if (!StiScriptHelper.getAllowCaching() || report == null || StiValidationUtil.isNullOrEmpty((String)script)) {
            return false;
        }
        HashMap<String, TokenCache> hashMap = tokensCacheDict;
        synchronized (hashMap) {
            TokenCache cache;
            if (tokensCacheDict.containsKey(StiScriptHelper.getTokensCacheKey(report, script)) && (cache = tokensCacheDict.get(StiScriptHelper.getTokensCacheKey(report, script))) == cache) {
                tokens.argvalue = cache.getTokens();
                positions.argvalue = cache.getTokenPositions();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveTokensToCache(StiReport report, String script, ArrayList<StiToken> tokens, ArrayList<StiCSharpScriptParser.TokenPosition> positions) {
        if (!StiScriptHelper.getAllowCaching() || report == null || StiValidationUtil.isNullOrEmpty((String)script)) {
            return;
        }
        HashMap<String, TokenCache> hashMap = tokensCacheDict;
        synchronized (hashMap) {
            TokenCache tempVar = new TokenCache();
            tempVar.setTokens(tokens);
            tempVar.setTokenPositions(positions);
            tokensCacheDict.put(StiScriptHelper.getTokensCacheKey(report, script), tempVar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearTokensCache(StiReport report) {
        HashMap<String, TokenCache> hashMap = tokensCacheDict;
        synchronized (hashMap) {
            if (report != null) {
                String key = String.format("%1$s_", report.getReportGuid());
                tokensCacheDict.keySet().stream().filter(k -> k.startsWith(key)).collect(Collectors.toList()).forEach(t -> tokensCacheDict.remove(t));
            } else {
                tokensCacheDict.clear();
            }
        }
    }

    private static class ObjectsProvider
    implements StiCSharpScriptParser.IExternalObjectsProvider {
        private StiReport report;
        private static Hashtable<String, String> systemVariablesCache;
        private static final Object systemVariablesCacheLock;

        public ObjectsProvider(StiReport report) {
            this.report = report;
        }

        public final boolean containsObject(String name) {
            if (ObjectsProvider.containsSystemVariable(name)) {
                return true;
            }
            if (this.report.getDictionary().getDataSources().contains(name)) {
                return true;
            }
            if (this.report.getDictionary().getBusinessObjects().contains(name)) {
                return true;
            }
            if (this.report.getDictionary().getVariables().stream().filter(v -> Objects.equals(name, v.getName())).count() == 1L) {
                return true;
            }
            for (StiPage page : this.report.getPages()) {
                boolean result = this.containsInContainer(page, name);
                if (!result) continue;
                return true;
            }
            return false;
        }

        public final boolean isReadOnlyObject(String name) {
            if (ObjectsProvider.containsSystemVariable(name)) {
                return false;
            }
            if (this.containsObject(name)) {
                return this.report.getDictionary().getVariables().get(name).getReadOnly();
            }
            return false;
        }

        public final Object getObject(String name) {
            if (ObjectsProvider.containsSystemVariable(name)) {
                return this.getSystemVariable(name);
            }
            if (this.report.getDictionary().getDataSources().contains(name)) {
                return this.report.getDictionary().getDataSources().get(name);
            }
            if (this.report.getDictionary().getBusinessObjects().contains(name)) {
                return this.report.getDictionary().getBusinessObjects().get(name);
            }
            for (StiPage page : this.report.getPages()) {
                Object result;
                StiRefObject tempOutResult;
                if (this.getResultFromContainer(page, name, (StiRefObject<Object>)(tempOutResult = new StiRefObject(result = null)))) {
                    result = tempOutResult.argvalue;
                    return result;
                }
                result = tempOutResult.argvalue;
            }
            return this.report.get(name);
        }

        private Object getSystemVariable(String name) {
            switch (name) {
                case "Column": {
                    return this.report.getColumn();
                }
                case "Line": {
                    return this.report.getLine();
                }
                case "LineThrough": {
                    return this.report.LineThrough;
                }
                case "LineABC": {
                    return this.report.LineABC;
                }
                case "LineRoman": {
                    return this.report.LineRoman;
                }
                case "GroupLine": {
                    return this.report.GroupLine;
                }
                case "PageNumber": {
                    return this.report.getPageNumber();
                }
                case "PageNumberThrough": {
                    return this.report.getPageNumberThrough();
                }
                case "PageNofM": {
                    return this.report.getPageNofM();
                }
                case "PageNofMThrough": {
                    return this.report.getPageNofMThrough();
                }
                case "TotalPageCount": {
                    return this.report.getTotalPageCount();
                }
                case "TotalPageCountThrough": {
                    return this.report.getTotalPageCountThrough();
                }
                case "IsFirstPage": {
                    return this.report.getIsFirstPage();
                }
                case "IsFirstPageThrough": {
                    return this.report.getIsFirstPageThrough();
                }
                case "IsLastPage": {
                    return this.report.getIsLastPage();
                }
                case "IsLastPageThrough": {
                    return this.report.getIsLastPageThrough();
                }
                case "PageCopyNumber": {
                    return 0;
                }
                case "ReportAlias": {
                    return this.report.getReportAlias();
                }
                case "ReportAuthor": {
                    return this.report.getReportAuthor();
                }
                case "ReportChanged": {
                    return this.report.getReportChanged();
                }
                case "ReportCreated": {
                    return this.report.getReportCreated();
                }
                case "ReportDescription": {
                    return this.report.getReportDescription();
                }
                case "ReportName": {
                    return this.report.getReportName();
                }
                case "Time": {
                    return null;
                }
                case "Today": {
                    return null;
                }
            }
            return null;
        }

        public final boolean isObjectSupportsNesting(Object value) {
            return value instanceof StiDataSource || value instanceof StiBusinessObject;
        }

        public final boolean containsNestedObject(Object value, String path) {
            String parentName = null;
            if (value instanceof StiDataSource) {
                parentName = ((StiDataSource)value).getName();
            }
            if (parentName == null) {
                return false;
            }
            return StiDataColumn.IsDataPathExists(this.report.getDictionary(), parentName + "." + path);
        }

        public final boolean getNestedObject(Object value, String path, StiRefObject<Object> result) {
            if (!this.containsNestedObject(value, path)) {
                result.argvalue = null;
                return false;
            }
            String parentName = null;
            if (value instanceof StiDataSource) {
                parentName = ((StiDataSource)value).getName();
            }
            if (parentName == null) {
                result.argvalue = null;
                return false;
            }
            result.argvalue = StiDataColumn.GetDataFromDataColumn(this.report.getDictionary(), parentName + "." + path, false);
            return true;
        }

        public final void setObject(String name, Object value) {
            if (!this.containsObject(name)) {
                throw new StiCSharpScriptParser.ScriptException(String.format("Variable '%1$s' doesn't exist.", name));
            }
            this.report.set(name, ObjectsProvider.containsSystemVariable(name) ? value : StiConvert.changeType((Object)value, this.report.getDictionary().getVariables().get(name).getType().getClass()));
        }

        public final boolean containsFunction(String name, Class[] argumentTypes) {
            return this.getUserFunction(name, argumentTypes) != null || this.getReportFunction(name, argumentTypes) != null;
        }

        public final Object invokeFunction(String name, Object[] arguments, Class[] argumentTypes) {
            if (Objects.equals(name, "ToQueryString")) {
                return ObjectsProvider.invokeToQueryStringFunction(arguments);
            }
            List<Class> typeList = Arrays.asList(arguments).stream().map(a -> a == null ? Object.class : a.getClass()).collect(Collectors.toList());
            StiFunction reportFunction = this.getReportFunction(name, argumentTypes);
            if (reportFunction != null) {
                return this.invokeReportFunction(reportFunction, arguments, typeList);
            }
            StiUserFunction userFunction = this.getUserFunction(name, argumentTypes);
            if (userFunction != null) {
                return this.invokeUserFunction(userFunction, arguments, typeList);
            }
            throw new StiCSharpScriptParser.ScriptException(String.format("Function '%1$s' doesn't exist.", name));
        }

        private Object invokeReportFunction(StiFunction function, Object[] arguments, List<Class> typeList) {
            return function.invoke(Arrays.asList(arguments));
        }

        private Object invokeUserFunction(StiUserFunction function, Object[] arguments, List<Class> typeList) {
            return StiUserFunctionHelper.invokeFunction(function, this.report, arguments);
        }

        private static Object invokeToQueryStringFunction(Object[] arguments) {
            ArrayList list = new ArrayList((List)arguments[0]);
            list.stream().map(a -> a.toString()).collect(Collectors.toList());
            return StiFunctionsData.toQueryString(list, (String)arguments[1], (String)arguments[2]);
        }

        private boolean isParameterTypesMatch(Class<?>[] expectedTypes, Class<?>[] actualTypes) {
            return expectedTypes.length == actualTypes.length;
        }

        private boolean isConvertible(Class fromType, Class toType) {
            return false;
        }

        private StiFunction getReportFunction(String functionName, Class<?>[] argumentTypes) {
            List list;
            List list2 = list = StiAppFunctions.functionsToCompile.containsKey(functionName) ? (List)StiAppFunctions.functionsToCompile.get(functionName) : null;
            if (list == null || list.size() == 0) {
                return null;
            }
            if (list.size() != 1) {
                return list.stream().map(c -> (StiFunction)c).filter(f -> this.isParameterTypesMatch(argumentTypes, argumentTypes)).findFirst().get();
            }
            return list.stream().map(c -> (StiFunction)c).findFirst().get();
        }

        private StiUserFunction getUserFunction(String functionName, Class[] argumentTypes) {
            List list = this.report.getDictionary().getUserFunctions().stream().filter(f -> Objects.equals(f.getName(), functionName)).collect(Collectors.toList());
            if (list == null || list.size() == 0) {
                return null;
            }
            if (list.size() == 1) {
                return (StiUserFunction)((Object)list.get(0));
            }
            return list.stream().filter(f -> this.isParameterTypesMatch(f.getArguments().getArgumentTypes(), argumentTypes)).findFirst().orElse(null);
        }

        private boolean containsInContainer(StiContainer parent, String name) {
            if (Objects.equals(parent.getName(), name)) {
                return true;
            }
            for (StiComponent comp : parent.getComponents()) {
                StiContainer cont;
                boolean result;
                if (!(comp instanceof StiContainer ? (result = this.containsInContainer(cont = (StiContainer)comp, name)) : Objects.equals(comp.getName(), name))) continue;
                return true;
            }
            return false;
        }

        private boolean getResultFromContainer(StiContainer parent, String name, StiRefObject<Object> result) {
            if (Objects.equals(parent.getName(), name)) {
                result.argvalue = parent;
                return true;
            }
            for (StiComponent comp : parent.getComponents()) {
                if (comp instanceof StiContainer) {
                    StiContainer cont = (StiContainer)comp;
                    StiRefObject tempOutResult2 = new StiRefObject(null);
                    if (!this.getResultFromContainer(cont, name, (StiRefObject<Object>)tempOutResult2)) continue;
                    result.argvalue = tempOutResult2.argvalue;
                    return true;
                }
                if (!Objects.equals(comp.getName(), name)) continue;
                result.argvalue = comp;
                return true;
            }
            result.argvalue = null;
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Hashtable<String, String> getSystemVariables() {
            Object object = systemVariablesCacheLock;
            synchronized (object) {
                if (systemVariablesCache == null) {
                    systemVariablesCache = new Hashtable();
                    StiSystemVariablesHelper.SYSTEM_VARIABLES.stream().forEach(v -> systemVariablesCache.put((String)v, (String)v));
                    StiSystemVariablesHelper.SYSTEM_VARIABLES_V2.stream().forEach(v -> systemVariablesCache.put((String)v, (String)v));
                }
            }
            return systemVariablesCache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean containsSystemVariable(String name) {
            Object object = systemVariablesCacheLock;
            synchronized (object) {
                return ObjectsProvider.getSystemVariables().containsKey(name);
            }
        }

        static {
            systemVariablesCacheLock = new Object();
        }
    }

    private static class TokenCache {
        private ArrayList<StiToken> tokens;
        private ArrayList<StiCSharpScriptParser.TokenPosition> tokenPositions;

        private TokenCache() {
        }

        public final ArrayList<StiToken> getTokens() {
            return this.tokens;
        }

        public final void setTokens(ArrayList<StiToken> value) {
            this.tokens = value;
        }

        public final ArrayList<StiCSharpScriptParser.TokenPosition> getTokenPositions() {
            return this.tokenPositions;
        }

        public final void setTokenPositions(ArrayList<StiCSharpScriptParser.TokenPosition> value) {
            this.tokenPositions = value;
        }
    }
}

