/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.service.StiExportService;
import com.stimulsoft.report.export.settings.StiBmpExportSettings;
import com.stimulsoft.report.export.settings.StiCsvExportSettings;
import com.stimulsoft.report.export.settings.StiExcel2007ExportSettings;
import com.stimulsoft.report.export.settings.StiExcelExportSettings;
import com.stimulsoft.report.export.settings.StiExcelXmlExportSettings;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.settings.StiHtmlExportSettings;
import com.stimulsoft.report.export.settings.StiJpegExportSettings;
import com.stimulsoft.report.export.settings.StiOdsExportSettings;
import com.stimulsoft.report.export.settings.StiOdtExportSettings;
import com.stimulsoft.report.export.settings.StiPcxExportSettings;
import com.stimulsoft.report.export.settings.StiPdfExportSettings;
import com.stimulsoft.report.export.settings.StiPngExportSettings;
import com.stimulsoft.report.export.settings.StiPowerPointExportSettings;
import com.stimulsoft.report.export.settings.StiRtfExportSettings;
import com.stimulsoft.report.export.settings.StiSvgExportSettings;
import com.stimulsoft.report.export.settings.StiSvgzExportSettings;
import com.stimulsoft.report.export.settings.StiSylkExportSettings;
import com.stimulsoft.report.export.settings.StiTxtExportSettings;
import com.stimulsoft.report.export.settings.StiWordExportSettings;
import com.stimulsoft.report.export.settings.StiXmlExportSettings;
import com.stimulsoft.report.export.settings.StiXpsExportSettings;
import java.io.OutputStream;

public class StiExportManager {
    private StiExportManager() {
    }

    private static <T extends StiExportSettings> T getDefaultSettings(StiReport report, Class<T> clazz) {
        try {
            if (report.getExportSettings() != null) {
                for (StiExportSettings settings : report.getExportSettings()) {
                    if (!settings.getClass().equals(clazz)) continue;
                    return (T)settings;
                }
            }
            return (T)((StiExportSettings)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void exportPdf(StiReport report, OutputStream stream) throws StiException {
        StiExportManager.exportPdf(report, StiExportManager.getDefaultSettings(report, StiPdfExportSettings.class), stream);
    }

    public static void exportPdf(StiReport report, StiPdfExportSettings settings, OutputStream stream) throws StiException {
        StiExportManager.export(StiExportFormat.Pdf, report, settings, stream);
    }

    public static void exportOdt(StiReport report, OutputStream stream) throws StiException {
        StiExportManager.exportOdt(report, StiExportManager.getDefaultSettings(report, StiOdtExportSettings.class), stream);
    }

    public static void exportOdt(StiReport report, StiOdtExportSettings settings, OutputStream stream) throws StiException {
        StiExportManager.export(StiExportFormat.Odt, report, settings, stream);
    }

    public static void exportOds(StiReport report, OutputStream stream) throws StiException {
        StiExportManager.exportOds(report, StiExportManager.getDefaultSettings(report, StiOdsExportSettings.class), stream);
    }

    public static void exportOds(StiReport report, StiOdsExportSettings settings, OutputStream stream) throws StiException {
        StiExportManager.export(StiExportFormat.Ods, report, settings, stream);
    }

    public static void exportHtml(StiReport report, OutputStream stream) throws StiException {
        StiExportManager.exportHtml(report, StiExportManager.getDefaultSettings(report, StiHtmlExportSettings.class), stream);
    }

    public static void exportHtml(StiReport report, StiHtmlExportSettings settings, OutputStream stream) throws StiException {
        StiExportManager.export(StiExportFormat.Html, report, settings, stream);
    }

    public static void exportText(StiReport report, OutputStream stream) throws StiException {
        StiExportManager.exportText(report, StiExportManager.getDefaultSettings(report, StiTxtExportSettings.class), stream);
    }

    public static void exportText(StiReport report, StiTxtExportSettings settings, OutputStream stream) throws StiException {
        StiExportManager.export(StiExportFormat.Text, report, settings, stream);
    }

    public static void exportRtf(StiReport report, OutputStream stream) throws StiException {
        StiExportManager.exportRtf(report, StiExportManager.getDefaultSettings(report, StiRtfExportSettings.class), stream);
    }

    public static void exportRtf(StiReport report, StiRtfExportSettings settings, OutputStream stream) throws StiException {
        StiExportManager.export(StiExportFormat.Rtf, report, settings, stream);
    }

    public static void exportXps(StiReport report, OutputStream stream) throws StiException {
        StiExportManager.exportXps(report, StiExportManager.getDefaultSettings(report, StiXpsExportSettings.class), stream);
    }

    public static void exportXps(StiReport report, StiXpsExportSettings settings, OutputStream stream) throws StiException {
        StiExportManager.export(StiExportFormat.Xps, report, settings, stream);
    }

    public static void exportCsv(StiReport report, OutputStream stream) throws StiException {
        StiExportManager.exportCsv(report, StiExportManager.getDefaultSettings(report, StiCsvExportSettings.class), stream);
    }

    public static void exportCsv(StiReport report, StiCsvExportSettings settings, OutputStream stream) throws StiException {
        StiExportManager.export(StiExportFormat.Csv, report, settings, stream);
    }

    public static void exportSylk(StiReport report, OutputStream stream) throws StiException {
        StiExportManager.exportSylk(report, StiExportManager.getDefaultSettings(report, StiSylkExportSettings.class), stream);
    }

    public static void exportSylk(StiReport report, StiSylkExportSettings settings, OutputStream stream) throws StiException {
        StiExportManager.export(StiExportFormat.Sylk, report, settings, stream);
    }

    public static void exportXml(StiReport report, OutputStream stream) throws StiException {
        StiExportManager.exportXml(report, StiExportManager.getDefaultSettings(report, StiXmlExportSettings.class), stream);
    }

    public static void exportXml(StiReport report, StiXmlExportSettings settings, OutputStream stream) throws StiException {
        StiExportManager.export(StiExportFormat.Xml, report, settings, stream);
    }

    public static void exportWord2007(StiReport report, OutputStream stream) throws StiException {
        StiExportManager.exportWord2007(report, StiExportManager.getDefaultSettings(report, StiWordExportSettings.class), stream);
    }

    public static void exportWord2007(StiReport report, StiWordExportSettings settings, OutputStream stream) throws StiException {
        StiExportManager.exportWord(report, settings, stream);
    }

    public static void exportWord(StiReport report, OutputStream stream) throws StiException {
        StiExportManager.exportWord(report, StiExportManager.getDefaultSettings(report, StiWordExportSettings.class), stream);
    }

    public static void exportWord(StiReport report, StiWordExportSettings settings, OutputStream stream) throws StiException {
        StiExportManager.export(StiExportFormat.Word, report, settings, stream);
    }

    public static void exportExcelXml(StiReport report, OutputStream stream) throws StiException {
        StiExportManager.exportExcelXml(report, StiExportManager.getDefaultSettings(report, StiExcelXmlExportSettings.class), stream);
    }

    public static void exportExcelXml(StiReport report, StiExcelXmlExportSettings settings, OutputStream stream) throws StiException {
        StiExportManager.export(StiExportFormat.ExcelXml, report, settings, stream);
    }

    @Deprecated
    public static void exportExcel2007(StiReport report, OutputStream stream) throws StiException {
        StiExportManager.exportExcel2007(report, StiExportManager.getDefaultSettings(report, StiExcel2007ExportSettings.class), stream);
    }

    @Deprecated
    public static void exportExcel2007(StiReport report, StiExcel2007ExportSettings settings, OutputStream stream) throws StiException {
        StiExportManager.exportExcel(report, settings, stream);
    }

    public static void exportExcel(StiReport report, OutputStream stream) throws StiException {
        StiExportManager.exportExcel(report, StiExportManager.getDefaultSettings(report, StiExcelExportSettings.class), stream);
    }

    public static void exportExcel(StiReport report, StiExcelExportSettings settings, OutputStream stream) throws StiException {
        StiExportManager.export(StiExportFormat.Excel, report, settings, stream);
    }

    public static void exportExcelBiff(StiReport report, OutputStream stream) throws StiException {
        StiExportManager.exportExcelBiff(report, StiExportManager.getDefaultSettings(report, StiExcelExportSettings.class), stream);
    }

    public static void exportExcelBiff(StiReport report, StiExcelExportSettings settings, OutputStream stream) throws StiException {
        StiExportManager.export(StiExportFormat.ExcelBiff, report, settings, stream);
    }

    public static void exportImageBmp(StiReport report, OutputStream stream) throws StiException {
        StiExportManager.exportImageBmp(report, StiExportManager.getDefaultSettings(report, StiBmpExportSettings.class), stream);
    }

    public static void exportImageBmp(StiReport report, StiBmpExportSettings settings, OutputStream stream) throws StiException {
        StiExportManager.export(StiExportFormat.ImageBmp, report, settings, stream);
    }

    public static void exportImageJpeg(StiReport report, OutputStream stream) throws StiException {
        StiExportManager.exportImageJpeg(report, StiExportManager.getDefaultSettings(report, StiJpegExportSettings.class), stream);
    }

    public static void exportImageJpeg(StiReport report, StiJpegExportSettings settings, OutputStream stream) throws StiException {
        StiExportManager.export(StiExportFormat.ImageJpeg, report, settings, stream);
    }

    public static void exportImagePng(StiReport report, OutputStream stream) throws StiException {
        StiExportManager.exportImagePng(report, StiExportManager.getDefaultSettings(report, StiPngExportSettings.class), stream);
    }

    public static void exportImagePng(StiReport report, StiPngExportSettings settings, OutputStream stream) throws StiException {
        StiExportManager.export(StiExportFormat.ImagePng, report, settings, stream);
    }

    public static void exportImageSvg(StiReport report, OutputStream stream) throws StiException {
        StiExportManager.exportImageSvg(report, StiExportManager.getDefaultSettings(report, StiSvgExportSettings.class), stream);
    }

    public static void exportImageSvg(StiReport report, StiSvgExportSettings settings, OutputStream stream) throws StiException {
        StiExportManager.export(StiExportFormat.ImageSvg, report, settings, stream);
    }

    public static void exportImageSvgz(StiReport report, OutputStream stream) throws StiException {
        StiExportManager.exportImageSvgz(report, StiExportManager.getDefaultSettings(report, StiSvgzExportSettings.class), stream);
    }

    public static void exportImageSvgz(StiReport report, StiSvgzExportSettings settings, OutputStream stream) throws StiException {
        StiExportManager.export(StiExportFormat.ImageSvgz, report, settings, stream);
    }

    public static void exportImagePcx(StiReport report, OutputStream stream) throws StiException {
        StiExportManager.exportImagePcx(report, StiExportManager.getDefaultSettings(report, StiPcxExportSettings.class), stream);
    }

    public static void exportImagePcx(StiReport report, StiPcxExportSettings settings, OutputStream stream) throws StiException {
        StiExportManager.export(StiExportFormat.ImagePcx, report, settings, stream);
    }

    public static void exportPowerPoint(StiReport report, StiPowerPointExportSettings settings, OutputStream stream) throws StiException {
        StiExportManager.export(StiExportFormat.PowerPoint, report, settings, stream);
    }

    public static void exportPowerPoint(StiReport report, OutputStream stream) throws StiException {
        StiExportManager.export(StiExportFormat.PowerPoint, report, StiExportManager.getDefaultSettings(report, StiPowerPointExportSettings.class), stream);
    }

    private static void export(StiExportFormat format, StiReport report, StiExportSettings settings, OutputStream stream) throws StiException {
        StiExportService exportService = format.getExportService();
        exportService.export(report, stream, settings);
    }
}

