/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.lib.io;

import com.stimulsoft.lib.io.StiCloseUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class StiLineIterator
implements Iterator<String> {
    private final BufferedReader bufferedReader;
    private String currentLine;
    private boolean finished;

    public StiLineIterator(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("Reader must not be null");
        }
        this.bufferedReader = this.createBufferedReader(reader);
    }

    private BufferedReader createBufferedReader(Reader reader) {
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader);
    }

    @Override
    public boolean hasNext() {
        if (this.currentLine != null) {
            return true;
        }
        if (this.finished) {
            return false;
        }
        return this.readLine();
    }

    private boolean readLine() {
        try {
            String line = this.bufferedReader.readLine();
            if (line == null) {
                this.finished = true;
                return false;
            }
            this.currentLine = line;
            return true;
        }
        catch (IOException ioe) {
            this.close();
            throw new IllegalStateException(ioe);
        }
    }

    @Override
    public String next() {
        return this.nextLine();
    }

    public String nextLine() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more lines");
        }
        String result = this.currentLine;
        this.currentLine = null;
        return result;
    }

    public void close() {
        this.finished = true;
        StiCloseUtil.close((Closeable)this.bufferedReader);
        this.currentLine = null;
    }

    @Override
    @Deprecated
    public void remove() {
        throw new UnsupportedOperationException("Remove unsupported on LineIterator");
    }
}

