var BarCodes = {
  "ReportVersion": "2024.1.3",
  "ReportGuid": "6605f94d517c459c82285ea92fe87839",
  "ReportName": "Bar-Codes",
  "ReportAlias": "Bar-Codes",
  "ReportFile": "BarCodes.mrt",
  "ReportAuthor": "Stimulsoft",
  "ReportDescription": "This sample demonstrates how to create a report with Barсodes.",
  "ReportCreated": "/Date(0+0300)/",
  "ReportChanged": "/Date(0+0300)/",
  "EngineVersion": "EngineV2",
  "CalculationMode": "Interpretation",
  "ReportUnit": "HundredthsOfInch",
  "ScriptLanguage": "CSharp",
  "PreviewSettings": 260042239,
  "ReportIcon": "iVBORw0KGgoAAAANSUhEUgAAASAAAAGWCAMAAADvzq7aAAAAAXNSR0IArs4c6QAAAARnQU1BAACx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\nu9cqAAAAAElFTkSuQmCC",
  "ReportImage": "iVBORw0KGgoAAAANSUhEUgAAASAAAAGWCAMAAADvzq7aAAAAAXNSR0IArs4c6QAAAARnQU1BAACx\njwv8YQUAAAGAUExURfHz901NTW9xc+3x9rG9yvP1+enc0LbF0s7d6JmZnP39/f+0htfl8Mq9uPn5\n+e3t7fT4/OXv9v/Stdzd3vvz6//m1dTDuqauuImHicLO2ePj5C4sLbmbgfXv55mdpgBhssjU3ry9\nv9TU1dvNxczMzsXDxLmuquvj3La0tq6ur9/TyKizvqmbmaOjppOltwAAAGOPsP/68/n+/ralnLO1\nvaWlrL6zrsK1ssHGzePn6/f7/uLr8fDq5c3Gwuzn4t7X0f/++Y2NkNDX3Pn18rWwtK2lprS5wNba\n3/+6j8O6tsPK0OLb166prFlZW6GfotTKxZl8Zo2UnmFkZ6CLgLy3vMS/xKarsVRANfv7+//dyNK0\nm4FmU0FBQrOqp/+xgP/Enzo4OGpURx84Vu/w7aGUkfb49sfIx5SSlNXPz8vIy87R0r3BwuTf3tjY\n2Pn9+tra2rm5uOjn6Pv7/fDw8P/AqOrq6t/g4Xx8fvb3+f/u4KiqqrCxsxYWF/Pi0fDy9v///5p+\nGtgAAAAZdEVYdFNvZnR3YXJlAEFkb2JlIEltYWdlUmVhZHlxyWU8AABueUlEQVR4Xu29i0PiSLo+\nHC4R4QiJiyMQVpcgwUSke6RBbiJydUCBlQGW2cEz7Cp3GcH8ABts61//3grYrd229sx0s7Pf8Wmb\nJJWqStVD1fvUm4QqAr3gSbwQ9AxeCHoGLwQ9gxeCnsELQc/ghaBn8ELQM3gh6Bm8EPQMXgh6Bi8E\nPYMXgp7BC0HP4IWgZ/BC0DP4mKCjdrdr1c8O7mPnyGo9DCCkPaFnIZ/iwP7KNdu9h9XI8mwP5zGc\n7T+ClXPVbO8rYq9tVeDtzrlSOr6HrcjSbE/CyrbxrqD38BFBB3+vVCsV+SPVfPePiqyaX0R/zUvX\nexQHf5cDhR/jr+bF2d53OI+TRzKf4m31+9ne18M/K7LKK5Q6ca38/Enm/7wxzfYk/L2y7j93zA7e\n4+MWVN75Vz5Q3jKhTY5e4wh01LNMT3z3j+/RViVDL6jQUXq/uLRSPARGcuwy2vcNOIh01EujJlxx\nM5UOoDXOnzO50EXPR6O//nsJhaVscB4//3t5h2P9KMYNrctooZd2wckonNzvbMDpgw3IEef1WRp/\nE97+I+/aoRb+IVPpQosHucMjjt7sLKNNH73DLf/TbJpeabNnc6GNf+QP35hHDxoV4BMbdPBzPoD+\n/m/XjzeWf/5b8aaSqX4vlfUdlB43Bjj1d7O8Khv949+Lmr/LMhm4jlxWNa1WMnnFzxmX9h8yaIGr\n5vy/zI6dn/OV7zFB/6xm5NAzgaCFf0FAJiNb+q4Kif5ZleUVf4VrnCCoRKb6Cv0IOS79E/J6pLX/\nDqz8q+JQoL9WK3LmH9/v/EOWN+fl5rzrr+al78yvVs2LuNQ0XK4ycv0IkfJVaG4P8QlBO/m8C61W\nLT9XXv1V/hZY+afZ8s7pXMLfPuyrfgTuoMZm1YLZsWU2vjG/gv3vqq9+NCtJIDf2LzlaNSu3zK92\nZCN0kfr534q//jv4879NJOQtdbFXaC93bn71tpK3YNI1C9CxoMB//7diwfzqXXUEOeK8vk4LQlt5\ns8yi+TnvgqrsyOQHP1eIv/57Gb6z76oOIAiuRK/8AxdZdfCvEVqA0n2Ex1vQd7KI/Ef5z6/2zQ60\nYVZt5fMmzBX6sbr0d5nrxwr9z+riu6rjn9X8SK76p3lx5R/fr/y9kl/+Ob8M0d7949WWWeX61/cb\nslc/VnBp3smrcmAIk/xXs+rv8t4/Xr3FrQayh/yVUD7Tz3KoA3ypkKNjDec1K88fBnQdF9QJEwSX\nhzYOXxhwBMXXmi1vR5V89x+v0Lvqq1+/kKCdfMYFLFW/36j+ewkMUv/vYEIA8G3335i/h97364//\npnGzgu/bfEI1YR8TpPf/1WySZ1w/yxahI0KtD/71/V//DT0SCFq07v9ohlyAIOrvZr4KPABB36O3\nssyh9d0/5MzfK+SP/zZB2/mu+j1lDVpxXlJp/ijeZg+3KnIEhZIIGk0JAqugfGN2gA0K4yv9nMFF\nPoAW/535+48l6JEWhJXon1Xlyr9gZ+tflcxUe7/7l0wme0WjHzOBHzPQbRffVRzon7IK7sKLK/96\n9deK7MT197zr3c8VGTS7isr1MxiczEi2/M9K8O8VGR4ASHk4XH+vjGSvVmTwZUH2+cAGXMOEIB2E\nSjku47w+P5j4Ldj5GTR5Ea3K8v5/fb8D9g9K+Kay9PbnilGmXK0sSqXGRVZCVJCIH6FdP8QnBKFr\nbC3KhAsReEd3q5NCkSYWE2uwrZFIR7jgvIYAImO3gWlcXVkkNIiEJOXba5w+gGI1VLsuky4doSmL\nOC8pDzAuGkJzHTiI4Yx1BBChg0xwkiscFLul0a8iZPl1UL6FYiEomAYyj13j2pUhREdC8aHgUGq4\nkg4XGZ+Fon38xXxK0Ase4IWgZ/CAoJp++IKhfog75R0etiCNRnd2do3K17D3AWWdtJl+vocUZRqv\nXJY2GA8SfnQkYRqk0yGcnXgrHU3xUf5fFaIIpm92aerqfrFmVy2fBcqiRiQ1ZxAwY0PCx11Mc6S/\nIA+Isg6VdToXVORKo1sLaq7Akl0EdHCsQzXIFeFAna7MXEEYWmFcqIZJQgdMoFZGmppGB6QFYn4E\nZlcHAXAI6XTXSMfQUDykowYMiQ6ODkmdpvzrNSZMZFxlyOubYOfywl/W7JNQRnTh15U15QCUHy6n\nK1/QCA6vypvM4JJa05P7H3nTn9igNcVR19/vKlBYcRG9sHaHl/ohY42iNf3lhU3fvdQzQ+bysn+4\neXg5sOqtjO2y61ppDvtDPaNn6IMmnEb7/r3LI9ugqe9etBRos4329VYr5DNkGH2TOGD0fuaie9ld\nRuFDojm8ZJgzPZzRH7W7zKwUXxk7zMHFUTTMNKPLiPLv2S4vh119uH3Z7cIWQrsEWhkwBHPAuNaC\nszQzfELQ3jJD6ZnNIdrE9z0G/s3Dvv7C6kd7zJFVf9H370cHembgh1oxg+Ylo49S3eUV//5lf3ik\n74LfN/QPXUeKvUEYuNAzXT2902279imr/7J/OdzvKjZpdHR52IfklB8dDYE5PxNcYzaj/a6V2e8u\nP2jfXws7+oEesr+wDhQodtE+3NdDAaz+IVSvO+ha+0O00q0xw/7R8tqhNCD5gE8I0ulqulqNIhF1\nS4nXOl2sG9TpzkR0MBB1A0J3rYv1r+GD0p2RugEpEhQxCOCe16drMERCIjEgkG5QK8cocVATY4Mr\nRFFgb8SzI//VGqW7ipEwQCIhSxK6MUXpBrfX5b6OUuj6JCTBg6lvgb1gmVLEbs/EayQOyhTVVZRF\nkYLq1cSBBuqJdH2FblAeDGJ9cZZkhk8I+hgHHyX43RC/TdV/F8rPVvs9vjzm/1G8EPQMXgh6Bi8E\nPYMXgp7BC0HP4IWgZ/BC0DN4IegZvBD0DB4QtPKX34effprtfC189Qx/Gw5mfGA8IOjt//4+/PDL\nbOdr4atn+JvwPzszPjA+Iuh/fhd++MvvTPg5/PLLV87wN+GHr07QV6/PfwlBv/ww2/mfH6Z7s80n\neK4F/fDLL7O9O3wmozv8ZoJ++OWH+ymk7P/3uat8Dl9I0P/+9PYnfAX8//99h3f+9y8//e8P//O/\nP2CeHlz7mfr8708rf/kB2H2f7If//e6XJ0v/mwl6+3blFygbzhT+/t9PEPTDT/BvFvDb8KUt6Lvv\nfvjul+9+evv2u+/+38rbvwBfgLc//QUCfgKqZrEwnmlBmCBI+pdp2u/+39u3P333l++gRrPzn+K3\nEvTD2x/+8t1fVn767u0v30GJcTnf/qT5y3e/vH0Lfw/K+gX4UoJ+gCtBzf7yFv7hWv0Alfvuh7dA\n1V+gIPejPtuCfvrhB/QXSPUTMAPZ/QI5vf3pKxL0P0AQEAG8/OUtXO3/ffcdfCNvf4ANLurbWaQv\nxZcS9BPQsfMLsIG/HKkF4avC8covUIxZJAnPtyBgBjjBOQDXK7gFvf3uiab/O7rY21+AHfhCoQX9\n9ANu97/A1wqs4WY0i/Sl+OIW9AtwJJkObECg1Pjzl/+BtgSt4EHM5+oDJlSyQRj/88P/eyvl+LHd\nvo/fTJBkpOEqP8AQCpf1u7/AnnRRfKlZpC/FlxIEMvBBxz4Al+Cj8v/GcdDztf/NBH0MTNLvxhcT\nhCl6BBD4Ufgfrs/H+OoZ/ib8BoK+EP+HRtK/D1/ddQKC/oP4vC+2AlLze4BHN18VXz3D3wb8Jt0d\nHhBULs92/m/jwTsmDwjSfXWC8FP7GYB/HcLbD2FPPYyuadBOny73A5DJQHqhYFq4WrlPHvR1KCa9\nxai5K3FZg9+0kaDBLxyW8QeGblZDCr9XHIPccAqRksLuA65399rCPAliMrIZGgg55SiSyYj8LESW\nqc9iPYKV7DLSJjurCSVCueQiVHrHq4DiraVnoX26hg6aYR+UGld6w3LgVUAXAKJifjj0U0ARro99\nEX8vaIHnlxDaI8p7rAsdnI4X8fcEucbKCOIFIMUS6pdrUieaJ0GX1VEWQ10ZIaSuZjOZMcpWG1JY\npNqbxXoEC7xlRYk2nFkLWnGjg9TE6nWGIotoq65EW86sCW3wSnRwzm4nN3DoeipbPy3V49qGY6g1\nrXrOlbmUu55Nop1G295JqVBP8VawNIvNQjibdh1sGy62HUL31N20+7zOujDcduz5UGhiQguN5TkT\n1EaiKNZQfoREdUUmG9VQVlYrQ5iGqjxB0Jvxeo33a/lCGu3sLu4LzQlnz74Koq1owV/kCz7krQs0\n8rZ82uz6EtpVC2yqVLf77K/CWav9dJ23nbpzQnqXPvDmlKHjJbRqybGF3cmpamVkQjt2Tttop3rx\n0LFPa2i6U3zDAgTZ6w6kjSzNmaBuvVKp5JF8hDKyvG4kk4lOmcZYrVSd5BME7QzRZmCvKLRJfQCt\nsf6LtC5noerL0MXWcOiFa//I5kJHUaqPQ8NtphgM+6jBWv2sG2Oa0QsrFTZRFONCjC63CDZsJ2dP\nN9OMmNPvXwYOGHHYPGyGty26kL8vMrbg1uLGImLCUXSUJudM0CVnrlYlgi5HMiTP66EFaUbmqjn7\nFEEzPHyfUoKI38Wc7f82fJIqdjjbwTi7mu3M2wZhgsx53MUQa2QjjdZvIUhC7V5534vTB5I+pgvq\nAEHTmtydO6DoA+p+tR8FxK7hdP+ZLiaHI6batlW/qIuhJi6YVJ69OIEHCFB6HSqLQSg9flcVegSW\nZhgpvPPN2ob0Oi9aKbjQ6tJBwYUDNyw4FKFVdyeH9RCy1OhA6HAmV5CsDBlj4C0I2SLa08JoYL4E\nSUaalFoQ0oiIwzaopnvOSB/86Milm7tuYrBx2rCdjo8tdoPXaRO6tpQ7l1UurGujCIWTR3ZfM5Gc\n/lJ2L7Ht2Frvnhq2PN5svaA9gaqurvdM4SWsg6B8aYi04LjgB3alt9ROJLcanbgg/Z7ynVM4jnrZ\nVNbXLNQbi+9HVBjfnKAPMu+01rIDm4xwfonMeydOJ8tql8Jxm1HwpdqnDZ8ActM7TeaO015eLUAL\n2l3aUGkdoURDBeMY9O644dtVT+rHcLLI82oDJiiZKhpcaIcPhvg4DJnQnhA37W073c0EyN+rlG8j\niVvaVqfQTihz46I3zmNRnCNBTOZupKjWyNRdWacnE3uzkCcHikc2Rl/Lwfe717ENB32qH24Pzy5a\n+v6WaUAx1vQQqr9WpFaX9lkmbNmEiCsQxZreY6PW9gXrZzZ9MDDeSy1t4V9z7WnHttsjGpJwZ9ww\ndMhQ+kF/v66nwtEQRFsbMFR/wwKxN4cDLjhPgsACSO+zg0tAgMxrQOYH+B1+GMU+42r8JuBfMj2O\nndb0903vfZKP8chLvPO0QX25XD7S8PkRbCuyirySb8vlRihA2TiZRfksPqEP/4Jktvs5fHL+o4Cn\nMoBT07PzJEhfkctlfHYkG8ll0Nsq8glqZDIkoiaZEcv3Z7Eeg2atCDRqEB6eTL/+nf1uGP9QE9cC\n2iUeD2ElkmRKCoWoIEJYyyAUOk4UaXbYwF0mkvIvuKcVhtP4EP+SBfb3h/Cxwrp2wE+DvbkSJLus\nV6oCVbG2KjIgqIVqyJOpIa4qy1Sq7CzWI9CWbNsO/Wla6zw8dfAWFM75mtoIqwat3lqn0Wp6IdtM\nTAT9m2S8mwWDfbCrTHkOterlHeHSLgimDUNo+yR0bNsu6Xc7oazFW+pJKiZXoc1m8XLDGUq6UJjd\ncKdeHTnfvFpdb5+W0M62o8PYXPMkSFOTG8WKMIDuBSMfpmprywYaEo3kg4xaQzxxOXvdzoacaW2p\nCfqlVaKFbJaNu3O+XVrjjQR3jgPaxnGLbyYa9Xg4AnZ4bds5AWk6DR54e0mtzT5RC202xe26c07f\naqltbyhD7kAfLYCrtZZNOFKNukAg+9JG+lyZagjwZfB1IOg41JH8/FkhML4xQZQaC3q3JoydnnE2\n6xn0Pbr2WNNhNRm5U/3YHCEzvHH0mf1+ashQTLPdBJc+euG/sLYHFwG04aNROG3l9ANm0M9FmX1W\n30I7xehwwIQ69EEo6meoi5xtKDbtJT9EWY1CJuF0OK3rorVcFB1YmaWw76ITAIXULy+krR2mfeHb\nTFnQQahTE+bri+llw05FJJgzCi6khtajOwNXg6xR+jy0KW4W6xFYf8uvnnWf+T1JGN8k+21YgAHo\nXLuYDvUqOjX0MBhJZ6sVq60ydTXwMOipn8no7ntg94BD35+Rfjj9HpLxnu6+V3XNNRi934p5EgQg\nhoi61OsHutHYVs002nKnVT657GYqsgfX/girjdksI2vTXwBCzRdgNHjAuPaK+CdvmIl32QmeBgDr\nED5sDtyM5DkA1kDNwNKbthxNYfHg+O5m6pdhngSJvV6vA38d9rJWMXYiFblGNupVOV0vElE/+P4/\nwkohN+GGzaJ7d31hnT6wW60XqXWfNt1sJgzRLUNuvNgMLJgWOqdKr6HtZuy+shjuHHPc2Mc07Q60\n17I7Amih1Qmp674Fz5+XoEtzdQrzCOUrGTQaEXnw7uutKoOeVLEVu6HJ2uvxpuBbjSwdpFh3ygOq\n1LMbQuM4eFuHuyq0oNzyRurxENuzp1MD216jrWYbnXEOVG0h0fEuoXemfbXlVGmPWD470n4M8yRI\nX+0QAJHKjzTglWXwWCg7kMlGZSRUZE/4Yjv6cDJgXw4rqXqOJUGaNpKX3mjYpz/irfqQ75L2LqK1\nuKXMtYf7l0V/Cg+FbGIzzJ61dDkTWrP6Lwi05t80rXEkuuh+9EPUpzHXFlS19tVZ9QSBw5HHDqrc\nKZOrZRFnltSrK08MFDE2n5jgZK812/kGmC9Blx1z1ZzB94Pk+Uw+3wB/tVJpt6v1M33+iRb0n8Sc\nCeKqFXxPWg7SC049aIuzUrFZK8/I/H8S/5EWJB+hUU+UX1rzFHHZHY0Ya7f+0oIkGzQ0RoxOIOhA\nNj6r2BgjMeSQEAHTKRqts1h/MsyTIH21Dj2rrKthFXMylToqY48D1atADu5vf0bMtQWZsR9fqchg\nHAQKX23bZKIT/AwIcpKyZ1TsP4V5EiSOPc6xM+F0OuuIF5ySN98djwWn4Gzrxk/MyvmfxDwJ+q/E\nkwSVRVcZy6+IpxWTfMD/e3iCIM1BirfkhEW04V4CdlZssxP/t/AEQWjBhFbjk6UVFVrjfdZxUvvq\nt9y4+v8JniJoX7nGaXvRHTexalp91bWvJ3/bnYKPoFGPJPQQGqqpiJFyjkZ6dlSHkSJG5PNj6U3b\ng5I9gdj7TChsFqgHEwyeUfRHIZ+gjF/Hm05juNMc6nL+p21QeGLQx7poM8loLfs9ffiPzcpbzhgn\ngLyRiTRYRuYU842MPC/vCzIBgtWVzz/3sXNuUnd9BoXXmlaw2vXJwYDa8+v6UKD94NpQ1x+IA2KF\nsUcpiilf4Jure7sWiHfmh/oOXfv+GCP2qZRqJU70NWjndHkT4uiGIiSLUTmVDq6t6dNru6YBtSkw\nxD44/FoTlxIMgScJgo8PL8r8YZQz1rpazTiNhFGOdKxOk9e3hfwYjUdiNjvpZz5PkJf0TrqF81cB\ntMsWeotoyzgRdpM8u+uG1uXej7O9yWnH6OCH276Cm+UTDuBNew7uv1ZQoYNTvldI8WzKx9njPfY0\nsoR2tut8j0Zay6p7e70ZSSjfnCyjnXPHaVaZEurZeiEJh7zr3biheroFfV0AQXKzeTI21hoZp4cl\nJtnxeMDZ0NjYNptlzBME2ZPp1eNJVuVCGx2eXUJb6zlfqMtzhShC7wz78WKqXQyr23F/ivPyXM/q\nXQJu4tCCvDZP4OC0x7qL1rFN6NknbOrUoUBot+5maeS1hKJvfLvqAneqpNFCY+Lb6BRCEz5UcON3\nHXx2tgVO0FwJGpnNwjjCZdSRkazv5DPQhrpfQNDeoSumJ9eGGhQbrOGp3y4G1zENdDEsGpvBNUZ3\nHcNdjREHOgjV7fmwNRrAx8APLSgK5878lL8m6snrmB6/tqDAXSymF6/OhmdMbRDTB9AOI5Ix6IoK\niipvQhcrX4SiAZGebwvijcZLp5FptNFZVrTJqtB8WOhig4gx+1QX+614+ND9Gbv8DOZKUKMOkBs1\nwqhds1L5kcw2pPQDIcNB8Fj2HEGx2+n24N6L3+LZ2YNCP4Qo3X1+bOI1SePuZxS7mxk59pFSz5Eg\nTQS/3TGSs+zImh80uFGvwY+4Tt0KofjM52Vex+gYsryqit2uLYNtiC9pqL04jdYW3FROSENHKjPk\nILAH/ULD0PuKGEWRA83eUVJrwVVaOQ5ea965XWgNOtCve4pV08pt/5Yh0U5fHCy4XQNdn/AeUmf+\ncp+IETkLqlGxAUUwpEj1A/MkCFS3Jg6HepEzDtUacaI2WtWNISKGlG7YLzNPeDJaywbPFu38eWm8\niHaTCc/hG6ea3hmH1luF3TTSqlbTe+fJRGkZbajCfMfeO05FWHZrPVSypvF7+rvrF4l110qcSfXY\nBBj71XUu7lSindRx6dSQivAQ5ksV2J4zGW6ASL45EQrHRb5z3DPQ8yVIzkdksoyzF4GvegXpB1k9\nWlIyEWdPNurnP9+AkDeaS3K93UnWonWAkBWbwvYkTh+kJgWOj6fRwpi3bDQmae0SWk2H3Rxv5bSG\nUHKPL7azQRGtJFLZSdztWhEG3mLKF4pzp85e3FpwrewmrXF216Ftp+L1XUjX9grrEyBImbIW4Yru\nQWK+L5KfjTL5fCYrZLIaRKu+X2KsMfT935Cml8/I+/IHF3+IWLd2SawdXu8PYQwYY25j4oVinzyA\nDwq/E7rnr3XPLkCDQIq65EUwViN2Lm8vgvvUZjLGudAFI3YJhkb7zMphjYiJ/n0/IdZEME5ijeiL\nl9Q1Qfmv95lajdhjwG6tXFK124PubWwFxG2eNkjeRjpKx2dGk9jS3/6mVJBltPi375HVKfZg5Eh9\ng7sFIOZ/dKQ7zxZEiCJqCEgw6pf/9r0LyPnb99//7W+LZyy0IDTIf5HM30nSx2LzEKILR5jepfkE\nD1//mGWIfxv1KOZqg4yyemTM5tWi42/4bQTV3zBUm6MRCwR9fhx04A2uieBHipSGWuEVOgrtFHLK\ngIaCoIELpJ4KxAYaqkYh+BDh9Jo9SC4kXamgCO1nAJ0KibVUq6MTz+gdShvt/6qDuAuqMrhyq7b4\nMjrTgef1q66sOzsbuM7oGGQaE3XlGh4MzLOLjdhRhler+cae6m/f4xYADFlUi2o1a+yAlf48Qedp\nng9sZT3Hh28c2ypvZGnnnMsmvSd8wjNeWsk6SyzIU9weWV4w2E+6DS7l6TZYT49NGS1oId6xm5B3\nPSuUdk1vDNrodmc33QSPbMujnZjAICdKdaMKabMsF+YTzmPTP1/ZnZaDbbUy7DWCOzdHgsqZtjjK\nCM6szYdeQctB5NIrlUvfpCaRnnH4RAtCXuw6bdgKWL3OVXbD8kGcs6USjlS7kDO9ZVfbWIJsdge9\nkAYFUk/Y04l6MtEWTp3gt7m5+PLKtodvsSnrdmkS1HJFr2rXoHiX9HZMaJUr5k7XF5G27eUFwaa1\n2p3jZFN1cG7KGXLrS8RcW1CXRKNITRxnL4fYAL0KQCtKdgS+J7fK5KP256+3Fzzyoxghxs4uKbF/\nBvnsg2MV6+IpmEnQIlLcA3lasdIxcqU7uKwdMdShGA5CjGV0ANsAuvDv+RlKh6eIphiCuo1ZyYPh\nmTWA1oa3Yg1yx3lEzwjYXPhFGLPv6TdM6PLIN18bFLGeqW1cY3CJf3bwt78RqBNhs+oBDyNr4c/2\n7PmgC06tBk8wPwvA+MYtKDtuNDLOgZOTCPr+by50yQ66XTQQ5CPmCwk6ID6ehTv25H3gey/mPTZ9\n98Gsyrq7d4bw65MPME8blDcKY2HQzUd0A0R+/zcTajuzavXlpdpplOv4xucZihEacMnxcgvkmtdN\n46ctZzCeK9AU1GtPIZKaQYCidbfiLRoEYgSxx7rwjN4UKdZyiyKpuz0DEkELRURdlwdTH1YjusBB\n3Y+Dqz+IFXMdl0Ysw6hbHYyVxViB0JRrBHkdm68NkldGjE2dnfRsChj/WAJtY3aSr4xGlZHoVDud\nH393H7B1wrpdB3Vvhzs3FICglfPkeBm9bdjirAttFZzukG8LxKqX6HFx7vhwe7weMi6iBfdFvMey\nfGfXDbHRwZtSr84LcDzGb1CtnLMJg23XAxlMempuO6k94R3orbppNNmdai4aEjrnhvm+J13OVEdq\ndSYv8Fb6e1UgxnH5iBipVM3VTOvS/NRbnLsnNg+48aVESG3bBTd+q6HctaCdOMcCQbnjdkpYzLFa\nt1XQxrlUstmYsLuvgmhDuekO9ewsF/fbLVDNv74K8dzphPPtmuBoqyH4QkIRCFplO3zIlnI6UhZo\nlavroe2SO8cfu8ONtlY51xY0yQ461ra64WwxaLnbjQiTzGgkG2XHI7m+knmCoM3D/UMXWqEGvx7p\nKehsK9ZBV4HQBdWEliEOCGqlSTSDtwvZ4E5TQcWsIggU6Fdz+WgoEpKaXYBXTx0d7thfxdpEdxP7\n+NaBKIpNBj++UOyDsonWPokOqLLV3w0ylHVIlY/0l8G5EmTleh2WrfeHxohtEulkZWO1MV8Zi8P6\nqFuJ3C/I78OKf7bzKWbzbKyEpPcTH1T6Gcy1i0GDgSZjREJeGMiNXEN+ORjJeJtgGw0jsdbnX/IG\n12oGaaYJsNp6OjZ87z3hMLxIjBRr+vn1MFeC2v12W5eN2GTyLpPhMxMN08jIItZ2Vo7vhdy7AfoR\n+jpxhQ2IOhSyFmiQ6wMvx6WOVcAcDTqz54YR51b6wLt85tqJpZa+brnnShB+qsGPI62KLEKN5LI8\nJc+qR7KKXK6utfVP3O0I8U5ebYt30Da7bbAZTXtKlMuCf7Dpvtjt2eyl3RN6K9spFONpbXS3BHbp\nK+I/QdBl3gjORmzEoUaGQ0IWkUMuI7N+niGvYI27uQ6LtPViKLG+tMMf9QrFNNpQvXOHJsXTrCOw\n4U7xQj0lEG9eMZKd+VqYL0ERmawzNiKqJcvrUHlU1yCRGoionRlZM5nBLN6nGPRF6mjQDKK9S5ES\n8TbEH+oY10EuGF7csS3ttQMrLT911iL329T+5cdLN/4hzJUgdjAcio2INW9sy2viGZO34d9kOhFV\na8sv5V90w2zumCNBmrwsD5A10ABG9aIcdpuoIcuijhGVKc2fabmfe5gjQeisL2Hqc2kGsKtDIozO\nyM/r138e8yTovxIvBD2DF4KewQtBz+DzBJVv8a/f/s/jbvVmCQ8IulLcvuB2ujr0Hf6sBCngi5yC\nVJDELUFCuelbGjbXcHJ6Bge+x4ODhyDxKen8+0jkh+ik4lZBE5A5jifl/F9AEHGbapToaxrIoHPr\nSSJwpqddWw6XV+WqHZKxQxJO3JJHJhdBkzRJwv9A2OKSAslr+MNEwv417NFEoL9E0/RakbwlNn0B\nOA35DyEtpMKRciXL0BPc9JBXTNB1EQxAtHkRRLpcpIJwua4VxJWLnn7cBlzwXQVcgdnHZ0DsHWc9\ni3YleRvQWrymif3k0qCNBH9UpnpGn5vzpZeJW3qrobootd22ZPfY0jxX7kJswto0HaaUKRPUnQy7\nW0mt4dLw5lXOYE28om/JzUYyzZhIYs04aSiPsovXt+SCg95v/WhaPbFOtg2FTrG1SM6LIJIpebq0\nX/BYaWrisdEi72nRiqTHR5Ksp0OQHU/yrht9AiDIw2aNSoIIpCxaNuJMhoyluHPi3lY7tMk4ru0t\nvWHYdcOZ4+Vd36khhWPf0lq1Opk44YGr21hiSav80dCLeHyNkofzAEELntRkbLm+jR1zk/j5CeyR\nmwZywWkYGwQe4h2z8UhwbgRdsa9fq5Ht9Wsj0r9+LUf+m9d5RJlfZ1yB6usKHZC9NkPfn0X+CATF\npbs2XgVV3siatjzpQq/ki/oui8c+tnMY6vigBZEXCVWo5DvccFg9lpDHxqchbEHFRU/ZYhK3oA1H\na1GrTJVaSS5p8yhpoD3h6K9D0mstG23aSosQ6zpUatfTTUurZ6gnbd1kcX4t6Krz+vU6amOChu8J\nugWCEAKCEAKCXNDjPwOwLOQ1pg/vYDtzfQ0bvIOBzc0tgc0N/CdwCH0NtnwaBumkbPEJmpASwh5O\nQtCBkGlqqnCmONItPjcFTgpR52aDAp3XN+ZKRhCsAf3N6xESC7yxWlnvGSsVdbJRqZhf31Sqk6tZ\n7C+DRMJ7kFh7MBlQe1zdz7J9D6BY0laStofZTY/nZ6RxF3v92kyga1rqYi4Xirx+bUPZ1685NHn9\n+gafbqBZ7I9AgvDg/9IGduC7hVB61bME7QG0CR/SuaySDJwxIHBJl9fkutbTsUOsfAR1OG2a0Kyk\nXHCCaUbkr6ElaCN0YAHMFMksg+DBCYiK9dCVMwV/5YLzbEE3r81B8paGFpThJ0HXuCqzIr5asaFO\nRfox6+daECgQZzjcdfOdePrIYT3uRI9Acm4Du462v61Ncoal9vIt2O9dC797cumQBE7LGn0FLt1e\nJgjK1rNArcmt5OWxRTvhVbnSoTZpTerhqLFEEqK3s22gb3Xbr/S2w+YxxCX2J3qvyqu8TJ0sk3O0\nQdCCBpggqb10YbgSIBR3HxhX0hf9KWKJQ0/daTjujJR2HiuV27BEEbcBuzLsYY2ObPpYRWOCQOCy\nShA4wSMJXAoEDipObjonKqj0WXbZ7rM7ebfg7GQd2ok7ERGUiSWSDBu0WbBFOq8voS45fRNoTPtj\nPpkqHTs7zuCcCZJaECbo5tBFYtXC3g60aBoOpq37EVznJj1Du20bbp/4UiXu0JZzUD7IaLU0jAe9\nyqLiDTQo6GKmpjPt7pW4KNdlE50Ce1hkO9CC9rgUiNYtGXI3Paa0NZrLrke9jq7HVmrbS0GCWLMr\nbSBhdE7F2lRhJ25B1KnPrrIVbYJheW5dzIe7WBUIIqgJn8cmueG6OwddjEXtzxtp+E6xugS2TAGs\nLWIBvnccDLpPkAo6jAc60yhT3MkbAE6A4ZaYn+VC6lJgumAXhhWwweelzezsVPMk/cOYt5H2w+Xh\nKkZ8ADIvjaRvXaXXrz2I+7yRxsAqj6shAapytwP/RTjx/hQA6gV6Djv4/x2mHEwdCqBqlgE022nK\ne1FnHOE9iD5HIw0dC3cxGPbVR+Zq1Wx0KVpsG8oXYM3mArKZzeO7NvURoKAx7lARgC1oUED0B5pL\nAUmL9tIBECVoCxcQgMUHPslmq758VFwmYz4pPv64JW3gWLnCRXDSAhcWwt9c0kEy8qLI+vwByN5H\n63CswDUZ6AcZSeoCtWbcMteBIhA0M9JyqamQeCR9df+7fxxk2MHY1y2XDn8vqlWFHKkInVq3bBn0\nhXbCkFPWO8kl+sgWV9J7k+iuUkF2rcdLjE1x1Dt3+FOmopvZNdF7SaZgSxadSq3KqlYtROLr0Q3H\nMtkPjVRWrxKyt7ptKjosWLaU2+uRw3ib5UqLlza3Ys5dDL+gQGGC8L0oMiiNpEkFidD19GMW+yGu\ntcZSMWHoGZ2qdyNHtuAET959ioWNLzqNhmzas+hazTo8y1tG0DqwT7+eLoHzv+Fc593b654OOGb0\nhc9rWTUahGPjxOBV7hlS7uPIOkStHXNOQ9zDJSKvsibkdWMvjIvbI4Lj2O1w6fi5jYMwQXlPJJPJ\nZ/JqNYdNj9SCzJlMG9UzGQ5ZM7LC4x59bLfU8rh53tM+jsY7XLc4UeSyaa5kM21klaBiw4QlEC5Y\nuOXceqfdWiJva7ulIEleZB2XBSerNkSPTeRe0iqMS1yxFfelsqbYpHPIpRzgiMU4K2tqcgl30V1c\ndKVO0ruGIsvXS/V2q+uj9+fbgrLIipvRDYV0CgLGPS7CjI9ZBEa6hNKvX0c+N5IGm7vlAJMBuwo4\ngJETNtN4j4QACAVrjcUKf0rGWITCKwhww8g1N/gTilvSCoIuyZSUgbQvzvKGfXwEA42QJQC7kunH\noeTF4ZM2aDoywSYdyoYH7SAWz1uMx4GNNBBUNUOjYaAIinqn02Fl2Fi3EBhptc35eSMNICgF1lxc\nmDvges327jRoJkn3ASHSgOsu7nSwBb6odIQhnZ5Cyv/eRUj4Jj9PEEHZS6ANAyIQcyuOVIEApXBd\nBD83mnsG2Eir0a3CJX99A1pPgjcPqNMKhdRQr8Gb/3zGpA7kJbBpoakgOFQgXhBGByiqBfvgPxF7\nMD7CavarLXgFZzFdWO1A0mjdpaLc7w8DOikVEbjKmYBn14UpKKlgADLwM0tXIH+Qil5LB+gA5AaX\nlHLcMz3VgsjN5KaDM22b2Oj54u6rsMru4NLWrv53MYS7GBBEIiBIRC5ESQS14Sq4w0i3Oz5rpMmw\nshu3HG0rXauRxe7hZSoNDIeU9vWEYUmbLkbp/YbSz1tyJu4kyrfZDtSK0JqayeGuqumztuoNpbWY\n9Pc6CnKPbxtN11Cx0PmJ3t0ucg4/x0VM1oKK4U3QoxKGpqrJGywKiHIZN8Ex/VQL2uycCU51r33u\nTE0mIK48Fy9yETCCvwMBGAdmwcRggiRL3VAD8rIG9AoajLQxCwY8+biRBhVzuhMOr9K14eipnWNl\nfInc93DZzimfMDrUS+SmJ6VW7a6zSbv6ZAzxCHrLsOcBeTrmk8eT5LEv4eFBzJYDWuUuSNf1hrGU\nSL45GScTIHMnBi5rsJeKHrq2y5bsJx5uZLm+zhk9k1ND6mmC9hIGmzMZmjiTbc7GCaW6u23t9PCd\nt9+OaQsiaCAIAM2HgWZ0LY2DaHy7Q8B3Gz8zko7tetgox2ZNgU1HqOPWJ5QEIe46mpNilxN8LDSM\nhKOd8HH60xJX4iyrBpLcOzalDLZ2iBuz9VIvyaabnP1kmT5y+opB4lq73uHcnIFr+7oFZ5JnWUuL\nc76iwZ1zH0OmgkpxnVpno6FiVvkUQQpCoaDxExf4j4fmcAwH5O8TtylBVHcov8HA3jwY3srrfIDQ\n67M3NxNUv7nJPm6kCUm14Opg23FJQG+kMFyu22X4vqCINARiIy4qCHwaSovlCrwQ0CpJuCi7Azqm\nODXDYPAVOCqkgQ84TW9mVTAGB0WEMGzicCA++bSrgQuCI+NS4oM/gClB+J40TVH06PXrQyCIoCiQ\nyurrigK2t1RQ0t1HAHYYPiQGJI2QXKqpWkxLJTEGVnbqfAI/UM2pJ4XvL+I7rITIKCBgqmWzRPgD\nOJXSUH4gBjtotHRrF2eFPyDhUwR9RUxVrIXHOgDj65sufe1yuVDgFhOEEN7/rJFuRpcDOhspBkmK\nA8VxHbWirlgrShKgOQRoVYAAxVkz0fRF1IWfn5Ht4CwWaF+UphiLC3tZDOenDmmIrl++Ap8LvJ4A\nkBKkFPhWZSAw8MEgE4w/EBmgXeEl0LH9J1XsqxIU4G7ASDNqNf7lc77y+uYQ8fg30A2arrw2Q1AG\n0HvcSNdO08OCbdvBnSgoLtppd1hPkluyRem9gq0YvChwbDBlYk49QyalbJm4KLnn9rNtH+dU5kyX\n20rNuUOtGhQWaab15lW3meyk9VbecuRejIWUwSLXOFc2fU0fq6J84SS94kwvXtRZLq1dXzxKNmF0\nOq8WNDXS6L2Rjk7veUhPNeBQUv3PGOna7rGn4/TwTtAU165l+2QixMeL8AVrlefrLq/g5J3K3RLr\ndHOeY6NhbLrneJXA8To45TxCFuSdcGmV9uykJAjZybHB61jJ9pLn6wa+YyxlWY9nKRDjl4n97fWO\nc+KJe8Db48bJ+RE0HShKMg903JgPUQTfQsvoDys3Zslsf9ZI14pJ7nS902UNywS9YeAdXMF3aqJv\n6bBnonLlLL5m8VgZyia960nuOO11gOveFMbOToE7xo6XS+tOt1gPvmm45WBZazqULESLHbUydm7g\n1CwPowMlhHIwdki2giHHqaoVTdv4rEpbqqvmStD6e4LkxEAxJQgO3Ar/QCF7XaX84tQ+fgKC3E84\nwKhjD4ukbgdg0cHPxPvYOmNLLCpIChQNVCxIwWETDAvWODFIQESsfySFU0zvrWELfh1WW9biy9ci\nZKoggjgQBqSLJCH2eXzTCgSEICSFnGsXgyGz1MXkiEaogfcAdaShXWCIPmukccWGWHkk/nANYSPd\nMpQCwC3AIfi22VSlaUVg+mgQyx9+CwRHkxLNEgCIPjg8WMVxCoAUiJWLACmQIkCQlG6uBOlHoyrm\nRI6CxlEFtkajcTSSq0nSCRv59C7Ip6BrID74diLot3SPELT5KA3KBN4UOGdHjuA1eR1SEiJFg1iF\n04Hc0oUJa3poMcaR+AbIp8ADovd03ceMrDvMlyCQeckaS4+eAW18IZD5AK15YiRNNtvWlvLS1/Up\nLgeH9cOcijqsnStbh4XFZoezBLRZCzPs2z3LWydDEKstQ23b4nUQQ71i17KwPlDjh2i/G/MiCN/u\nWEc2bHTA8sgVXWmPHTCMv/pa5meoQH1qpB5BzN45rrPnJxMHGZr4ttc9LJ92nXY88Y59/djgITkh\nGioN+ElwocSzE3Kv4D1ZVxtq9mSgyTnV2QZ+/eV3Y55GWo1EvT//+sYWHE3ts+R1SPp1I7iow8PB\no23+llz1FEDIHbn15X3PpdqtPGsEA+BINT2+YrPNKkIli/6Q4Q3BNYHzpOm9IuNVhpJi95Bomo5K\n0biF+wNVmWcXy+Jspdsd0hDoA4AjaYGxzxnpgQL8EMI/WMbmlFKQG+A3AcgpoQQRxHcKxWWSAIXD\nQXAElllyFsBwgReHo/1OzLOLST84hEG0fCS7a0Hvt9KqbJ8z0mA3pT+ovLTpg/xI4dInPjf7xKr0\nlTHPFvQBkoX+ANzL8PapB4f3MXU554N5tqC79vJhT/qbHQLwUPvPhnkRBEO992Bm23vQSx/BObaM\nL8W8CMJPwZ/Fn5Cf+RH034oXgp7B5wkqK16A8VmCdDW8hu7/eTxYPfAhQS+/F8OY0w/q9A11NqvO\nqtUNDqmtmsiAiuguI8imRryAnBxqQBhFNdRj9SzBA2z00tOZgI+C07XnD/Bc7YA1PJ3Jzvvfk9+r\ny4X/3sSIe+Rs5+IuUFNGK9MZGjZn89Dv4UPqLqIEKWhOBLXwL8IzcvjvQZmOTqYfymqcDAl5ZDQi\neVYKGw4zeXNmluAB3h1rHctrURd6Y9gZLR75BxQjtonm8squan8JHTAXDNQdz8S+GKOIzXYAHWw5\nh32rPloOB48Oz7qM2Azu2ciLfpxE+9bLYUy/ati/vBxQQPW5khnUjoJ7pxa00u1f2Cg88c6eVbSR\nEHQxx+lx8BqGOpKoERTSnSFCxGsPUDpEaTQUXougJuIw5ubRxTtW2Nwxv32yjLSGznG7kdxe8k6W\nVtlUMiVEDK4du2BBB/YT106ivuthhaIFbbH23rHg4XkjfxzvsdxxJ3UsqHbXCyQ6FYS4NZLo2DuF\n7SVpXipvacE4Se5CKrfW1ksZTWjHvuzleNYrGOc3wZKmMkZoVMVvjCO1DC/BJjOiqlAzt4dmka3O\nwjLVyiz+A6wUm93iroNEIVtyg8/24voi69uY1Itj9hiqw4YcaGXb4EK7ViFl0vJL6J0gFAuXrSbr\nsaVztjFbjNeLl97EhKVRsWvL8dkOWzwqxKN+dKBlC45NZzuVWER7Y3bXkfNAm/RaQnFbatxxzm+K\nrggQoB6Yje0bgTHXW+bhuEoaZRp5Hogiq2MIq5sZT2Xw+ILGZY1Goxvgtb41mrJY09U05cEVFdBR\nmhh0k/LZNZIWw4iR5bIUgs6uYQ9iUwqNJgb/qWtIKV5DlaSsRI2o08QC+204Ltd0V6ICL8gREzWx\nwTWeB09HlSkXBJ0p5kYQ20NCHY31GrVIqcv6LGoJqAdhLZQdltUUpdZAWLvSkB68/pkwH4LKvEj2\nNIMe0nOobUPcJer1NbxY4zUDFofZIEyPemcR6GaPQLOCZ7x5OJU/mA+87IE0q8UO45ekiJkK0sFs\nC9gn0dHD+YTWpMOV5RWGW1ypE2gN6+Ms6wMG7T2YlTH2zMosXw2EmWfM1pZZdFY1owzKjFBFTZr5\nvrlbx2HoLmwW/SMcJLjjYGyYMyBRJMSLZdAWdKGPXTJr1kH/4lCn37QLyzHiIOxRXA50FLMfp9rk\nxaHmiNhPBFciwfDyvh+dkWdHik0/2jL4xRi9YFo4ZnkhHUB7/fAS8qo2+/rApp73Xwysy2tWBVrR\nx8L+Ha17Xl2sZ5bMMFicCKpOCLPVaiZ4CKtI5hrCeNHctZofnyHnIFFPGLqRRBJxpwbbG48A9nTC\nnSa9Sa8AYmU9N6R2O9zyAmtPnExsqYiBj3O9Y9ZunLCnwRVPiE2BsfVa45Om0QEE7Sq5IBAU31ad\neZfQlnBccnk7CX1jkjw7V4aOj3kWL/wL+jcBnZwXQTU9EhlE9RFDoaGI9DqNXkNKYYNpGAFh5eFZ\n5VEjneq0Q5N1Nok2HHHbdlKrRG/jnWJX27FPUr6teLbHFqF5LUwEHgRpP9tO9dz1RI/zWHlncKcY\njtdB3ledSm8yAVru6Wy9QmuC21ZEmzA+2OKt2sAGy22oO/zwjbLIQ7anKqRd70W17Om8ZN44RiMO\nyYeUXLwcIdaInGocJq/r8sNBnrTKUW8khd3kZykeAOSlXKPKZ66yTocn1gY7cQZBmk21BVRIR4HL\ntLqIp9Yu96+v0RkcD9aOFWhwC7FgeN2/LsNmUBtciRTSDGq5KDZFeDANpqusK+tQWdSBbIkgiqQO\nZ7sIxk0HOQ90cyKo0bNVrZPKoCEj5GY+X+3IsigyQcZ2ecRQI0KeJzNGquLUV9S/ScX23q+LiCcX\nfwDNg7o8wJ2f8ll8yBYwpy6GIiMkd2KPIiM3y+Qzj4LBFyz3W1UGex4ZlJVrPrMUZN811SsEg6EH\nOHjcbOFGdh+z1J+gf5cdjtB3rX1K67xskAaRGk0NlWuohg2y9MwZRtLw0TZX1dAP8EyRGjSuSic+\nwt7+qUXs7w/BZ+pTXXLtEKpfvvDHhq6LIz64x5QvQeTO9Lhh7AwHQ9iugZ2Fz0NxGAMHF6GFUrCs\nBzJ29PRRcH957/D6YungorafANHf6Q7E2l5wb+gNptIIM7mv10lLiq9AVvMhSKxamarIVVE2g4x5\nvBg2NTYaYSwE35CsIkMj8DLUqMKS5kfX/ba3T4We95idxHuF02N3x24BB9bTs0aS7NqPpq0Iywqg\nX0lM0NqPESVsV9VA0EF8aSHCH4MPArFTdiOYqQVDThl74xSEXmLiNbpZTFCuN05a4wX32bYjV7Lh\naV7jnYmUass4t4VHItirKGfysqq8IhvJBsYbc0ZmvgH/DI1vWGSVPI1xRTTKpvEfYqPEhuOpYzZ1\n3AGV8XbA80bvnGxP3XEz277ddXBF7cmwcxHqtKEWPOB0hHhM0G40tc5bU9De3nnYVAkaxUqCTR5l\nBbYbB4+s1OSdQNDGREiN+SLPnDq01iyOFO+wUZzKq54bQUwD2bKok81XhUzV7Mzf1PudOjV+HRmq\nB40aQmorigzOIjVGejz9MfYUIDVrx8RWMqADJ2uhAW74OwOp67v2qLJ4RsXsDhdD7beAIN0A38RA\neF0IPBCODWrla9xO9xUHDPbW+rBH3erAAdOV+4QUV7MQp/3XZdGvE283WcgDrQXL0hTlsYFmTgTZ\n9KjeR5yIeLDV1bzx5qyB37vjmjfGig1MKoeYFupakc36+SWxD8S71UY2sSXX3StsrCsdfOSKfDHu\nra+1/8kklU8QpNlh0BqmGK3MVvb63UuZZYya6oS6aRM6NDZXx+aO+qau749f24wyoxzVwNmAvpWH\nMfXjtzsew3QVTEmswO3WTSu2gjdlavBpOZlauA0pHqjbTBHXHtxGvMNdHk8R9DZCe5VrwVtiIDKK\ntaHmgld8cAN/E2ozb6sqlM1VOWtmbjrZm5u2sXJ500XZqtmmv+ljb8R886iRjukpfXnTf1u+HQxq\nMfGS3idQSkWvUFonWCO0uesYHMJ3f8D0B/v94e1mnPLHoKT2xT0G2scmfL0HCf0pB2bJa6L3lteC\n+/41PQIJYzBFq0oyVt5yQPVrMYbYU+yDXTpYOFboN0si43qKoBW7zW7Srofc4aJvnw3xHe8kAkrw\nu8DoUXeArBRqmMWGjLsBiozV7s3Q3OqbW91arY1EKxp0rY9OKp1qx9leQki2UxGnLxcH30qBvBN2\ne723bYLT+/Z114pzCb0rNXcTzkkyldyI7CoReuPj+SDa2TZAnNwlu+JGaHfiS63bO+59ngXpk4QN\nrRp6yTBEOvB240LYiCeyR+HCcYG1e7TKJwlaa8VbrDDuuK0p5X4SCOInDulmwW9GbcQMRjXrCKzE\nWUZwVprATKaar98Mb9qaDHgeThRh0Wg6OvoUKVuc7aRDTc+RetGrWk1yLIRNuIQvxVvWDtFmcRI4\ngIHPyqmbt3Hd3V5ByPJQS62P7y2jd+fQONCGPsGChwG0JsZJfbzPs1xP4Et+MCGrAgcq5nYh7Vjp\n7WWjKeA2PBEKbJ0/ctJPrJKp0eDHQvsDkSDK0MWYA2a5Nrzfh78cOlmEqo4vzR0YEmVkvZt+ddTP\nj2IVeetGxFO5qiviKFPLj9geP0vxADAKZMrXNZ2I9vqp4M4wABITGwZWGAJcJgLcqT36gLlGMaYW\ng1ix2PWZvwadZ0XEq/od9LEF1ZX38fKakGqPukb7QXCT94Nl5gi6aOyCjg3x/crYUGQCe348vpfq\n6qL6c7tpX6+gMYwR5WWqU5E1qsbuTb7DV8yETA5XBQ9S1tNVL/UyWebRcdA9xHA1vx6eF775EKSR\nAD51A1SqbRZuxlTGbB5pRjcD8GQrs/MY94vzHg/UU5RKuTN03V/kUneLRCmptFjzHVYGOO7KrFoX\nVgJE7oAicC9Ysz0Q9Pt5YRxQ5bOjQxSeVwvKR5BMQFVr32xDmkoD8a8zreGwV73Bwx4RWhX2QcDf\nQL1HZb4vDum1I0NgoBvQMbyGM0WtvkI7x0uaPk1R2Dlfi1iO9BQ6GOy5z8AaQJo1v3ibO7aIRM1r\nAYc4gA5OJyaKIhbcej8caZWUhhQxLZu3e35wQWj4qsBT2wMOBiRaca/Z4z0eTO58COL02QoxyujA\n7uS7nYGRZ/IwUDQb8QXlnKaiHlR5q9k6GZ1x0wQPoRU8SSHkXDWa3hiK+AlfnMWLXCZ46/bkuId9\nsLW/K5HdhFbOHSnByvNLEMW/cVLkU5EJixP8qEIHbwx18FV4A9oq0UjraNpC5+s0Cicv4izbE07x\nY7ceC74HRMQExY8nQ210XjYICU6k7iBjWzMaImsFjLVObfTwwnjsrFrLxkF/VLYaUU89wP79J0jF\nuwWtu6AthfDaYZggrmcBgtiCelLcdw4P0dq2Cm0Y8HrNRe0ELwe9IvTt2R7vzbYLkGCrMV0Um/dt\nAEFr2SWkTa5lD7dVAbSV3JxwQFDCQSIt2ym4JNk72OXr8eWVVce8bJCN1Nk0Yhv1u4gZjioMdK1R\npmKWmyuZhmgddmGU1EdWERkf7WIxUScytwPigoKBHF5PY4/BvtL+sHwhXq8xoG6aNT+oEtq5uMVj\nPeyK7DEwWhR1+/69oQ4sFoyW9/VlkdzRL0t3MVa6TC+whu+QHCn2/Qf65dhhAO1c1oCCgwtwPdYO\nywS4MOScCBLNHHPDdMwadQWNzBVZtaqDEmPfIgKOqrlakaOKEZkFwvx5X+xrA68p/wWYUxcTzPjZ\naj6PKhFkdlI39Usz0TPHslVsmisjiaVMtToAofssPrPo5TfGnAgSW6jfRkMrsg5Rm0KtWq2uoaSw\nyy4agoBQlWq1qiZkl7MED7DDwLhuxR6k/uiiqb8D8yFI3UMRq8ZIDYy6oRFxasSPpbB22QiSPM6q\nNchjBpNENB5dXENri/e43nHPiF3TOWM+BI2cKD+qybCaG2VIgN0IGo2HZk4jU8NZs7nDxTJVYwUv\n7fcIvG28lJhdcPq7v+9uwh/AfAgiRNFmpnhw5CtVq0gip1lEhCYDI0PBzFBn4GGY9VxVk63cL80H\nxLqDQ3Qx1F0u/+47Ur8b8yEoDxZmrKtWKtUhKlcnumoVvwtUFRFVrVbMffCY8esxYK4bswR/HsyH\nIGaQzyB51Ww2y1EkA92NMrO1QR+G0dUK09cgo1EzALI6jLk7S/GnwXwIAndepq6a1fW6rCGrdHuy\nPs+oR5GRla1WIyNSX6k0jKNRRozkP78K238I8yIIyW+M+QjXqpir1XYHehqKjKo3I9ZcNctEsNJm\nORBUN+cfN0L/QcyHoGEfDc3WcVVmBv9ihKpZGNcgZIQ+l6+YuVq1mpFRSJORZSrzG0l/IeZDkAyP\nlavmtt48YM34BpBceoujUpHeGUITafpAKMzHL5H9CTAfggbg/hF9pqxhNLo+IsAgSzeo+oMBOoM9\nCPvTYm426L8VnyeojH9K/ALyswRdTX8N9GfA7e3tbA8grcWC/2YHXxsf5Xh73yx+RND0F2V/Bkg/\ngZ8BvlQ8rZYC/yRemlUNQ5qa7A4PDu7jLvzD+dnvp+/9jBpP64UxzQSO/vwE3Vu6BlCze6wJgz6h\nwqu0RLXr0swl5GZ6unANXgQgsGmSFq7BlaSlqShnLMSKJJ4XhV4pSlMow0lp0v/bW3pj8Qp4x5EI\nrVuBp0wJ7PkCJK0rzm2y2z8CvHRNaYgXowHEjntjZXi8vriXtWgtscJ0IqGFhpIptd1t9+Gpyap2\np6S4BGW1RbtxEy/NbEhunq7bPKq+LZ6M20rR3aTeY0k1JH4DWjVeSAB2CTFhafe5uHtiO08OT9PH\nc5vT/o/gbukaab6F2LnBmgwL60u7RtWGJWyaTlKxUPK6I0736VJKaS8Vs0bHNK5dvd5peAS8KMIt\nre0kIq/4ktfoPva0EoaU+kSa9B9OBVJugTdIP0rHk0caeMcx64QIql3PfwdBeOmaFl66BiBy5F42\nOUwHqNxieCk8nRuI3E8o6x7OsmXoHptCzrRXJVkSOpcuWp3puMQieeRMhhx6NyX4WiFDs6Hsltrx\nksQKXhEn55BmmCO0jiPP0GK75E4dl4l0fW6T/v8xgFF+P30v2E2svtLnh/mAcZAUgDGdYhEgHUHg\n7IC+Jgg86TLsbSoD+MSdeaLxQgLSLnGtteC5maZJv5GRxpO0vMeHQ2nn/aG08yDyw7Swi/9JUaY2\n9wNFHwNXG0NihpiZ84+AacI1xoB6T6+GIQUpZvOlAPC8zADMPaT571CxE4uLpGMcKBRNBlaKeG6u\nq4sgnvefOgwESILil7yqzXFUa7kmxFTDgEXqVpoLGQQJy5WCDqy5l0nmCE85SYocKBVepwb0iqxx\nZIC4W9eGDFwEXf0gNLSrkOkaS9q3IIi2yvNy+DN2nJ5eo+tq5eX5lroVuRIg2O/i5Pk6HCkC47x8\nSAZ6+bwv4lOzeXkLTEWAz+CkWbcQGETqDZeTxwtdlfzHUW1923FpV14ct+Ntw1Drbh/G04XFM1vR\nsEQScS7Zm3SUnCpAEPvH2wbGq6JXS0vadGjCq45KS7qc23tCrhknatXF8dLONj6ltaSi2iRjX2+X\ngtc5ZVc4TDmsSWuL3X4V2Iunjabr2zPhm9gguoV/eVmV5SeRiFPeRmxVVmFHrBw1qpXKELkr1c6o\nl1fAYXUYQONqlZWzo0m10kMB+iprhqQVo1Pt8st7I2R0BoCguDciOM48PafDnvUJIEJOpd2TNSaP\nLXsJD6+iA9poav1w2xE23S6T+8cQ0aisJXqGbbWHd9jPTxZXPPWsm44dcwa81NpOgp3AqYJy06DN\ndhKNk6U1p+LUN4bIE94wsatc03mVCe7bLBtB22SVjKwik08iDc+ojTqVTKUzYkdX/CgjH7gKsopa\n3VYTjHo0Yv2HQqWazTsjnkzeZuVsLmcVJzV6gCBIgiKYIMp35InGfb4ua7HVPaYW5zlMNZQ2wWRX\nnRV9VtP1dXNJaxrEl44Ww1F6r+jrtoR0jbtkx0mf1dLiSks1raFtoq9TyaitDu1pt2RLJH3MsWXX\n0fW4OUOwllLmPO20tTXu2I47SXoz4eOCIJfKb7L40acEySSCCNoltwUCBZmsaruiXeoGUuT50QQ3\ntzwbcY4D+Ur+AUHQgjBB2LgSs+n+p/pCkFrPdC5/SaiwRZXm/peM+zQOnJOiw/9rcN3wLo4Ahnx6\nJJ2a7lwrIA3OHYsW/sNzJeOzeG7o+bSgKUEuhOQ++qpXqVRbKHClViNCPoG+BT0wwxuzAspXHxI0\na0Ez3Ek69hek2ThBrrDHMJvf+AHeLwOAMZM1qcbEbJEasMfvc7yb7wzH/DBCwJPlg3WfC0FVI5iT\nTiZiNDr9JHS0UYSJqF3OfGOUt7Y9I3kkzw+tWbkx4+EebUHSLJOBvgKXniC0aqxSNIwOs6pcVrWF\nZ2nFniv+k/5f3xIgWfgAdA5ayUUWrBQZGATpX1vLKz4cFrN7FgOBPkQC7y7lOGxK647CeFNtwjIH\n+W2ZcqZcFpRsLgQJjeSoDj2rWkeEa6JusEQl4xpXK9WMH2WdEV4+uEJZMOsDdPVICyJzjmjvMGVU\nsmA3b2/BMzMsaVUkGY5PPBZvAvsIeJJ/h77A8ouhDmci6dWTVlqr6sZZN54f130cjR9yEceWyv4K\nNBDC1o71BmvnXBlSkbe1bZU+pdTimfXonFOtYuKLJBGzKzeUv6a+zSKQnxLkNE6MHRzUUyjISaPB\nixm5yyPLVDBBjYgg71K3WThtFR8QNGtBtURHHXEa4unEogi+6dqpp5AAb4teMKZTi9oEXoUlbFjD\nS9kkkgmjQcCT/jvsBYc2y3vAzaC3jCa77xTUbjfiYcdxvGTNWqkfhyPTmxOSAIJSHshwGUq+4ZzE\n1RHLNb0aMVyo9sDnnZOKyWS9EQ9BmXw9UqiUjL7lgSvbMFba5FWpMjGy+YwsG6nKgLZHWlDtjUdw\nspaQ6tSyBd3prNjpcoKKIC98aHXdZFvUgc6dpvEk/60uF1dqDSR5kW4N7cp6tNW0XJNhE8p5bD6r\n+9TRc6bxkjVkLFE6tBuK7oQDuluR3GJbgs+nuKXDBRA96LMElVNtWi4s32bK9seMdJUbcTC+qchg\nCFQVRqyLRk6gRI9QqcpK3S8bMctkec1jLci7pAODSoh4In7IHysTIWJzdEuIktrA7nSSf7C2EAsf\nQxT8hxPAf+kk7MAWx4AwBfhlM48DCxeJ51WGYJxKOg8mGhLAzly6GIyNnXmnEZCxCXzG2YjSfg7P\n/zvstIVqRD0eyarq3igjA9P9aQuarkr9Ae+VBiCJ/BQzTXq/lYB16E7SZp7pHT6kxMAnsbt2D1KE\nb0YQNJZ7RjrSkZvzCLlouR5N1JEewqPtSsU6qMgnFTMrr2eqDRTI5wlMECR90IKwsIMKYS3DElXj\nFq9mxwpicBGdyY6uT4CnRuItfAIgXaAcstAUZQNxw2uwLV+DBwZsgZrj1dgWNZgC7NiRdK0FVF9I\nnhpcUIoQOFoEaftGBMnA6mTkfAPaBiZoHGHlVTmeVVUiqNG7wnFkMtsgM5qAHyLvZCpqlyKfp1we\naEEyWWScnbaghgdU7IK1uYepTmExp6qbyE2jyddMSsfXaxG32sTwSyTZrEdURRNz2OxEVMNLWzoE\nRmqfbxsXNW9ebTuCWhOpe1NaAuk2kcR+z8YvNdWmVNS6TF64md5SLr1tWApsnZg2k5fsMrnXa/NL\nYbVK+81cjfcElSQbJM/kBbkgz7P0YVQ9Uaszh5RcZuyO8nIZtt3yiXEsy4/kk7zRNcYWXRYp3SNI\nWkY0UUq4x8aSoCT3PClHqe4sJXhHIJbgSgKWHfAiPOBotbKGs0RH6c2yRsNyYLdjXw8GUp1jHnwz\nUneanJyeZBe1i17LqS/h3s0aVYfL5e2TTgOniitdWyWeNTodTGcXy57Dm4VU34SgFliRuy42c1bB\nP+UqZg9CXbmgVpttwUqlgYzmSgVcjaqsPqpjh8OWybic5vddDFxYqYtdr4IL2TK1okWQqBK5VmxG\ntfjY6qNr3mQ7VATZIXOlXtKUUyt5XwEkndWfKhX0ljNdXKa3Jj5rcWwia16nL+FggyS9JfQ87V2n\nz2NpLV+vGorrvl1f0ZoOHGWTqXUWBgbhUs9jguieb7OuBm3LyDLwN5JakBV1ZPlM3icfZ/LOwyjb\n4CORiq2dzzSGI1le3phkZHLbSMiA0ttGo2kLynxoQWNsgyhpJRmQGEqa5h8gHWO7iuf2p6ColLQr\nYjVSYN+KoCAdXsUGlA4rE4xy4CycgQJCfiJe3AYHwoECDvBMzBAB5A4nIanbuwhPEiR5I/gPfEKw\nWzjvL8G0i0EL4iONqQ3yGDtBWcWIIuCWKlgZvvtRMI4rMtkhGciqjayYkTXGsoqVVNwNFO9skGSk\nocRTfZFqIRXjQ1lAtLBu4TPSOpk0DIumx5JH9j4l/oCySYcQDUJwfByEk+LTOBaWebwDUSAxff2U\nL3YrNhcp2+KZbUn0E4zCavvSuWglFZvJ/JQgIdK6rVShupVKhmDBWWXl/AgTpA+gbNbIkplKA7ra\nIQoEHpN5UJwlvIIagAxQ2Mu6xt4myI8O3wK8opYD1/ieIbtMcLa4mwA5w3JFr7UDeDUbHP2WgNjX\nUkYKMhArLgGToi2wvxSI2YAh7MORgWtaPKSvByCAROCqCR5L+EkjTWwKyZSb5x3Lq6+o7aVwVnq8\n9AV438XcDbUgdbGR3OiJ5DmbWi7L37JyT77Ti3YEiDRkWE820htnMvLRKJvNClfQxSBpRMAtqGOU\nuhh5wXnXF4983bTNtM9tO8K+pone8l24l0Iqva9rrb8xtBbpLaX2hKzZLWElTRU7bFRr2j8t4dVs\ncqZ6lCTO2MWcZdO361ykj5I54/JweHh0rtQPc7Zt5TKcDKX1/GGrbW2FIiZu+awQ/dF0TZ4qA08Q\nRG4eJ4tLm2pPO+EIaJdWfF/Iz7QF3RsHSUY608LNwVjN3E4iSM4hEjnBLDM2uVNtnGRg8FPtoQy+\n3fGpkY4llrSlUsroUdkjnkVv58dX25Y15/IxN/YIE4e35LArT00rHi7roOmcJbREb64nksbpajah\n6Wo2gcDqSPnmxLPkFUqBYy7hoXPZdd4zKSUcZ07BtKracqSyk2OhcyywnnpJsZrcXV8MrEaeXNsH\nCFrOuXsFy1HihNYubYBj8mW4L/NSF8MdLt8ZBdRAUP6Wj6BRh1TQHgge2kbQgvg8jjG5zsvk4ON/\nMg661rq5aErwJK0JA+cOJe3KwlLMruI8dZ+NcyZbzl7Sq9R5DXUfTTejnILc9LWip6UON13NxpP2\nOtqKIycQWEwWoyyt9aSL9KYhlfY1eZ+QLjYtRyUrNIZoMWWAv3g6u7Tg6YDc9bVPLsB2KwbpPreI\nF170k31FX3JWvgQfE9QbRdTdvHwCo6GMWx+YRFz60SidBxWr5EeMkJHl82O5vpHJ83LrYwTdkgNQ\nH3DksTc2UMDwGYtRkKDA0orLeLZ/KghWFi80gzEtJogTFiu8ms2AolpwsCylxhEgIbbROCJe3UaK\nLLlwg1tiQIgDSIQXPJuuUPZ5ghRYvAKSzwY7d4b+C/DxOIg3qseufKYOAx6Z1XUlRK7IvIwD32JU\nhT4lVCG4I0fZasUmp9AjXWzqROHr47LAv6mHIDEhheLa4l38AFUCuBwB8DfAUOM4kgzjOFO9wwk+\nYLrGDc4Cb6SsJLcMPiTCnyIIn/89ACONRzWZUUEy0q5eIyvQkbxaLs9k2nSAbwRu1caxfMREZCM1\nLeTzo0hdHu2M8lk1BeMgnPS9kVZjI91UXIMGYe9K0q7ABQwMN31QDXCZ8GLXWKCgKvs+Eo6BjOvc\n0j6/dDSJWqPELV22gg8myRpIIF5fFA9YJFHDy7cd4YXWcFb4SPooNxUBUtdcFmEM8o1vuc7GQXxE\n7UF+WbXhqciAoEkkQASG8k41a6wMr66wzCNrZYRco8qQfmwcVHvj0HPDls1EkGHTUWHpaFulIy88\nCkKs29jFozRVXAqBwtIb68Fc5zB4qDhLqFYdR5NgOJ6kyXD61LC0ZbFa6otH9XNV09K0+aBTFpfq\ni7nOcmB1fZHBy/a3LE3lci5q7VAhtb7o164vE11rculb3lHM3I2DgCAnYoAg6EXtALZB5JVezoIL\nW9VLBPVQG0aRV3IZ84Gge+OgWiKZjXhKvJK49kY8wthtV4G08cvk/ljtnngjJUtupCRB7LLJhFAq\nqAIb2fVgyqNEm0DQnjN4KjjsJ07T+XopmOCMpWzHEyx7Vfvn655jk2vVYG+cLAbCI0NW8Dj2PUUP\ne6w+AQFcjtmzwrdZoe7jLtbBN4D8GVnksFBo+F1svj426tsdmTyfHWZxF2Nhmx+1bPmI4n0Xc37o\nYjV7KbvuTm+8UqwkPMlogc+arm9FGBWKduN6Z+zhHM2spbW0abAJSlt7e7Gc8nk7gs9rsBVVpGj3\nsVHeWWLb6iSvSnUSvgKjXrzaMNTVbp/N4sqtK72GIL2Z9bFNVmjHDbZxqWcIjT2KWMptfXoZ0Vl9\nfzM+NtId89jIDmQwkkZX+SEqVMejyiGMryuVNpOnwUizeapdrQoon3lopO/uB4HSDEBioCNQ4GER\nYhBfBYoniloTDSLWV1BBhUKBH3mR4SQ4UfQ15ScJvwIiESJsCAqcKlAwv2JZ9ONlcG7J/jL24AAD\nBQkxSMqPxSwoBq+lAEnupPTfpgVNZR5G0pKzWilFOArcLcVwKG+7WFlplBnSPRhI2/wjegIjIPlh\nS5YpUHm5X/HI7Q4styBcoC/XWInwfwDsXIPu4/cMAhAkaRtsYDSCHxVK8bDjRWLvSjoPwnQHrFI4\nMt6B0ziedDT7gLwlQ453vpENukcQHiiOIx2XTU46IThPQGiFc7WMHpmsRQ8CgkwGA0TWSBEjmb4V\nET4liFB0l2PgJN1SUbzuJ64OyA24WtEAVuTQWAmB1+TF4tV0BWzFIAqsEgFdc5Gk9xcD15SUJtBd\nDuB4UmRIS4JTBrJHEAqI817J8EkQkaNoMICXGv02KvZIF0siqxypqxWz7HaC7weh1qhUrbTQ1VUJ\nxkHVTM+IAvkKZRuNPxkHESvbEcfwshkl99RpqjVsBWkiZ+EW9+2OI7z098W2WrnctARWVdZo07fc\nam+7syB4e8WucVF3kVBa243FFshRU73YGtYtA9+QswzshvYivc8uNVXLK+e9dQvFBQnSaul2gmHT\nRWd5S53Wc5b9zrd6LnZnpNVTI50HIx1gIm2nvGFUk73RSNYm1UZB3nBO2IAgz4+MWU5uDXiMgtMt\nfGqkY4n1UkkYq8i9LN85d3ra4Dlp3buGnsf4CjrUmt0jCEYDvZEAhRJKbGKdczoXNbvJ0/XgSjzu\n3j7xXBqVrrD7NGscl3h1ZOw5hrRji2s3KWTHpp0s5xScRlNgz+iE9IbBcWecPC0lIBb/5GLYf6SL\nTcdBH2TegwgXOwK1DwSukhWwzv6KMavGD+MDzmyERahejbgClCyPHpH5a+96lE+mDPRa1sCqJ0pC\nsXncA2fJ6U50isvEHp+0FpwqeqPgBCUq8Ot80sctXoU8naQituucqN18oaEKbI49hZJWnUyViiZt\nwem2K12rnk7HZgIq0xzvWbxecyoL1oJg8pbqgjMZt2jZp5dT/4M26MNA0W1Ue65uA6xRnb0CU9CT\nySSCnGokr8hp8OYLAbpebQRIfyYv3bT/aKCIZUsh+sEXHARBYPA9xEGwD5p0SzH4niAIGF6rGXw0\nkCNq95UCS9otiJikYbegcRRWMkg8yLmJawZOi34QN4LwS2lFCCAYaItnDCSh4BTkj09cqL/NOqt3\nKobvB0kqBh3O1mAUzkaQ9hsVLJyU661+p9o1Gucbk0xG3o74u2o3aewc4vtBkPThLdc7fSGxisEW\nh9xJknQgKQ6IHd7TgynGphY8SOx/SAqGw3EUUlSAd4ItuZST5IJJ/yXZmx7gBHgPPvqH8DEHIy29\nYSbXI08EXfnz0h1F2RAhdQPJOYgERrqTp5DaSecZ9KizCn7YNXae9ocBqAlWISIWhetIigNiBKeB\nnMD+4tUtwUQZy17SXwTzygwDMDxQ0DoYIEFsiH5LHh3mTEfKfg+MtgK/7EKKwEHg7HAqjzR8QnY4\nQylFAAYD36yL3XvsA0ed0dDFNqxtbtRl8foabHs4aVCNel49bUGUSz2m5WybeWQcRByl2yAzS5sJ\nVXiRpGx+m+VMu06SucXw4pEveH0R7UYvTKIttB4lybCnaaizTtatoLfWo8ztqaHfHtoU4Mal+zb8\nDGNy7IbTSlp3qrRGmYtzYNJmy1og26bepmhyar9taGuDlwtSybS/OUHYBuEbZp2RnnSpKzIZNwJf\n7FYu3aEWkB5sEPhiMAi5AoLysmpE+PR+UC0BulNKCo64x+igj4wl5/Gk56E3HNSbEw+4XHa38ZXW\nKKi2ss4l4sxNFTrDxmFvmd7y2A2dbHL7RHCQ5J6HHRtIcpPv2R3hk2GS1O2qjQ61ZXspkHNcZD1p\nELemUVCGPbugdYKKpsOGXvbbuBqBFvSharWSF4zTlzjNsip0MSCoil9eKBldt/mqWY6n3L7M01n1\niAeCXI1sIFMxGz0QuVoZSS9xJiEO2PVaoe3j+FKHd8IAJ7DamKRD/LhEH5Xa26VkW+nSRrOdxDrr\nyKVTS+RZYVBseopjJUmH193h9bDD7sitmxRrpw7WRANB/IQ3sE7TNZ1Tr3MJy64lEC41Vblj9cSX\nOmGFrtDzFNO59Si96UkWFr/JC1Tk0OMseZzjXtRXb7MMrXeWnHp2QNA257ik71h99G3P6WTpupX2\n94i2jevisXGrTfJjp68NTrXTw7VtNMUesrSvDedErEoMQTFE30+IIDVwtAzuVLAviY0IZwZ+EqsT\nlBk7UPgOKBhdZjlkuvaLQz/DKcDZIvBZRT8o+q/9cFYM9ocgcDBAZEDwRGZZAQ4cExwoICP/ZZqE\n/L+RL4YfmgSurgKSsaMJBQlH+KV/BXhNYGqxyaSvrmgFfvMCRjlgKnEi+IRBEk264DMA6cCGkhBH\nspb4lXEXOBG3IDFgoQmwvVi17pws7G1ND/DF4R9+jge7JDEELccn4Ap4g09LR/iKOBspPc5VigX/\np5/4Yxr8bQj6yiDDPsbGdKjiEtTszBakdcNl8DBnZ5/E9BbrH8F/A0G3fXtDyfacvSRJDrzrwWZ0\nmFDtW+ZTvv+KFsSkPLuvNiN6cB143jgpOCfnppTjj7eOL8F/AUFEzJmcTPgSO1bRNe84kuSz7rhq\na73zpY/C/xD+K7oYo+/7bxmSAYtLDYPU7voy5e/7pZt+3xz/FQSBaOFHW7hPgfKctf1whBVodvqb\n4r+CoIcA+Z/tzQPfgCDxa2OW738InyVIp5vOz/ubUf7amOX7n0H5ZXKTp/FfMfvLhRVP4ArYuTft\n886HxR7uY0Cii+Udqx+hGF4a4w4xaSr1na71wZzz4qeT6pVFFKOIu1UpxIczXP9ZCdpa59MuPJX2\nwjpNHbkDlGZtGe34RQUw5kJbKleZHNA6IEzXX1MrDsLuLSEeRBuqQExRFmMDHePa8S5iig60DQeJ\n8ISeewpxgPYEkkLQia5ilGuPRpoBUdbsxekN360YdtMILnNMPjGn/Z+HoBU2t87aI8tIyy9qx85Q\nhC0E0Zp3vIT2jIto1ZkOHwudNycKOL+77kJ7lrBly4I2nOzWScrdO9TyHHvMRlSQ0wLvNISMJrTJ\nMzye3HM3srTC2TvW82RJgbY8bOHS6+mxhZTQ3HZrI2zKSc+zBfWMDQpRjYg6YmwjNDaq71b84I2N\nRgQAJx6dw2ylkGt7nQ76bXZXmHQLqVLITaA1t1aJViMWaEGrjlV3KqukkbeTYtGKc2nLwC6jDUMq\nrp5Y40EITe4K68MjEi0I6dDx+hJacOzFuR4rJAzLyD4phRo++yIkYHuCIHR6cc47SWsTpRD75KoI\nX52g/OvXXWR9jdFAyPz65m5mLpkU9vr1zevXj64DeSDGCPEsCj0G7VsZRuwqjvyoTOmX0VqXRDvM\n6uJqEj9nRStWUkQ7Vn2sGQSzY13e04uBvcOYNbB5WDsKUgEwL7dirAt26Ci4f3jQ9cesJFq7PYtd\nUpc0EKRYsYpHwxpFXVIExIP9uRrpO4KAByCo+hrP+C8hg4OmBD26+NEz2Om63i93/Uew9snCPoD5\nEDTM5+X5vFGtFpH15nUl24CeVHl9I4XK83JoTDeYHVlW/ehMnDFJbHYUKCZeHZy5kOaODmmKad3t\nwTCwSaxJa6aJuhjCk3nPEJMiTOXs3hpHCG3ieQpn2vZZxMCaz4eg+ofWAS1ounZGVWo0Eqbt5/Xr\nvHTiU3gXdegabb2KceeL3xldaKX4K6UZQOX6JEWjLUe4V2B91C5Y4YNE1Ms2kwE0+BUGmGe/ai3o\noJhTBkCv0Vu1QtwrkDHQLLTFRumB61ftIgyHIWJN1KyBip2RMXrDoiHK1FohIGpiduiL8yGo9ThB\nd8Q8R5BdUF+aQKKioVPl6jqYmqJ9LHSgneT4rBLtFJu9bGfiakIPecf3dhvctiMU73BhMLn2rOrg\nvAOKBGq3wZs2xmpbJNlbRLsKtDrhign2R1WMi/us5yxWMScbPtlWvlmPeybrOdCw7JwJujGbzTcV\na1dq3Wio525eV4fdy25Xf9m+eW3Wdz83naKd5bOKt1l7qch6k4XlwEoquWW06LpIK1jjrh029sai\nVcZ8qIu8hnMnX/dpBa7DTwTOHre60W4orXWWlg8SE08h6g2t24RltKrsezmsbepFdIpVTIVVbJKa\nqPnWtoq3xpPa9RCbCNbm2sUkmD9ccADmaLZLAEGz3Uew395MIpCwPkXdEmIoeEBRMaqp6KOzAUGB\nbVk51HVJGCj2NQPXGrM/JESxSe63Re16ELoTHJ+JVsUBhfaahxdUOLh5iA6ah7EmvWmtHcFY6owS\nrRTI2UZJsX94NtyLDmLiBWWljobNeS2n3jabq9B6ME3mtnWGLrSgyqW017VBY5rFfRT3V7S+X+In\nsZP7bYt9fapiunkt4QfDecgOZF4Sq2ljgl3pSNqFv6cIeuBSfw4x8YzSSMv81R7MSKL54JPBbhkv\nTA84+BA688j2mLsVasv3iJgPQVMAQXfsPIQU9vkudsA1WVeZXkjDvhio/ZpbLF+Xb9eKLml1/RgN\n/iVCZ7/aeY8/IFLLtR1vfBm3Mx0hBsBj3XS7MCexmgatxANbvlvstUFo4AzFYqIrVu7rRLzcwuY5\nGCRpiLDwyiVuFl0EXmhpbgRZG9lRPm9+bZYGP4DpJEzSFsaMsFU3Hl3YBwgCHXJsNhKvEPhXvg01\nCE0JhOYkgMIhd3t1Ha+YtiCk1PZSq97ZatsN2t1kOIp2Es6xaktts0/sJ+BkONmiPuV0s4VWKgr+\n76lQ5OuJ8dii9bR2s9hPO9CeZtNv1mH0sMovppzroYivMLdlRBGKYJnXAUGP9JbM69cMsj0xDgJd\nmjTiwMNqMiWsx23n6bjV7ga3NHuqtKttJXATlFq3FdTLsiBkxz3elqXRijvUBpnii6dqcNO2Jime\nPxY4Ph53gK1ZZY8nLd6Xap8mnAXQwqELHXghU7UqgNayp5Net7Bb0iZhcDQvghqYIM3nCLp5kqBN\nvUjtW8+6LrRqUFwc7g03owORuiTRAUPB8Sa0iB1bkBJFSmz6KStDUUdA5s7gTKSODtds/r12AFz1\n4ErLH46KffEC4q/Y/PttAvRrEB5S/ds+HnoM+iK1aYFx6DK6aA31VFMMz6sF6TOZ0TirxwRVdagl\nywDymTz8ZWTCjCDKmX10icwH+HQd1Mdh/STe2pct5fMJ5kMQjIPkeFuGFlRDgmSZ7zCSvPnp4PFz\nwGsVQomklWtisxI/KDmcRGUwyLNAkOc76MpMAK8r/yutY8gdBjtfA/JAt8YMGOpMgQ769CBwptDd\nu1WJUZ7ewQSlmw9BMJKWCJraoClBksy/J0iP4HIa8Iyk+B9hqxC9EsGILuEp3fcUUx9yjf31Gq92\nNXU5V9wu0KcyXor4Gu14oQGVryVnM9RT7vM9E9oophyUlgOmd3LKnHLN7gh5eHcgFnJOOilWW5IG\nWjFuGUYUhAvlLBqXTrfGz2u18DuCsA2SWtDojGGGzHAwviPIfAMe2vhGWh77YxzEabQq2LRZrgFq\nE04ZMCHnbEG49E6gXpI+abPuYoETttSOjUgntQ4E7TU6Amh2scnlTDuFs3Zz1xDGYgVnvLwKNcnN\nw5RSH1xTL70x5XgYGIAnNzYuba1rs75Q1vQmaa/bPfMi6K6L1e5a0N0KLJ07gqRxkPozN8y0prV4\na5f1jmGggnKd0yVoVA2B1U7cHN51p/iepE9sivdpnR6ug1dJX2347HA2FUwJnS1VOLixq9yfDIG5\ntQm3/Qo8N67fY/VhPtSZsCkHOLBwxn5C2dVC2w5auT1O5jrH+sCTBG2aoEHev4vye9G+uTFC37/s\ngpGuoYnEA9MdajBBcAKMtOSWQQt6dAm/ndDimo8Op8Um1HiNsUELAm3qW/14mVS0lQ2ucf4ti9jv\nN0HAzmyDJkgR2rf1bdCCqAtf4Chd67rW9rngPgfMrXCHZWpngPoovLg2rHebiqOlfRseRK+0Icto\nXxxcpCGrQayuZ54maCMpau3rTMFf/J0ScAcNQcB1JFcDWtCUIBgdUvcJAlejTBC/o9nu+Wc73wRP\nEKRZcToXN5qhU9jMwv4YJFdjaoOm96QHiH3QxT4HneveghvSInazhdUB98s/BXD8Ec049iNr35XR\nwXTR1qfWxXuCILQZ3Uw521xdGca28I+AGjttCMmlhnLXgkayvIi4B11M73TqZyke4I1pC/qSTlfD\nVQEXXXdw2lmE+ulQ+LIQwIH4tqAOP6TW1Q5Sy2usSwNiViY1mKnYTmJpL6oNojKIWuxac4WuV1qg\nUQcpessxQDWQx6AGlcGz02lce9bmsuYKnOsy2muj2JMESV8D/urK0ucfwdRIT1vQAyP9sAWBkX70\npr3XUfSuhxLjUnQ7yW0vIvtYnTCk1r0q9MaxXeqeqw5O6+dJYXjuwHca7SWuuFrSZk1ai/ZkGW0J\nqQi9um7Ptt+8cq3E9acl3sOrtSptqUDbHc1dZ1ubrTfY48Baws1sn66fp7cdcTabRBvruWPLXGX+\nEYI+UbFHCdplfjxRC7ZCM6GuJ3ctb889bNO3rQSRWq2zuYR6cYdfPbF6d0/q7lDaO+Ym/Gl20j51\n/LptUCBvOuV2vWPB64JBwoJypeGLt09ZbftNdkJvtHfjzePObmKdU6J3Bi3fEHzaXMTG59JxSONt\ndf4DBEk2CE/7hr15oGZKUCM7+TxBjOvI1mbO+hTV1B/5iJ2W3n9m3bQNSegGEJhbOmBqLb0t2IzC\nUT/MUX3YOxscWfbqJFopBhnXDiQfhC3oIDc8wjlZ9WLzkHHtUfsQ3kyftfQDtKde3KsPrEfDMM4G\np9nnFP+pFnQPU4Lw2rGfJWg+WHnU/v3nCLq7nTg10pKrkX2aIGxkH0UN6oG3YGjfIyZ5V1Pj+aEm\nj9lS7OJ9Ev7e6s6HoDqMf8w36qFV8ubF6S1paxf+rO2BRJD5JiMR5JyleAAoLXbSVpXItXkIlalB\nlfDtYtAufDdX03e980G0g8QSjPVAwHQ6tFbwkaBuC2mIvlOggSNwstYOQ8Fp1cG1RUdLcC6w0h4Q\naK0ICe9cXPziGHoHCUEXdfMiSLqtqpa8+fsXnOE5I72wnsuq0E6KHZyeG7TrbX4ZpYTe4dZx9I0P\n61bTlkhCtE1wNLInzYbJu4hWF9Hmsa/pTJ4aXAfbHv8bbNK3TnbXLbuvAshbsnrZ7eRuqefpndgu\nEh0WvYtYT9Nop3WUch+dm9A79tQwadvn9VTDip9q3ExQuXrvqcZ7dGWzcdDnWpD3RLDFXQvr277O\nBlYvGBTZOXY3zXfPx0kuvRufcA5oDV6P2nFZ8L7SKl1oS1nT+rQObtxQuXbiufi2QYtrnWrbG8oA\njApOlSHBdu4TQNBC/PlYiVbcqTQLUb2d3unJInp32khrk1rVnAjS6DCgU9w9hQfcbQHSnQ9wNT5H\nUDjNUAzaV+zkWL31Ik0Vl2EARHqX9ilO3x9QF8wmq+dcSO96N4m2+1wQxpIHOZ+oXdpk/Vi6GErP\n6SFwx6Y/64dNroM3SnLDshc9ag/PGKv+ghsy6KDZxw5VuMPUqRB01X643YzO7bnYHcrvOXkAKfQJ\nb/4RhAMw0L0H6cnGl+LAOr0f9iWYD0EDtdqpVl8izQgPfjKvX1fkeWhM0iONyusbGX66AWrGZTKf\nebDxEB9pzkeHGLM1E6XPGd4fPBJ9eq/y0VPzNNJ3Bhh8sXvvB41ev4Yx4pMAlwrkCook1eDyCCQL\na5h0Cl0Mi667Qw04WmjH6tphpJgb0ENwIE6OVqEDYa8UXDAcCn4bTiDli9YupXHYDhvAlZY8OHQF\nZ45A9OZCEIyDniLo0ZtA9+Bte0vDXdWGb6uxhA7Ok9uOvWw74YBRz84uu+3YNui32WOo/1ZCEIKn\nkwbn5jgTnF1dN22VQkptOyccatW27Y6gAILelC7fKHO+zaxNv8GbVtXgiF9sv4LL7Nk9NuHQbuBB\nBA52PYfezrlyfgTJJsJIlukjJpOpgMHJZMAyD5BVJhsJY7ksn8ErjbIyWWeW4gFCveM6n3UaXG/W\ngQavjdW6G2OfF2r2zp0DHy2XOKkbMCF1HvSqxGpthTdKSKdlvRO10Jz8am/bO17nOpZtdHBcP23U\nS/RqY1I8rffOwV1Dq8f4qe2G79QAKufTQtqDuC2hCh3Py0i/9+a7qC2ZZQnT+0Fge+6Ngx410lvt\nN8pB8XDBt98BUo7a/f1uUd+/oKEeIdO+jen3Q1HcR/YHzOCyOGxGqXBXD4RtFpY20npyy7TJErnO\ngNPje/ZoAw4OF9LhzkCbDpsuOBISXuA7iiup9iZ7u9Fu4hakH/RDls25e/Nd1J2JFtb2ezfMnpR5\n0OAvl52vjPkQZLvBPOjrthrq3ryWtVutls1mYyvmTLvOgNltcaBp1Wr15jME3eF+YT/GE+eeumP4\nHOZDECe1IAnvX8FDqP/hnRdCalX3DPknwHXc8UsbjJlo3UkZWin6wQmDw3cmBA4XBOWWcB+Tbs3u\nkWjlEIfBeZxgrYC72pdhPgRNn2pIuDTf3D2CH0geqgSiegMwf+aphnacbXvdNqbV9Nq2TWjVgNaE\n7mFYy8ZtQrt90TpNXpyWrFrPobakeKf2pbqJ9qlSO1kClz4kcIdhmzUxjgR2Tn2pTs5pWl1fxi+A\nfiHmQ5CGvHtgjDQx/IBjult7v4tqZK2Gf1j46EV31Z5eyx7njnlHKGI5sJ/QK7spdnfcLmjTqQmX\n6GhLrWO+1Ez4dpcW3Np4oTHuaLdPwG7t8KHjjneSOOHcMMrJJXNj2+65g0BfztB8CPqDOLpgGe26\nnrfqD2PFRRTyuXbYYahzORiu8f4Fd9fPXPBt/eHgItdYXvFaNq3spf/i0oqFLZz15Tp6pqiv02vx\nw5CJGVyEfTQKP6jqU/ivIAjjoPn8l36QAz/+I2z+wUdW/zUE/afwQtAz+DxBmpp0E+f/OmqfJegF\nn+KFoGfwQtAzeCHoGbwQ9AxeCHoGLwQ9gxeCnsELQc/ghaBn8ELQM3gh6Bm8EPQMXgh6Bi8EPYMX\ngp7BC0HP4IWgZ/BC0DN4IegZvBD0DF4IegYvBD2DF4KewQtBz+CFoGfwQtAzeCHoGbwQ9AxeCHoG\nLwQ9gxeCnsELQc/ghaBn8ELQM3gh6Bm8EPQMXgh6Bi8EPYMXgp7BC0HP4IWgZ/BC0DN4IegZvBD0\nDF4IegYvBD2DF4KewQtBz+CFoGfwQtAzeCHoGbwQ9AxeCHoGLwQ9gxeCnsELQc/ghaBn8ELQM3gh\n6Bm8EPQMXgh6Bi8EPYMXgp7BC0HP4IWgZ/BC0DN4IegZvBD0DF4IegYvBD2DF4KeBEL/HwDirDIF\nu9cqAAAAAElFTkSuQmCC",
  "Styles": {
    "0": {
      "Ident": "StiStyle",
      "Name": "Header1",
      "HorAlignment": "Center",
      "VertAlignment": "Center",
      "Font": "Segoe UI;21.75;Bold;",
      "Border": "Bottom;166,166,166;;;;;;solid:Black",
      "Brush": "solid:",
      "TextBrush": "solid:64,64,64",
      "NegativeTextBrush": "solid:Red"
    },
    "1": {
      "Ident": "StiStyle",
      "Name": "Header2",
      "HorAlignment": "Center",
      "VertAlignment": "Center",
      "Font": "Segoe UI;12;Bold;",
      "Border": "Left, Right;White;;;;;;solid:Black",
      "Brush": "solid:255,179,135",
      "TextBrush": "solid:255,255,255",
      "NegativeTextBrush": "solid:Red",
      "AllowUseBorderFormatting": false,
      "AllowUseBorderSides": false
    },
    "2": {
      "Ident": "StiStyle",
      "Name": "Data1",
      "VertAlignment": "Center",
      "Font": "Segoe UI;9.75;;",
      "Border": ";235,235,235;;;;;;solid:Black",
      "Brush": "solid:",
      "TextBrush": "solid:64,64,64",
      "NegativeTextBrush": "solid:Red",
      "AllowUseBorderFormatting": false,
      "AllowUseBorderSides": false
    },
    "3": {
      "Ident": "StiStyle",
      "Name": "Data2",
      "Font": "Segoe UI;9.75;;",
      "Border": ";255,255,255;;;;;;solid:Black",
      "Brush": "solid:240,242,246",
      "TextBrush": "solid:64,64,64",
      "NegativeTextBrush": "solid:Red"
    },
    "4": {
      "Ident": "StiStyle",
      "Name": "Footer1",
      "HorAlignment": "Right",
      "VertAlignment": "Center",
      "Font": "Segoe UI;9.75;;",
      "Border": ";58,78,94;;;;;;solid:Black",
      "Brush": "solid:",
      "TextBrush": "solid:166,166,166",
      "NegativeTextBrush": "solid:Red",
      "AllowUseBorderSides": false
    }
  },
  "Pages": {
    "0": {
      "Ident": "StiPage",
      "Name": "Page1",
      "Guid": "8764d9723d5c4e8a9a396f493b4fa40b",
      "Interaction": {
        "Ident": "StiInteraction"
      },
      "Border": ";;2;;;;;solid:Black",
      "Brush": "solid:",
      "Components": {
        "0": {
          "Ident": "StiReportTitleBand",
          "Name": "ReportTitleBand2",
          "Guid": "34839448fd6242af8ad23f8514aed14e",
          "CanGrow": true,
          "ClientRectangle": "0,20,749,90",
          "Interaction": {
            "Ident": "StiInteraction"
          },
          "Border": ";;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text24",
              "Guid": "87f467faa05c4e6488c7d802dbd6f39f",
              "CanGrow": true,
              "ClientRectangle": "570,0,179,40",
              "ComponentStyle": "Header1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "{ReportAuthor}"
              },
              "HorAlignment": "Right",
              "VertAlignment": "Center",
              "Font": "Segoe UI;21.75;Bold;",
              "Border": "Bottom;166,166,166;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 0,
                "Right": 3,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "SystemVariables"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text25",
              "Guid": "d9874c36a6354a53bda30eb2c4d1f3a1",
              "CanGrow": true,
              "ClientRectangle": "0,0,570,40",
              "ComponentStyle": "Header1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Two-Dimensionals Barсodes"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;21.75;Bold;",
              "Border": "Bottom;166,166,166;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 2,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiText",
              "Name": "Text95",
              "Guid": "8cd0a4fab927479eb202f77fd5c5ea00",
              "CanGrow": true,
              "ClientRectangle": "0,40,570,20",
              "ComponentStyle": "Footer1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "{ReportDescription}"
              },
              "Font": "Segoe UI;9.75;;",
              "Border": ";58,78,94;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:166,166,166",
              "TextOptions": {
                "WordWrap": true
              },
              "Margins": {
                "Left": 6,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "3": {
              "Ident": "StiText",
              "Name": "Text96",
              "Guid": "b9813368ad1e42d386d9c6236ea74552",
              "CanGrow": true,
              "ClientRectangle": "570,40,179,20",
              "ComponentStyle": "Footer1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Date: {Today.ToString(\"Y\")}"
              },
              "HorAlignment": "Right",
              "Font": "Segoe UI;9.75;;",
              "Border": ";58,78,94;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:166,166,166",
              "TextOptions": {
                "WordWrap": true
              },
              "Margins": {
                "Left": 0,
                "Right": 4,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            }
          }
        },
        "1": {
          "Ident": "StiPageHeaderBand",
          "Name": "PageHeaderBand1",
          "CanGrow": true,
          "ClientRectangle": "0,150,749,40",
          "Interaction": {
            "Ident": "StiInteraction"
          },
          "Border": ";;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text46",
              "Guid": "e4f5664f55354a8da88d4d3083ba58ae",
              "ClientRectangle": "0,0,160,40",
              "ComponentStyle": "Header2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Symbology"
              },
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "Font": "Segoe UI;12;Bold;",
              "Border": "Right;White;;;;;;solid:Black",
              "Brush": "solid:255,179,135",
              "TextBrush": "solid:255,255,255",
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text47",
              "Guid": "9641c5f9d9ce42029fbb54f0673e9828",
              "ClientRectangle": "160,0,240,40",
              "ComponentStyle": "Header2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Example"
              },
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "Font": "Segoe UI;12;Bold;",
              "Border": "Left, Right;White;;;;;;solid:Black",
              "Brush": "solid:255,179,135",
              "TextBrush": "solid:255,255,255",
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiText",
              "Name": "Text48",
              "Guid": "4226776896ca4742af2c4e08614e2083",
              "ClientRectangle": "390,0,359,40",
              "ComponentStyle": "Header2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Description"
              },
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "Font": "Segoe UI;12;Bold;",
              "Border": "Left;White;;;;;;solid:Black",
              "Brush": "solid:255,179,135",
              "TextBrush": "solid:255,255,255",
              "Type": "Expression"
            }
          }
        },
        "2": {
          "Ident": "StiDataBand",
          "Name": "DataBand32",
          "Guid": "b1fb3908c1e840d1a0aaf3be9621ecf1",
          "CanGrow": true,
          "ClientRectangle": "0,230,749,210",
          "ComponentStyle": "Data1",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": "All;235,235,235;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text93",
              "Guid": "dd7415a31b40427da878f4b365494f3e",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,200",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "QR Code"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";235,235,235;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text94",
              "Guid": "588b36c61f4142808a20a228dd81265a",
              "CanGrow": true,
              "ClientRectangle": "390,0,359,100",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "A QR Code (QR is the abbreviation for Quick Response) is a two-dimensional code, readable by QR scanners, mobile phones with a camera, and smartphones. It was created by Toyota subsidiary Denso-Wave in 1994."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";235,235,235;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode32",
              "Guid": "003e547250ed451f9c96c67af8704050",
              "ClientRectangle": "160,0,230,100",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";235,235,235;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiQRCodeBarCodeType",
                "BodyBrush": "empty",
                "EyeFrameBrush": "empty",
                "EyeBallBrush": "empty"
              },
              "Code": {
                "Value": "12345678901"
              }
            },
            "3": {
              "Ident": "StiBarCode",
              "Name": "BarCode23",
              "Guid": "59192bb833c84ecc9e66a6793037b50f",
              "ClientRectangle": "160,100,230,100",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";235,235,235;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "Transparent",
              "AutoScale": true,
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiQRCodeBarCodeType",
                "ErrorCorrectionLevel": "Level3",
                "ImageMultipleFactor": 0.45,
                "BodyBrush": "empty",
                "EyeFrameBrush": "empty",
                "EyeBallBrush": "empty",
                "Image": "data:image/png;base64,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"
              },
              "Code": {
                "Value": "http://www.stimulsoft.com"
              }
            },
            "4": {
              "Ident": "StiText",
              "Name": "Text100",
              "Guid": "fadb9d38cbf0400bb33671a1cf49d4f4",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,100,359,100",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Due to error correction, it is possible to create artistic QR codes that still scan correctly, but contain intentional errors to make them more readable or attractive to the human eye, as well as to incorporate colors, logos, and other features into the QR code block."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";235,235,235;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            }
          },
          "CountData": 1
        },
        "3": {
          "Ident": "StiDataBand",
          "Name": "DataBand30",
          "Guid": "2c606e621b1246eb8ce92b679c6b6dcf",
          "CanGrow": true,
          "ClientRectangle": "0,480,749,130",
          "ComponentStyle": "Data2",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": ";255,255,255;;;;;;solid:Black",
          "Brush": "solid:240,242,246",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text26",
              "Guid": "6f5400fef2154bd1b87dd3d33d90ae14",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,130",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "DataMatrix"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text27",
              "Guid": "0e0bfe497eaa464fb8cf5c5127e0a4a8",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,130",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "The DataMatrix barcode was created by the CiMatrix company. Every DataMatrix is composed of two solid adjacent borders in an \"L\" shape (called the \"finder pattern\") and two other borders consisting of alternating dark and light \"cells\" or modules (called the \"timing pattern\"). Symbol sizes vary from 8×8 to 144×144."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";235,235,235;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode25",
              "Guid": "b2e6dc4dba7c4f07bab44403541f10dc",
              "GrowToHeight": true,
              "ClientRectangle": "160,0,230,130",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "BackColor": "Transparent",
              "AutoScale": true,
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiDataMatrixBarCodeType"
              },
              "Code": {
                "Value": "12345678901"
              }
            }
          },
          "CountData": 1
        },
        "4": {
          "Ident": "StiDataBand",
          "Name": "DataBand21",
          "Guid": "84724017231949d79871c3fd36b9509f",
          "CanGrow": true,
          "ClientRectangle": "0,650,749,130",
          "ComponentStyle": "Data1",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": "All;235,235,235;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text6",
              "Guid": "386fe852e1ae40bbb5f4eea535c75272",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,130",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Maxicode"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text70",
              "Guid": "f7399c860a0b435f8b11c18a679a69a5",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,130",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "The Maxicode is a two dimensional matrix, fixed size code that was originally developed for use by UPS in tracking and shipping packages, as it can be scanned quickly on a conveyor belt. It's similar to a 1D barcode, but uses dots instead of bars. It's also called a Bird's Eye code or a UPS code."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";235,235,235;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode18",
              "Guid": "a2d2d581053745ce9198250c82c970f9",
              "GrowToHeight": true,
              "ClientRectangle": "160,0,230,130",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "BackColor": "Transparent",
              "AutoScale": true,
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiMaxicodeBarCodeType"
              },
              "Code": {
                "Value": "ABC abc 123"
              }
            }
          },
          "CountData": 1
        },
        "5": {
          "Ident": "StiDataBand",
          "Name": "DataBand31",
          "Guid": "7893ce4501ce41ff9d83679e3a799787",
          "CanGrow": true,
          "ClientRectangle": "0,820,749,130",
          "ComponentStyle": "Data2",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": ";255,255,255;;;;;;solid:Black",
          "Brush": "solid:240,242,246",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text33",
              "Guid": "d92c5f8c08c143c293fdc59e62f5c1cf",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,130",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "PDF417"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text34",
              "Guid": "6aa048750e3e4482a2c6ef8fbfc3d8ec",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,130",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "The PDF417 barcode was developed by Symbol Technologies in 1991. The name of the barcode consist of 2 parts. The PDF comes from Portable Data File. The 417 comes from the structure of the bar-code: each bar-code character consists of 17 modules, each of which consists of 4 bars and 1 space. Any ASCII characters can be encoded in this bar-code. The length of data depends on the encoding mode and can reach 1100 bytes, or 1800 text characters, or 2600 digits."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode26",
              "Guid": "0c303e725f264f9bbb26f684a7ae0ef5",
              "GrowToHeight": true,
              "ClientRectangle": "160,0,230,130",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";255,255,255;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "240,242,246",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiPdf417BarCodeType",
                "Module": 25,
                "DataColumns": 5,
                "DataRows": 3,
                "AspectRatio": 1
              },
              "Code": {
                "Value": "12345678901"
              }
            }
          },
          "CountData": 1
        },
        "6": {
          "Ident": "StiDataBand",
          "Name": "DataBand34",
          "Guid": "1f353c84c4c2453abcfc574fee1031b6",
          "CanGrow": true,
          "ClientRectangle": "0,990,749,130",
          "ComponentStyle": "Data1",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": "All;235,235,235;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text103",
              "Guid": "b2e55dc7206c498b8254c053209a5062",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,130",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Aztec"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text104",
              "Guid": "9e578282de324d809bd42768e4ec25da",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,130",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "The Aztec is a type of 2D barcode. The code was published by AIM, Inc. in 1997. Although the Aztec Code was patented, that patent was officially made public domain. The Aztec Code is also published as ISO/IEC 24778:2008 standard. Named after the resemblance of the central finder pattern to an Aztec pyramid, Aztec Code has the potential to use less space than other matrix barcodes because it does not require a surrounding blank \"quiet zone\"."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";235,235,235;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode33",
              "Guid": "75ed6d50bda94553a60b1be044e6bdfd",
              "GrowToHeight": true,
              "ClientRectangle": "160,0,230,130",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "BackColor": "Transparent",
              "AutoScale": true,
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiAztecBarCodeType"
              },
              "Code": {
                "Value": "12345678901"
              }
            }
          },
          "CountData": 1
        }
      },
      "PaperSize": "A4",
      "TitleBeforeHeader": true,
      "Watermark": {
        "TextBrush": "solid:50,0,0,0"
      }
    },
    "1": {
      "Ident": "StiPage",
      "Name": "Page2",
      "Guid": "4d3371d91f814f02a331c99b54ecf20a",
      "Interaction": {
        "Ident": "StiInteraction"
      },
      "Border": ";;2;;;;;solid:Black",
      "Brush": "solid:",
      "Components": {
        "0": {
          "Ident": "StiReportTitleBand",
          "Name": "ReportTitleBand1",
          "Guid": "998babe0f71747a9b63a9ec23452d45b",
          "CanGrow": true,
          "ClientRectangle": "0,20,749,90",
          "Interaction": {
            "Ident": "StiInteraction"
          },
          "Border": ";;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text105",
              "Guid": "5765fb289305471595434bc48d5d79c3",
              "CanGrow": true,
              "ClientRectangle": "570,0,179,40",
              "ComponentStyle": "Header1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "{ReportAuthor}"
              },
              "HorAlignment": "Right",
              "VertAlignment": "Center",
              "Font": "Segoe UI;21.75;Bold;",
              "Border": "Bottom;166,166,166;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 0,
                "Right": 3,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "SystemVariables"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text106",
              "Guid": "ab5419cb1b1b45578c77c70e740b6934",
              "CanGrow": true,
              "ClientRectangle": "0,0,570,40",
              "ComponentStyle": "Header1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "EAN\\UPC Barсodes"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;21.75;Bold;",
              "Border": "Bottom;166,166,166;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 2,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiText",
              "Name": "Text107",
              "Guid": "42973933231c4d4ea872a107f1de32b3",
              "CanGrow": true,
              "ClientRectangle": "0,40,570,20",
              "ComponentStyle": "Footer1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "{ReportDescription}"
              },
              "Font": "Segoe UI;9.75;;",
              "Border": ";58,78,94;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:166,166,166",
              "TextOptions": {
                "WordWrap": true
              },
              "Margins": {
                "Left": 6,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "3": {
              "Ident": "StiText",
              "Name": "Text108",
              "Guid": "1710eb5766584ffb92f14636a18faa19",
              "CanGrow": true,
              "ClientRectangle": "570,40,179,20",
              "ComponentStyle": "Footer1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Date: {Today.ToString(\"Y\")}"
              },
              "HorAlignment": "Right",
              "Font": "Segoe UI;9.75;;",
              "Border": ";58,78,94;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:166,166,166",
              "TextOptions": {
                "WordWrap": true
              },
              "Margins": {
                "Left": 0,
                "Right": 4,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            }
          }
        },
        "1": {
          "Ident": "StiPageHeaderBand",
          "Name": "PageHeaderBand2",
          "Guid": "c9c9a16de9164754a40121db7fcdd22f",
          "CanGrow": true,
          "ClientRectangle": "0,150,749,40",
          "Interaction": {
            "Ident": "StiInteraction"
          },
          "Border": ";;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text77",
              "Guid": "ce348690aa1c435f809a7d031f654b8a",
              "ClientRectangle": "0,0,160,40",
              "ComponentStyle": "Header2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Symbology"
              },
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "Font": "Segoe UI;12;Bold;",
              "Border": "Right;White;;;;;;solid:Black",
              "Brush": "solid:255,179,135",
              "TextBrush": "solid:255,255,255",
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text78",
              "Guid": "f1e3ea1f99584ec18281e6382bb5f268",
              "ClientRectangle": "160,0,240,40",
              "ComponentStyle": "Header2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Example"
              },
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "Font": "Segoe UI;12;Bold;",
              "Border": "Left, Right;White;;;;;;solid:Black",
              "Brush": "solid:255,179,135",
              "TextBrush": "solid:255,255,255",
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiText",
              "Name": "Text79",
              "Guid": "febb421d6b9f45bfa4e9a71e9a79053a",
              "ClientRectangle": "390,0,359,40",
              "ComponentStyle": "Header2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Description"
              },
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "Font": "Segoe UI;12;Bold;",
              "Border": "Left;White;;;;;;solid:Black",
              "Brush": "solid:255,179,135",
              "TextBrush": "solid:255,255,255",
              "Type": "Expression"
            }
          }
        },
        "2": {
          "Ident": "StiDataBand",
          "Name": "DataBand15",
          "Guid": "23edd3b2eef14bce8216abcc1d1aa1e6",
          "CanGrow": true,
          "ClientRectangle": "0,230,749,360",
          "ComponentStyle": "Data1",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": "All;235,235,235;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text3",
              "Guid": "d7e9388551994ea6a02eb7585876a427",
              "CanGrow": true,
              "ClientRectangle": "0,0,160,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "EAN-128a"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text4",
              "Guid": "4caa88564a46438ebf6f58581c93b7d3",
              "CanGrow": true,
              "ClientRectangle": "390,0,359,360",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "The EAN-128 bar-code is a subset of the Code128 barcode which uses a variable length, high density, alphanumeric symbology. It allows the output of 128 characters of ASCII and is effective for digits. There are actually three subcodes, which can be mixed within a single barcode: EAN-128a, EAN-128b, EAN-128c. The structure of the EAN-128 bar-code is the same as for the Code128 bar-code. Elements of the bar-code consist of three bars and three spaces. Bars and spaces have module construction and their width consists of either one or four modules. The width of an element consists of eleven modules. To difference between the EAN-128 bar-code and the Code128 bar-code is that the FNC1 is placed after the start character. This character is reserved for the EAN.UCC system."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";235,235,235;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiText",
              "Name": "Text8",
              "Guid": "2b86572f8e954b50b34975167396b902",
              "CanGrow": true,
              "ClientRectangle": "0,90,160,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "EAN-128b"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "3": {
              "Ident": "StiText",
              "Name": "Text66",
              "Guid": "b01b9caad38341318594ddafa7bdb06a",
              "CanGrow": true,
              "ClientRectangle": "0,180,160,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "EAN-128c"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "4": {
              "Ident": "StiBarCode",
              "Name": "BarCode3",
              "Guid": "3b1be17a00ae4010b0af208c80a74ad8",
              "ClientRectangle": "160,0,230,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiEAN128aBarCodeType"
              },
              "Code": {
                "Value": "ABC123"
              }
            },
            "5": {
              "Ident": "StiBarCode",
              "Name": "BarCode4",
              "Guid": "1dc5fc764a674621b11c606127a1178d",
              "ClientRectangle": "160,90,230,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiEAN128bBarCodeType"
              },
              "Code": {
                "Value": "ABCabc123"
              }
            },
            "6": {
              "Ident": "StiBarCode",
              "Name": "BarCode5",
              "Guid": "91f2a95e945f42beab312260f71a804b",
              "ClientRectangle": "160,180,230,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiEAN128cBarCodeType"
              },
              "Code": {
                "Value": "0123456789012345"
              }
            },
            "7": {
              "Ident": "StiText",
              "Name": "Text109",
              "Guid": "39dd6422a2f34dacaf11c074aee8c94c",
              "CanGrow": true,
              "ClientRectangle": "0,270,160,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "EAN-128 Auto"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "8": {
              "Ident": "StiBarCode",
              "Name": "BarCode43",
              "Guid": "74d93451f40d4ba291c906d6dd97ee58",
              "ClientRectangle": "160,270,230,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiEAN128AutoBarCodeType"
              },
              "Code": {
                "Value": "1234567890123"
              }
            }
          },
          "EvenStyle": "Data2",
          "CountData": 1
        },
        "3": {
          "Ident": "StiDataBand",
          "Name": "DataBand6",
          "Guid": "2bccc6a71b7d4b28872709885f751e06",
          "CanGrow": true,
          "ClientRectangle": "0,630,749,340",
          "ComponentStyle": "Data2",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": ";255,255,255;;;;;;solid:Black",
          "Brush": "solid:240,242,246",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text21",
              "Guid": "a900fe349f0345b6bcbf68ace0b46abe",
              "CanGrow": true,
              "ClientRectangle": "0,0,160,120",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "EAN-13"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text22",
              "Guid": "032bd8257ccb415bb66ed85a491c53a3",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,340",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "The EAN-13 barcode was created based on the UPC-A barcode as an extension of the EAN.UCC system used outside the USA. EAN-13 is the European version of UPC-A. The structure of EAN-13 barcode is the same as UPC-A. Each bar-code character consist of 2 bars and 2 spaces, which may have a width from 1 to 4 modules. The first digit is always placed outside the symbol, additionally the right quiet zone indicator (>) is used to indicate the Quiet Zones that are necessary for barcode scanners to work properly."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode21",
              "Guid": "e0f52faeb61446f189940403d1d5c814",
              "ClientRectangle": "160,0,230,110",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";255,255,255;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "240,242,246",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiEAN13BarCodeType"
              },
              "Code": {
                "Value": "0123456789012"
              }
            },
            "3": {
              "Ident": "StiBarCode",
              "Name": "BarCode48",
              "Guid": "02155bc4c50d46768125e04c267acc8b",
              "ClientRectangle": "160,110,230,120",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";255,255,255;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "240,242,246",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiUpcABarCodeType",
                "SupplementType": "TwoDigit",
                "SupplementCode": "12",
                "ShowQuietZoneIndicator": false
              },
              "Code": {
                "Value": "4523456789012"
              }
            },
            "4": {
              "Ident": "StiBarCode",
              "Name": "BarCode49",
              "Guid": "c978102d0594490a897d21600f9b1b98",
              "ClientRectangle": "160,230,230,110",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";255,255,255;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "240,242,246",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiEAN13BarCodeType",
                "SupplementType": "FiveDigit",
                "SupplementCode": "12345"
              },
              "Code": {
                "Value": "4523456789012"
              }
            },
            "5": {
              "Ident": "StiText",
              "Name": "Text62",
              "Guid": "e8448461ffc84f729111d4237a7556c0",
              "CanGrow": true,
              "ClientRectangle": "0,120,160,110",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "EAN-13 + Sup2"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "6": {
              "Ident": "StiText",
              "Name": "Text63",
              "Guid": "fa8629563d9f484caaefc694770d0bc3",
              "CanGrow": true,
              "ClientRectangle": "0,230,160,110",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "EAN-13 + Sup5"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            }
          },
          "CountData": 1
        }
      },
      "PaperSize": "A4",
      "TitleBeforeHeader": true,
      "Watermark": {
        "TextBrush": "solid:50,0,0,0"
      }
    },
    "2": {
      "Ident": "StiPage",
      "Name": "Page3",
      "Guid": "fbb3365357bf4703836965f754b1123f",
      "Interaction": {
        "Ident": "StiInteraction"
      },
      "Border": ";;2;;;;;solid:Black",
      "Brush": "solid:",
      "Components": {
        "0": {
          "Ident": "StiReportTitleBand",
          "Name": "ReportTitleBand3",
          "Guid": "998babe0f71747a9b63a9ec23452d45b",
          "CanGrow": true,
          "ClientRectangle": "0,20,749,90",
          "Interaction": {
            "Ident": "StiInteraction"
          },
          "Border": ";;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text110",
              "Guid": "5765fb289305471595434bc48d5d79c3",
              "CanGrow": true,
              "ClientRectangle": "570,0,179,40",
              "ComponentStyle": "Header1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "{ReportAuthor}"
              },
              "HorAlignment": "Right",
              "VertAlignment": "Center",
              "Font": "Segoe UI;21.75;Bold;",
              "Border": "Bottom;166,166,166;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 0,
                "Right": 3,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text111",
              "Guid": "ab5419cb1b1b45578c77c70e740b6934",
              "CanGrow": true,
              "ClientRectangle": "0,0,570,40",
              "ComponentStyle": "Header1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "EAN\\UPC Barсodes"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;21.75;Bold;",
              "Border": "Bottom;166,166,166;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 2,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiText",
              "Name": "Text112",
              "Guid": "42973933231c4d4ea872a107f1de32b3",
              "CanGrow": true,
              "ClientRectangle": "0,40,570,20",
              "ComponentStyle": "Footer1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "{ReportDescription}"
              },
              "Font": "Segoe UI;9.75;;",
              "Border": ";58,78,94;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:166,166,166",
              "TextOptions": {
                "WordWrap": true
              },
              "Margins": {
                "Left": 6,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "3": {
              "Ident": "StiText",
              "Name": "Text113",
              "Guid": "1710eb5766584ffb92f14636a18faa19",
              "CanGrow": true,
              "ClientRectangle": "570,40,179,20",
              "ComponentStyle": "Footer1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Date: {Today.ToString(\"Y\")}"
              },
              "HorAlignment": "Right",
              "Font": "Segoe UI;9.75;;",
              "Border": ";58,78,94;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:166,166,166",
              "TextOptions": {
                "WordWrap": true
              },
              "Margins": {
                "Left": 0,
                "Right": 4,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            }
          }
        },
        "1": {
          "Ident": "StiPageHeaderBand",
          "Name": "PageHeaderBand7",
          "Guid": "c9c9a16de9164754a40121db7fcdd22f",
          "CanGrow": true,
          "ClientRectangle": "0,150,749,40",
          "Interaction": {
            "Ident": "StiInteraction"
          },
          "Border": ";;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text114",
              "Guid": "ce348690aa1c435f809a7d031f654b8a",
              "ClientRectangle": "0,0,160,40",
              "ComponentStyle": "Header2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Symbology"
              },
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "Font": "Segoe UI;12;Bold;",
              "Border": "Right;White;;;;;;solid:Black",
              "Brush": "solid:255,179,135",
              "TextBrush": "solid:255,255,255",
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text115",
              "Guid": "f1e3ea1f99584ec18281e6382bb5f268",
              "ClientRectangle": "160,0,240,40",
              "ComponentStyle": "Header2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Example"
              },
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "Font": "Segoe UI;12;Bold;",
              "Border": "Left, Right;White;;;;;;solid:Black",
              "Brush": "solid:255,179,135",
              "TextBrush": "solid:255,255,255",
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiText",
              "Name": "Text116",
              "Guid": "febb421d6b9f45bfa4e9a71e9a79053a",
              "ClientRectangle": "390,0,359,40",
              "ComponentStyle": "Header2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Description"
              },
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "Font": "Segoe UI;12;Bold;",
              "Border": "Left;White;;;;;;solid:Black",
              "Brush": "solid:255,179,135",
              "TextBrush": "solid:255,255,255",
              "Type": "Expression"
            }
          }
        },
        "2": {
          "Ident": "StiDataBand",
          "Name": "DataBand37",
          "Guid": "4253746f63354780a70c6b38a2163c61",
          "CanGrow": true,
          "ClientRectangle": "0,230,749,270",
          "ComponentStyle": "Data1",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": "All;235,235,235;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text126",
              "Guid": "1fbea62956a44f048c9eed8393d1ef5d",
              "CanGrow": true,
              "ClientRectangle": "0,0,160,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "EAN-8"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text127",
              "Guid": "97f210ebeb8c432f9ac2ffe415a0ccef",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,270",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "The EAN-8 bar-code was developed for use on small packages. It is used instead of the EAN-13 bar-code where an EAN-13 barcode would be too large, for example on packets of gum. The structure of the EAN-8 bar-code is in the same as the structure of the EAN-13 bar-code. The check digit is calculated automatically irrespective of input data. This bar-code does not contain the code of the producer and has only 4 digits. As a result there can only be 10000 specimen products per  organization, so the EAN-8 bar-code is provided only to those organizations which really need it."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";235,235,235;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode57",
              "Guid": "5547daed85024d67ada2ef17dc0e6172",
              "ClientRectangle": "160,0,230,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiEAN8BarCodeType"
              },
              "Code": {
                "Value": "12345678"
              }
            },
            "3": {
              "Ident": "StiBarCode",
              "Name": "BarCode58",
              "Guid": "8a7f7caf126c4d62ac655fa4f388cff8",
              "ClientRectangle": "160,90,230,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiEAN8BarCodeType",
                "SupplementType": "TwoDigit",
                "SupplementCode": "12"
              },
              "Code": {
                "Value": "4523456789012"
              }
            },
            "4": {
              "Ident": "StiBarCode",
              "Name": "BarCode59",
              "Guid": "7e99162526324265b4e322c31f8d0ddf",
              "ClientRectangle": "160,180,230,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiEAN8BarCodeType",
                "SupplementType": "TwoDigit",
                "SupplementCode": "12"
              },
              "Code": {
                "Value": "4523456789012"
              }
            },
            "5": {
              "Ident": "StiText",
              "Name": "Text128",
              "Guid": "03c61f7fc5134532a7e5fbd3ffc8cb7a",
              "CanGrow": true,
              "ClientRectangle": "0,90,160,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "EAN-8 + Sup2"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "6": {
              "Ident": "StiText",
              "Name": "Text129",
              "Guid": "92a9f27353c54b2b915fffe6f11223c2",
              "CanGrow": true,
              "ClientRectangle": "0,180,160,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "EAN-8 + Sup5"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            }
          },
          "CountData": 1
        },
        "3": {
          "Ident": "StiDataBand",
          "Name": "DataBand7",
          "Guid": "4f2ef30123a34147a2f7c647f55ada0a",
          "CanGrow": true,
          "ClientRectangle": "0,540,749,330",
          "ComponentStyle": "Data2",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": ";255,255,255;;;;;;solid:Black",
          "Brush": "solid:240,242,246",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text1",
              "Guid": "6c4848f21ea1439ca7098fc0c03969c2",
              "CanGrow": true,
              "ClientRectangle": "0,0,160,110",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "UPC-A"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text2",
              "Guid": "8d3ad635ab40478ea73e61b3c3a00851",
              "CanGrow": true,
              "ClientRectangle": "390,0,359,330",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "UPC-A was the first barcode, created by Uniform Code Council, Inc. in 1973. The UPC-A barcode is an unbroken code with a fixed length and high density. It is used for tracking trade items in stores, and otherwise marking goods. UPC-A barcodes consist of 11 data digits and one check digit. The first digit is a number system digit that normally represents the type of product being identified. The following 5 digits are a manufacturers code and the next 5 digits are used to identify a specific product. The barcode does not contain any information about characteristics of a product, but only a unique number relating to an entry in the International data base where all information about the particular product is stored.\n"
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";235,235,235;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode1",
              "Guid": "1b6fdb83c7164944b7e6be979102e259",
              "ClientRectangle": "160,0,230,110",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiUpcABarCodeType",
                "ShowQuietZoneIndicator": false
              },
              "Code": {
                "Value": "1234567890123"
              }
            },
            "3": {
              "Ident": "StiBarCode",
              "Name": "BarCode41",
              "Guid": "d32e4210bae34613901d896a15ffffb5",
              "ClientRectangle": "160,110,230,110",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiUpcABarCodeType",
                "SupplementType": "TwoDigit",
                "SupplementCode": "12",
                "ShowQuietZoneIndicator": false
              },
              "Code": {
                "Value": "4523456789012"
              }
            },
            "4": {
              "Ident": "StiBarCode",
              "Name": "BarCode42",
              "Guid": "d05cf8d7c7e84891993a8db2983a57bb",
              "ClientRectangle": "160,220,230,110",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiUpcABarCodeType",
                "SupplementType": "FiveDigit",
                "SupplementCode": "12345",
                "ShowQuietZoneIndicator": false
              },
              "Code": {
                "Value": "4523456789012"
              }
            },
            "5": {
              "Ident": "StiText",
              "Name": "Text13",
              "Guid": "81929836cb984b3598233aa6ee3839b7",
              "CanGrow": true,
              "ClientRectangle": "0,110,160,110",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "UPC-A + Sup2"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "6": {
              "Ident": "StiText",
              "Name": "Text14",
              "Guid": "a395e6a8a93242c482ca953d77f39395",
              "CanGrow": true,
              "ClientRectangle": "0,220,160,110",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "UPC-A + Sup5"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            }
          },
          "EvenStyle": "Data2",
          "CountData": 1
        },
        "4": {
          "Ident": "StiDataBand",
          "Name": "DataBand8",
          "Guid": "0805896964784095bfbaecd326c6e6e4",
          "CanGrow": true,
          "ClientRectangle": "0,910,749,120",
          "ComponentStyle": "Data1",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": "All;235,235,235;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text56",
              "Guid": "bb7055dba4e04b629fd0e8368252deb3",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,120",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "UPC-E"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text57",
              "Guid": "5b7cb780014348a984e3abee07556146",
              "CanGrow": true,
              "ClientRectangle": "390,0,359,120",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "A UPC-E is a smaller seven digit UPC symbology for number system 0. For UPC-E barcodes, normally 6 digits are specified and the barcode calculates the seventh check digit. Before the Middle guard bars, a binary 1 is indicated by a bar, while a 0 is indicated by a space. After the Middle guard bars, however, the patterns are optically inverted. In other words, a 1 is now indicated by a space, and a 0 is now indicated by a bar. It has the same basic structure as the UPC-A barcode. Note the 'human readable' digits at the foot which can be used by operators if the label becomes damaged or will not scan for some reason - \"1234567\" is the number encoded in the barcode."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";235,235,235;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode2",
              "Guid": "7bb0e9bcc5784f5190fd7ae5a4175292",
              "GrowToHeight": true,
              "ClientRectangle": "160,0,230,120",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiUpcEBarCodeType",
                "ShowQuietZoneIndicator": false
              },
              "Code": {
                "Value": "01234567"
              }
            }
          },
          "EvenStyle": "Data2",
          "CountData": 1
        }
      },
      "PaperSize": "A4",
      "TitleBeforeHeader": true,
      "Watermark": {
        "TextBrush": "solid:50,0,0,0"
      }
    },
    "3": {
      "Ident": "StiPage",
      "Name": "Page4",
      "Guid": "41b8831cf6d94b3a9af28c828ed1783f",
      "Interaction": {
        "Ident": "StiInteraction"
      },
      "Border": ";;2;;;;;solid:Black",
      "Brush": "solid:",
      "Components": {
        "0": {
          "Ident": "StiReportTitleBand",
          "Name": "ReportTitleBand4",
          "Guid": "998babe0f71747a9b63a9ec23452d45b",
          "CanGrow": true,
          "ClientRectangle": "0,20,749,90",
          "Interaction": {
            "Ident": "StiInteraction"
          },
          "Border": ";;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text10",
              "Guid": "5765fb289305471595434bc48d5d79c3",
              "CanGrow": true,
              "ClientRectangle": "570,0,179,40",
              "ComponentStyle": "Header1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "{ReportAuthor}"
              },
              "HorAlignment": "Right",
              "VertAlignment": "Center",
              "Font": "Segoe UI;21.75;Bold;",
              "Border": "Bottom;166,166,166;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 0,
                "Right": 3,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text30",
              "Guid": "ab5419cb1b1b45578c77c70e740b6934",
              "CanGrow": true,
              "ClientRectangle": "0,0,570,40",
              "ComponentStyle": "Header1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "EAN\\UPC Barсodes"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;21.75;Bold;",
              "Border": "Bottom;166,166,166;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 2,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiText",
              "Name": "Text41",
              "Guid": "42973933231c4d4ea872a107f1de32b3",
              "CanGrow": true,
              "ClientRectangle": "0,40,570,20",
              "ComponentStyle": "Footer1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "{ReportDescription}"
              },
              "Font": "Segoe UI;9.75;;",
              "Border": ";58,78,94;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:166,166,166",
              "TextOptions": {
                "WordWrap": true
              },
              "Margins": {
                "Left": 6,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "3": {
              "Ident": "StiText",
              "Name": "Text42",
              "Guid": "1710eb5766584ffb92f14636a18faa19",
              "CanGrow": true,
              "ClientRectangle": "570,40,179,20",
              "ComponentStyle": "Footer1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Date: {Today.ToString(\"Y\")}"
              },
              "HorAlignment": "Right",
              "Font": "Segoe UI;9.75;;",
              "Border": ";58,78,94;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:166,166,166",
              "TextOptions": {
                "WordWrap": true
              },
              "Margins": {
                "Left": 0,
                "Right": 4,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            }
          }
        },
        "1": {
          "Ident": "StiPageHeaderBand",
          "Name": "PageHeaderBand8",
          "Guid": "c9c9a16de9164754a40121db7fcdd22f",
          "CanGrow": true,
          "ClientRectangle": "0,150,749,40",
          "Interaction": {
            "Ident": "StiInteraction"
          },
          "Border": ";;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text54",
              "Guid": "ce348690aa1c435f809a7d031f654b8a",
              "ClientRectangle": "0,0,160,40",
              "ComponentStyle": "Header2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Symbology"
              },
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "Font": "Segoe UI;12;Bold;",
              "Border": "Right;White;;;;;;solid:Black",
              "Brush": "solid:255,179,135",
              "TextBrush": "solid:255,255,255",
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text55",
              "Guid": "f1e3ea1f99584ec18281e6382bb5f268",
              "ClientRectangle": "160,0,240,40",
              "ComponentStyle": "Header2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Example"
              },
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "Font": "Segoe UI;12;Bold;",
              "Border": "Left, Right;White;;;;;;solid:Black",
              "Brush": "solid:255,179,135",
              "TextBrush": "solid:255,255,255",
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiText",
              "Name": "Text60",
              "Guid": "febb421d6b9f45bfa4e9a71e9a79053a",
              "ClientRectangle": "390,0,359,40",
              "ComponentStyle": "Header2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Description"
              },
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "Font": "Segoe UI;12;Bold;",
              "Border": "Left;White;;;;;;solid:Black",
              "Brush": "solid:255,179,135",
              "TextBrush": "solid:255,255,255",
              "Type": "Expression"
            }
          }
        },
        "2": {
          "Ident": "StiDataBand",
          "Name": "DataBand9",
          "Guid": "e215071202f84d18a3d86015f67df3da",
          "CanGrow": true,
          "ClientRectangle": "0,230,749,110",
          "ComponentStyle": "Data1",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": "All;235,235,235;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text11",
              "Guid": "6e839464f87347569d78bffcd4647b6a",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,110",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "UPC-Sup2"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text12",
              "Guid": "1fe86f70843449c98775e52e6a4cde60",
              "CanGrow": true,
              "ClientRectangle": "390,0,359,110",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Add-on Symbols (barcodes) can be used in some applications together with the EAN-13, UPC-A, and UPC-E bar-codes. Add-on Symbols may contain 2 or 5 additional digits and are usually placed to the right of the barcode."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode8",
              "Guid": "663287f52abd4fa48cda73c462563023",
              "GrowToHeight": true,
              "ClientRectangle": "160,0,230,110",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";255,255,255;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiUpcSup2BarCodeType",
                "ShowQuietZoneIndicator": false
              },
              "Code": {
                "Value": "02"
              }
            }
          },
          "CountData": 1
        },
        "3": {
          "Ident": "StiDataBand",
          "Name": "DataBand10",
          "Guid": "2bf6e0c272a9450caa28241fadb9fe44",
          "CanGrow": true,
          "ClientRectangle": "0,380,749,120",
          "ComponentStyle": "Data2",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": ";255,255,255;;;;;;solid:Black",
          "Brush": "solid:240,242,246",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text58",
              "Guid": "cea92e738b1f44fcb8df432b1540f6c6",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,120",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "UPC-Sup5"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text59",
              "Guid": "750888fb3660433481880bf33d8059e5",
              "CanGrow": true,
              "ClientRectangle": "390,0,359,120",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Add-on Symbols (barcodes) can be used in some applications together with the EAN-13, UPC-A, and UPC-E bar-codes. Add-on Symbols may contain 2 or 5 additional digits and are usually placed to the right of the barcode."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode9",
              "Guid": "2ea54c8db0294a62a3dcedfd029d4117",
              "GrowToHeight": true,
              "ClientRectangle": "160,0,230,120",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";255,255,255;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "240,242,246",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiUpcSup5BarCodeType",
                "ShowQuietZoneIndicator": false
              },
              "Code": {
                "Value": "00321"
              }
            }
          },
          "CountData": 1
        },
        "4": {
          "Ident": "StiDataBand",
          "Name": "DataBand36",
          "Guid": "046e34997e4a4f02973684cb123dcbcb",
          "CanGrow": true,
          "ClientRectangle": "0,540,749,130",
          "ComponentStyle": "Data1",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": "All;235,235,235;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text136",
              "Guid": "7121b6bd9788441a8fc97202519ce82d",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,130",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "JAN-13"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text137",
              "Guid": "c726da08d8ab45149c89f7c2129ed46d",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,130",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "A JAN-13 barcode is another name for an EAN-13 barcode dedicated for use only in Japan. The first two digits should be 45 or 49 which indicate Japan. Note the 'human readable' digits at the foot which can be used by operators if the label becomes damaged or will not scan for some reason - \"4901234567894\" is the number encoded in the barcode.\n\n"
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";235,235,235;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode53",
              "Guid": "52be6237ddd64cc686749b7397cc3e2f",
              "ClientRectangle": "160,0,230,130",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiJan13BarCodeType"
              },
              "Code": {
                "Value": "4523456789012"
              }
            }
          },
          "CountData": 1
        },
        "5": {
          "Ident": "StiDataBand",
          "Name": "DataBand35",
          "Guid": "7db522d23c8b43668bcdf8c759493fef",
          "CanGrow": true,
          "ClientRectangle": "0,710,749,100",
          "ComponentStyle": "Data2",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": ";255,255,255;;;;;;solid:Black",
          "Brush": "solid:240,242,246",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text134",
              "Guid": "c08c51f796ac4ef895776ffac9a64975",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,100",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "JAN-8"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text135",
              "Guid": "3eaa446dd3b34135b1a2441ac5dfdc4c",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,100",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "A JAN-8 barcode is another name for an EAN-8 barcode dedicated for use only in Japan. The first two digits of the barcode should be 45 or 49 to indicate Japan. Note the 'human readable' digits at the foot which can be used by operators if the label becomes damaged or will not scan for some reason - \"49123456\" is a number encoded in the barcode.\n\n"
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";235,235,235;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode52",
              "Guid": "6245e551c5124832b7664b053f19f041",
              "GrowToHeight": true,
              "ClientRectangle": "160,0,230,100",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiJan8BarCodeType"
              },
              "Code": {
                "Value": "4523456789012"
              }
            }
          },
          "EvenStyle": "Data2",
          "CountData": 1
        }
      },
      "PaperSize": "A4",
      "TitleBeforeHeader": true,
      "Watermark": {
        "TextBrush": "solid:50,0,0,0"
      }
    },
    "4": {
      "Ident": "StiPage",
      "Name": "Page5",
      "Guid": "3543ac03d5b34b1eb8ff0a585c6dfc02",
      "Interaction": {
        "Ident": "StiInteraction"
      },
      "Border": ";;2;;;;;solid:Black",
      "Brush": "solid:",
      "Components": {
        "0": {
          "Ident": "StiReportTitleBand",
          "Name": "ReportTitleBand5",
          "Guid": "c21fce0ce849410f9276a85f3a461d33",
          "CanGrow": true,
          "ClientRectangle": "0,20,749,90",
          "Interaction": {
            "Ident": "StiInteraction"
          },
          "Border": ";;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text61",
              "Guid": "38649832b6b84c15971dc9a42ccdfa76",
              "CanGrow": true,
              "ClientRectangle": "570,0,179,40",
              "ComponentStyle": "Header1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "{ReportAuthor}"
              },
              "HorAlignment": "Right",
              "VertAlignment": "Center",
              "Font": "Segoe UI;21.75;Bold;",
              "Border": "Bottom;166,166,166;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 0,
                "Right": 3,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text117",
              "Guid": "fe2eebe4766b4fd38108bc08a4509465",
              "CanGrow": true,
              "ClientRectangle": "0,0,570,40",
              "ComponentStyle": "Header1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "GS1 Barсodes"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;21.75;Bold;",
              "Border": "Bottom;166,166,166;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 2,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiText",
              "Name": "Text118",
              "Guid": "3bc6a324e4334bbf92daa8d94f341a92",
              "CanGrow": true,
              "ClientRectangle": "0,40,570,20",
              "ComponentStyle": "Footer1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "{ReportDescription}"
              },
              "Font": "Segoe UI;9.75;;",
              "Border": ";58,78,94;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:166,166,166",
              "TextOptions": {
                "WordWrap": true
              },
              "Margins": {
                "Left": 6,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "3": {
              "Ident": "StiText",
              "Name": "Text119",
              "Guid": "43512f74e60a48a69d4e843b1a7344f3",
              "CanGrow": true,
              "ClientRectangle": "570,40,179,20",
              "ComponentStyle": "Footer1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Date: {Today.ToString(\"Y\")}"
              },
              "HorAlignment": "Right",
              "Font": "Segoe UI;9.75;;",
              "Border": ";58,78,94;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:166,166,166",
              "TextOptions": {
                "WordWrap": true
              },
              "Margins": {
                "Left": 0,
                "Right": 4,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            }
          }
        },
        "1": {
          "Ident": "StiPageHeaderBand",
          "Name": "PageHeaderBand3",
          "Guid": "80178ec92dcb45578820672ed1cbc2ae",
          "CanGrow": true,
          "ClientRectangle": "0,150,749,40",
          "Interaction": {
            "Ident": "StiInteraction"
          },
          "Border": ";;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text80",
              "Guid": "243f09e9b489479cb1e07fd171e28f51",
              "ClientRectangle": "0,0,160,40",
              "ComponentStyle": "Header2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Symbology"
              },
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "Font": "Segoe UI;12;Bold;",
              "Border": "Right;White;;;;;;solid:Black",
              "Brush": "solid:255,179,135",
              "TextBrush": "solid:255,255,255",
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text81",
              "Guid": "7e86664d28b34909ad55912a992dec66",
              "ClientRectangle": "160,0,240,40",
              "ComponentStyle": "Header2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Example"
              },
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "Font": "Segoe UI;12;Bold;",
              "Border": "Left, Right;White;;;;;;solid:Black",
              "Brush": "solid:255,179,135",
              "TextBrush": "solid:255,255,255",
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiText",
              "Name": "Text82",
              "Guid": "62e678191b994069a50b4c0617f6530f",
              "ClientRectangle": "390,0,359,40",
              "ComponentStyle": "Header2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Description"
              },
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "Font": "Segoe UI;12;Bold;",
              "Border": "Left;White;;;;;;solid:Black",
              "Brush": "solid:255,179,135",
              "TextBrush": "solid:255,255,255",
              "Type": "Expression"
            }
          }
        },
        "2": {
          "Ident": "StiDataBand",
          "Name": "DataBand33",
          "Guid": "2af63d0b44b34f209b5e31462ed8f335",
          "CanGrow": true,
          "ClientRectangle": "0,230,749,120",
          "ComponentStyle": "Data1",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": "All;235,235,235;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text101",
              "Guid": "f5ce175ce1b54519923682f13a6e4d0c",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,120",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "GS1-128"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text102",
              "Guid": "3942212a1818422d96611764ff589ce6",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,120",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "GS1-128 was developed to provide a global standard for exchanging data between different companies. GS1-128 not only encodes the data, but provides a method of defining the meaning of the data by defining a list of “Application Identifiers” (best before dates, batch numbers, quantities, weights and many other attributes needed by the user).\nGS1-128 is a derivative language of the Code 128 symbology, utilizing a control character (FNC1) and application identifiers."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";235,235,235;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode24",
              "Guid": "9971945ac11d416f9f2297f5292bba7d",
              "GrowToHeight": true,
              "ClientRectangle": "160,0,230,120",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiGS1_128BarCodeType"
              },
              "Code": {
                "Value": "(21)012345(3103)000123"
              }
            }
          },
          "EvenStyle": "Data2",
          "CountData": 1
        },
        "3": {
          "Ident": "StiDataBand",
          "Name": "DataBand2",
          "Guid": "e0f6de6c79ea4db080fd93efaa2aea85",
          "CanGrow": true,
          "ClientRectangle": "0,390,749,120",
          "ComponentStyle": "Data2",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": ";255,255,255;;;;;;solid:Black",
          "Brush": "solid:240,242,246",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text150",
              "Guid": "b17e1b9db5e04389b818cdf8c0c96d1c",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,120",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "GS1 DataMatrix"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text151",
              "Guid": "03ed3d937eb04d57a5920af828273d76",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,120",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "GS1 DataMatrix is a matrix (2D or two-dimensional) barcode which may be printed as a square or rectangular symbol made up of individual dots or squares. This representation is an ordered grid of dark and light dots bordered by a finder pattern."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";235,235,235;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode37",
              "Guid": "808941f45d824f4bb5470b1e2dd2f797",
              "GrowToHeight": true,
              "ClientRectangle": "160,0,230,120",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiGS1DataMatrixBarCodeType"
              },
              "Code": {
                "Value": "[21]012345[3103]000123"
              }
            }
          },
          "EvenStyle": "Data2",
          "CountData": 1
        },
        "4": {
          "Ident": "StiDataBand",
          "Name": "DataBand29",
          "Guid": "7e94836a47384e5d8d69de3a103e5016",
          "CanGrow": true,
          "ClientRectangle": "0,550,749,120",
          "ComponentStyle": "Data1",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": "All;235,235,235;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text152",
              "Guid": "5d88c6f97657476f9a8035b75021bfdd",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,120",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "GS1 QR Code"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text153",
              "Guid": "c2a5431c41754b4a903a908dd3047cf7",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,120",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "GS1 QR Codes were recently introduced to the GS1 System to provide another option for extended labeling, such as the representation of a URL with a GTIN on a product. Containing up to 4,296 characters, the GS1 QR Code is a two-dimensional square barcode that carries text-based data."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";235,235,235;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode39",
              "Guid": "1d76f3b9953b4f6ead196ed9bb4aeb89",
              "GrowToHeight": true,
              "ClientRectangle": "160,0,230,120",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiGS1QRCodeBarCodeType",
                "BodyBrush": "empty",
                "EyeFrameBrush": "empty",
                "EyeBallBrush": "empty"
              },
              "Code": {
                "Value": "[21]012345[3103]000123"
              }
            }
          },
          "EvenStyle": "Data2",
          "CountData": 1
        },
        "5": {
          "Ident": "StiDataBand",
          "Name": "DataBand28",
          "Guid": "6393389e0b5446afa46b6a700491ba72",
          "CanGrow": true,
          "ClientRectangle": "0,710,749,120",
          "ComponentStyle": "Data2",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": ";255,255,255;;;;;;solid:Black",
          "Brush": "solid:240,242,246",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text44",
              "Guid": "448dbda4c73f445f966b33769e0d6fb1",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,120",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "SSCC"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text76",
              "Guid": "3c77fc515f3d41ad96e2c52b4b1a2e35",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,120",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "The Serial Shipping Container Code (SSCC) is an 18-digit number used to identify logistics units. In order to automate the reading process, the SSCC is often encoded in a barcode, generally GS1-128, and can also be encoded in an RFID tag. It is used in electronic commerce transactions."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";235,235,235;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode30",
              "Guid": "c2c9e52cad4745d0a97ecc1ee20c9b67",
              "GrowToHeight": true,
              "ClientRectangle": "160,0,230,120",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiSSCC18BarCodeType"
              },
              "Code": {
                "Value": "(00)~0~0123456~000000001~8"
              }
            }
          },
          "EvenStyle": "Data2",
          "CountData": 1
        },
        "6": {
          "Ident": "StiDataBand",
          "Name": "DataBand5",
          "Guid": "e779c47164c0484b96c0ba4ad1cfb651",
          "CanGrow": true,
          "ClientRectangle": "0,870,749,120",
          "ComponentStyle": "Data1",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": "All;235,235,235;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text120",
              "Guid": "29484c110c6a4c9bba77c6a72aa23e96",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,120",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "ITF 14"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text121",
              "Guid": "1405eb6119974953bb0f9f8c271a13b6",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,120",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "The ITF-14 bar-code was developed to encode a Global Trade Item Number. The ITF bar-code has the nominal size of  (152*44mm) and low requirements to the printing surface. Therefore, it can be printed not only on a label but directly onto a packing carton."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";235,235,235;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode7",
              "Guid": "e4d835d27b1a4af1bcdc6259a9aac1f7",
              "GrowToHeight": true,
              "ClientRectangle": "160,0,230,120",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiITF14BarCodeType",
                "Module": 12
              },
              "Code": {
                "Value": "15400141288763"
              }
            }
          },
          "EvenStyle": "Data2",
          "CountData": 1
        }
      },
      "PaperSize": "A4",
      "TitleBeforeHeader": true,
      "Watermark": {
        "TextBrush": "solid:50,0,0,0"
      }
    },
    "5": {
      "Ident": "StiPage",
      "Name": "Page6",
      "Guid": "72e4353ebf454f70b5e98d54ba075891",
      "Interaction": {
        "Ident": "StiInteraction"
      },
      "Border": ";;2;;;;;solid:Black",
      "Brush": "solid:",
      "Components": {
        "0": {
          "Ident": "StiReportTitleBand",
          "Name": "ReportTitleBand6",
          "Guid": "d27fd4cebfa54df98667460e37bdccf7",
          "CanGrow": true,
          "ClientRectangle": "0,20,749,90",
          "Interaction": {
            "Ident": "StiInteraction"
          },
          "Border": ";;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text122",
              "Guid": "9582512879b14544901db53b4dbde8e2",
              "CanGrow": true,
              "ClientRectangle": "570,0,179,40",
              "ComponentStyle": "Header1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "{ReportAuthor}"
              },
              "HorAlignment": "Right",
              "VertAlignment": "Center",
              "Font": "Segoe UI;21.75;Bold;",
              "Border": "Bottom;166,166,166;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 0,
                "Right": 3,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text123",
              "Guid": "cab228996eed44e5b3f54b4c1996e1b5",
              "CanGrow": true,
              "ClientRectangle": "0,0,570,40",
              "ComponentStyle": "Header1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "POST Barсodes"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;21.75;Bold;",
              "Border": "Bottom;166,166,166;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 2,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiText",
              "Name": "Text124",
              "Guid": "f7883e1d316042fab887ef168b67f868",
              "CanGrow": true,
              "ClientRectangle": "0,40,570,20",
              "ComponentStyle": "Footer1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "{ReportDescription}"
              },
              "Font": "Segoe UI;9.75;;",
              "Border": ";58,78,94;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:166,166,166",
              "TextOptions": {
                "WordWrap": true
              },
              "Margins": {
                "Left": 6,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "3": {
              "Ident": "StiText",
              "Name": "Text125",
              "Guid": "db09eb0ccaf443cc8182ff89becc7dda",
              "CanGrow": true,
              "ClientRectangle": "570,40,179,20",
              "ComponentStyle": "Footer1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Date: {Today.ToString(\"Y\")}"
              },
              "HorAlignment": "Right",
              "Font": "Segoe UI;9.75;;",
              "Border": ";58,78,94;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:166,166,166",
              "TextOptions": {
                "WordWrap": true
              },
              "Margins": {
                "Left": 0,
                "Right": 4,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            }
          }
        },
        "1": {
          "Ident": "StiPageHeaderBand",
          "Name": "PageHeaderBand4",
          "Guid": "ae724dbebc244ff2bc4919770e63af1c",
          "CanGrow": true,
          "ClientRectangle": "0,150,749,40",
          "Interaction": {
            "Ident": "StiInteraction"
          },
          "Border": ";;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text83",
              "Guid": "c6de4550896c44f88ab91db65eca3af5",
              "ClientRectangle": "0,0,160,40",
              "ComponentStyle": "Header2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Symbology"
              },
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "Font": "Segoe UI;12;Bold;",
              "Border": "Right;White;;;;;;solid:Black",
              "Brush": "solid:255,179,135",
              "TextBrush": "solid:255,255,255",
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text84",
              "Guid": "a6b2863efecc42238b1bb51f12846e17",
              "ClientRectangle": "160,0,240,40",
              "ComponentStyle": "Header2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Example"
              },
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "Font": "Segoe UI;12;Bold;",
              "Border": "Left, Right;White;;;;;;solid:Black",
              "Brush": "solid:255,179,135",
              "TextBrush": "solid:255,255,255",
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiText",
              "Name": "Text85",
              "Guid": "23c59246b0644bdeb8d47bb1d0fb5fae",
              "ClientRectangle": "390,0,359,40",
              "ComponentStyle": "Header2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Description"
              },
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "Font": "Segoe UI;12;Bold;",
              "Border": "Left;White;;;;;;solid:Black",
              "Brush": "solid:255,179,135",
              "TextBrush": "solid:255,255,255",
              "Type": "Expression"
            }
          }
        },
        "2": {
          "Ident": "StiDataBand",
          "Name": "DataBand25",
          "Guid": "43cd43c322a941a28dfa1444b337570c",
          "CanGrow": true,
          "ClientRectangle": "0,230,749,90",
          "ComponentStyle": "Data1",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": "All;235,235,235;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text73",
              "Guid": "e01a4736eda341518c74e833077359a1",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Australia Post 4 State"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text74",
              "Guid": "8d5a8ee8e49240be92433fce86c4867b",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "The Australia Post 4-Stage bar-code is used in Australia for the purposes of sorting and directing mail. The barcode consists of 4 elements (4 conditions), each has its own name, value. Each element consists of two bars and two spaces. Each barcode contains 4 check symbols, calculated by the ReedSolomon algorithm. The value of these symbols are usually printed after the text of the barcode."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";235,235,235;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode13",
              "Guid": "408630335632490e928f23d9dc9b89a0",
              "GrowToHeight": true,
              "ClientRectangle": "160,0,230,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiAustraliaPost4StateBarCodeType"
              },
              "Code": {
                "Value": "1139987520"
              }
            }
          },
          "CountData": 1
        },
        "3": {
          "Ident": "StiDataBand",
          "Name": "DataBand24",
          "Guid": "08fa171423aa43b4ba240e1122769c9c",
          "CanGrow": true,
          "ClientRectangle": "0,360,749,70",
          "ComponentStyle": "Data2",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": ";255,255,255;;;;;;solid:Black",
          "Brush": "solid:240,242,246",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text15",
              "Guid": "6d9e65e703a84d8e8ea7c0bddf56de11",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,70",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Intelligent Mail 4-State"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text16",
              "Guid": "0ab5eb047fce4ffc9a58afca0c7fece2",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,70",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "USPS Intelligent Mail barcode (IMb), also known as the USPS OneCode Solution or USPS 4-State Customer Code, was developed by the United States Postal Service (USPS) and is used for automated sorting of mail."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode12",
              "Guid": "8bd1509db7da4eedb992a6d0299250b7",
              "GrowToHeight": true,
              "ClientRectangle": "160,0,230,70",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "BackColor": "Transparent",
              "AutoScale": true,
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiIntelligentMail4StateBarCodeType",
                "Module": 20
              },
              "Code": {
                "Value": "01 234 567094 987654321 01234 5678 91"
              }
            }
          },
          "CountData": 1
        },
        "4": {
          "Ident": "StiDataBand",
          "Name": "DataBand13",
          "Guid": "087c5a2a0bce4da4813ac533b227a7f9",
          "CanGrow": true,
          "ClientRectangle": "0,470,749,90",
          "ComponentStyle": "Data1",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": "All;235,235,235;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text139",
              "Guid": "1902055dc5bb4ccab7a224f24b8995d6",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Postnet"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text140",
              "Guid": "815fea5a72aa442e9dfaef6c8e07b817",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "The POSTNET (POSTal Numeric Encoding Technique) bar-code was developed by the United States Postal Service for encoding ZIP-codes and correct sorting using BCSs. It can encode ZIP, ZIP+4, and ZIP+4+2 postal codes.\nThe Postnet bar-code can encode 0-9 digits. The bar-code consist of short and long bars. Each symbol of data is encoded using five bars. This bar-code contains only one check symbol, that is calculated by the modulo-10 algorithm."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";235,235,235;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode50",
              "Guid": "a3e401b7b7874b80af81f3859f415720",
              "GrowToHeight": true,
              "ClientRectangle": "160,0,230,90",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiPostnetBarCodeType"
              },
              "Code": {
                "Value": "12345"
              }
            }
          },
          "EvenStyle": "Data2",
          "CountData": 1
        },
        "5": {
          "Ident": "StiDataBand",
          "Name": "DataBand27",
          "Guid": "f0248cf3fbd9428f9ae6c708b7385de2",
          "CanGrow": true,
          "ClientRectangle": "0,600,749,70",
          "ComponentStyle": "Data2",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": ";255,255,255;;;;;;solid:Black",
          "Brush": "solid:240,242,246",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text31",
              "Guid": "ff2ddd015e1c463580bcd8bc26bff8f5",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,70",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Royal TPG Post KIX 4-State"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text75",
              "Guid": "b20146c38a8d4ff99af23da454cdef9c",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,70",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "This symbology is used by Royal Dutch TPG Post (Netherlands) for Postal code and automatic mail sorting. It provides information about the address of the receiver. This symbology encodes alpha-numeric characters (0-9, A-Z)."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode27",
              "Guid": "14540f76fd82422a9cdfa4e04301c53e",
              "GrowToHeight": true,
              "ClientRectangle": "160,0,240,70",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiDutchKIXBarCodeType"
              },
              "Code": {
                "Value": "2500GG30250"
              }
            }
          },
          "CountData": 1
        },
        "6": {
          "Ident": "StiDataBand",
          "Name": "DataBand26",
          "Guid": "950a74c5928443c6bd0326af8019f2ce",
          "CanGrow": true,
          "ClientRectangle": "0,710,749,60",
          "ComponentStyle": "Data1",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": "All;235,235,235;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text23",
              "Guid": "763871af208c4f84bddc1fde51958196",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,60",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Royal Mail 4 State"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text28",
              "Guid": "e15768f3e47843969c1415080518ca62",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,60",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "The Royal Mail 4-state Customer Code(RM4SCC) is a height-modulated barcode symbology for use in automated mail sort process."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";235,235,235;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode22",
              "Guid": "aac19ee498a9443fa13720e0b250153c",
              "ClientRectangle": "160,0,230,60",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiRoyalMail4StateBarCodeType"
              },
              "Code": {
                "Value": "529508A"
              }
            }
          },
          "EvenStyle": "Data2",
          "CountData": 1
        },
        "7": {
          "Ident": "StiDataBand",
          "Name": "DataBand12",
          "Guid": "21bacd5deb5f442890dd44d2f8faebdd",
          "CanGrow": true,
          "ClientRectangle": "0,810,749,270",
          "ComponentStyle": "Data2",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": ";255,255,255;;;;;;solid:Black",
          "Brush": "solid:240,242,246",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text130",
              "Guid": "284a2781935341a8873b2640a2226f7b",
              "CanGrow": true,
              "ClientRectangle": "0,0,160,70",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "FIM A"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text131",
              "Guid": "417e9b975bc74f778909ed3197605eff",
              "CanGrow": true,
              "ClientRectangle": "390,0,359,270",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Facing Identification Mark (FIM) is the type of postal bar code used in automated mail processing by the U.S. Postal Service. FIM is a set of vertical bars. FIM patterns are placed in the upper right corner along the top edge and two inches in from the right edge of letters and cards."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiText",
              "Name": "Text132",
              "Guid": "006929c445f149caa7898fa30403e197",
              "CanGrow": true,
              "ClientRectangle": "0,70,160,70",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "FIM B"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "3": {
              "Ident": "StiText",
              "Name": "Text133",
              "Guid": "077827fa23e242d592fa426ed5846bae",
              "CanGrow": true,
              "ClientRectangle": "0,140,160,70",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "FIM C"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "4": {
              "Ident": "StiBarCode",
              "Name": "BarCode11",
              "Guid": "2619a1fdaf964271a5fe6372f7afba2b",
              "ClientRectangle": "240,0,70,70",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";255,255,255;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "240,242,246",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiFIMBarCodeType"
              },
              "Code": {
                "Value": "A"
              }
            },
            "5": {
              "Ident": "StiBarCode",
              "Name": "BarCode20",
              "Guid": "f75d3a072aac4501893aac7ced5fd134",
              "ClientRectangle": "240,70,70,70",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";255,255,255;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "240,242,246",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiFIMBarCodeType"
              },
              "Code": {
                "Value": "B"
              }
            },
            "6": {
              "Ident": "StiBarCode",
              "Name": "BarCode46",
              "Guid": "753934dabed543959eb995acd3711fd9",
              "ClientRectangle": "240,140,70,70",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";255,255,255;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "240,242,246",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiFIMBarCodeType"
              },
              "Code": {
                "Value": "C"
              }
            },
            "7": {
              "Ident": "StiBarCode",
              "Name": "BarCode47",
              "Guid": "37dd237db85f47caa1f83410a559353f",
              "ClientRectangle": "240,210,70,60",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";255,255,255;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "240,242,246",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiFIMBarCodeType"
              },
              "Code": {
                "Value": "D"
              }
            },
            "8": {
              "Ident": "StiText",
              "Name": "Text138",
              "Guid": "475f33efaeab4a4f801638fca4d34dff",
              "CanGrow": true,
              "ClientRectangle": "0,210,160,60",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "FIM D"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            }
          },
          "EvenStyle": "Data2",
          "CountData": 1
        }
      },
      "PaperSize": "A4",
      "TitleBeforeHeader": true,
      "Watermark": {
        "TextBrush": "solid:50,0,0,0"
      }
    },
    "6": {
      "Ident": "StiPage",
      "Name": "Page7",
      "Guid": "16e115c651824fea94f8048a817ce120",
      "Interaction": {
        "Ident": "StiInteraction"
      },
      "Border": ";;2;;;;;solid:Black",
      "Brush": "solid:",
      "Components": {
        "0": {
          "Ident": "StiReportTitleBand",
          "Name": "ReportTitleBand7",
          "Guid": "3cb97702996c482fb2e6fecdcc133495",
          "CanGrow": true,
          "ClientRectangle": "0,20,749,90",
          "Interaction": {
            "Ident": "StiInteraction"
          },
          "Border": ";;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text29",
              "Guid": "b251f96475c54f85a4a292beebb7df32",
              "CanGrow": true,
              "ClientRectangle": "570,0,179,40",
              "ComponentStyle": "Header1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "{ReportAuthor}"
              },
              "HorAlignment": "Right",
              "VertAlignment": "Center",
              "Font": "Segoe UI;21.75;Bold;",
              "Border": "Bottom;166,166,166;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 0,
                "Right": 3,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text89",
              "Guid": "76d778ef5aab4aaaa2fefb11dcc7f1d6",
              "CanGrow": true,
              "ClientRectangle": "0,0,570,40",
              "ComponentStyle": "Header1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Other Barсodes"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;21.75;Bold;",
              "Border": "Bottom;166,166,166;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 2,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiText",
              "Name": "Text90",
              "Guid": "131b793afedf4035ad9b7e467643266e",
              "CanGrow": true,
              "ClientRectangle": "0,40,570,20",
              "ComponentStyle": "Footer1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "{ReportDescription}"
              },
              "Font": "Segoe UI;9.75;;",
              "Border": ";58,78,94;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:166,166,166",
              "TextOptions": {
                "WordWrap": true
              },
              "Margins": {
                "Left": 6,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "3": {
              "Ident": "StiText",
              "Name": "Text91",
              "Guid": "c4e5c08918fc4a279d5f910480223b8c",
              "CanGrow": true,
              "ClientRectangle": "570,40,179,20",
              "ComponentStyle": "Footer1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Date: {Today.ToString(\"Y\")}"
              },
              "HorAlignment": "Right",
              "Font": "Segoe UI;9.75;;",
              "Border": ";58,78,94;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:166,166,166",
              "TextOptions": {
                "WordWrap": true
              },
              "Margins": {
                "Left": 0,
                "Right": 4,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            }
          }
        },
        "1": {
          "Ident": "StiPageHeaderBand",
          "Name": "PageHeaderBand5",
          "Guid": "215256195c674eb38e3c1de31d368e7b",
          "CanGrow": true,
          "ClientRectangle": "0,150,749,40",
          "Interaction": {
            "Ident": "StiInteraction"
          },
          "Border": ";;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text86",
              "Guid": "660321c5d79148cdadfb40aea698db00",
              "ClientRectangle": "0,0,160,40",
              "ComponentStyle": "Header2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Symbology"
              },
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "Font": "Segoe UI;12;Bold;",
              "Border": "Right;White;;;;;;solid:Black",
              "Brush": "solid:255,179,135",
              "TextBrush": "solid:255,255,255",
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text87",
              "Guid": "78b1574963794112a4096a7cdb17f8c7",
              "ClientRectangle": "160,0,240,40",
              "ComponentStyle": "Header2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Example"
              },
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "Font": "Segoe UI;12;Bold;",
              "Border": "Left, Right;White;;;;;;solid:Black",
              "Brush": "solid:255,179,135",
              "TextBrush": "solid:255,255,255",
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiText",
              "Name": "Text88",
              "Guid": "4257f3feda25431e92e0cd52e05cacc1",
              "ClientRectangle": "390,0,359,40",
              "ComponentStyle": "Header2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Description"
              },
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "Font": "Segoe UI;12;Bold;",
              "Border": "Left;White;;;;;;solid:Black",
              "Brush": "solid:255,179,135",
              "TextBrush": "solid:255,255,255",
              "Type": "Expression"
            }
          }
        },
        "2": {
          "Ident": "StiDataBand",
          "Name": "DataBand17",
          "Guid": "805347d55b244e95b4779a7fbaf779f1",
          "CanGrow": true,
          "ClientRectangle": "0,230,749,90",
          "ComponentStyle": "Data1",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": "All;235,235,235;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text20",
              "Guid": "52c09030b044479490d56b1386d51ea1",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Pharmacode"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text67",
              "Guid": "4d37ebad6ab2452db5b12da386ba07b1",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "A Pharmacode barcode is used in the pharmaceutical industry as a packing control system. The Pharmacode barcode is placed on the package. A Pharmacode barcode can represent only a single integer from 3 to 131070. All digits in the specified range make correct barcodes, but some of these barcodes can be unreadable because all barcodes are identical."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";235,235,235;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode16",
              "Guid": "f30aa3dee862485ebbf7adf266585ae3",
              "GrowToHeight": true,
              "ClientRectangle": "160,0,230,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiPharmacodeBarCodeType"
              },
              "Code": {
                "Value": "1256"
              }
            }
          },
          "CountData": 1
        },
        "3": {
          "Ident": "StiDataBand",
          "Name": "DataBand16",
          "Guid": "5d11cfa85688435eb27af3fc8ce9dca4",
          "CanGrow": true,
          "ClientRectangle": "0,360,749,90",
          "ComponentStyle": "Data2",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": ";255,255,255;;;;;;solid:Black",
          "Brush": "solid:240,242,246",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text18",
              "Guid": "96e428453a4b45fe8aa5b2090f5c634e",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,90",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Code 11"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text19",
              "Guid": "14c4e8f13f1f4ae28e9157fd7b375703",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,90",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "The Code 11 bar-code weas developed by Intermec in 1977. It is used in telecommunications. This barcode has high density and can encode any length string consisting of the digits 0-9 and the dash character. The Code 11 uses one or two check digits and two check symbols. Usually, if the length of the string is less than 10 symbols then only one check symbol is used. If the the length of the string is 10 symbols and more then 2 check symbols are used. The value of the check symbol is calculated by the modulo-10 algorithm."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode15",
              "Guid": "a1f14c4fca2444308f1a940d01690cff",
              "GrowToHeight": true,
              "ClientRectangle": "160,0,230,90",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";255,255,255;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "240,242,246",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiCode11BarCodeType",
                "Module": 13
              },
              "Code": {
                "Value": "A12345678B"
              }
            }
          },
          "CountData": 1
        },
        "4": {
          "Ident": "StiDataBand",
          "Name": "DataBand14",
          "Guid": "d6ac1eb453134f51bada64bbd50329c4",
          "CanGrow": true,
          "ClientRectangle": "0,490,749,360",
          "ComponentStyle": "Data1",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": "All;235,235,235;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text32",
              "Guid": "805026f39b4e409686120cd9fb04eb7d",
              "CanGrow": true,
              "ClientRectangle": "0,0,160,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Code 128a"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text43",
              "Guid": "5694599563274ac488cbea845e4089ae",
              "CanGrow": true,
              "ClientRectangle": "390,0,359,360",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "The Code128 barcode was developed in 1981. It is a variable length, high density, alphanumeric symbology. It allows the output of 128 characters of ASCII and is effective for digits. There are actually three subcodes, which can be mixed within a single barcode: Code128a, Code128b, Code128c. The barcode consist of three bars and three spaces. Bars and spaces have module construction and their width consist of one or four modules. The width of an element consist of eleven modules. The \"Stop\" sign consist of 13 modules and has four bars and three spaces. The check sum is calculated automatically."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";235,235,235;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiText",
              "Name": "Text64",
              "Guid": "7a4eb3d3d38740a4982f01f4c42d8887",
              "CanGrow": true,
              "ClientRectangle": "0,90,160,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Code 128b"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "3": {
              "Ident": "StiText",
              "Name": "Text65",
              "Guid": "60cb1ea6c8744283904c211a34786753",
              "CanGrow": true,
              "ClientRectangle": "0,180,160,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Code 128c"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "4": {
              "Ident": "StiBarCode",
              "Name": "BarCode29",
              "Guid": "ce8f94eb13af4d57864ce0130866d328",
              "ClientRectangle": "160,0,230,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiCode128aBarCodeType"
              },
              "Code": {
                "Value": "ABC123"
              }
            },
            "5": {
              "Ident": "StiBarCode",
              "Name": "BarCode31",
              "Guid": "aff66fd768cf4bc4917c4f8b3f994a24",
              "ClientRectangle": "160,90,230,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiCode128bBarCodeType"
              },
              "Code": {
                "Value": "ABCabc123"
              }
            },
            "6": {
              "Ident": "StiBarCode",
              "Name": "BarCode38",
              "Guid": "58f855c690af444083c581380cc14215",
              "ClientRectangle": "160,180,230,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiCode128cBarCodeType"
              },
              "Code": {
                "Value": "0123456789012345"
              }
            },
            "7": {
              "Ident": "StiText",
              "Name": "Text92",
              "Guid": "12333ff929294db4b0f54cfd0ea06bc0",
              "CanGrow": true,
              "ClientRectangle": "0,270,160,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Code 128 Auto"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "8": {
              "Ident": "StiBarCode",
              "Name": "BarCode28",
              "Guid": "0ca7bf8594824dff8d865c3674dde61f",
              "ClientRectangle": "160,270,230,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiCode128AutoBarCodeType"
              },
              "Code": {
                "Value": "1234567890123"
              }
            }
          },
          "EvenStyle": "Data2",
          "CountData": 1
        }
      },
      "PaperSize": "A4",
      "TitleBeforeHeader": true,
      "Watermark": {
        "TextBrush": "solid:50,0,0,0"
      }
    },
    "7": {
      "Ident": "StiPage",
      "Name": "Page8",
      "Guid": "65eef4866409464fb2ea108ec3ccad77",
      "Interaction": {
        "Ident": "StiInteraction"
      },
      "Border": ";;2;;;;;solid:Black",
      "Brush": "solid:",
      "Components": {
        "0": {
          "Ident": "StiReportTitleBand",
          "Name": "ReportTitleBand8",
          "Guid": "3cb97702996c482fb2e6fecdcc133495",
          "CanGrow": true,
          "ClientRectangle": "0,20,749,90",
          "Interaction": {
            "Ident": "StiInteraction"
          },
          "Border": ";;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text141",
              "Guid": "b251f96475c54f85a4a292beebb7df32",
              "CanGrow": true,
              "ClientRectangle": "570,0,179,40",
              "ComponentStyle": "Header1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "{ReportAuthor}"
              },
              "HorAlignment": "Right",
              "VertAlignment": "Center",
              "Font": "Segoe UI;21.75;Bold;",
              "Border": "Bottom;166,166,166;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 0,
                "Right": 3,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text142",
              "Guid": "76d778ef5aab4aaaa2fefb11dcc7f1d6",
              "CanGrow": true,
              "ClientRectangle": "0,0,570,40",
              "ComponentStyle": "Header1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Other Barсodes"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;21.75;Bold;",
              "Border": "Bottom;166,166,166;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 2,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiText",
              "Name": "Text143",
              "Guid": "131b793afedf4035ad9b7e467643266e",
              "CanGrow": true,
              "ClientRectangle": "0,40,570,20",
              "ComponentStyle": "Footer1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "{ReportDescription}"
              },
              "Font": "Segoe UI;9.75;;",
              "Border": ";58,78,94;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:166,166,166",
              "TextOptions": {
                "WordWrap": true
              },
              "Margins": {
                "Left": 6,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "3": {
              "Ident": "StiText",
              "Name": "Text144",
              "Guid": "c4e5c08918fc4a279d5f910480223b8c",
              "CanGrow": true,
              "ClientRectangle": "570,40,179,20",
              "ComponentStyle": "Footer1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Date: {Today.ToString(\"Y\")}"
              },
              "HorAlignment": "Right",
              "Font": "Segoe UI;9.75;;",
              "Border": ";58,78,94;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:166,166,166",
              "TextOptions": {
                "WordWrap": true
              },
              "Margins": {
                "Left": 0,
                "Right": 4,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            }
          }
        },
        "1": {
          "Ident": "StiPageHeaderBand",
          "Name": "PageHeaderBand9",
          "Guid": "215256195c674eb38e3c1de31d368e7b",
          "CanGrow": true,
          "ClientRectangle": "0,150,749,40",
          "Interaction": {
            "Ident": "StiInteraction"
          },
          "Border": ";;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text145",
              "Guid": "660321c5d79148cdadfb40aea698db00",
              "ClientRectangle": "0,0,160,40",
              "ComponentStyle": "Header2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Symbology"
              },
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "Font": "Segoe UI;12;Bold;",
              "Border": "Right;White;;;;;;solid:Black",
              "Brush": "solid:255,179,135",
              "TextBrush": "solid:255,255,255",
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text146",
              "Guid": "78b1574963794112a4096a7cdb17f8c7",
              "ClientRectangle": "160,0,240,40",
              "ComponentStyle": "Header2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Example"
              },
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "Font": "Segoe UI;12;Bold;",
              "Border": "Left, Right;White;;;;;;solid:Black",
              "Brush": "solid:255,179,135",
              "TextBrush": "solid:255,255,255",
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiText",
              "Name": "Text147",
              "Guid": "4257f3feda25431e92e0cd52e05cacc1",
              "ClientRectangle": "390,0,359,40",
              "ComponentStyle": "Header2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Description"
              },
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "Font": "Segoe UI;12;Bold;",
              "Border": "Left;White;;;;;;solid:Black",
              "Brush": "solid:255,179,135",
              "TextBrush": "solid:255,255,255",
              "Type": "Expression"
            }
          }
        },
        "2": {
          "Ident": "StiDataBand",
          "Name": "DataBand40",
          "CanGrow": true,
          "ClientRectangle": "0,230,749,90",
          "ComponentStyle": "Data1",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": "All;235,235,235;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiBarCode",
              "Name": "BarCode56",
              "Guid": "8e9b2e445858472a91a796d2fea72d94",
              "GrowToHeight": true,
              "ClientRectangle": "160,0,230,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";193,152,89;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiCode39BarCodeType"
              },
              "Code": {
                "Value": "ABC123"
              }
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text157",
              "Guid": "2debd69f7e124a858c781c1522d33293",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Code 39"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              }
            },
            "2": {
              "Ident": "StiText",
              "Name": "Text158",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Code 39 is a variable length symbology that can encode 44 characters. Code 39 is the most popular symbology in the non-retail world and is used extensively in manufacturing, military, and medicine applications. Each Code 39 bar code has a start/stop character represented by an asterisk (*).The bar-code code does not contain the check character but can be added programmatically. Each character starts with a 'dark bar' that consists of 5 dark and 4 blank bars. The ratio between narrow and wide bars may range from 2.2:1 to 3:1. The Code 39 barcode has low data density. It requires more free space than Code 128, but the Code 39 barcode can be identified by any barcode scanner.\n"
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";235,235,235;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            }
          },
          "CountData": 1
        },
        "3": {
          "Ident": "StiDataBand",
          "Name": "DataBand41",
          "Guid": "743e2ebfbdf74414aa92cc09ea5c7ddd",
          "CanGrow": true,
          "ClientRectangle": "0,360,749,90",
          "ComponentStyle": "Data2",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": ";255,255,255;;;;;;solid:Black",
          "Brush": "solid:240,242,246",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text159",
              "Guid": "aefa327060b3436b86220572fac9db68",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,90",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Code 39 Extended"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text160",
              "Guid": "82086d66c8fe4fedac4158421fd5ce76",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,90",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Code 39 extended is the version of the Code 39 bar-code which also supports the ASCII set of characters. The 0-9, A-Z, \".\" and \"-\" characters are encoded the same as of the Code 39 bar-code. "
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode60",
              "Guid": "6e203de99cb846c4a82e3ce005a8f85c",
              "GrowToHeight": true,
              "ClientRectangle": "160,0,230,90",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";255,255,255;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "240,242,246",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiCode39ExtBarCodeType"
              },
              "Code": {
                "Value": "Abc123"
              }
            }
          },
          "CountData": 1
        },
        "4": {
          "Ident": "StiDataBand",
          "Name": "DataBand3",
          "Guid": "29b44bd24f804b22b821527e9701ba7a",
          "CanGrow": true,
          "ClientRectangle": "0,490,749,90",
          "ComponentStyle": "Data1",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": "All;235,235,235;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text51",
              "Guid": "88391acafbc9458086c578d525c889ca",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Code 93"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text52",
              "Guid": "a40ecda5c45a4bafa665d3be81856007",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "The Code 93 is a variable length symbology that can encode the complete 128 ASCII character set. This barcode was developed as an enhanced version of the Code 39 barcode. It has a higher density than either the Code 39 or the Code 128 bar-code. The Code 93 barcode may encode Latin letters (from A to Z), digits (from 0 to 9) and a group of special characters. The barcode always contains two check characters. Each characters consist of nine modules which are joined in 3 groups. Each group has one black bar and one white bar."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";235,235,235;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode14",
              "Guid": "e10b1597026642ec87bc8e02efe88970",
              "GrowToHeight": true,
              "ClientRectangle": "160,0,230,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiCode93BarCodeType"
              },
              "Code": {
                "Value": "ABC123"
              }
            }
          },
          "CountData": 1
        },
        "5": {
          "Ident": "StiDataBand",
          "Name": "DataBand4",
          "Guid": "b7a2b261253944fe86d07f7dc655a23d",
          "CanGrow": true,
          "ClientRectangle": "0,620,749,90",
          "ComponentStyle": "Data2",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": ";255,255,255;;;;;;solid:Black",
          "Brush": "solid:240,242,246",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text17",
              "Guid": "a81390d063ab4deab76b9de476591281",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,90",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Code 93 Extended"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text53",
              "Guid": "c6999c6c0f0a4fe8a66af027ef532714",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,90",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Code 93 extended is a version of the Code 93 barcode that supports a set of ASCII characters. All additional symbols are encoded as a sequence of two Code 93 characters. The first character is always one of four special characters. Therefore, scanners can always identify the different versions of the bar-code."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode45",
              "Guid": "79ed56bb291b4b039ce39f346026489d",
              "GrowToHeight": true,
              "ClientRectangle": "160,0,230,90",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";255,255,255;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "240,242,246",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiCode93ExtBarCodeType"
              },
              "Code": {
                "Value": "Abc123"
              }
            }
          },
          "CountData": 1
        },
        "6": {
          "Ident": "StiDataBand",
          "Name": "DataBand11",
          "Guid": "f24fe735b49d4ed7a90c0b38ccaf38af",
          "CanGrow": true,
          "ClientRectangle": "0,750,749,90",
          "ComponentStyle": "Data1",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": "All;235,235,235;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text39",
              "Guid": "1e661a1b83644029bd18855fbadb0759",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Codabar"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text40",
              "Guid": "bc14da45817148439eed17cf478c09c5",
              "CanGrow": true,
              "ClientRectangle": "390,0,359,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "The Codabar is a linear barcode symbology developed in 1972. It can be called as NW-7, USD-4, Code 2 of 7 (2 values of a bar length, 7 elements). It is frequently used in medicine (for example, blood bank forms). Two bars and three spaces are used for encoding. The bar-code has four different sets of start/stop characters: A, B, C, D. These characters are used only as start/stop characters and should not be appeared in the bar-code."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";235,235,235;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode10",
              "Guid": "da3c3792d7e64aaf853d8362477f9cc1",
              "ClientRectangle": "160,0,230,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiCodabarBarCodeType"
              },
              "Code": {
                "Value": "A12345678B"
              }
            }
          },
          "CountData": 1
        }
      },
      "PaperSize": "A4",
      "TitleBeforeHeader": true,
      "Watermark": {
        "TextBrush": "solid:50,0,0,0"
      }
    },
    "8": {
      "Ident": "StiPage",
      "Name": "Page9",
      "Guid": "b36bffc37cc04c30805c7f0527fb7d72",
      "Interaction": {
        "Ident": "StiInteraction"
      },
      "Border": ";;2;;;;;solid:Black",
      "Brush": "solid:",
      "Components": {
        "0": {
          "Ident": "StiReportTitleBand",
          "Name": "ReportTitleBand9",
          "Guid": "3cb97702996c482fb2e6fecdcc133495",
          "CanGrow": true,
          "ClientRectangle": "0,20,749,90",
          "Interaction": {
            "Ident": "StiInteraction"
          },
          "Border": ";;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text9",
              "Guid": "b251f96475c54f85a4a292beebb7df32",
              "CanGrow": true,
              "ClientRectangle": "570,0,179,40",
              "ComponentStyle": "Header1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "{ReportAuthor}"
              },
              "HorAlignment": "Right",
              "VertAlignment": "Center",
              "Font": "Segoe UI;21.75;Bold;",
              "Border": "Bottom;166,166,166;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 0,
                "Right": 3,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text45",
              "Guid": "76d778ef5aab4aaaa2fefb11dcc7f1d6",
              "CanGrow": true,
              "ClientRectangle": "0,0,570,40",
              "ComponentStyle": "Header1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Other Barсodes"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;21.75;Bold;",
              "Border": "Bottom;166,166,166;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 2,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiText",
              "Name": "Text49",
              "Guid": "131b793afedf4035ad9b7e467643266e",
              "CanGrow": true,
              "ClientRectangle": "0,40,570,20",
              "ComponentStyle": "Footer1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "{ReportDescription}"
              },
              "Font": "Segoe UI;9.75;;",
              "Border": ";58,78,94;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:166,166,166",
              "TextOptions": {
                "WordWrap": true
              },
              "Margins": {
                "Left": 6,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "3": {
              "Ident": "StiText",
              "Name": "Text50",
              "Guid": "c4e5c08918fc4a279d5f910480223b8c",
              "CanGrow": true,
              "ClientRectangle": "570,40,179,20",
              "ComponentStyle": "Footer1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Date: {Today.ToString(\"Y\")}"
              },
              "HorAlignment": "Right",
              "Font": "Segoe UI;9.75;;",
              "Border": ";58,78,94;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:166,166,166",
              "TextOptions": {
                "WordWrap": true
              },
              "Margins": {
                "Left": 0,
                "Right": 4,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            }
          }
        },
        "1": {
          "Ident": "StiPageHeaderBand",
          "Name": "PageHeaderBand6",
          "Guid": "215256195c674eb38e3c1de31d368e7b",
          "CanGrow": true,
          "ClientRectangle": "0,150,749,40",
          "Interaction": {
            "Ident": "StiInteraction"
          },
          "Border": ";;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text97",
              "Guid": "660321c5d79148cdadfb40aea698db00",
              "ClientRectangle": "0,0,160,40",
              "ComponentStyle": "Header2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Symbology"
              },
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "Font": "Segoe UI;12;Bold;",
              "Border": "Right;White;;;;;;solid:Black",
              "Brush": "solid:255,179,135",
              "TextBrush": "solid:255,255,255",
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text98",
              "Guid": "78b1574963794112a4096a7cdb17f8c7",
              "ClientRectangle": "160,0,240,40",
              "ComponentStyle": "Header2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Example"
              },
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "Font": "Segoe UI;12;Bold;",
              "Border": "Left, Right;White;;;;;;solid:Black",
              "Brush": "solid:255,179,135",
              "TextBrush": "solid:255,255,255",
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiText",
              "Name": "Text99",
              "Guid": "4257f3feda25431e92e0cd52e05cacc1",
              "ClientRectangle": "390,0,359,40",
              "ComponentStyle": "Header2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Description"
              },
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "Font": "Segoe UI;12;Bold;",
              "Border": "Left;White;;;;;;solid:Black",
              "Brush": "solid:255,179,135",
              "TextBrush": "solid:255,255,255",
              "Type": "Expression"
            }
          }
        },
        "2": {
          "Ident": "StiDataBand",
          "Name": "DataBand18",
          "Guid": "36be667269774d83a1a3c5f9429f77ec",
          "CanGrow": true,
          "ClientRectangle": "0,230,749,90",
          "ComponentStyle": "Data1",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": "All;235,235,235;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text35",
              "Guid": "5e7196c4fc0c4a31a0deb34cf9859e3f",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "ISBN-10"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text36",
              "Guid": "ed0abf426c204600a8ad23ad176389f9",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "ISBN is the abbreviation of International Standard Book Number - a unique, numeric commercial book identifier. Based upon the 9-digit Standard Book Numbering (SBN) code introduced in 1966,  10-digit ISBN format was developed in 1970 and became the international standard. Note the 'human readable' digits at the foot which can be used by operators if the label becomes damaged or will not scan for some reason - \"80-902734-1-6\" is the number encoded in the barcode.\n\n"
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";235,235,235;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode17",
              "Guid": "6fb9cf24926a4e61bbeb2bd44e86c284",
              "GrowToHeight": true,
              "ClientRectangle": "160,0,230,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "Transparent",
              "AutoScale": true,
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiIsbn10BarCodeType"
              },
              "Code": {
                "Value": "0-7356-2153-5"
              }
            }
          },
          "CountData": 1
        },
        "3": {
          "Ident": "StiDataBand",
          "Name": "DataBand19",
          "Guid": "19276ea6189240918484c63a3500aa47",
          "CanGrow": true,
          "ClientRectangle": "0,360,749,90",
          "ComponentStyle": "Data2",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": ";255,255,255;;;;;;solid:Black",
          "Brush": "solid:240,242,246",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text68",
              "Guid": "0875175201f340d09bd49a45d8f5a928",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,90",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "ISBN-13"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text69",
              "Guid": "9a84cb41ff7243c6a171f19de0f984b1",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,90",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "ISBN is the abbreviation of International Standard Book Number - a unique, numeric commercial book identifier.  The ISBN-13 specification was Issued from January 2007, and describes how the 13-digit ISBN check digit is calculated. Note the 'human readable' digits at the foot which can be used by operators if the label becomes damaged or will not scan for some reason - \"978-0-306-40615-7\" is a number encoded in the barcode.\n\n"
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode34",
              "Guid": "5f429b8a742445f98629fe3064a203ac",
              "GrowToHeight": true,
              "ClientRectangle": "160,0,230,90",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";255,255,255;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "240,242,246",
              "AutoScale": true,
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiIsbn13BarCodeType"
              },
              "Code": {
                "Value": "978-0-7356-2153-4"
              }
            }
          },
          "CountData": 1
        },
        "4": {
          "Ident": "StiDataBand",
          "Name": "DataBand1",
          "Guid": "e9719f526e074c0595067b657a0acccb",
          "CanGrow": true,
          "ClientRectangle": "0,490,749,90",
          "ComponentStyle": "Data1",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": "All;235,235,235;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text148",
              "Guid": "30c0c4f118cd4e469adc29c44da82b2f",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Msi"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text149",
              "Guid": "f6d9a9fe222b46cc84f6f46c57629622",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "MSI (also known as Modified Plessey) is a barcode symbology developed by the MSI Data Corporation, based on the original Plessey Code symbology. It is a continuous symbology that is not self-checking. MSI is used primarily for inventory control, marking storage containers and shelves in warehouse environments."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";235,235,235;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode6",
              "Guid": "215ef73334324e589e76093faeaf2f53",
              "ClientRectangle": "160,0,230,90",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";;;;;;;solid:Black",
              "BackColor": "Transparent",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiPlesseyBarCodeType"
              },
              "Code": {
                "Value": "1234567"
              }
            }
          },
          "EvenStyle": "Data2",
          "CountData": 1
        },
        "5": {
          "Ident": "StiDataBand",
          "Name": "DataBand20",
          "Guid": "efb233f65c434d2ca20592a182c74035",
          "CanGrow": true,
          "ClientRectangle": "0,620,749,90",
          "ComponentStyle": "Data2",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": ";255,255,255;;;;;;solid:Black",
          "Brush": "solid:240,242,246",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text37",
              "Guid": "e8742246d3634fc6a682c8fdbf8c0e6d",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,90",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "Plessey"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text38",
              "Guid": "087a87c2e980420c879e5541113e4c21",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,90",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "A Plessey barcode was created by Plessey company in England on March 1971. The Plessey barcode is widely used in libraries, supermarkets, and production environments. A variant of the barcode known as Anker Code and appropriate scanners were provided by the ADS company. Encoding technology of the Plessey barcode was used by MSE Data Corporation. This company used it to create an MSI barcode that sometimes is called 'modified Plessey'. This bar-code is now obsolete and new scanners cannot read it."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode35",
              "Guid": "b75dc3c480fb43688a815e0a979f08fe",
              "ClientRectangle": "160,0,230,90",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";255,255,255;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "240,242,246",
              "AutoScale": true,
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiPlesseyBarCodeType"
              },
              "Code": {
                "Value": "1234567"
              }
            }
          },
          "EvenStyle": "Data2",
          "CountData": 1
        },
        "6": {
          "Ident": "StiDataBand",
          "Name": "DataBand23",
          "Guid": "e4e890a93b734a16a8adacb6e629c514",
          "CanGrow": true,
          "ClientRectangle": "0,750,749,90",
          "ComponentStyle": "Data1",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": "All;235,235,235;;;;;;solid:Black",
          "Brush": "solid:",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text5",
              "Guid": "96d1247ee6c4498b8df9c4dd0c82ea87",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "2 of 5 Interleaved"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text72",
              "Guid": "239a79a628ea4a968ac40c294a79ef57",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "The 2of5 Interleaved barcode is a high density variable length numeric only symbology that encodes digit pairs in an interleaved manner. This bar-code is developed of the Code 25 Standard. It is usually used in the industrial."
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode36",
              "Guid": "2a378232d3e24240baee45baec1195e2",
              "ClientRectangle": "160,0,230,90",
              "ComponentStyle": "Data1",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";255,255,255;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "Transparent",
              "AutoScale": true,
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiInterleaved2of5BarCodeType"
              },
              "Code": {
                "Value": "12345678"
              }
            }
          },
          "CountData": 1
        },
        "7": {
          "Ident": "StiDataBand",
          "Name": "DataBand22",
          "Guid": "dc0cee3d83bd4f36ae3cfbaf259a1638",
          "CanGrow": true,
          "ClientRectangle": "0,880,749,90",
          "ComponentStyle": "Data2",
          "Interaction": {
            "Ident": "StiBandInteraction"
          },
          "Border": ";255,255,255;;;;;;solid:Black",
          "Brush": "solid:240,242,246",
          "Components": {
            "0": {
              "Ident": "StiText",
              "Name": "Text7",
              "Guid": "1d115f92dd09491d9b85fd8e825003f8",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "0,0,160,90",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "2 of 5 Standard"
              },
              "VertAlignment": "Center",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "Margins": {
                "Left": 3,
                "Right": 0,
                "Top": 0,
                "Bottom": 0
              },
              "Type": "Expression"
            },
            "1": {
              "Ident": "StiText",
              "Name": "Text71",
              "Guid": "972fa15094944fd68a03d4962a414d5f",
              "CanGrow": true,
              "GrowToHeight": true,
              "ClientRectangle": "390,0,359,90",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Text": {
                "Value": "The 2of5 bar-code was developed 40 years ago. This is a low density variable length numeric. This barcode is used in manufacture and is known as Code 25, Code 25 Standard or Code 25 Industrial. It is very seldom used these days.\n"
              },
              "HorAlignment": "Width",
              "Font": "Segoe UI;9.75;;",
              "Border": ";255,255,255;;;;;;solid:Black",
              "Brush": "solid:240,242,246",
              "TextBrush": "solid:64,64,64",
              "TextOptions": {
                "WordWrap": true
              },
              "TextQuality": "Wysiwyg",
              "Margins": {
                "Left": 2,
                "Right": 5,
                "Top": 5,
                "Bottom": 5
              },
              "Type": "Expression"
            },
            "2": {
              "Ident": "StiBarCode",
              "Name": "BarCode19",
              "Guid": "f022003c0de84851babbe0a53823f906",
              "GrowToHeight": true,
              "ClientRectangle": "160,0,230,90",
              "ComponentStyle": "Data2",
              "Interaction": {
                "Ident": "StiInteraction"
              },
              "Border": ";255,255,255;;;;;;solid:Black",
              "ForeColor": "64,64,64",
              "BackColor": "240,242,246",
              "HorAlignment": "Center",
              "VertAlignment": "Center",
              "BarCodeType": {
                "Ident": "StiStandard2of5BarCodeType"
              },
              "Code": {
                "Value": "12345678"
              }
            }
          },
          "CountData": 1
        }
      },
      "PaperSize": "A4",
      "TitleBeforeHeader": true,
      "Watermark": {
        "TextBrush": "solid:50,0,0,0"
      }
    }
  }
}