import { StiHttpClientService } from './http-client.service';
import { Observable, Subject } from 'rxjs';
import { ModelService } from './model.service';
import { StylesService } from './styles.service';
import { ViewerEvent, BookmarkNode, Message } from './objects';
import { PageService } from './page.service';
import { HelperService } from './helper.service';
import { FormService } from '../forms/form.service';
import { FullScreenService } from './full-screen.service';
import { MenuService } from '../menu/menu.service';
import { AnimationService } from './animation.service';
import * as i0 from "@angular/core";
export declare class ControllerService {
    private httpClient;
    private model;
    private stylesService;
    private pageService;
    private helper;
    private formService;
    private fullScreenService;
    private menuService;
    private styleService;
    private animationService;
    private subject;
    actionSubject: Subject<Message>;
    constructor(httpClient: StiHttpClientService, model: ModelService, stylesService: StylesService, pageService: PageService, helper: HelperService, formService: FormService, fullScreenService: FullScreenService, menuService: MenuService, styleService: StylesService, animationService: AnimationService);
    setupHandlers(): void;
    hideToolbar(): void;
    showToolbar(): void;
    keepToolbar(): void;
    getMessage(): Observable<any>;
    getActionMessage(): Observable<Message>;
    post(action: string, cAction?: string, postData?: any, responseType?: string, subAction?: string): void;
    loadViewer(): void;
    getReport(): void;
    getPages(): void;
    postExport(format: string, settings: any, elementName?: string, isDashboardExport?: boolean): void;
    loadFile(fileName: string, content: any): void;
    postOpen(data: any): void;
    action(event: ViewerEvent): void;
    scrollToPage(): void;
    showError(message: any, messageText?: string): boolean;
    postReportResource(resourceName: string, viewType: string): void;
    postBookmarkNodeAction(node: BookmarkNode): void;
    viewerResized(): void;
    initAutoUpdateCache(): void;
    startRefreshReportTimer(timeout: number): void;
    checkTrExp(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<ControllerService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<ControllerService>;
}
