import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./export.service";
import * as i3 from "../forms/form.service";
import * as i4 from "./controller.service";
export class MailService {
    constructor(model, exportService, formService, controller) {
        this.model = model;
        this.exportService = exportService;
        this.formService = formService;
        this.controller = controller;
        exportService.getMessage().subscribe(event => {
            if (event === 'postMail') {
                this.postMail();
            }
        });
    }
    postMail() {
        this.fillDefaults();
        if (this.model.options.email.showEmailDialog) {
            this.formService.showForm('sendEmailForm');
        }
        else {
            this.sendMail();
        }
    }
    sendMail() {
        const data = {
            exportFormat: this.exportService.format,
            exportSettings: this.exportService.exportSettings
        };
        this.formService.closeForm('sendEmailForm');
        this.controller.post('EmailReport', this.model.options.actions.emailReport, data);
        this.controller.actionSubject.next({ action: 'Email', data });
    }
    fillDefaults() {
        this.exportService.exportSettings.Email = this.model.options.email.defaultEmailAddress;
        this.exportService.exportSettings.Message = this.model.options.email.defaultEmailMessage;
        this.exportService.exportSettings.Subject = this.model.options.email.defaultEmailSubject;
        let ext = this.exportService.format.toLowerCase().replace('image', '');
        switch (ext) {
            case 'excelbiff':
                ext = 'xls';
                break;
            case 'excel':
                ext = 'xlsx';
                break;
            case 'excelxml':
                ext = 'xls';
                break;
            case 'html5':
                ext = 'html';
                break;
            case 'jpeg':
                ext = 'jpg';
                break;
            case 'PowerPoint':
                ext = 'ppt';
                break;
            case 'text':
                ext = 'txt';
                break;
            case 'Word':
                ext = 'docx';
                break;
        }
        this.exportService.exportSettings.Attachment = this.model.reportParams.reportFileName + '.' + ext;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: MailService, deps: [{ token: i1.ModelService }, { token: i2.ExportService }, { token: i3.FormService }, { token: i4.ControllerService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: MailService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: MailService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.ExportService }, { type: i3.FormService }, { type: i4.ControllerService }] });
//# sourceMappingURL=data:application/json;base64,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