import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./md5.service";
import * as i3 from "./controller.service";
import * as i4 from "./helper.service";
import * as i5 from "./drill-down.service";
export class InteractionsService {
    constructor(model, md5, controller, helper, drillDownService) {
        this.model = model;
        this.md5 = md5;
        this.controller = controller;
        this.helper = helper;
        this.drillDownService = drillDownService;
        controller.getMessage().subscribe((message) => {
            if (message.action === 'InitVars') {
                this.showParametersPanel(message.data);
            }
        });
        controller.getActionMessage().subscribe((message) => {
            switch (message.action) {
                case 'Variables':
                    this.postInteraction({ action: 'Variables', variables: this.getParametersValues() });
                    break;
                case 'Reset':
                    this.showParametersPanel(this.model.options.paramsVariables);
                    break;
                default:
                    break;
            }
        });
    }
    postInteraction(params) {
        this.drillDownService.saveState();
        // Add new drill-down parameters to drill-down queue and calc guid
        if (params.action !== 'InitVars' && (params.action === 'DrillDown' || params.action === 'DashboardDrillDown')) {
            if (this.model.options.drillDownInProgress) {
                return;
            }
            if (params.action === 'DashboardDrillDown' && params.drillDownParameters) {
                params.drillDownParameters.isDashboardDrillDown = true; // add dbs flag
            }
            const drillDownParameters = this.model.reportParams.drillDownParameters || [];
            params.drillDownParameters = params.drillDownParameters ? drillDownParameters.concat(params.drillDownParameters) : drillDownParameters;
            if (params.action === 'DrillDown') {
                params.drillDownGuid = this.md5.hex_md5(JSON.stringify(this.sortPropsInDrillDownParameters(params.drillDownParameters)));
            }
            else {
                params.dashboardDrillDownGuid = this.md5.hex_md5(JSON.stringify(this.sortPropsInDrillDownParameters(params.drillDownParameters)));
            }
            this.model.options.drillDownInProgress = true;
        }
        this.controller.post(params.action, this.model.options.actions.interaction, params);
    }
    showParametersPanel(data) {
        if (!data) {
            return;
        }
        if (this.controller.showError(data)) {
            data = null;
        }
        this.model.options.isParametersReceived = true;
        this.model.options.paramsVariables = typeof data === 'string' ? JSON.parse(data) : data;
        this.model.controls.parametersPanel.visible = !this.model.options.isMobileDevice;
        // if (this.model.reportParams.type === 'Dashboard') jsObject.postAction('GetPages');
        const paramsVariables = this.helper.copyObject(this.model.options.paramsVariables);
        const countParameters = this.helper.getCountObjects(paramsVariables);
        let minParametersCount = this.model.options.appearance.minParametersCountForMultiColumns != null ? this.model.options.appearance.minParametersCountForMultiColumns : 5;
        const countColumns = (countParameters <= minParametersCount) ? 1 : this.model.options.appearance.parametersPanelColumnsCount;
        let countInColumn = Math.trunc(countParameters / countColumns);
        if (countInColumn * countColumns < countParameters) {
            countInColumn++;
        }
        // setup lists
        for (let i = 0; i < countParameters; i++) {
            const variable = paramsVariables[i];
            if (variable.items) {
                variable.items.forEach((v, index) => {
                    let isChecked = true;
                    if (variable.value instanceof Array && !variable.allowUserValues &&
                        variable.value.indexOf(variable.items[index].value) < 0 && variable.value.indexOf(variable.items[index].key) < 0)
                        isChecked = false;
                    if (variable.isFirstInitialization && variable.checkedStates && index < variable.checkedStates.length) {
                        isChecked = variable.checkedStates[index];
                    }
                    v.isChecked = isChecked;
                    v.visible = true;
                });
            }
            variable.isNull = (variable.type === 'DateTime' && variable.value === null && variable.basicType === 'NullableValue');
        }
        this.model.interactions = { paramsVariables, countColumns: new Array(countColumns), countInColumn: new Array(countInColumn) };
    }
    sortPropsInDrillDownParameters(inArray) {
        if (!inArray || !inArray.length) {
            return inArray;
        }
        const outArray = [];
        for (let i = 0; i < inArray.length; i++) {
            const propNames = [];
            const el = inArray[i];
            const copyEl = {};
            Object.keys(el).forEach(p => {
                if (el.hasOwnProperty(p)) {
                    propNames.push(p);
                }
            });
            propNames.sort();
            propNames.forEach(propName => copyEl[propName] = el[propName]);
            outArray[i] = copyEl;
        }
        return outArray;
    }
    getParametersValues() {
        const parametersValues = {};
        Object.keys(this.model.interactions.paramsVariables).forEach(i => {
            const parameter = this.model.interactions.paramsVariables[i];
            parametersValues[parameter.name] = this.getVariableValue(parameter);
        });
        return parametersValues;
    }
    getVariableValue(parameter) {
        if (parameter.isNull) {
            return null;
        }
        switch (parameter.basicType) {
            case 'Value':
            case 'NullableValue':
                return this.val(parameter.key, parameter, parameter.allowUserValues ? parameter.value : parameter.key);
            case 'Range':
                return { from: this.val(parameter.key, parameter), to: this.val(parameter.keyTo, parameter) };
            case 'List':
                const value = [];
                if (parameter.items) {
                    parameter.items.filter(i => parameter.allowUserValues || i.isChecked).forEach(item => value.push(this.val(item.key, parameter)));
                }
                return value;
        }
    }
    val(key, parameter, value) {
        return parameter.type === 'DateTime' ? this.helper.getStringDateTime(key, parameter.dateTimeType) : (value === undefined ? key : value);
    }
    initializeInteractions(page) {
        if (!page) {
            return;
        }
        const elems = page.querySelectorAll ? page.querySelectorAll('td,div,span,rect,path,ellipse') : page.getElementsByTagName('td');
        const collapsedHash = [];
        for (const elem of elems) {
            if (elem.getAttribute('interaction') && (elem.getAttribute('pageguid') ||
                elem.getAttribute('reportfile') ||
                elem.getAttribute('collapsed') ||
                elem.getAttribute('databandsort'))) {
                elem.style.cursor = 'pointer';
                const sort = elem.getAttribute('sort');
                if (sort) {
                    this.paintSortingArrow(elem, sort);
                }
                const collapsed = elem.getAttribute('collapsed');
                if (collapsed) {
                    const compId = elem.getAttribute('compindex') + '|' + elem.getAttribute('interaction');
                    if (collapsedHash.indexOf(compId) < 0) {
                        this.paintCollapsingIcon(elem, collapsed === 'true');
                        collapsedHash.push(compId);
                    }
                }
                elem.onclick = (e) => {
                    if (elem.getAttribute('pageguid') || elem.getAttribute('reportfile')) {
                        this.postInteractionDrillDown(elem);
                    }
                    else if (elem.getAttribute('collapsed')) {
                        this.postInteractionCollapsing(elem);
                    }
                    else {
                        this.postInteractionSorting(elem, e.ctrlKey);
                    }
                };
                if (elem.getAttribute('pageguid') || elem.getAttribute('reportfile')) {
                    elem.onmouseover = () => elem.style.opacity = 0.75;
                    elem.onmouseout = () => elem.style.opacity = 1;
                }
            }
        }
    }
    getComponentOffset(component) {
        let offsetX = 0;
        let offsetY = 0;
        const startComponent = component;
        while (component && !isNaN(component.offsetLeft) && !isNaN(component.offsetTop)
            && (component === startComponent || component.style.position === '' || component.style.position === 'static')) {
            offsetX += component.offsetLeft - component.scrollLeft;
            offsetY += component.offsetTop - component.scrollTop;
            component = component.offsetParent;
        }
        return { top: offsetY, left: offsetX };
    }
    paintSortingArrow(component, sort) {
        if (component.arrowImg) {
            return;
        }
        const arrowImg = document.createElement("div");
        let sortUpSrc = "<svg xmlns='http://www.w3.org/2000/svg' width='12' height='12'><path d='M1 9l5-4 5 4z' fill='#eeeeee' stroke='#666'/></svg>";
        let sortDownSrc = "<svg xmlns='http://www.w3.org/2000/svg' width='12' height='12'><path d='M1 5l5 4 5-4z' fill='#eeeeee' stroke='#666'/></svg>";
        arrowImg.innerHTML = sort == "asc" ? sortDownSrc : sortUpSrc;
        const arrowWidth = (this.model.reportParams.zoom / 100) * 16;
        const arrowHeight = (this.model.reportParams.zoom / 100) * 16;
        arrowImg.style.position = 'absolute';
        arrowImg.style.width = arrowWidth + 'px';
        arrowImg.style.height = arrowHeight + 'px';
        component.appendChild(arrowImg);
        component.arrowImg = arrowImg;
        const oldPosition = component.style.position;
        const oldClassName = component.className;
        let reportDisplayMode = this.model.options.displayModeFromReport || this.model.options.appearance.reportDisplayMode;
        if (reportDisplayMode == "Table")
            component.style.position = "relative";
        if (!oldClassName) {
            component.className = 'stiSortingParentElement';
        }
        const arrowLeftPos = this.helper.findPosX(arrowImg, component.className);
        const arrowTopPos = this.helper.findPosY(arrowImg, component.className);
        arrowImg.style.marginLeft = (component.offsetWidth - arrowLeftPos - arrowWidth - ((this.model.reportParams.zoom / 100) * 3)) + 'px';
        arrowImg.style.marginTop = (component.offsetHeight / 2 - arrowHeight / 2 - arrowTopPos) + 'px';
        if (oldPosition && reportDisplayMode == "Table")
            component.style.position = oldPosition;
        component.className = oldClassName;
    }
    paintCollapsingIcon(component, collapsed) {
        if (component.collapsImg) {
            return;
        }
        const collapsImg = document.createElement('img');
        collapsImg.src = collapsed ? this.model.img('CollapsingPlus.png') : this.model.img('CollapsingMinus.png');
        collapsImg.style.position = 'absolute';
        const collapsWidth = (this.model.reportParams.zoom / 100) * 10;
        const collapsHeight = (this.model.reportParams.zoom / 100) * 10;
        collapsImg.style.width = collapsWidth + 'px';
        collapsImg.style.height = collapsHeight + 'px';
        component.appendChild(collapsImg);
        component.collapsImg = collapsImg;
        const componentOffset = this.getComponentOffset(component);
        const collapsOffset = this.getComponentOffset(collapsImg);
        collapsImg.style.marginLeft = (componentOffset.left - collapsOffset.left + collapsWidth / 3) + 'px';
        collapsImg.style.marginTop = (componentOffset.top - collapsOffset.top + collapsWidth / 3) + 'px';
    }
    postInteractionSorting(component, isCtrl) {
        const params = {
            action: 'Sorting',
            sortingParameters: {
                ComponentName: component.getAttribute('interaction') + ';' + isCtrl.toString(),
                DataBand: component.getAttribute('databandsort')
            }
        };
        if (this.model.options.isParametersReceived) {
            params.variables = this.getParametersValues();
        }
        this.postInteraction(params);
    }
    postInteractionDrillDown(component) {
        const params = {
            action: 'DrillDown',
            drillDownParameters: {
                ComponentIndex: component.getAttribute('compindex'),
                ElementIndex: component.getAttribute('elementindex'),
                PageIndex: component.getAttribute('pageindex'),
                PageGuid: component.getAttribute('pageguid'),
                ReportFile: component.getAttribute('reportfile')
            }
        };
        this.postInteraction(params);
    }
    postInteractionCollapsing(component) {
        const componentName = component.getAttribute('interaction');
        const collapsingIndex = component.getAttribute('compindex');
        const collapsed = component.getAttribute('collapsed') === 'true' ? false : true;
        if (!this.model.reportParams.collapsingStates) {
            this.model.reportParams.collapsingStates = {};
        }
        if (!this.model.reportParams.collapsingStates[componentName]) {
            this.model.reportParams.collapsingStates[componentName] = {};
        }
        this.model.reportParams.collapsingStates[componentName][collapsingIndex] = collapsed;
        const params = {
            action: 'Collapsing',
            collapsingParameters: {
                ComponentName: componentName,
                CollapsingStates: this.model.reportParams.collapsingStates
            }
        };
        if (this.model.options.isParametersReceived) {
            params.variables = this.getParametersValues();
        }
        this.postInteraction(params);
    }
    updateAllHyperLinks() {
        let pointers = this.model.reportParams.tableOfContentsPointers;
        //var bookmarksPanel = this.controls.bookmarksPanel;
        if (this.model.reportParams.bookmarksContent != null || (pointers && pointers.length > 0)) {
            this.model.pages.forEach(p => {
                const page = p.page;
                if (page) {
                    const aHyperlinks = page.getElementsByTagName('a');
                    for (const aHyperlink of aHyperlinks) {
                        aHyperlink.hrefContent = aHyperlink.getAttribute('href');
                        if (aHyperlink.hrefContent) {
                            if (aHyperlink.hrefContent.indexOf("#") == 0) {
                                let anchorParams = aHyperlink.hrefContent.substring(1).split("#GUID#");
                                aHyperlink.anchorName = anchorParams[0];
                                aHyperlink.componentGuid = anchorParams.length > 1 ? anchorParams[1] : "";
                                aHyperlink.onclick = () => {
                                    let currAnchorName = aHyperlink.anchorName;
                                    let cuurCompGuid = aHyperlink.componentGuid;
                                    try {
                                        currAnchorName = decodeURI(aHyperlink.anchorName);
                                    }
                                    catch (e) {
                                        currAnchorName = aHyperlink.anchorName;
                                    }
                                    if (pointers.length > 0) {
                                        let pageIndex = 1;
                                        for (let i = 0; i < pointers.length; i++) {
                                            if (cuurCompGuid) {
                                                if (pointers[i].componentGuid == cuurCompGuid) {
                                                    pageIndex = pointers[i].pageIndex;
                                                    break;
                                                }
                                            }
                                            else if (currAnchorName) {
                                                let pointerAnchor = pointers[i].anchor.indexOf("#") == 0 ? pointers[i].anchor.substring(1) : pointers[i].anchor;
                                                if (pointerAnchor == currAnchorName) {
                                                    pageIndex = pointers[i].pageIndex;
                                                    break;
                                                }
                                            }
                                        }
                                        let anchorName = "";
                                        if (currAnchorName)
                                            anchorName += currAnchorName;
                                        if (cuurCompGuid)
                                            anchorName += ("#GUID#" + cuurCompGuid);
                                        if (anchorName) {
                                            this.controller.action({ name: 'BookmarkAction', bookmarkPage: Math.max(pageIndex - 1, 0), bookmarkAnchor: anchorName, componentGuid: aHyperlink.compunentGuid });
                                            return false;
                                        }
                                    }
                                    if (this.model.reportParams.bookmarksContent != null) {
                                        const node = this.model.nodes.find(n => n.name === currAnchorName);
                                        if (node) {
                                            this.model.navigateNode = node;
                                        }
                                        else {
                                            for (let k = 0; k < document.anchors.length; k++) {
                                                if (document.anchors[k].name == currAnchorName) {
                                                    //jsObject.scrollToAnchor(currAnchorName);
                                                    this.helper.scrollToAnchor(currAnchorName);
                                                    return;
                                                }
                                            }
                                        }
                                        this.controller.post('BookmarkAction', null, 0);
                                        /*let aBookmarks = bookmarksPanel.getElementsByTagName("a");
                                        for (let k = 0; k < aBookmarks.length; k++) {
                                          let clickFunc = aBookmarks[k].getAttribute("onclick");
                                          if (clickFunc && clickFunc.indexOf("'" + currAnchorName + "'") >= 0) {
                                            try {
                                              eval(clickFunc);
                                              return false;
                                            }
                                            catch (e) { }
                                          }
                                        }
                    
                                        this.controller.post('BookmarkAction', null, 0);*/
                                        return false;
                                    }
                                    //=================================
                                    /*let pageIndex = 1;
                                    for (let i = 0; i < pointers.length; i++) {
                                      if (aHyperlink.componentGuid) {
                                        if (pointers[i].componentGuid == aHyperlink.componentGuid) {
                                          pageIndex = pointers[i].pageIndex;
                                          break;
                                        }
                                      }
                                      else if (aHyperlink.bookmarkAnchor) {
                                        if (pointers[i].anchor == decodeURI(aHyperlink.bookmarkAnchor)) {
                                          pageIndex = pointers[i].pageIndex;
                                          break;
                                        }
                                      }
                                    }
                                    this.controller.action({ name: 'BookmarkAction', bookmarkPage: pageIndex - 1, bookmarkAnchor: decodeURI(aHyperlink.bookmarkAnchor), componentGuid: aHyperlink.compunentGuid });
                                    return false;
                                    };
                                    } else if (this.model.reportParams.bookmarksContent != null) {
                                    aHyperlink.anchorName = aHyperlink.hrefContent.replace('#', '');
                  
                                    aHyperlink.onclick = () => {
                                    const node = this.model.nodes.find(n => n.url.replace(/\\\'/g, '\'').substr(1) === aHyperlink.anchorName);
                                    if (node) {
                                      this.model.navigateNode = node;
                                    } else if (aHyperlink.hrefContent.indexOf('#') === 0) {
                                      for (let i = 0; i < document.anchors.length; i++) {
                                        const anchor = document.anchors[i];
                                        if (anchor.name === aHyperlink.anchorName) {
                                          this.helper.scrollToAnchor(aHyperlink.anchorName);
                                          return;
                                        }
                                      }
                                      this.controller.post('BookmarkAction', null, 0);
                                    }
                                    return false;
                                    };*/
                                };
                            }
                        }
                    }
                }
            });
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: InteractionsService, deps: [{ token: i1.ModelService }, { token: i2.Md5Service }, { token: i3.ControllerService }, { token: i4.HelperService }, { token: i5.DrillDownService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: InteractionsService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: InteractionsService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.Md5Service }, { type: i3.ControllerService }, { type: i4.HelperService }, { type: i5.DrillDownService }] });
//# sourceMappingURL=data:application/json;base64,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