import { Injectable } from '@angular/core';
import { HttpParams } from '@angular/common/http';
import { EMPTY, throwError } from 'rxjs';
import { catchError, timeout } from 'rxjs/operators';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
import * as i2 from "./model.service";
import * as i3 from "./helper.service";
import * as i4 from "./file.saver.service";
export class StiHttpClientService {
    constructor(httpClient, model, helper, fileSaver) {
        this.httpClient = httpClient;
        this.model = model;
        this.helper = helper;
        this.fileSaver = fileSaver;
    }
    post(url, data, responseType = 'json') {
        const model = this.model;
        model.showProgress = true;
        const reqTimeout = this.model.options?.server?.requestTimeout > 0 ? this.model.options?.server?.requestTimeout * 1000 : 1000 * 1000;
        if (responseType === 'json') {
            return this.httpClient.post(url, this.getFormData(data)).pipe(
            // retry(3),
            timeout(reqTimeout), catchError((error) => {
                model.httpError = error;
                model.showProgress = false;
                console.error(error);
                console.error(`url: ${url}, reqTimeout: ${reqTimeout}, responseType: ${responseType}`);
                console.error(data);
                this.model.controls.navigatePanel.enabled = true;
                this.model.controls.toolbar.enabled = true;
                if (error?.error?.text != null && error.error.text.startsWith('<?xml')) {
                    alert(error.error.text.replace(/<.+?>/gi, ''));
                }
                return throwError('Something bad happened; please try again later.');
            }));
        }
        else {
            return this.httpClient.post(url, this.getFormData(data), { responseType: 'text' }).pipe(
            // retry(3),
            timeout(reqTimeout), catchError((error) => {
                model.httpError = error;
                model.showProgress = false;
                console.error(error);
                console.error(`url: ${url}, reqTimeout: ${reqTimeout}, responseType: ${responseType}`);
                console.error(data);
                this.model.controls.navigatePanel.enabled = true;
                this.model.controls.toolbar.enabled = true;
                if (error?.error?.text != null && error.error.text.startsWith('<?xml')) {
                    alert(error.error.text.replace(/<.+?>/gi, ''));
                }
                return throwError('Something bad happened; please try again later.');
            }));
        }
    }
    getFormData(data) {
        const formData = new FormData();
        Object.keys(data).forEach(key => formData.append(key, data[key]));
        return formData;
    }
    getParams(data) {
        let params = new HttpParams();
        Object.keys(data).forEach(key => params = params.set(key, data[key]));
        return params;
    }
    getData(url, data) {
        return this.httpClient.post(url, this.getFormData(data), { responseType: 'blob' }).pipe(catchError((error) => {
            console.error(error);
            return EMPTY;
        }));
    }
    postForm(url, data, doc, postOnlyData = false, retrieveFileName = true) {
        if (!this.model.options.replaceHtmlFormWithRequest) {
            this.postForm2(url, data, doc, postOnlyData);
        }
        else {
            const params = postOnlyData ? data : this.model.createPostParameters(data, true);
            if (retrieveFileName) {
                data.onlyFileName = true;
                this.post(url, this.model.createPostParameters(data)).subscribe((resp) => {
                    this.model.showProgress = false;
                    this.model.controls.navigatePanel.enabled = true;
                    this.model.controls.toolbar.enabled = true;
                    let fileName = resp.fileName;
                    delete data.onlyFileName;
                    this.showData(url, params, doc, fileName);
                });
            }
            else {
                this.showData(url, params, doc, null);
            }
        }
    }
    showData(url, params, doc, fileName) {
        this.getData(url, params).subscribe((data) => {
            if (doc) {
                if (window.navigator && window.navigator.msSaveOrOpenBlob) {
                    window.navigator.msSaveOrOpenBlob(data);
                }
                else {
                    var fileURL = URL.createObjectURL(data);
                    window.open(fileURL, '_blank');
                }
            }
            else {
                this.fileSaver.saveAs(data, fileName);
            }
        });
    }
    postForm2(url, data, doc, postOnlyData = false) {
        if (!doc) {
            doc = document;
        }
        const form = doc.createElement('FORM');
        form.setAttribute('method', 'POST');
        form.setAttribute('action', url);
        const params = postOnlyData ? data : this.model.createPostParameters(data, true);
        Object.keys(params).forEach(key => {
            const paramsField = doc.createElement('INPUT');
            paramsField.setAttribute('type', 'hidden');
            paramsField.setAttribute('name', key);
            paramsField.setAttribute('value', params[key]);
            form.appendChild(paramsField);
        });
        if (this.model.options.jsDesigner) {
            this.model.options.jsDesigner.options.ignoreBeforeUnload = true;
        }
        doc.body.appendChild(form);
        form.submit();
        doc.body.removeChild(form);
        setTimeout(() => {
            if (this.model.options.jsDesigner) {
                this.model.options.jsDesigner.options.ignoreBeforeUnload = false;
            }
        }, 500);
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiHttpClientService, deps: [{ token: i1.HttpClient }, { token: i2.ModelService }, { token: i3.HelperService }, { token: i4.FileSaverService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiHttpClientService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiHttpClientService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.HttpClient }, { type: i2.ModelService }, { type: i3.HelperService }, { type: i4.FileSaverService }] });
//# sourceMappingURL=data:application/json;base64,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