import { Injectable } from '@angular/core';
import { Item } from './objects';
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
export class CollectionsService {
    constructor(model) {
        this.model = model;
    }
    getImageTypesItems() {
        const items = [];
        if (this.model.options.exports.showExportToImageBmp) {
            items.push(new Item('Bmp', 'Bmp', null, 'Bmp'));
        }
        if (this.model.options.exports.showExportToImageGif) {
            items.push(new Item('Gif', 'Gif', null, 'Gif'));
        }
        if (this.model.options.exports.showExportToImageJpeg) {
            items.push(new Item('Jpeg', 'Jpeg', null, 'Jpeg'));
        }
        if (this.model.options.exports.showExportToImagePcx) {
            items.push(new Item('Pcx', 'Pcx', null, 'Pcx'));
        }
        if (this.model.options.exports.showExportToImagePng) {
            items.push(new Item('Png', 'Png', null, 'Png'));
        }
        if (this.model.options.exports.showExportToImageTiff) {
            items.push(new Item('Tiff', 'Tiff', null, 'Tiff'));
        }
        if (this.model.options.exports.showExportToImageMetafile) {
            items.push(new Item('Emf', 'Emf', null, 'Emf'));
        }
        if (this.model.options.exports.showExportToImageSvg) {
            items.push(new Item('Svg', 'Svg', null, 'Svg'));
        }
        if (this.model.options.exports.showExportToImageSvgz) {
            items.push(new Item('Svgz', 'Svgz', null, 'Svgz'));
        }
        return items;
    }
    getDataTypesItems() {
        const items = [];
        if (this.model.options.exports.showExportToCsv) {
            items.push(new Item('Csv', 'Csv', null, 'Csv'));
        }
        if (this.model.options.exports.showExportToDbf) {
            items.push(new Item('Dbf', 'Dbf', null, 'Dbf'));
        }
        if (this.model.options.exports.showExportToXml) {
            items.push(new Item('Xml', 'Xml', null, 'Xml'));
        }
        if (this.model.options.exports.showExportToDif) {
            items.push(new Item('Dif', 'Dif', null, 'Dif'));
        }
        if (this.model.options.exports.showExportToSylk) {
            items.push(new Item('Sylk', 'Sylk', null, 'Sylk'));
        }
        if (this.model.options.exports.showExportToJson) {
            items.push(new Item('Json', 'Json', null, 'Json'));
        }
        return items;
    }
    getExcelTypesItems() {
        const items = [];
        if (this.model.options.exports.showExportToExcel) {
            items.push(new Item('Excel', 'Excel', null, 'Excel'));
        }
        if (this.model.options.exports.showExportToExcelBiff) {
            items.push(new Item('ExcelBiff', 'Excel 97-2003', null, 'ExcelBiff'));
        }
        if (this.model.options.exports.showExportToExcelXml) {
            items.push(new Item('ExcelXml', 'Excel Xml 2003', null, 'ExcelXml'));
        }
        return items;
    }
    getHtmlTypesItems() {
        const items = [];
        if (this.model.options.exports.showExportToHtml) {
            items.push(new Item('Html', 'Html', null, 'Html'));
        }
        if (this.model.options.exports.showExportToHtml5) {
            items.push(new Item('Html5', 'Html5', null, 'Html5'));
        }
        if (this.model.options.exports.showExportToMht) {
            items.push(new Item('Mht', 'Mht', null, 'Mht'));
        }
        return items;
    }
    getZoomItems() {
        const items = [];
        [0.25, 0.5, 0.75, 1, 1.25, 1.5, 2].forEach((item, i) => items.push(new Item('item' + i, (item * 100) + '%', null, item)));
        return items;
    }
    getImageFormatForHtmlItems() {
        const items = [];
        items.push(new Item('item0', 'Jpeg', null, 'Jpeg'));
        items.push(new Item('item1', 'Gif', null, 'Gif'));
        items.push(new Item('item2', 'Bmp', null, 'Bmp'));
        items.push(new Item('item3', 'Png', null, 'Png'));
        return items;
    }
    getExportModeItems() {
        const items = [];
        items.push(new Item('item0', 'Table', null, 'Table'));
        items.push(new Item('item1', 'Span', null, 'Span'));
        items.push(new Item('item2', 'Div', null, 'Div'));
        return items;
    }
    getImageResolutionItems() {
        const items = [];
        ['10', '25', '50', '75', '100', '200', '300', '400', '500'].forEach((item, i) => items.push(new Item('item' + i, item, null, parseInt(item, 10))));
        return items;
    }
    getImageCompressionMethodItems() {
        const items = [];
        items.push(new Item('item0', 'Jpeg', null, 'Jpeg'));
        items.push(new Item('item1', 'Flate', null, 'Flate'));
        return items;
    }
    getImageQualityItems() {
        const items = [];
        [0.25, 0.5, 0.75, 0.85, 0.9, 0.95, 1].forEach((item, i) => items.push(new Item('item' + i, (item * 100).toString(), null, item)));
        return items;
    }
    getBorderTypeItems() {
        const items = [];
        items.push(new Item('item0', this.model.loc('BorderTypeSimple'), null, 'Simple'));
        items.push(new Item('item1', this.model.loc('BorderTypeSingle'), null, 'UnicodeSingle'));
        items.push(new Item('item2', this.model.loc('BorderTypeDouble'), null, 'UnicodeDouble'));
        return items;
    }
    getEncodingDataItems() {
        const items = [];
        this.model.encodingData.forEach((item, i) => items.push(new Item('item' + i, item.value, null, item.key)));
        return items;
    }
    getImageFormatItems(withoutMonochrome = false) {
        const items = [];
        items.push(new Item('item0', this.model.loc('ImageFormatColor'), null, 'Color'));
        items.push(new Item('item1', this.model.loc('ImageFormatGrayscale'), null, 'Grayscale'));
        if (!withoutMonochrome) {
            items.push(new Item('item2', this.model.loc('ImageFormatMonochrome'), null, 'Monochrome'));
        }
        return items;
    }
    getMonochromeDitheringTypeItems() {
        const items = [];
        items.push(new Item('item0', 'None', null, 'None'));
        items.push(new Item('item1', 'FloydSteinberg', null, 'FloydSteinberg'));
        items.push(new Item('item2', 'Ordered', null, 'Ordered'));
        return items;
    }
    getTiffCompressionSchemeItems() {
        const items = [];
        items.push(new Item('item0', 'Default', null, 'Default'));
        items.push(new Item('item1', 'CCITT3', null, 'CCITT3'));
        items.push(new Item('item2', 'CCITT4', null, 'CCITT4'));
        items.push(new Item('item3', 'LZW', null, 'LZW'));
        items.push(new Item('item4', 'None', null, 'None'));
        items.push(new Item('item5', 'Rle', null, 'Rle'));
        return items;
    }
    getEncodingDifFileItems() {
        const items = [];
        items.push(new Item('item0', '437', null, '437'));
        items.push(new Item('item1', '850', null, '850'));
        items.push(new Item('item2', '852', null, '852'));
        items.push(new Item('item3', '857', null, '857'));
        items.push(new Item('item4', '860', null, '860'));
        items.push(new Item('item5', '861', null, '861'));
        items.push(new Item('item6', '862', null, '862'));
        items.push(new Item('item7', '863', null, '863'));
        items.push(new Item('item8', '865', null, '865'));
        items.push(new Item('item9', '866', null, '866'));
        items.push(new Item('item10', '869', null, '869'));
        return items;
    }
    getExportModeRtfItems() {
        const items = [];
        items.push(new Item('item0', this.model.loc('ExportModeRtfTable'), null, 'Table'));
        items.push(new Item('item1', this.model.loc('ExportModeRtfFrame'), null, 'Frame'));
        return items;
    }
    getEncodingDbfFileItems() {
        const items = [];
        items.push(new Item('item0', 'Default', null, 'Default'));
        items.push(new Item('item1', '437 U.S. MS-DOS', null, 'USDOS'));
        items.push(new Item('item2', '620 Mazovia(Polish) MS-DOS', null, 'MazoviaDOS'));
        items.push(new Item('item3', '737 Greek MS-DOS(437G)', null, 'GreekDOS'));
        items.push(new Item('item4', '850 International MS-DOS', null, 'InternationalDOS'));
        items.push(new Item('item5', '852 Eastern European MS-DOS', null, 'EasternEuropeanDOS'));
        items.push(new Item('item6', '857 Turkish MS-DOS', null, 'TurkishDOS'));
        items.push(new Item('item7', '861 Icelandic MS-DOS', null, 'IcelandicDOS'));
        items.push(new Item('item8', '865 Nordic MS-DOS', null, 'NordicDOS'));
        items.push(new Item('item9', '866 Russian MS-DOS', null, 'RussianDOS'));
        items.push(new Item('item10', '895 Kamenicky(Czech) MS-DOS', null, 'KamenickyDOS'));
        items.push(new Item('item11', '1250 Eastern European Windows', null, 'EasternEuropeanWindows'));
        items.push(new Item('item12', '1251 Russian Windows', null, 'RussianWindows'));
        items.push(new Item('item13', '1252 WindowsANSI', null, 'WindowsANSI'));
        items.push(new Item('item14', '1253 GreekWindows', null, 'GreekWindows'));
        items.push(new Item('item15', '1254 TurkishWindows', null, 'TurkishWindows'));
        items.push(new Item('item16', '10000 StandardMacintosh', null, 'StandardMacintosh'));
        items.push(new Item('item17', '10006 GreekMacintosh', null, 'GreekMacintosh'));
        items.push(new Item('item18', '10007 RussianMacintosh', null, 'RussianMacintosh'));
        items.push(new Item('item19', '10029 EasternEuropeanMacintosh', null, 'EasternEuropeanMacintosh'));
        return items;
    }
    getAllowEditableItems() {
        const items = [];
        items.push(new Item('item0', this.model.loc('NameYes'), null, 'Yes'));
        items.push(new Item('item1', this.model.loc('NameNo'), null, 'No'));
        return items;
    }
    getEncryptionKeyLengthItems() {
        const items = [];
        items.push(new Item('item0', '40 bit RC4 (Acrobat 3)', null, 'Bit40'));
        items.push(new Item('item1', '128 bit RC4 (Acrobat 5)', null, 'Bit128'));
        items.push(new Item('item2', '128 bit AES (Acrobat 7)', null, 'Bit128_r4'));
        items.push(new Item('item3', '256 bit AES (Acrobat 9)', null, 'Bit256_r5'));
        items.push(new Item('item4', '256 bit AES (Acrobat X)', null, 'Bit256_r6'));
        return items;
    }
    getDataExportModeItems() {
        const items = [];
        items.push(new Item('item0', this.model.loc('BandsFilterDataOnly'), null, 'Data'));
        items.push(new Item('item1', this.model.loc('BandsFilterDataAndHeaders'), null, 'DataAndHeaders'));
        items.push(new Item('item2', this.model.loc('BandsFilterDataAndHeadersFooters'), null, 'DataAndHeadersFooters'));
        items.push(new Item('item3', this.model.loc('BandsFilterAllBands'), null, 'AllBands'));
        return items;
    }
    getFilterConditionItems(dataType) {
        const items = [];
        switch (dataType) {
            case 'String':
                items.push(new Item('item0', this.model.loc('ConditionEqualTo'), '', 'EqualTo'));
                items.push(new Item('item1', this.model.loc('ConditionNotEqualTo'), '', 'NotEqualTo'));
                items.push('separator1');
                items.push(new Item('item2', this.model.loc('ConditionContaining'), '', 'Containing'));
                items.push(new Item('item3', this.model.loc('ConditionNotContaining'), '', 'NotContaining'));
                items.push('separator2');
                items.push(new Item('item4', this.model.loc('ConditionBeginningWith'), '', 'BeginningWith'));
                items.push(new Item('item5', this.model.loc('ConditionEndingWith'), '', 'EndingWith'));
                items.push('separator3');
                items.push(new Item('item2', this.model.loc('ConditionBetween'), '', 'Between'));
                items.push(new Item('item3', this.model.loc('ConditionNotBetween'), '', 'NotBetween'));
                items.push('separator4');
                items.push(new Item('item6', this.model.loc('ConditionGreaterThan'), '', 'GreaterThan'));
                items.push(new Item('item7', this.model.loc('ConditionGreaterThanOrEqualTo'), '', 'GreaterThanOrEqualTo'));
                items.push('separator5');
                items.push(new Item('item8', this.model.loc('ConditionLessThan'), '', 'LessThan'));
                items.push(new Item('item9', this.model.loc('ConditionLessThanOrEqualTo'), '', 'LessThanOrEqualTo'));
                items.push('separator6');
                items.push(new Item('item10', this.model.loc('ConditionIsNull'), '', 'IsNull'));
                items.push(new Item('item11', this.model.loc('ConditionIsNotNull'), '', 'IsNotNull'));
                items.push('separator7');
                items.push(new Item('item12', this.model.loc('ConditionIsBlank'), '', 'IsBlank'));
                items.push(new Item('item13', this.model.loc('ConditionIsNotBlank'), '', 'IsNotBlank'));
                break;
            case 'Numeric':
            case 'DateTime':
                {
                    items.push(new Item('item0', this.model.loc('ConditionEqualTo'), '', 'EqualTo'));
                }
                items.push(new Item('item1', this.model.loc('ConditionNotEqualTo'), '', 'NotEqualTo'));
                items.push('separator1');
                items.push(new Item('item2', this.model.loc('ConditionBetween'), '', 'Between'));
                items.push(new Item('item3', this.model.loc('ConditionNotBetween'), '', 'NotBetween'));
                items.push('separator2');
                items.push(new Item('item4', this.model.loc('ConditionGreaterThan'), '', 'GreaterThan'));
                items.push(new Item('item5', this.model.loc('ConditionGreaterThanOrEqualTo'), '', 'GreaterThanOrEqualTo'));
                items.push('separator3');
                items.push(new Item('item6', this.model.loc('ConditionLessThan'), '', 'LessThan'));
                items.push(new Item('item7', this.model.loc('ConditionLessThanOrEqualTo'), '', 'LessThanOrEqualTo'));
                items.push('separator4');
                items.push(new Item('item8', this.model.loc('ConditionIsNull'), '', 'IsNull'));
                items.push(new Item('item9', this.model.loc('ConditionIsNotNull'), '', 'IsNotNull'));
                break;
            case 'Boolean':
                {
                    items.push(new Item('item0', this.model.loc('ConditionEqualTo'), '', 'EqualTo'));
                }
                items.push(new Item('item1', this.model.loc('ConditionNotEqualTo'), '', 'NotEqualTo'));
                break;
        }
        return items;
    }
    getBoolItems() {
        const items = [];
        items.push(new Item('item0', this.model.loc('NameTrue'), null, 'True'));
        items.push(new Item('item1', this.model.loc('NameFalse'), null, 'False'));
        return items;
    }
    getPaperSizesItems() {
        const items = [];
        this.model.paperSizes.forEach((item, i) => items.push(new Item('item' + i, item, null, item)));
        return items;
    }
    getOrientationItems() {
        const items = [];
        items.push(new Item('item0', this.model.loc('Portrait'), null, 'Portrait'));
        items.push(new Item('item1', this.model.loc('Landscape'), null, 'Landscape'));
        return items;
    }
    getDashboardImageQualityItems() {
        const items = [];
        [50, 75, 100, 150, 200, 300, 500].forEach((item, i) => items.push(new Item('item' + i, item + '%', null, item.toString())));
        return items;
    }
    getPdfSecurityCertificatesItems() {
        let items = [];
        if (this.model.pdfSecurityCertificates) {
            for (var i = 0; i < this.model.pdfSecurityCertificates.length; i++) {
                var item = this.model.pdfSecurityCertificates[i];
                items.push(new Item('item' + i, "Name: " + item.name + "<br>Issuer: " + item.issuer + "<br>Valid from: " + item.from + " to " + item.to, null, item.thumbprint, null, null, null, 'DigitalSignature'));
            }
        }
        return items;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: CollectionsService, deps: [{ token: i1.ModelService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: CollectionsService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: CollectionsService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.ModelService }] });
//# sourceMappingURL=data:application/json;base64,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