import { Component, Input } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "@angular/common";
export class MenuItem {
    constructor(name, caption, img, type, selected, imageSize, value) {
        this.name = name;
        this.caption = caption;
        this.img = img;
        this.type = type;
        this.selected = selected;
        this.imageSize = imageSize;
        this.value = value;
    }
}
export class MenuItemComponent {
    constructor(model) {
        this.model = model;
        this.styleName = 'stiJsViewerMenuStandartItem';
        this.selected = false;
        this.over = false;
        this._enabled = true;
    }
    ngOnInit() { }
    get enabled() {
        return this._enabled;
    }
    set enabled(value) {
        if (!value) {
            this.over = false;
        }
        this._enabled = value;
    }
    mouseover() {
        if (!this.enabled || !this.enabled) {
            return;
        }
        this.over = true;
    }
    mouseout() {
        if (!this.enabled || !this.enabled) {
            return;
        }
        this.over = false;
    }
    get height() {
        if (this.item.imageSize === 'Big') {
            return '38px';
        }
        else {
            return this.model.options.isMobileDevice ? '0.4in' : (this.model.options.isTouchDevice ? '30px' : '24px');
        }
    }
    get className() {
        return this.styleName ? this.styleName + ' ' + (this.enabled ? (this.styleName + ((this.selected || this.item.selected) ? 'Selected' : (this.over ? 'Over' : ''))) : this.styleName + 'Disabled') : '';
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: MenuItemComponent, deps: [{ token: i1.ModelService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: MenuItemComponent, selector: "sti-menu-item", inputs: { item: "item", styleName: "styleName", enabled: "enabled" }, ngImport: i0, template: `
    <div *ngIf="item.type!='separator'" [class]="className" (mouseover)="mouseover()"
         (mouseout)="mouseout()" [style.height]="height">
         <table [style.height]="'100%'" [style.width]="'100%'" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
            <tr class="stiJsViewerClearAllStyles">
                <td *ngIf="item.img != null && !model.options.appearance.rightToLeft" class="stiJsViewerClearAllStyles" [style.width.px]="22" [style.minWidth.px]="22" [style.padding]="0"
                [style.textAlign]="'center'" [style.lineHeight]="0">
                  <img *ngIf="item.img != ''" [style.height.px]="item.imageSize === 'Big' ? 32 : 16" [style.width.px]="item.imageSize === 'Big' ? 32 : 16" src="{{model.img(item.img)}}" />
                </td>

                <td *ngIf="item.caption != null" class="stiJsViewerClearAllStyles" [style.whiteSpace]="'nowrap'"
                  [style.textAlign]="model.options.appearance.rightToLeft ? 'right' : 'left'"
                  [style.padding]="item.imageSize == 'None' ? '0 20px 0 30px' : '0 20px 0 7px'">
                  {{item.caption}}
                </td>

                <td *ngIf="item.img != null && model.options.appearance.rightToLeft" class="stiJsViewerClearAllStyles" [style.width.px]="22" [style.minWidth.px]="22" [style.padding]="'0'"
                [style.textAlign]="'center'" [style.lineHeight]="0">
                  <img *ngIf="item.img != ''" [style.height.px]="item.imageSize === 'Big' ? 32 : 16" [style.width.px]="item.imageSize === 'Big' ? 32 : 16" src="{{model.img(item.img)}}" />
                </td>
            </tr>
         </table>
    </div>
    <div *ngIf="item.type=='separator'" class="stiJsViewerVerticalMenuSeparator" [style.margin]="item.imageSize == 'Big' ? '1px 2px 1px 2px' : ''">
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: MenuItemComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-menu-item',
                    template: `
    <div *ngIf="item.type!='separator'" [class]="className" (mouseover)="mouseover()"
         (mouseout)="mouseout()" [style.height]="height">
         <table [style.height]="'100%'" [style.width]="'100%'" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
            <tr class="stiJsViewerClearAllStyles">
                <td *ngIf="item.img != null && !model.options.appearance.rightToLeft" class="stiJsViewerClearAllStyles" [style.width.px]="22" [style.minWidth.px]="22" [style.padding]="0"
                [style.textAlign]="'center'" [style.lineHeight]="0">
                  <img *ngIf="item.img != ''" [style.height.px]="item.imageSize === 'Big' ? 32 : 16" [style.width.px]="item.imageSize === 'Big' ? 32 : 16" src="{{model.img(item.img)}}" />
                </td>

                <td *ngIf="item.caption != null" class="stiJsViewerClearAllStyles" [style.whiteSpace]="'nowrap'"
                  [style.textAlign]="model.options.appearance.rightToLeft ? 'right' : 'left'"
                  [style.padding]="item.imageSize == 'None' ? '0 20px 0 30px' : '0 20px 0 7px'">
                  {{item.caption}}
                </td>

                <td *ngIf="item.img != null && model.options.appearance.rightToLeft" class="stiJsViewerClearAllStyles" [style.width.px]="22" [style.minWidth.px]="22" [style.padding]="'0'"
                [style.textAlign]="'center'" [style.lineHeight]="0">
                  <img *ngIf="item.img != ''" [style.height.px]="item.imageSize === 'Big' ? 32 : 16" [style.width.px]="item.imageSize === 'Big' ? 32 : 16" src="{{model.img(item.img)}}" />
                </td>
            </tr>
         </table>
    </div>
    <div *ngIf="item.type=='separator'" class="stiJsViewerVerticalMenuSeparator" [style.margin]="item.imageSize == 'Big' ? '1px 2px 1px 2px' : ''">
    </div>
  `
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }], propDecorators: { item: [{
                type: Input
            }], styleName: [{
                type: Input
            }], enabled: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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