import { Component } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/mail.service";
import * as i3 from "../services/export.service";
import * as i4 from "@angular/common";
import * as i5 from "../controls/text-box.componet";
import * as i6 from "./base-form.component";
import * as i7 from "../controls/text-area.component";
export class SendEmailFormComponent {
    constructor(model, mailService, exportService) {
        this.model = model;
        this.mailService = mailService;
        this.exportService = exportService;
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: SendEmailFormComponent, deps: [{ token: i1.ModelService }, { token: i2.MailService }, { token: i3.ExportService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: SendEmailFormComponent, selector: "sti-send-email-form", ngImport: i0, template: `
    <sti-base-form #baseForm [fontFamily]="model.options.toolbar.fontFamily"
      [color]="model.options.toolbar.fontColor"
      [fontSize]="'12px'"
      [name]="'sendEmailForm'"
      [caption]="model.loc('EmailOptions')"
      [level]="1"
      [defaultTop]="150"
      (action)="this.mailService.sendMail()">
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.width]="'100%'">
        <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerCaptionControls" [style.padding]="model.options.isMobileDevice ? '0 25px 0 4px' : ''">
                {{model.loc('Email')}}
              </td>
              <td *ngIf="!model.options.isMobileDevice">
                <sti-text-box [margin]="model.options.isMobileDevice ? '4px 4px 12px 4px' : '4px'"
                  [value]="exportService.exportSettings.Email"
                  [width]="model.options.isMobileDevice ? 200 : 280"
                  (onchange)="exportService.exportSettings.Email = $event.value">
                </sti-text-box>
              </td>
            </tr>
            <tr class="stiJsViewerClearAllStyles" *ngIf="model.options.isMobileDevice">
              <td class="stiJsViewerClearAllStyles">
                <sti-text-box [margin]="model.options.isMobileDevice ? '4px 4px 12px 4px' : '4px'"
                  [value]="exportService.exportSettings.Email"
                  [width]="model.options.isMobileDevice ? 200 : 280"
                  (onchange)="exportService.exportSettings.Email = $event.value">
                </sti-text-box>
              </td>
            </tr>

            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerCaptionControls" [style.padding]="model.options.isMobileDevice ? '0 25px 0 4px' : ''">
                {{model.loc('Subject')}}
              </td>
              <td *ngIf="!model.options.isMobileDevice">
                <sti-text-box [margin]="model.options.isMobileDevice ? '4px 4px 12px 4px' : '4px'"
                  [value]="exportService.exportSettings.Subject"
                  [width]="model.options.isMobileDevice ? 200 : 280"
                  (onchange)="exportService.exportSettings.Subject = $event.value">
                </sti-text-box>
              </td>
            </tr>
            <tr class="stiJsViewerClearAllStyles" *ngIf="model.options.isMobileDevice">
              <td class="stiJsViewerClearAllStyles">
                <sti-text-box [margin]="model.options.isMobileDevice ? '4px 4px 12px 4px' : '4px'"
                  [value]="exportService.exportSettings.Subject"
                  [width]="model.options.isMobileDevice ? 200 : 280"
                  (onchange)="exportService.exportSettings.Subject = $event.value">
                </sti-text-box>
              </td>
            </tr>

            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerCaptionControls" [style.padding]="model.options.isMobileDevice ? '0 25px 0 4px' : ''">
                {{model.loc('Message')}}
              </td>
              <td *ngIf="!model.options.isMobileDevice">
                <sti-text-area [margin]="model.options.isMobileDevice ? '4px 4px 12px 4px' : '4px'"
                  [value]="exportService.exportSettings.Message"
                  [height]="70"
                  [width]="model.options.isMobileDevice ? 200 : 280"
                  (onchange)="exportService.exportSettings.Message = $event.value">
                </sti-text-area>
              </td>
            </tr>
            <tr class="stiJsViewerClearAllStyles" *ngIf="model.options.isMobileDevice">
              <td class="stiJsViewerClearAllStyles">
                <sti-text-area [margin]="model.options.isMobileDevice ? '4px 4px 12px 4px' : '4px'"
                  [value]="exportService.exportSettings.Message"
                  [height]="70"
                  [width]="model.options.isMobileDevice ? 200 : 280"
                  (onchange)="exportService.exportSettings.Message = $event.value">
                </sti-text-area>
              </td>
            </tr>

            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerCaptionControls" [style.padding]="model.options.isMobileDevice ? '0 25px 0 4px' : ''">
                {{model.loc('Attachment')}}
              </td>
              <td *ngIf="!model.options.isMobileDevice">
                <div [style.margin.px]="4">
                  {{exportService.exportSettings.Attachment}}
                </div>
              </td>
            </tr>
            <tr class="stiJsViewerClearAllStyles" *ngIf="model.options.isMobileDevice">
              <td class="stiJsViewerClearAllStyles">
                <div [style.margin.px]="4">
                  {{exportService.exportSettings.Attachment}}
                </div>
              </td>
            </tr>
        </tbody>
      </table>
    </sti-base-form>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i5.TextBoxComponent, selector: "sti-text-box", inputs: ["width", "actionLostFocus", "tooltip", "enabled", "value", "margin", "focusOnCreate", "maxLength", "color", "type", "padding", "border", "variable", "textAlign", "autocomplete", "readOnly"], outputs: ["action", "onchange", "onblur"] }, { kind: "component", type: i6.BaseFormComponent, selector: "sti-base-form", inputs: ["level", "caption", "helpUrl", "fontFamily", "color", "fontSize", "containerPadding", "name", "defaultTop", "showCancel", "showButtons", "showSeparator"], outputs: ["changeVisibility", "action"] }, { kind: "component", type: i7.TextAreaComponent, selector: "sti-text-area", inputs: ["width", "height", "enabled", "value", "padding", "margin"], outputs: ["action", "onchange", "onblur"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: SendEmailFormComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-send-email-form',
                    template: `
    <sti-base-form #baseForm [fontFamily]="model.options.toolbar.fontFamily"
      [color]="model.options.toolbar.fontColor"
      [fontSize]="'12px'"
      [name]="'sendEmailForm'"
      [caption]="model.loc('EmailOptions')"
      [level]="1"
      [defaultTop]="150"
      (action)="this.mailService.sendMail()">
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.width]="'100%'">
        <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerCaptionControls" [style.padding]="model.options.isMobileDevice ? '0 25px 0 4px' : ''">
                {{model.loc('Email')}}
              </td>
              <td *ngIf="!model.options.isMobileDevice">
                <sti-text-box [margin]="model.options.isMobileDevice ? '4px 4px 12px 4px' : '4px'"
                  [value]="exportService.exportSettings.Email"
                  [width]="model.options.isMobileDevice ? 200 : 280"
                  (onchange)="exportService.exportSettings.Email = $event.value">
                </sti-text-box>
              </td>
            </tr>
            <tr class="stiJsViewerClearAllStyles" *ngIf="model.options.isMobileDevice">
              <td class="stiJsViewerClearAllStyles">
                <sti-text-box [margin]="model.options.isMobileDevice ? '4px 4px 12px 4px' : '4px'"
                  [value]="exportService.exportSettings.Email"
                  [width]="model.options.isMobileDevice ? 200 : 280"
                  (onchange)="exportService.exportSettings.Email = $event.value">
                </sti-text-box>
              </td>
            </tr>

            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerCaptionControls" [style.padding]="model.options.isMobileDevice ? '0 25px 0 4px' : ''">
                {{model.loc('Subject')}}
              </td>
              <td *ngIf="!model.options.isMobileDevice">
                <sti-text-box [margin]="model.options.isMobileDevice ? '4px 4px 12px 4px' : '4px'"
                  [value]="exportService.exportSettings.Subject"
                  [width]="model.options.isMobileDevice ? 200 : 280"
                  (onchange)="exportService.exportSettings.Subject = $event.value">
                </sti-text-box>
              </td>
            </tr>
            <tr class="stiJsViewerClearAllStyles" *ngIf="model.options.isMobileDevice">
              <td class="stiJsViewerClearAllStyles">
                <sti-text-box [margin]="model.options.isMobileDevice ? '4px 4px 12px 4px' : '4px'"
                  [value]="exportService.exportSettings.Subject"
                  [width]="model.options.isMobileDevice ? 200 : 280"
                  (onchange)="exportService.exportSettings.Subject = $event.value">
                </sti-text-box>
              </td>
            </tr>

            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerCaptionControls" [style.padding]="model.options.isMobileDevice ? '0 25px 0 4px' : ''">
                {{model.loc('Message')}}
              </td>
              <td *ngIf="!model.options.isMobileDevice">
                <sti-text-area [margin]="model.options.isMobileDevice ? '4px 4px 12px 4px' : '4px'"
                  [value]="exportService.exportSettings.Message"
                  [height]="70"
                  [width]="model.options.isMobileDevice ? 200 : 280"
                  (onchange)="exportService.exportSettings.Message = $event.value">
                </sti-text-area>
              </td>
            </tr>
            <tr class="stiJsViewerClearAllStyles" *ngIf="model.options.isMobileDevice">
              <td class="stiJsViewerClearAllStyles">
                <sti-text-area [margin]="model.options.isMobileDevice ? '4px 4px 12px 4px' : '4px'"
                  [value]="exportService.exportSettings.Message"
                  [height]="70"
                  [width]="model.options.isMobileDevice ? 200 : 280"
                  (onchange)="exportService.exportSettings.Message = $event.value">
                </sti-text-area>
              </td>
            </tr>

            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerCaptionControls" [style.padding]="model.options.isMobileDevice ? '0 25px 0 4px' : ''">
                {{model.loc('Attachment')}}
              </td>
              <td *ngIf="!model.options.isMobileDevice">
                <div [style.margin.px]="4">
                  {{exportService.exportSettings.Attachment}}
                </div>
              </td>
            </tr>
            <tr class="stiJsViewerClearAllStyles" *ngIf="model.options.isMobileDevice">
              <td class="stiJsViewerClearAllStyles">
                <div [style.margin.px]="4">
                  {{exportService.exportSettings.Attachment}}
                </div>
              </td>
            </tr>
        </tbody>
      </table>
    </sti-base-form>
  `
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.MailService }, { type: i3.ExportService }] });
//# sourceMappingURL=data:application/json;base64,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