import { Component, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/controller.service";
import * as i3 from "./form.service";
import * as i4 from "../controls/text-box.componet";
import * as i5 from "./base-form.component";
export class PasswordFormComponent {
    constructor(model, controller, formService) {
        this.model = model;
        this.controller = controller;
        this.formService = formService;
    }
    ngOnInit() { }
    changeVisibility(state) {
        if (state === 'visible') {
            this.password = '';
            this.textBox.element.nativeElement.focus();
        }
    }
    action() {
        const data = this.formService.form.formData;
        data.openingFilePassword = this.password;
        this.formService.closeForm('passwordForm');
        this.controller.postOpen(data);
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: PasswordFormComponent, deps: [{ token: i1.ModelService }, { token: i2.ControllerService }, { token: i3.FormService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: PasswordFormComponent, selector: "sti-password-form", viewQueries: [{ propertyName: "textBox", first: true, predicate: ["textBox"], descendants: true }], ngImport: i0, template: `
    <sti-base-form [fontFamily]="model.options.toolbar.fontFamily"
      [color]="model.options.toolbar.fontColor"
      [name]="'passwordForm'"
      [caption]="model.loc('PasswordSaveReport').replace(':', '')"
      [level]="2"
      [defaultTop]="150"
      (changeVisibility)="changeVisibility($event)"
      (action)="action()">
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.margin.px]="5">
        <tbody>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerCaptionControls">
              {{model.loc('PasswordEnter')}}
            </td>
            <td class="stiJsViewerCaptionControls">
              <sti-text-box #textBox [type]="'password'" [autocomplete]="'new-password'" [width]="200" [focusOnCreate]="true" [value]="password" (onchange)="password = $event.value">
              </sti-text-box>
            </td>
          </tr>
        </tbody>
      </table>
    </sti-base-form>
  `, isInline: true, dependencies: [{ kind: "component", type: i4.TextBoxComponent, selector: "sti-text-box", inputs: ["width", "actionLostFocus", "tooltip", "enabled", "value", "margin", "focusOnCreate", "maxLength", "color", "type", "padding", "border", "variable", "textAlign", "autocomplete", "readOnly"], outputs: ["action", "onchange", "onblur"] }, { kind: "component", type: i5.BaseFormComponent, selector: "sti-base-form", inputs: ["level", "caption", "helpUrl", "fontFamily", "color", "fontSize", "containerPadding", "name", "defaultTop", "showCancel", "showButtons", "showSeparator"], outputs: ["changeVisibility", "action"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: PasswordFormComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-password-form',
                    template: `
    <sti-base-form [fontFamily]="model.options.toolbar.fontFamily"
      [color]="model.options.toolbar.fontColor"
      [name]="'passwordForm'"
      [caption]="model.loc('PasswordSaveReport').replace(':', '')"
      [level]="2"
      [defaultTop]="150"
      (changeVisibility)="changeVisibility($event)"
      (action)="action()">
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.margin.px]="5">
        <tbody>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerCaptionControls">
              {{model.loc('PasswordEnter')}}
            </td>
            <td class="stiJsViewerCaptionControls">
              <sti-text-box #textBox [type]="'password'" [autocomplete]="'new-password'" [width]="200" [focusOnCreate]="true" [value]="password" (onchange)="password = $event.value">
              </sti-text-box>
            </td>
          </tr>
        </tbody>
      </table>
    </sti-base-form>
  `
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.ControllerService }, { type: i3.FormService }], propDecorators: { textBox: [{
                type: ViewChild,
                args: ['textBox']
            }] } });
//# sourceMappingURL=data:application/json;base64,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