import { Component } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "./form.service";
import * as i3 from "@angular/common";
import * as i4 from "../controls/button.component";
import * as i5 from "./base-form.component";
export class NotificationFormComponent {
    constructor(model, formService) {
        this.model = model;
        this.formService = formService;
    }
    ngOnInit() { }
    changeVisibility(state) {
        if (state === 'hidden' && this.model.notificationFormOptions?.cancelAction) {
            this.model.notificationFormOptions.cancelAction();
        }
    }
    action() {
        this.model.notificationFormOptions?.action ? this.model.notificationFormOptions.action() : this.formService.closeForm('notificationForm');
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: NotificationFormComponent, deps: [{ token: i1.ModelService }, { token: i2.FormService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: NotificationFormComponent, selector: "sti-notification-form", ngImport: i0, template: `
  <sti-base-form [fontFamily]="model.options.toolbar.fontFamily"
      [color]="model.options.toolbar.fontColor"
      [name]="'notificationForm'"
      [defaultTop]="150"
      [caption]="model.loc('Viewer')"
      [level]="4"
      [showButtons]="false"
      [showSeparator]="false"
      (changeVisibility)="changeVisibility($event)">
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
        <tbody>
          <tr *ngIf="model.notificationFormOptions?.image" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" [style.textAlign]="'center'">
              <img src="{{model.img(model.notificationFormOptions?.image)}}" [style.marginTop.px]="20" [style.width.px]="112" [style.height.px]="112">
            </td>
          </tr>
          <tr *ngIf="model.notificationFormOptions?.message" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles">
              <div class="stiJsViewerNotificationFormMessage">
                {{model.notificationFormOptions?.message}}
              </div>
            </td>
          </tr>
          <tr *ngIf="model.notificationFormOptions?.description" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles">
              <div class="stiJsViewerNotificationFormDescription">
                {{model.notificationFormOptions?.description}}
              </div>
            </td>
          </tr>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" [style.textAlign]="'center'">
              <sti-button
                [caption]="model.notificationFormOptions?.buttonCaption"
                [styleName]="'stiJsViewerLoginButton'"
                [innerTableWidth]="'100%'"
                [height]="'40px'"
                [minWidth]="'80px'"
                [captionAlign]="'center'"
                [cursor]="'pointer'"
                [display]="'inline-block'"
                [minWidth]="'200px'"
                [width]="'auto'"
                [margin]="'20px 30px 30px 30px'"
                [fontSize]="'14px'"
                (action)="action()">
              </sti-button>
            </td>
          </tr>
        </tbody>
      </table>
    </sti-base-form>
    `, isInline: true, dependencies: [{ kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i4.ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }, { kind: "component", type: i5.BaseFormComponent, selector: "sti-base-form", inputs: ["level", "caption", "helpUrl", "fontFamily", "color", "fontSize", "containerPadding", "name", "defaultTop", "showCancel", "showButtons", "showSeparator"], outputs: ["changeVisibility", "action"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: NotificationFormComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-notification-form',
                    template: `
  <sti-base-form [fontFamily]="model.options.toolbar.fontFamily"
      [color]="model.options.toolbar.fontColor"
      [name]="'notificationForm'"
      [defaultTop]="150"
      [caption]="model.loc('Viewer')"
      [level]="4"
      [showButtons]="false"
      [showSeparator]="false"
      (changeVisibility)="changeVisibility($event)">
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
        <tbody>
          <tr *ngIf="model.notificationFormOptions?.image" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" [style.textAlign]="'center'">
              <img src="{{model.img(model.notificationFormOptions?.image)}}" [style.marginTop.px]="20" [style.width.px]="112" [style.height.px]="112">
            </td>
          </tr>
          <tr *ngIf="model.notificationFormOptions?.message" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles">
              <div class="stiJsViewerNotificationFormMessage">
                {{model.notificationFormOptions?.message}}
              </div>
            </td>
          </tr>
          <tr *ngIf="model.notificationFormOptions?.description" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles">
              <div class="stiJsViewerNotificationFormDescription">
                {{model.notificationFormOptions?.description}}
              </div>
            </td>
          </tr>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" [style.textAlign]="'center'">
              <sti-button
                [caption]="model.notificationFormOptions?.buttonCaption"
                [styleName]="'stiJsViewerLoginButton'"
                [innerTableWidth]="'100%'"
                [height]="'40px'"
                [minWidth]="'80px'"
                [captionAlign]="'center'"
                [cursor]="'pointer'"
                [display]="'inline-block'"
                [minWidth]="'200px'"
                [width]="'auto'"
                [margin]="'20px 30px 30px 30px'"
                [fontSize]="'14px'"
                (action)="action()">
              </sti-button>
            </td>
          </tr>
        </tbody>
      </table>
    </sti-base-form>
    `
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.FormService }] });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibm90aWZpY2F0aW9uLWZvcm0uY29tcG9uZW50LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc3RpbXVsc29mdC12aWV3ZXItYW5ndWxhci9zcmMvbGliL2Zvcm1zL25vdGlmaWNhdGlvbi1mb3JtLmNvbXBvbmVudC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsU0FBUyxFQUFVLE1BQU0sZUFBZSxDQUFDOzs7Ozs7O0FBOERsRCxNQUFNLE9BQU8seUJBQXlCO0lBRXBDLFlBQW1CLEtBQW1CLEVBQVMsV0FBd0I7UUFBcEQsVUFBSyxHQUFMLEtBQUssQ0FBYztRQUFTLGdCQUFXLEdBQVgsV0FBVyxDQUFhO0lBQUksQ0FBQztJQUU1RSxRQUFRLEtBQUssQ0FBQztJQUVkLGdCQUFnQixDQUFDLEtBQWE7UUFDNUIsSUFBSSxLQUFLLEtBQUssUUFBUSxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsdUJBQXVCLEVBQUUsWUFBWSxFQUFFLENBQUM7WUFDM0UsSUFBSSxDQUFDLEtBQUssQ0FBQyx1QkFBdUIsQ0FBQyxZQUFZLEVBQUUsQ0FBQztRQUNwRCxDQUFDO0lBQ0gsQ0FBQztJQUVELE1BQU07UUFDSixJQUFJLENBQUMsS0FBSyxDQUFDLHVCQUF1QixFQUFFLE1BQU0sQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyx1QkFBdUIsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsQ0FBQztJQUM1SSxDQUFDOytHQWRVLHlCQUF5QjttR0FBekIseUJBQXlCLDZEQXhEMUI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0tBcURQOzs0RkFHUSx5QkFBeUI7a0JBMURyQyxTQUFTO21CQUFDO29CQUNULFFBQVEsRUFBRSx1QkFBdUI7b0JBQ2pDLFFBQVEsRUFBRTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7S0FxRFA7aUJBQ0oiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21wb25lbnQsIE9uSW5pdCB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xyXG5pbXBvcnQgeyBNb2RlbFNlcnZpY2UgfSBmcm9tICcuLi9zZXJ2aWNlcy9tb2RlbC5zZXJ2aWNlJztcclxuaW1wb3J0IHsgRm9ybVNlcnZpY2UgfSBmcm9tICcuL2Zvcm0uc2VydmljZSc7XHJcblxyXG5AQ29tcG9uZW50KHtcclxuICBzZWxlY3RvcjogJ3N0aS1ub3RpZmljYXRpb24tZm9ybScsXHJcbiAgdGVtcGxhdGU6IGBcclxuICA8c3RpLWJhc2UtZm9ybSBbZm9udEZhbWlseV09XCJtb2RlbC5vcHRpb25zLnRvb2xiYXIuZm9udEZhbWlseVwiXHJcbiAgICAgIFtjb2xvcl09XCJtb2RlbC5vcHRpb25zLnRvb2xiYXIuZm9udENvbG9yXCJcclxuICAgICAgW25hbWVdPVwiJ25vdGlmaWNhdGlvbkZvcm0nXCJcclxuICAgICAgW2RlZmF1bHRUb3BdPVwiMTUwXCJcclxuICAgICAgW2NhcHRpb25dPVwibW9kZWwubG9jKCdWaWV3ZXInKVwiXHJcbiAgICAgIFtsZXZlbF09XCI0XCJcclxuICAgICAgW3Nob3dCdXR0b25zXT1cImZhbHNlXCJcclxuICAgICAgW3Nob3dTZXBhcmF0b3JdPVwiZmFsc2VcIlxyXG4gICAgICAoY2hhbmdlVmlzaWJpbGl0eSk9XCJjaGFuZ2VWaXNpYmlsaXR5KCRldmVudClcIj5cclxuICAgICAgPHRhYmxlIGNsYXNzPVwic3RpSnNWaWV3ZXJDbGVhckFsbFN0eWxlc1wiIGNlbGxwYWRkaW5nPVwiMFwiIGNlbGxzcGFjaW5nPVwiMFwiPlxyXG4gICAgICAgIDx0Ym9keT5cclxuICAgICAgICAgIDx0ciAqbmdJZj1cIm1vZGVsLm5vdGlmaWNhdGlvbkZvcm1PcHRpb25zPy5pbWFnZVwiIGNsYXNzPVwic3RpSnNWaWV3ZXJDbGVhckFsbFN0eWxlc1wiPlxyXG4gICAgICAgICAgICA8dGQgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzXCIgW3N0eWxlLnRleHRBbGlnbl09XCInY2VudGVyJ1wiPlxyXG4gICAgICAgICAgICAgIDxpbWcgc3JjPVwie3ttb2RlbC5pbWcobW9kZWwubm90aWZpY2F0aW9uRm9ybU9wdGlvbnM/LmltYWdlKX19XCIgW3N0eWxlLm1hcmdpblRvcC5weF09XCIyMFwiIFtzdHlsZS53aWR0aC5weF09XCIxMTJcIiBbc3R5bGUuaGVpZ2h0LnB4XT1cIjExMlwiPlxyXG4gICAgICAgICAgICA8L3RkPlxyXG4gICAgICAgICAgPC90cj5cclxuICAgICAgICAgIDx0ciAqbmdJZj1cIm1vZGVsLm5vdGlmaWNhdGlvbkZvcm1PcHRpb25zPy5tZXNzYWdlXCIgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzXCI+XHJcbiAgICAgICAgICAgIDx0ZCBjbGFzcz1cInN0aUpzVmlld2VyQ2xlYXJBbGxTdHlsZXNcIj5cclxuICAgICAgICAgICAgICA8ZGl2IGNsYXNzPVwic3RpSnNWaWV3ZXJOb3RpZmljYXRpb25Gb3JtTWVzc2FnZVwiPlxyXG4gICAgICAgICAgICAgICAge3ttb2RlbC5ub3RpZmljYXRpb25Gb3JtT3B0aW9ucz8ubWVzc2FnZX19XHJcbiAgICAgICAgICAgICAgPC9kaXY+XHJcbiAgICAgICAgICAgIDwvdGQ+XHJcbiAgICAgICAgICA8L3RyPlxyXG4gICAgICAgICAgPHRyICpuZ0lmPVwibW9kZWwubm90aWZpY2F0aW9uRm9ybU9wdGlvbnM/LmRlc2NyaXB0aW9uXCIgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzXCI+XHJcbiAgICAgICAgICAgIDx0ZCBjbGFzcz1cInN0aUpzVmlld2VyQ2xlYXJBbGxTdHlsZXNcIj5cclxuICAgICAgICAgICAgICA8ZGl2IGNsYXNzPVwic3RpSnNWaWV3ZXJOb3RpZmljYXRpb25Gb3JtRGVzY3JpcHRpb25cIj5cclxuICAgICAgICAgICAgICAgIHt7bW9kZWwubm90aWZpY2F0aW9uRm9ybU9wdGlvbnM/LmRlc2NyaXB0aW9ufX1cclxuICAgICAgICAgICAgICA8L2Rpdj5cclxuICAgICAgICAgICAgPC90ZD5cclxuICAgICAgICAgIDwvdHI+XHJcbiAgICAgICAgICA8dHIgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzXCI+XHJcbiAgICAgICAgICAgIDx0ZCBjbGFzcz1cInN0aUpzVmlld2VyQ2xlYXJBbGxTdHlsZXNcIiBbc3R5bGUudGV4dEFsaWduXT1cIidjZW50ZXInXCI+XHJcbiAgICAgICAgICAgICAgPHN0aS1idXR0b25cclxuICAgICAgICAgICAgICAgIFtjYXB0aW9uXT1cIm1vZGVsLm5vdGlmaWNhdGlvbkZvcm1PcHRpb25zPy5idXR0b25DYXB0aW9uXCJcclxuICAgICAgICAgICAgICAgIFtzdHlsZU5hbWVdPVwiJ3N0aUpzVmlld2VyTG9naW5CdXR0b24nXCJcclxuICAgICAgICAgICAgICAgIFtpbm5lclRhYmxlV2lkdGhdPVwiJzEwMCUnXCJcclxuICAgICAgICAgICAgICAgIFtoZWlnaHRdPVwiJzQwcHgnXCJcclxuICAgICAgICAgICAgICAgIFttaW5XaWR0aF09XCInODBweCdcIlxyXG4gICAgICAgICAgICAgICAgW2NhcHRpb25BbGlnbl09XCInY2VudGVyJ1wiXHJcbiAgICAgICAgICAgICAgICBbY3Vyc29yXT1cIidwb2ludGVyJ1wiXHJcbiAgICAgICAgICAgICAgICBbZGlzcGxheV09XCInaW5saW5lLWJsb2NrJ1wiXHJcbiAgICAgICAgICAgICAgICBbbWluV2lkdGhdPVwiJzIwMHB4J1wiXHJcbiAgICAgICAgICAgICAgICBbd2lkdGhdPVwiJ2F1dG8nXCJcclxuICAgICAgICAgICAgICAgIFttYXJnaW5dPVwiJzIwcHggMzBweCAzMHB4IDMwcHgnXCJcclxuICAgICAgICAgICAgICAgIFtmb250U2l6ZV09XCInMTRweCdcIlxyXG4gICAgICAgICAgICAgICAgKGFjdGlvbik9XCJhY3Rpb24oKVwiPlxyXG4gICAgICAgICAgICAgIDwvc3RpLWJ1dHRvbj5cclxuICAgICAgICAgICAgPC90ZD5cclxuICAgICAgICAgIDwvdHI+XHJcbiAgICAgICAgPC90Ym9keT5cclxuICAgICAgPC90YWJsZT5cclxuICAgIDwvc3RpLWJhc2UtZm9ybT5cclxuICAgIGBcclxufSlcclxuXHJcbmV4cG9ydCBjbGFzcyBOb3RpZmljYXRpb25Gb3JtQ29tcG9uZW50IGltcGxlbWVudHMgT25Jbml0IHtcclxuXHJcbiAgY29uc3RydWN0b3IocHVibGljIG1vZGVsOiBNb2RlbFNlcnZpY2UsIHB1YmxpYyBmb3JtU2VydmljZTogRm9ybVNlcnZpY2UpIHsgfVxyXG5cclxuICBuZ09uSW5pdCgpIHsgfVxyXG5cclxuICBjaGFuZ2VWaXNpYmlsaXR5KHN0YXRlOiBzdHJpbmcpIHtcclxuICAgIGlmIChzdGF0ZSA9PT0gJ2hpZGRlbicgJiYgdGhpcy5tb2RlbC5ub3RpZmljYXRpb25Gb3JtT3B0aW9ucz8uY2FuY2VsQWN0aW9uKSB7XHJcbiAgICAgIHRoaXMubW9kZWwubm90aWZpY2F0aW9uRm9ybU9wdGlvbnMuY2FuY2VsQWN0aW9uKCk7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBhY3Rpb24oKSB7XHJcbiAgICB0aGlzLm1vZGVsLm5vdGlmaWNhdGlvbkZvcm1PcHRpb25zPy5hY3Rpb24gPyB0aGlzLm1vZGVsLm5vdGlmaWNhdGlvbkZvcm1PcHRpb25zLmFjdGlvbigpIDogdGhpcy5mb3JtU2VydmljZS5jbG9zZUZvcm0oJ25vdGlmaWNhdGlvbkZvcm0nKTtcclxuICB9XHJcbn1cclxuIl19