import { Component, ViewChild } from '@angular/core';
import { trigger, state, transition, animate, style, keyframes } from '@angular/animations';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/tooltip.service";
import * as i3 from "../services/helper.service";
import * as i4 from "@angular/common";
import * as i5 from "./button.component";
export class TooltipComponent {
    constructor(model, tooltipService, helper) {
        this.model = model;
        this.tooltipService = tooltipService;
        this.helper = helper;
    }
    ngAfterViewInit() {
        this.model.controls.tooltip.el = this.element;
    }
    ngOnInit() { }
    action() {
        this.helper.showHelpWindow(this.tooltipService.helpLink);
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: TooltipComponent, deps: [{ token: i1.ModelService }, { token: i2.TooltipService }, { token: i3.HelperService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: TooltipComponent, selector: "sti-tooltip", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
      <div #element class='stiJsViewerToolTip' [@expandDown]="tooltipService.state"
        [style.left.px]='tooltipService.left' [style.top.px]='tooltipService.top'
        (mouseover)="tooltipService.showFromTooltip()" (mouseout)="tooltipService.hide()">
        <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.height]="'100%'"
          [style.border]="model.options.appearance.showTooltipsHelp ? '' : 0">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerToolTipTextCell">
                {{tooltipService.caption}}
              </td>
            </tr>
            <tr *ngIf="model.options.appearance.showTooltipsHelp" class="stiJsViewerClearAllStyles">
              <td  class="stiJsViewerClearAllStyles">
                <sti-button [caption]="model.loc('TellMeMore')"
                    [imageName]="'HelpIcon.png'"
                    [margin]="'4px 8px 4px 8px'"
                    (action)='action()'
                    [styleName]="'stiJsViewerHyperlinkButton'">
                </sti-button>
              </td>
            </tr>
          </tbody>
        </table>
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i5.ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }], animations: [
            trigger('expandDown', [
                state('initial', style({ opacity: 0, display: 'none' })),
                state('preInitial', style({ opacity: 0, display: 'block' })),
                state('preInitial2', style({ opacity: 0, display: 'block' })),
                state('expanded', style({ opacity: 1, display: 'block' })),
                transition('preInitial => expanded', [
                    animate('300ms 300ms ease-in-out', keyframes([
                        style({ display: 'block', opacity: 0, offset: 0 }),
                        style({ display: 'block', opacity: 1, offset: 1 }),
                    ]))
                ])
            ])
        ] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: TooltipComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-tooltip',
                    template: `
      <div #element class='stiJsViewerToolTip' [@expandDown]="tooltipService.state"
        [style.left.px]='tooltipService.left' [style.top.px]='tooltipService.top'
        (mouseover)="tooltipService.showFromTooltip()" (mouseout)="tooltipService.hide()">
        <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.height]="'100%'"
          [style.border]="model.options.appearance.showTooltipsHelp ? '' : 0">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerToolTipTextCell">
                {{tooltipService.caption}}
              </td>
            </tr>
            <tr *ngIf="model.options.appearance.showTooltipsHelp" class="stiJsViewerClearAllStyles">
              <td  class="stiJsViewerClearAllStyles">
                <sti-button [caption]="model.loc('TellMeMore')"
                    [imageName]="'HelpIcon.png'"
                    [margin]="'4px 8px 4px 8px'"
                    (action)='action()'
                    [styleName]="'stiJsViewerHyperlinkButton'">
                </sti-button>
              </td>
            </tr>
          </tbody>
        </table>
    </div>
  `,
                    animations: [
                        trigger('expandDown', [
                            state('initial', style({ opacity: 0, display: 'none' })),
                            state('preInitial', style({ opacity: 0, display: 'block' })),
                            state('preInitial2', style({ opacity: 0, display: 'block' })),
                            state('expanded', style({ opacity: 1, display: 'block' })),
                            transition('preInitial => expanded', [
                                animate('300ms 300ms ease-in-out', keyframes([
                                    style({ display: 'block', opacity: 0, offset: 0 }),
                                    style({ display: 'block', opacity: 1, offset: 1 }),
                                ]))
                            ])
                        ])
                    ]
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.TooltipService }, { type: i3.HelperService }], propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });
//# sourceMappingURL=data:application/json;base64,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