import { Component, Input, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/helper.service";
import * as i3 from "../../menu/menu.service";
import * as i4 from "../../services/interactions.service";
import * as i5 from "@angular/common";
import * as i6 from "./parameter-text-box.component";
import * as i7 from "./parameter-checkbox.component";
import * as i8 from "./parameter-button.component";
export class ParameterComponent {
    constructor(model, helper, menuService, intearctionService) {
        this.model = model;
        this.helper = helper;
        this.menuService = menuService;
        this.intearctionService = intearctionService;
    }
    ngOnInit() { }
    get params() {
        return this._params;
    }
    set params(params) {
        this._params = params;
        if (params.basicType === 'Range') {
            if (params.type === 'DateTime' && params.keyTo && params.keyTo.isNull) {
                params.keyTo = this.helper.getDateTimeObject(new Date());
            }
        }
    }
    get showParameterInTwoRows() {
        return this.params.basicType === 'Range' && this.model.options.appearance.currentParametersPanelPosition === 'Left';
    }
    getReadOnlyCheckbox() {
        return this.params.basicType === 'List' || !this.params.allowUserValues;
    }
    getFirstTextBoxValue() {
        let value = '';
        if (this.params.basicType === 'Value' || this.params.basicType === 'NullableValue') {
            if (this.params.type === 'DateTime' && this.params.value === null) {
                this.params.value = new Date();
                this.params.key = this.helper.getDateTimeObject(this.params.value);
            }
            value = (this.params.type === 'DateTime') ? this.helper.getStringKey(this.params.key, this.params) : (this.params.allowUserValues ? this.params.key :
                (this.params.value != "" || !this.params.isChanged ? this.params.value : this.params.key));
        }
        // Range
        if (this.params.basicType === 'Range') {
            if (this.params.type === 'DateTime' && this.params.key && this.params.key.isNull) {
                this.params.key = this.helper.getDateTimeObject(new Date());
            }
            value = this.helper.getStringKey(this.params.key, this.params);
        }
        // List
        if (this.params.basicType === 'List' && this.params.items) {
            this.params.items.forEach((item) => {
                if (item.isChecked) {
                    if (value !== '') {
                        value += (this.model.options.listSeparator ? this.model.options.listSeparator + " " : "; ");
                    }
                    if (this.params.allowUserValues) {
                        value += this.helper.getStringKey(item.key, this.params);
                    }
                    else {
                        value += item.value !== '' ? item.value : this.helper.getStringKey(item.key, this.params);
                    }
                }
            });
        }
        return value != null ? value.toString() : value;
    }
    firstGuidAction() {
        if (this.params.basicType === 'Range') {
            this.params.key = this.helper.newGuid();
        }
        else {
            this.params.key = this.params.value = this.helper.newGuid();
        }
    }
    doubleDateTimeAction(event) {
        this.menuService.addMenu({
            type: 'doubleDatePickerMenu', name: 'doubleDatePickerMenu', items: [], parent: this.rangeFrom,
            params: this.params,
            state: ''
        });
        setTimeout(() => {
            this.menuService.showMenu('doubleDatePickerMenu');
        });
    }
    firstDateTimeAction(event) {
        this.menuService.addMenu({
            type: 'datePickerMenu', name: 'datePickerMenu', items: [], parent: this.firstDateTimeButton,
            params: this.params,
            state: ''
        });
        setTimeout(() => {
            this.menuService.showMenu('datePickerMenu');
        });
    }
    dropDownButtonAction(event) {
        let menuType = 'parameterMenuForValue';
        switch (this.params.basicType) {
            case 'Range':
                menuType = 'parameterMenuForRange';
                break;
            case 'List':
                menuType = this.params.allowUserValues ? 'parameterMenuForEditList' : 'parameterMenuForNotEditList';
                break;
        }
        if (this.params.items) {
            this.params.items.forEach(i => i.visible = true);
        }
        let this_ = this;
        this.menuService.addMenu({
            type: menuType, name: 'parameterMenu', items: [], parent: this.element,
            params: this.params,
            state: '',
            onCloseEvent: () => {
                this_.onCloseMenuEvent();
            }
        });
        setTimeout(() => {
            this.menuService.showMenu('parameterMenu');
        });
    }
    onCloseMenuEvent() {
        if (this.params.binding) {
            if (!this.model.options.paramsVariablesStartValues) {
                this.model.options.paramsVariablesStartValues = this.helper.copyObject(this.model.options.paramsVariables);
            }
            this.intearctionService.postInteraction({ action: 'InitVars', variables: this.intearctionService.getParametersValues(), isBindingVariable: true });
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ParameterComponent, deps: [{ token: i1.ModelService }, { token: i2.HelperService }, { token: i3.MenuService }, { token: i4.InteractionsService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: ParameterComponent, selector: "sti-parameter", inputs: { params: "params" }, viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }, { propertyName: "firstDateTimeButton", first: true, predicate: ["firstDateTimeButton"], descendants: true }, { propertyName: "doubleDateTimeButton", first: true, predicate: ["doubleDateTimeButton"], descendants: true }, { propertyName: "rangeFrom", first: true, predicate: ["rangeFrom"], descendants: true }], ngImport: i0, template: `
    <table #element class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" #rangeFrom>
       <tbody>
          <tr class="stiJsViewerClearAllStyles" >
            <td *ngIf="params.type == 'Bool' && (params.basicType == 'Value' || params.basicType == 'NullableValue')"
                [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
                <sti-parameter-checkbox [params]="params" [isEnabled]="params.allowUserValues" (action)="params.value = $event" [nullable]="params.basicType == 'NullableValue'">
                </sti-parameter-checkbox>
            </td>

            <td *ngIf="params.basicType == 'Range' && model.options.appearance.currentParametersPanelPosition === 'Top'"  [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
                {{model.loc('RangeFrom')}}
            </td>

            <td *ngIf="params.type != 'Bool' || params.basicType == 'List'"
                [style.position]="(params.basicType == 'NullableValue' || params.allowNullableString) && params.allowUserValues ? 'relative' : ''"
                [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
                <sti-parameter-text-box [variable]="params"
                    [readOnly]="getReadOnlyCheckbox()"
                    [value]="getFirstTextBoxValue()">
                </sti-parameter-text-box>
            </td>

            <td *ngIf="params.type == 'DateTime' && params.allowUserValues && params.basicType != 'List' && params.basicType != 'Range'"
                [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight" #firstDateTimeButton>
                <sti-parameter-button [buttonType]="'DateTimeButton'" [params]="params"  (action)="firstDateTimeAction($event)">
                </sti-parameter-button>
            </td>

            <td *ngIf="params.type == 'Guid' && params.allowUserValues && params.basicType != 'List'"
                [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
                <sti-parameter-button  [buttonType]="'GuidButton'" [params]="params" (action)="firstGuidAction()">
                </sti-parameter-button>
            </td>

            <td *ngIf="!showParameterInTwoRows && params.basicType == 'Range' && model.options.appearance.currentParametersPanelPosition === 'Top'" [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
              {{model.loc('RangeTo')}}
            </td>

            <!-- second -->
            <td *ngIf="!showParameterInTwoRows && params.basicType == 'Range'" [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-text-box [variable]="params"
                    [readOnly]="!params.allowUserValues"
                    [value]="helper.getStringKey(params.keyTo, params)"
                    [secondTextBox]="true">
              </sti-parameter-text-box>
            </td>

            <td *ngIf="!showParameterInTwoRows && params.basicType == 'Range' && params.type == 'DateTime' && params.allowUserValues" #doubleDateTimeButton
              [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button  [buttonType]="'DateTimeButton'" [params]="params" (action)="doubleDateTimeAction($event)">
              </sti-parameter-button>
            </td>

            <td *ngIf="!showParameterInTwoRows && params.basicType == 'Range' && params.type == 'Guid' && params.allowUserValues"
              [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button  [buttonType]="'GuidButton'" [params]="params" (action)="params.keyTo=helper.newGuid()">
              </sti-parameter-button>
            </td>

            <td *ngIf="!showParameterInTwoRows && params.items != null || (params.basicType == 'List' && params.allowUserValues)"
                [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button [buttonType]="'DropDownButton'" [params]="params" (action)="dropDownButtonAction($event)">
              </sti-parameter-button>
            </td>
          </tr>

          <!-- NEW LINE -->
          <tr *ngIf="showParameterInTwoRows">
            <td *ngIf="params.basicType == 'Range' && model.options.appearance.currentParametersPanelPosition === 'Top'" [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
              {{model.loc('RangeTo')}}
            </td>

            <!-- second -->
            <td *ngIf="params.basicType == 'Range'" [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-text-box [variable]="params"
                    [readOnly]="!params.allowUserValues"
                    [value]="helper.getStringKey(params.keyTo, params)"
                    [secondTextBox]="true">
              </sti-parameter-text-box>
            </td>

            <td *ngIf="params.basicType == 'Range' && params.type == 'DateTime' && params.allowUserValues" #doubleDateTimeButton
              [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button  [buttonType]="'DateTimeButton'" [params]="params" (action)="doubleDateTimeAction($event)">
              </sti-parameter-button>
            </td>

            <td *ngIf="params.basicType == 'Range' && params.type == 'Guid' && params.allowUserValues"
              [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button  [buttonType]="'GuidButton'" [params]="params" (action)="params.keyTo=helper.newGuid()">
              </sti-parameter-button>
            </td>

            <td *ngIf="params.items != null || (params.basicType == 'List' && params.allowUserValues)"
                [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button [buttonType]="'DropDownButton'" [params]="params" (action)="dropDownButtonAction($event)">
              </sti-parameter-button>
            </td>
          </tr>
       </tbody>
    </table>
  `, isInline: true, dependencies: [{ kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i6.ParameterTextBoxComponent, selector: "sti-parameter-text-box", inputs: ["item", "variable", "readOnly", "focusOnCreate", "isMenu", "value", "secondTextBox"] }, { kind: "component", type: i7.ParameterCheckboxComponent, selector: "sti-parameter-checkbox", inputs: ["params", "captionText", "margin", "width", "imageBlockParentWidth", "isEnabled", "isMenuParameter", "paramNull", "nullable"], outputs: ["action"] }, { kind: "component", type: i8.ParameterButtonComponent, selector: "sti-parameter-button", inputs: ["params", "buttonType"], outputs: ["action"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ParameterComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-parameter',
                    template: `
    <table #element class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" #rangeFrom>
       <tbody>
          <tr class="stiJsViewerClearAllStyles" >
            <td *ngIf="params.type == 'Bool' && (params.basicType == 'Value' || params.basicType == 'NullableValue')"
                [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
                <sti-parameter-checkbox [params]="params" [isEnabled]="params.allowUserValues" (action)="params.value = $event" [nullable]="params.basicType == 'NullableValue'">
                </sti-parameter-checkbox>
            </td>

            <td *ngIf="params.basicType == 'Range' && model.options.appearance.currentParametersPanelPosition === 'Top'"  [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
                {{model.loc('RangeFrom')}}
            </td>

            <td *ngIf="params.type != 'Bool' || params.basicType == 'List'"
                [style.position]="(params.basicType == 'NullableValue' || params.allowNullableString) && params.allowUserValues ? 'relative' : ''"
                [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
                <sti-parameter-text-box [variable]="params"
                    [readOnly]="getReadOnlyCheckbox()"
                    [value]="getFirstTextBoxValue()">
                </sti-parameter-text-box>
            </td>

            <td *ngIf="params.type == 'DateTime' && params.allowUserValues && params.basicType != 'List' && params.basicType != 'Range'"
                [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight" #firstDateTimeButton>
                <sti-parameter-button [buttonType]="'DateTimeButton'" [params]="params"  (action)="firstDateTimeAction($event)">
                </sti-parameter-button>
            </td>

            <td *ngIf="params.type == 'Guid' && params.allowUserValues && params.basicType != 'List'"
                [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
                <sti-parameter-button  [buttonType]="'GuidButton'" [params]="params" (action)="firstGuidAction()">
                </sti-parameter-button>
            </td>

            <td *ngIf="!showParameterInTwoRows && params.basicType == 'Range' && model.options.appearance.currentParametersPanelPosition === 'Top'" [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
              {{model.loc('RangeTo')}}
            </td>

            <!-- second -->
            <td *ngIf="!showParameterInTwoRows && params.basicType == 'Range'" [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-text-box [variable]="params"
                    [readOnly]="!params.allowUserValues"
                    [value]="helper.getStringKey(params.keyTo, params)"
                    [secondTextBox]="true">
              </sti-parameter-text-box>
            </td>

            <td *ngIf="!showParameterInTwoRows && params.basicType == 'Range' && params.type == 'DateTime' && params.allowUserValues" #doubleDateTimeButton
              [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button  [buttonType]="'DateTimeButton'" [params]="params" (action)="doubleDateTimeAction($event)">
              </sti-parameter-button>
            </td>

            <td *ngIf="!showParameterInTwoRows && params.basicType == 'Range' && params.type == 'Guid' && params.allowUserValues"
              [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button  [buttonType]="'GuidButton'" [params]="params" (action)="params.keyTo=helper.newGuid()">
              </sti-parameter-button>
            </td>

            <td *ngIf="!showParameterInTwoRows && params.items != null || (params.basicType == 'List' && params.allowUserValues)"
                [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button [buttonType]="'DropDownButton'" [params]="params" (action)="dropDownButtonAction($event)">
              </sti-parameter-button>
            </td>
          </tr>

          <!-- NEW LINE -->
          <tr *ngIf="showParameterInTwoRows">
            <td *ngIf="params.basicType == 'Range' && model.options.appearance.currentParametersPanelPosition === 'Top'" [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
              {{model.loc('RangeTo')}}
            </td>

            <!-- second -->
            <td *ngIf="params.basicType == 'Range'" [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-text-box [variable]="params"
                    [readOnly]="!params.allowUserValues"
                    [value]="helper.getStringKey(params.keyTo, params)"
                    [secondTextBox]="true">
              </sti-parameter-text-box>
            </td>

            <td *ngIf="params.basicType == 'Range' && params.type == 'DateTime' && params.allowUserValues" #doubleDateTimeButton
              [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button  [buttonType]="'DateTimeButton'" [params]="params" (action)="doubleDateTimeAction($event)">
              </sti-parameter-button>
            </td>

            <td *ngIf="params.basicType == 'Range' && params.type == 'Guid' && params.allowUserValues"
              [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button  [buttonType]="'GuidButton'" [params]="params" (action)="params.keyTo=helper.newGuid()">
              </sti-parameter-button>
            </td>

            <td *ngIf="params.items != null || (params.basicType == 'List' && params.allowUserValues)"
                [style.padding]="'0 2px 0 2px'" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button [buttonType]="'DropDownButton'" [params]="params" (action)="dropDownButtonAction($event)">
              </sti-parameter-button>
            </td>
          </tr>
       </tbody>
    </table>
  `
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.HelperService }, { type: i3.MenuService }, { type: i4.InteractionsService }], propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }], firstDateTimeButton: [{
                type: ViewChild,
                args: ['firstDateTimeButton']
            }], doubleDateTimeButton: [{
                type: ViewChild,
                args: ['doubleDateTimeButton']
            }], rangeFrom: [{
                type: ViewChild,
                args: ['rangeFrom']
            }], params: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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