import { Component, Input, ViewChild, Output, EventEmitter } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../menu/menu.service";
import * as i3 from "../services/tooltip.service";
import * as i4 from "../services/helper.service";
import * as i5 from "@angular/common";
export class ButtonComponent {
    constructor(model, menuService, tooltipService, helper) {
        this.model = model;
        this.menuService = menuService;
        this.tooltipService = tooltipService;
        this.helper = helper;
        this.margin = '1px';
        this.height = '23px';
        this.selected = false;
        this.imageCellTextAlign = 'center';
        this.imageSizesWidth = 16;
        this.imageSizesHeight = 16;
        this.closeButton = false;
        this.resourceButton = false;
        this.navagationPanelTooltip = false;
        this.helpLink = 'user-manual/index.html?viewer_reports.htm';
        this.action = new EventEmitter();
        this.closeButtonAction = new EventEmitter();
        this.over = false;
        this.showMenu = false;
        this.closeButtonPressed = false;
        this.resourceButtonPressed = false;
        this._enabled = true;
        this.canShowTooltip = true;
    }
    ngOnInit() {
        if (this.menuItems) {
            setTimeout(() => {
                this.menuObj = { type: 'buttonMenu', name: this.actionName, items: this.menuItems, parent: !this.resourceButton ? this.button : this.resButtonEl, state: '' };
                this.menuService.addMenu(this.menuObj);
            }, 500);
        }
    }
    get styleName() {
        return this._styleName || 'stiJsViewerStandartSmallButton';
    }
    set styleName(value) {
        this._styleName = value;
    }
    get enabled() {
        return this._enabled;
    }
    set enabled(value) {
        if (!value) {
            this.over = false;
        }
        this._enabled = value;
    }
    mouseover() {
        if (!this.enabled) {
            return;
        }
        this.over = true;
        if (this.model.options.toolbar.showMenuMode === 'Hover' && ['Print', 'Save', 'SendEmail', 'Zoom', 'ViewMode'].some(a => a === this.actionName)) {
            this.tooltipService.hideImmediately();
            this.menuService.showMenu(this.actionName);
        }
        else if (this.tooltip && !this.menuService.menus.some(e => e.state === 'expanded') && this.canShowTooltip) {
            const top = !this.navagationPanelTooltip ? this.model.controls.toolbar.offsetHeight + this.model.controls.dashboardsPanel.offsetHeight :
                this.helper.findPosY(this.model.controls.navigatePanel.el.nativeElement, 'stiJsViewerMainPanel');
            const tooltip = this.tooltip === true ? (this.model.localization[this.actionName + 'ToolTip'] != null ? this.model.loc(this.actionName + 'ToolTip') : this.model.loc(this.actionName)) : this.tooltip;
            this.tooltipService.show(this.helper.findPosX(this.button.nativeElement, 'stiJsViewerMainPanel'), top, tooltip, !this.navagationPanelTooltip, this.helpLink);
        }
    }
    mouseout() {
        if (!this.enabled) {
            return;
        }
        this.over = false;
        this.tooltipService.hide();
        setTimeout(() => {
            this.canShowTooltip = true;
        }, 1000);
    }
    click() {
        if (this.enabled && !this.closeButtonPressed) {
            this.tooltipService.hideImmediately();
            if (this.menuItems == null || (this.resourceButton && !this.resourceButtonPressed)) {
                this.action.emit();
            }
            else {
                this.menuService.showMenu(this.actionName);
            }
        }
        this.canShowTooltip = false;
        this.closeButtonPressed = false;
        this.resourceButtonPressed = false;
    }
    get className() {
        return this.styleName ? this.styleName + ' ' + (this.enabled ? (this.styleName + ((this.selected || this.menuObj?.state === 'expanded') ? 'Selected' : (this.over ? 'Over' : 'Default'))) : this.styleName + 'Disabled') : '';
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ButtonComponent, deps: [{ token: i1.ModelService }, { token: i2.MenuService }, { token: i3.TooltipService }, { token: i4.HelperService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: ButtonComponent, selector: "sti-button", inputs: { caption: "caption", caption2: "caption2", captionAlign: "captionAlign", captionPadding: "captionPadding", captionPaddingLeft: "captionPaddingLeft", captionWhiteSpace: "captionWhiteSpace", captionOverflow: "captionOverflow", captionTextOverflow: "captionTextOverflow", captionWidth: "captionWidth", captionMaxWidth: "captionMaxWidth", captionLineHeight: "captionLineHeight", imageName: "imageName", arrow: "arrow", arrowMarginTop: "arrowMarginTop", margin: "margin", height: "height", selected: "selected", minWidth: "minWidth", innerTableWidth: "innerTableWidth", menuItems: "menuItems", actionName: "actionName", tooltip: "tooltip", imageCellTextAlign: "imageCellTextAlign", imageCellWidth: "imageCellWidth", imageCellPadding: "imageCellPadding", imageSizesWidth: "imageSizesWidth", imageSizesHeight: "imageSizesHeight", imageMargin: "imageMargin", width: "width", display: "display", closeButton: "closeButton", resourceButton: "resourceButton", styleColors: "styleColors", boxSizing: "boxSizing", navagationPanelTooltip: "navagationPanelTooltip", cursor: "cursor", fontSize: "fontSize", helpLink: "helpLink", borderColor: "borderColor", styleName: "styleName", enabled: "enabled" }, outputs: { action: "action", closeButtonAction: "closeButtonAction" }, viewQueries: [{ propertyName: "button", first: true, predicate: ["button"], descendants: true }, { propertyName: "resButtonEl", first: true, predicate: ["resButtonEl"], descendants: true }], ngImport: i0, template: `
  <div #button
    [style.fontFamily]="model.options.toolbar.fontFamily"
    [style.cursor]="cursor"
    [style.borderColor]="borderColor"
    [class]="className"
    [style.height]="helper.val(height, '23px')"
    [style.boxSizing]="helper.val(boxSizing, 'content-box')"
    [style.margin]="helper.val(margin, '1px')"
    [style.minWidth]="minWidth"
    [style.width]="width"
    [style.display]="display"
    [style.fontSize]="fontSize"
    (mouseover)="mouseover()"
    (mouseout)="mouseout()"
    (click)="click()" >
    <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.height]="'100%'" [style.width]="innerTableWidth">
      <tbody>
        <tr class="stiJsViewerClearAllStyles">
          <td *ngIf="imageName != null" [style.lineHeight]="0" [style.padding]="helper.val(imageCellPadding, '0 3px')" [style.textAlign]="imageCellTextAlign"
          [style.width]="imageCellWidth" class="stiJsViewerClearAllStyles">
            <img src="{{model.img(imageName)}}"
                [style.opacity]="enabled ? '1' : '0.5'"
                [style.width.px]="imageSizesWidth"
                [style.height.px]="imageSizesHeight"
                [style.margin]="imageMargin">
          </td>
          <td *ngIf="caption != null"
             [style.whiteSpace]="'nowrap'"
             [style.textAlign]="captionAlign || 'left'"
             [style.padding]="captionPadding || ((arrow ? '1px 0' : '1px 5px') + (imageName ? ' 0 0' : ' 0 5px'))"
             [style.width]="captionWidth"
             [style.maxWidth]="captionMaxWidth"
             [style.lineHeight]="captionLineHeight"
             [style.paddingLeft]="captionPaddingLeft"
             [style.whiteSpace]="captionWhiteSpace"
             [style.overflow]="captionOverflow"
             [style.textOverflow]="captionTextOverflow"
             class="stiJsViewerClearAllStyles">
            {{caption}}
            <div *ngIf="caption2 != null">
            {{caption2}}
            </div>
          </td>
          <td *ngIf="arrow" class="stiJsViewerClearAllStyles">
            <img src="{{arrow == 'Up' || arrow == 'Down' ? model.img('Arrows.SmallArrow' + arrow + (arrow == 'Down' && styleColors && styleColors.isDarkStyle ? 'White.png' : '.png')) : model.img(arrow)}}"
            [style]="{lineHeight:'0', width:'8px', height:'8px', verticalAlign:'baseline', padding:caption ? '0 5px 0 5px' : '0 5px 0 2px', marginTop: arrowMarginTop}"
            [style.opacity]="enabled ? '1' : '0.5'"/>
          </td>

          <td *ngIf="closeButton" class="stiJsViewerClearAllStyles">
            <sti-button [imageName]="'CloseForm.png'"
              [imageMargin]="'1px 0 0 -1px'"
              [margin]="'0 2px 0 0'"
              [imageCellPadding]="'0'"
              [width]="model.options.isTouchDevice ? '22px' : '17px'"
              [height]="model.options.isTouchDevice ? '22px' : '17px'"
              (action)="closeButtonPressed = true; closeButtonAction.emit()">
            </sti-button>
          </td>

          <td #resButtonEl *ngIf="resourceButton" [style.width.px]="1">
            <sti-button [imageName]="'Arrows.SmallArrowDown.png'"
              [styleName]="'stiJsViewerResourceDropDownButton'"
              [innerTableWidth]="'100%'"
              [margin]="'0 7px 0 3px'"
              [imageCellTextAlign]="'center'"
              [imageSizesWidth]="8"
              [imageSizesHeight]="8"
              [height]="model.options.isTouchDevice ? '23px' : '17px'"
              [width]="model.options.isTouchDevice ? '23px' : '17px'"
              (action)="resourceButtonPressed = true;">>
            </sti-button>
          </td>

        </tr>
      </tbody>
    </table>
  </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ButtonComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-button',
                    template: `
  <div #button
    [style.fontFamily]="model.options.toolbar.fontFamily"
    [style.cursor]="cursor"
    [style.borderColor]="borderColor"
    [class]="className"
    [style.height]="helper.val(height, '23px')"
    [style.boxSizing]="helper.val(boxSizing, 'content-box')"
    [style.margin]="helper.val(margin, '1px')"
    [style.minWidth]="minWidth"
    [style.width]="width"
    [style.display]="display"
    [style.fontSize]="fontSize"
    (mouseover)="mouseover()"
    (mouseout)="mouseout()"
    (click)="click()" >
    <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.height]="'100%'" [style.width]="innerTableWidth">
      <tbody>
        <tr class="stiJsViewerClearAllStyles">
          <td *ngIf="imageName != null" [style.lineHeight]="0" [style.padding]="helper.val(imageCellPadding, '0 3px')" [style.textAlign]="imageCellTextAlign"
          [style.width]="imageCellWidth" class="stiJsViewerClearAllStyles">
            <img src="{{model.img(imageName)}}"
                [style.opacity]="enabled ? '1' : '0.5'"
                [style.width.px]="imageSizesWidth"
                [style.height.px]="imageSizesHeight"
                [style.margin]="imageMargin">
          </td>
          <td *ngIf="caption != null"
             [style.whiteSpace]="'nowrap'"
             [style.textAlign]="captionAlign || 'left'"
             [style.padding]="captionPadding || ((arrow ? '1px 0' : '1px 5px') + (imageName ? ' 0 0' : ' 0 5px'))"
             [style.width]="captionWidth"
             [style.maxWidth]="captionMaxWidth"
             [style.lineHeight]="captionLineHeight"
             [style.paddingLeft]="captionPaddingLeft"
             [style.whiteSpace]="captionWhiteSpace"
             [style.overflow]="captionOverflow"
             [style.textOverflow]="captionTextOverflow"
             class="stiJsViewerClearAllStyles">
            {{caption}}
            <div *ngIf="caption2 != null">
            {{caption2}}
            </div>
          </td>
          <td *ngIf="arrow" class="stiJsViewerClearAllStyles">
            <img src="{{arrow == 'Up' || arrow == 'Down' ? model.img('Arrows.SmallArrow' + arrow + (arrow == 'Down' && styleColors && styleColors.isDarkStyle ? 'White.png' : '.png')) : model.img(arrow)}}"
            [style]="{lineHeight:'0', width:'8px', height:'8px', verticalAlign:'baseline', padding:caption ? '0 5px 0 5px' : '0 5px 0 2px', marginTop: arrowMarginTop}"
            [style.opacity]="enabled ? '1' : '0.5'"/>
          </td>

          <td *ngIf="closeButton" class="stiJsViewerClearAllStyles">
            <sti-button [imageName]="'CloseForm.png'"
              [imageMargin]="'1px 0 0 -1px'"
              [margin]="'0 2px 0 0'"
              [imageCellPadding]="'0'"
              [width]="model.options.isTouchDevice ? '22px' : '17px'"
              [height]="model.options.isTouchDevice ? '22px' : '17px'"
              (action)="closeButtonPressed = true; closeButtonAction.emit()">
            </sti-button>
          </td>

          <td #resButtonEl *ngIf="resourceButton" [style.width.px]="1">
            <sti-button [imageName]="'Arrows.SmallArrowDown.png'"
              [styleName]="'stiJsViewerResourceDropDownButton'"
              [innerTableWidth]="'100%'"
              [margin]="'0 7px 0 3px'"
              [imageCellTextAlign]="'center'"
              [imageSizesWidth]="8"
              [imageSizesHeight]="8"
              [height]="model.options.isTouchDevice ? '23px' : '17px'"
              [width]="model.options.isTouchDevice ? '23px' : '17px'"
              (action)="resourceButtonPressed = true;">>
            </sti-button>
          </td>

        </tr>
      </tbody>
    </table>
  </div>
  `
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.MenuService }, { type: i3.TooltipService }, { type: i4.HelperService }], propDecorators: { caption: [{
                type: Input
            }], caption2: [{
                type: Input
            }], captionAlign: [{
                type: Input
            }], captionPadding: [{
                type: Input
            }], captionPaddingLeft: [{
                type: Input
            }], captionWhiteSpace: [{
                type: Input
            }], captionOverflow: [{
                type: Input
            }], captionTextOverflow: [{
                type: Input
            }], captionWidth: [{
                type: Input
            }], captionMaxWidth: [{
                type: Input
            }], captionLineHeight: [{
                type: Input
            }], imageName: [{
                type: Input
            }], arrow: [{
                type: Input
            }], arrowMarginTop: [{
                type: Input
            }], margin: [{
                type: Input
            }], height: [{
                type: Input
            }], selected: [{
                type: Input
            }], minWidth: [{
                type: Input
            }], innerTableWidth: [{
                type: Input
            }], menuItems: [{
                type: Input
            }], actionName: [{
                type: Input
            }], tooltip: [{
                type: Input
            }], imageCellTextAlign: [{
                type: Input
            }], imageCellWidth: [{
                type: Input
            }], imageCellPadding: [{
                type: Input
            }], imageSizesWidth: [{
                type: Input
            }], imageSizesHeight: [{
                type: Input
            }], imageMargin: [{
                type: Input
            }], width: [{
                type: Input
            }], display: [{
                type: Input
            }], closeButton: [{
                type: Input
            }], resourceButton: [{
                type: Input
            }], styleColors: [{
                type: Input
            }], boxSizing: [{
                type: Input
            }], navagationPanelTooltip: [{
                type: Input
            }], cursor: [{
                type: Input
            }], fontSize: [{
                type: Input
            }], helpLink: [{
                type: Input
            }], borderColor: [{
                type: Input
            }], action: [{
                type: Output
            }], closeButtonAction: [{
                type: Output
            }], button: [{
                type: ViewChild,
                args: ['button']
            }], resButtonEl: [{
                type: ViewChild,
                args: ['resButtonEl']
            }], styleName: [{
                type: Input
            }], enabled: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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