import { Component, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/find.service";
import * as i3 from "../services/controller.service";
import * as i4 from "@angular/common";
import * as i5 from "../controls/button.component";
import * as i6 from "../controls/text-box.componet";
import * as i7 from "../controls/text-block.component";
export class FindPanelComponent {
    constructor(model, findService, controller) {
        this.model = model;
        this.findService = findService;
        this.controller = controller;
        this.changeFind = false;
        this.initItems();
        controller.getMessage().subscribe((message) => {
            switch (message.action) {
                case 'GetReport':
                case 'GetPages':
                case 'OpenReport':
                case 'Variables':
                    if (model.controls.findPanel.visible) {
                        setTimeout(() => {
                            this.findService.hideFindLabels();
                            this.find('Next');
                        });
                    }
                    break;
            }
        });
    }
    ngAfterViewInit() {
        this.model.controls.findPanel.el = this.element;
        this.model.controls.findPanel.getVisibility().subscribe(() => {
            if (this.model.controls.findPanel.visible) {
                this.findService.text = '';
                setTimeout(() => {
                    this.textBox.element.nativeElement.focus();
                });
            }
        });
    }
    ngOnInit() { }
    selected(item) {
        switch (item.action) {
            case 'MatchCase':
                return this.findService.matchCase;
            case 'MatchWholeWord':
                return this.findService.matchWholeWord;
        }
        return false;
    }
    textBoxAction(target) {
        this.findService.text = target.value;
        this.find('Next');
    }
    find(direction) {
        if (this.findService.text === '') {
            this.findService.hideFindLabels();
            return;
        }
        if (this.findService.lastFindText !== this.findService.text || this.changeFind) {
            this.changeFind = false;
            this.findService.showFindLabels();
        }
        else {
            this.findService.selectFindLabel(direction);
        }
    }
    initItems() {
        this.items = [
            { type: 'button', action: 'close', img: 'CloseForm.png', margin: '2px' },
            { type: 'textBlock', action: 'text', caption: this.model.loc('FindWhat').replace(":", ""), margin: '2px' },
            { type: 'textBox', action: 'findTextBox', margin: '2px' },
            { type: 'button', action: 'FindPreviows', caption: this.model.loc('FindPrevious'), img: 'Arrows.ArrowUpBlue.png', margin: '2px' },
            { type: 'button', action: 'FindNext', caption: this.model.loc('FindNext'), img: 'Arrows.ArrowDownBlue.png', margin: '2px' },
            { type: 'button', action: 'MatchCase', caption: this.model.loc('MatchCase').replace('&', ''), margin: '2px' },
            { type: 'button', action: 'MatchWholeWord', caption: this.model.loc('MatchWholeWord').replace('&', ''), margin: '2px' }
        ];
    }
    action(action) {
        switch (action) {
            case 'close':
                this.model.controls.findPanel.visible = false;
                break;
            case 'MatchCase':
                this.findService.matchCase = !this.findService.matchCase;
                this.changeFind = true;
                break;
            case 'MatchWholeWord':
                this.findService.matchWholeWord = !this.findService.matchWholeWord;
                this.changeFind = true;
                break;
            case 'FindPreviows':
                this.findService.text = this.textBox.element.nativeElement.value;
                this.find('Previous');
                break;
            case 'FindNext':
                this.findService.text = this.textBox.element.nativeElement.value;
                this.find('Next');
                break;
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: FindPanelComponent, deps: [{ token: i1.ModelService }, { token: i2.FindService }, { token: i3.ControllerService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: FindPanelComponent, selector: "sti-find-panel", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }, { propertyName: "textBox", first: true, predicate: ["textBox"], descendants: true }], ngImport: i0, template: `
    <div #element [style.display]="model.controls.findPanel.visible ? '' : 'none'"
    [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerToolBarSeparated' : '')">
      <div [style.paddingTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''">
        <div class="stiJsViewerToolBarTable" [style.border]="model.options.toolbar.displayMode == 'Separated' ? '0px' : ''" [style.boxSizing]="'border-box'">
          <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.margin.px]="0">
            <tbody>
                <tr class="stiJsViewerClearAllStyles">
                   <td *ngFor="let item of items"  class="stiJsViewerClearAllStyles">
                      <sti-button *ngIf="item.type=='button'"
                        [actionName]="item.action"
                        [imageName]="item.img"
                        [caption]="item.caption"
                        [margin]="item.margin"
                        [height]="model.options.toolbar.displayMode == 'Separated' ? '28px' : ''"
                        (action)="action(item.action)"
                        [selected]="selected(item)"
                        ></sti-button>
                      <sti-text-box #textBox *ngIf="item.type=='textBox'" [width]="170"
                        [margin]="item.margin"
                        [focusOnCreate]="true"
                        (action)="textBoxAction($event)"
                        [value]="findService.text"></sti-text-box>
                      <sti-text-block *ngIf="item.type=='textBlock'" [margin]="item.margin" [text]="item.caption"></sti-text-block>
                  </td>
                </tr>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i5.ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }, { kind: "component", type: i6.TextBoxComponent, selector: "sti-text-box", inputs: ["width", "actionLostFocus", "tooltip", "enabled", "value", "margin", "focusOnCreate", "maxLength", "color", "type", "padding", "border", "variable", "textAlign", "autocomplete", "readOnly"], outputs: ["action", "onchange", "onblur"] }, { kind: "component", type: i7.TextBlockComponent, selector: "sti-text-block", inputs: ["text", "margin"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: FindPanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-find-panel',
                    template: `
    <div #element [style.display]="model.controls.findPanel.visible ? '' : 'none'"
    [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerToolBarSeparated' : '')">
      <div [style.paddingTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''">
        <div class="stiJsViewerToolBarTable" [style.border]="model.options.toolbar.displayMode == 'Separated' ? '0px' : ''" [style.boxSizing]="'border-box'">
          <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.margin.px]="0">
            <tbody>
                <tr class="stiJsViewerClearAllStyles">
                   <td *ngFor="let item of items"  class="stiJsViewerClearAllStyles">
                      <sti-button *ngIf="item.type=='button'"
                        [actionName]="item.action"
                        [imageName]="item.img"
                        [caption]="item.caption"
                        [margin]="item.margin"
                        [height]="model.options.toolbar.displayMode == 'Separated' ? '28px' : ''"
                        (action)="action(item.action)"
                        [selected]="selected(item)"
                        ></sti-button>
                      <sti-text-box #textBox *ngIf="item.type=='textBox'" [width]="170"
                        [margin]="item.margin"
                        [focusOnCreate]="true"
                        (action)="textBoxAction($event)"
                        [value]="findService.text"></sti-text-box>
                      <sti-text-block *ngIf="item.type=='textBlock'" [margin]="item.margin" [text]="item.caption"></sti-text-block>
                  </td>
                </tr>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  `
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.FindService }, { type: i3.ControllerService }], propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }], textBox: [{
                type: ViewChild,
                args: ['textBox']
            }] } });
//# sourceMappingURL=data:application/json;base64,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