import { Component, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/drill-down.service";
import * as i3 from "../services/controller.service";
import * as i4 from "@angular/common";
import * as i5 from "../controls/button.component";
export class DrillDownPanelComponent {
    constructor(model, drillDownService, controller) {
        this.model = model;
        this.drillDownService = drillDownService;
        this.controller = controller;
        controller.getMessage().subscribe((message) => {
            if (message?.action === 'DrillDown' && this.element) {
                this.element.nativeElement.scrollTop = 0;
            }
        });
    }
    ngOnInit() { }
    ngAfterViewInit() {
        this.model.controls.drillDownPanel.el = this.element;
    }
    action(button) {
        this.drillDownService.saveState();
        this.model.drillDownButtons.forEach(b => b.selected = false);
        button.selected = true;
        this.model.setReportParams(button.reportParams);
        this.element.nativeElement.scrollTop = 0;
        this.controller.getPages();
    }
    close(button) {
        this.model.drillDownButtons.splice(this.model.drillDownButtons.indexOf(button), 1);
        button.visible = false;
        if (button.selected) {
            this.action(this.model.drillDownButtons[0]);
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: DrillDownPanelComponent, deps: [{ token: i1.ModelService }, { token: i2.DrillDownService }, { token: i3.ControllerService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: DrillDownPanelComponent, selector: "sti-drill-down-panel", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
  <div #element [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerToolBarSeparated' : '')"
    [style.display]="model.controls.drillDownPanel.visible ? '' : 'none'">
    <div [style.paddingTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''">
      <table class="stiJsViewerToolBarTable" cellpadding="0" cellspacing="0" [style.margin.px]="0" [style.boxSizing]="'border-box'"
        [style.border]="model.options.toolbar.displayMode == 'Separated' ? '0px' : ''"
        [style.color]="model.options.toolbar.fontColor"
        [style.fontFamily]="model.options.toolbar.fontFamily">
        <tbody>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles">
              <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
                <tbody>
                  <tr class="stiJsViewerClearAllStyles">
                    <td *ngFor="let button of model.drillDownButtons; index as i" class="stiJsViewerClearAllStyles" [style.padding.px]="0" [style.border.px]="0" [style.lineHeight]="0">
                      <sti-button [display]="button.visible ? 'inline-block': 'none'"
                        [margin]="'2px 1px 2px 2px'"
                        [caption]="button.caption"
                        [height]="model.options.toolbar.displayMode == 'Separated' ? '28px' : null"
                        [display]="'inline-block'"
                        [selected]="button.selected"
                        [closeButton]="i > 0"
                        (action)="action(button)"
                        (closeButtonAction)="close(button)">
                      </sti-button>
                    </td>
                  </tr>
                </tbody>
              </table>
            </td>
          </tr>
        </tbody>
      </table>
    </div>
  </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "component", type: i5.ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: DrillDownPanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-drill-down-panel',
                    template: `
  <div #element [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerToolBarSeparated' : '')"
    [style.display]="model.controls.drillDownPanel.visible ? '' : 'none'">
    <div [style.paddingTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''">
      <table class="stiJsViewerToolBarTable" cellpadding="0" cellspacing="0" [style.margin.px]="0" [style.boxSizing]="'border-box'"
        [style.border]="model.options.toolbar.displayMode == 'Separated' ? '0px' : ''"
        [style.color]="model.options.toolbar.fontColor"
        [style.fontFamily]="model.options.toolbar.fontFamily">
        <tbody>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles">
              <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
                <tbody>
                  <tr class="stiJsViewerClearAllStyles">
                    <td *ngFor="let button of model.drillDownButtons; index as i" class="stiJsViewerClearAllStyles" [style.padding.px]="0" [style.border.px]="0" [style.lineHeight]="0">
                      <sti-button [display]="button.visible ? 'inline-block': 'none'"
                        [margin]="'2px 1px 2px 2px'"
                        [caption]="button.caption"
                        [height]="model.options.toolbar.displayMode == 'Separated' ? '28px' : null"
                        [display]="'inline-block'"
                        [selected]="button.selected"
                        [closeButton]="i > 0"
                        (action)="action(button)"
                        (closeButtonAction)="close(button)">
                      </sti-button>
                    </td>
                  </tr>
                </tbody>
              </table>
            </td>
          </tr>
        </tbody>
      </table>
    </div>
  </div>
  `
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.DrillDownService }, { type: i3.ControllerService }], propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });
//# sourceMappingURL=data:application/json;base64,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