import { DayOfWeek } from "./enums";
import { TimeSpan } from "./TimeSpan";
export declare class DateTime {
    private static ticksPerMillisecond;
    private static ticksPerSecond;
    private static ticksPerMinute;
    private static ticksPerHour;
    private static ticksPerDay;
    private static millisPerSecond;
    private static millisPerMinute;
    private static millisPerHour;
    private static millisPerDay;
    private static daysPerYear;
    private static daysPer4Years;
    private static daysPer100Years;
    private static daysPer400Years;
    private static daysTo1601;
    private static daysTo1899;
    private static daysTo10000;
    private static minTicks;
    private static maxTicks;
    private static maxMillis;
    private static fileTimeOffset;
    private static doubleDateOffset;
    private static oADateMinAsTicks;
    private static oADateMinAsDouble;
    private static oADateMaxAsDouble;
    private static datePartYear;
    private static datePartDayOfYear;
    private static datePartMonth;
    private static DatePartDay;
    private static daysToMonth365;
    private static daysToMonth366;
    static minValue: DateTime;
    static maxValue: DateTime;
    static getNetTypeName(): string;
    DateTimeOffset: string;
    private innerDate;
    get year(): number;
    get month(): number;
    get day(): number;
    /** 0 – Sunday, 1 – Monday etc */
    get dayOfWeek(): DayOfWeek;
    get hour(): number;
    get minute(): number;
    get second(): number;
    get millisecond(): number;
    get ticks(): number;
    get dayOfYear(): number;
    static now(): DateTime;
    static today(): DateTime;
    static isLeapYear(year: number): boolean;
    /** The month number ranging from 1 to 12. JS calculate month from 0. This will even work for December. */
    static daysInMonth(year: number, month: number): number;
    static compare(t1: DateTime, t2: DateTime): number;
    private static doubleDateToTicks;
    toString(format?: string): string;
    static ticksNetToTicksJs(ticks: number): number;
    negate(): DateTime;
    addYears(value: number): DateTime;
    addMonths(value: number): DateTime;
    addHours(value: number): DateTime;
    addMinutes(value: number): DateTime;
    addSeconds(value: number): DateTime;
    addMilliseconds(value: number): DateTime;
    addTicks(value: number): DateTime;
    compareTo(value: DateTime): number;
    subtract(value: DateTime): TimeSpan;
    get date(): Date;
    static oaDateToTicks0(oaDate: number): number;
    static ticksToOADate0(ticks: number): number;
    toOADate(): number;
    toOADate2(round: boolean): number;
    toNetJsonString(): string;
    static fromNetJsonString(jsonDate: string): DateTime;
    static fromOADate(oadate: number): DateTime;
    static fromString(d?: string, logError?: boolean): DateTime;
    get timeOfDay(): TimeSpan;
    get date2(): DateTime;
    constructor(param1: Date | number, month?: number, day?: number, hour?: number, minute?: number, second?: number, millisecond?: number);
}
