import StiPadding from "../../properties/StiPadding";
import { StiDisplayCurrencyAs, StiThousandSeparator, StiUnitAlignment } from "../../system/enums";
import { StiChangesInterceptor, StiFormattedElement, StiSetProperty } from "../../system/interfaces";
import StiJson from "../../system/StiJson";
import { StiForm } from "../StiForm";
import { StiDescriptionSettings } from "./StiDescriptionSettings";
import { StiInnerTextSettings } from "./StiInnerTextSettings";
import { StiLabelSettings } from "./StiLabelSettings";
export declare class StiFormSettings implements StiChangesInterceptor, StiFormattedElement {
    form: StiForm;
    private _label;
    private _description;
    private _innerText;
    private _dateTimeFormat;
    private _dateFomat;
    private _timeFormat;
    private _currency;
    private _currencyFormat;
    private _unitAlignment;
    private _thousandSeparator;
    private _decimalDigits;
    private _padding;
    private _gridColumns;
    private _gridVerticalStep;
    private _culture;
    constructor(form: StiForm);
    getCulture(): string;
    set culture(value: string);
    get culture(): string;
    get reportImage(): string;
    set reportImage(value: string);
    get formName(): string;
    set formName(value: string);
    get gridColumns(): number;
    set gridColumns(value: number);
    get gridVerticalStep(): number;
    set gridVerticalStep(value: number);
    get padding(): StiPadding;
    set padding(value: StiPadding);
    get label(): StiLabelSettings;
    set label(value: StiLabelSettings);
    get description(): StiDescriptionSettings;
    set description(value: StiDescriptionSettings);
    get innerText(): StiInnerTextSettings;
    set innerText(value: StiInnerTextSettings);
    get dateTimeFormat(): string;
    set dateTimeFormat(value: string);
    get dateFormat(): string;
    set dateFormat(value: string);
    get timeFormat(): string;
    set timeFormat(value: string);
    get currency(): string;
    set currency(value: string);
    get currencyFormat(): StiDisplayCurrencyAs;
    set currencyFormat(value: StiDisplayCurrencyAs);
    get unitAlignment(): StiUnitAlignment;
    set unitAlignment(value: StiUnitAlignment);
    get thousandSeparator(): StiThousandSeparator;
    set thousandSeparator(value: StiThousandSeparator);
    get decimalDigits(): number;
    set decimalDigits(value: number);
    propertyChanged(propName: string, value: any, oldObject: any): void;
    saveToJsonObject(options: any): StiJson;
    loadFormJsonString(text: string): void;
    loadFromJsonObject(json: StiJson): void;
    applySettings(element: StiSetProperty): void;
}
