import { StiUsedFontsList } from "../services/objects";
import Color from "../system/Color";
import { StiLineWeight } from "../system/enums";
import { Font } from "../system/Font";
import { StiLabel, StiDescription, StiOptionsElement, StiHtmlStyle, StiValueElement, StiEditableContent, StiTabIndex } from "../system/interfaces";
import StiJson from "../system/StiJson";
import { StiFormElement } from "./base/StiFormElement";
import { StiTextItem } from "./text/StiTextItem";
export declare class StiListBoxElement extends StiFormElement implements StiLabel, StiDescription, StiOptionsElement, StiHtmlStyle, StiValueElement, StiTabIndex {
    type: string;
    tooltip: string;
    required: boolean;
    description: StiTextItem;
    font: Font;
    backgroundColor: Color;
    textColor: Color;
    borderColor: Color;
    borderWeight: StiLineWeight;
    allowMultiselection: boolean;
    options: string[];
    selectedOptions: string[];
    tabIndex: number;
    setDefaultValues(): void;
    constructor();
    setTabIndex(value: number): number;
    getUsedFonts(usedFonts: StiUsedFontsList): void;
    htmlStyle(): string;
    getDefaultEditableContent(): StiEditableContent;
    get value(): any;
    saveToJsonObject(options: any): StiJson;
    loadFromJsonObject(json: StiJson): void;
}
