import { StiUsedFontsList } from "../services/objects";
import Color from "../system/Color";
import { HatchStyle, StiBarcodeType, StiBodyBrush, StiQRCodeBodyShapeType, StiQRCodeErrorCorrectionLevel, StiQRCodeEyeBallShapeType, StiQRCodeEyeFrameShapeType, StiQRCodeSize } from "../system/enums";
import { StiLabel, StiDescription, StiChangesInterceptor } from "../system/interfaces";
import StiJson from "../system/StiJson";
import { StiFormElement } from "./base/StiFormElement";
import { StiTextItem } from "./text/StiTextItem";
export declare class StiBarcodeElement extends StiFormElement implements StiLabel, StiDescription, StiChangesInterceptor {
    type: string;
    tooltip: string;
    private _description;
    private _barcodeType;
    private _matrixSize;
    private _errorCorrectionLevel;
    private _bodyBrushType;
    private _bodyBrushColor;
    private _startBodyBrushColor;
    private _endBodyBrushColor;
    private _bodyBrushBackColor;
    private _bodyBrushForeColor;
    private _bodyShapeType;
    private _bodyBrushAngle;
    private _bodyBrushHatchStyle;
    private _bodyBrushFocus;
    private _bodyBrushBlend;
    private _bodyBrushDrawHatch;
    private _eyeBallBrushType;
    private _eyeBallBrushColor;
    private _startEyeBallBrushColor;
    private _endEyeBallBrushColor;
    private _eyeBallBrushBackColor;
    private _eyeBallBrushForeColor;
    private _eyeBallShapeType;
    private _eyeBallBrushAngle;
    private _eyeBallBrushHatchStyle;
    private _eyeBallBrushFocus;
    private _eyeBallBrushBlend;
    private _eyeBallBrushDrawHatch;
    private _eyeFrameBrushType;
    private _eyeFrameBrushColor;
    private _startEyeFrameBrushColor;
    private _endEyeFrameBrushColor;
    private _eyeFrameBrushBackColor;
    private _eyeFrameBrushForeColor;
    private _eyeFrameShapeType;
    private _eyeFrameBrushAngle;
    private _eyeFrameBrushHatchStyle;
    private _eyeFrameBrushFocus;
    private _eyeFrameBrushBlend;
    private _eyeFrameBrushDrawHatch;
    private _codeString;
    private _width;
    private _height;
    private _style;
    private _backColor;
    private _foreColor;
    showProgress: boolean;
    img: string;
    showBodyBrushEditor: boolean;
    showEyeBallBrushEditor: boolean;
    showEyeFrameBrushEditor: boolean;
    propertyChanged(propName: string): void;
    get backColor(): Color;
    set backColor(value: Color);
    get foreColor(): Color;
    set foreColor(value: Color);
    get style(): number;
    set style(value: number);
    get Width(): number;
    set Width(value: number);
    get Height(): number;
    set Height(value: number);
    constructor();
    getUsedFonts(usedFonts: StiUsedFontsList): void;
    isChanged(): boolean;
    setStyle(value: number): void;
    resetChanged(): void;
    get description(): StiTextItem;
    set description(value: StiTextItem);
    get barcodeType(): StiBarcodeType;
    set barcodeType(value: StiBarcodeType);
    get matrixSize(): StiQRCodeSize;
    set matrixSize(value: StiQRCodeSize);
    get errorCorrectionLevel(): StiQRCodeErrorCorrectionLevel;
    set errorCorrectionLevel(value: StiQRCodeErrorCorrectionLevel);
    get codeString(): string;
    set codeString(value: string);
    get eyeBallBrushType(): StiBodyBrush;
    set eyeBallBrushType(value: StiBodyBrush);
    get eyeBallBrushColor(): Color;
    set eyeBallBrushColor(value: Color);
    get startEyeBallBrushColor(): Color;
    set startEyeBallBrushColor(value: Color);
    get endEyeBallBrushColor(): Color;
    set endEyeBallBrushColor(value: Color);
    get eyeBallBrushBackColor(): Color;
    set eyeBallBrushBackColor(value: Color);
    get eyeBallBrushForeColor(): Color;
    set eyeBallBrushForeColor(value: Color);
    get eyeBallShapeType(): StiQRCodeEyeBallShapeType;
    set eyeBallShapeType(value: StiQRCodeEyeBallShapeType);
    get eyeBallBrushAngle(): number;
    set eyeBallBrushAngle(value: number);
    get eyeBallBrushHatchStyle(): HatchStyle;
    set eyeBallBrushHatchStyle(value: HatchStyle);
    get eyeBallBrushFocus(): number;
    set eyeBallBrushFocus(value: number);
    get eyeBallBrushBlend(): number;
    set eyeBallBrushBlend(value: number);
    get eyeBallBrushDrawHatch(): boolean;
    set eyeBallBrushDrawHatch(value: boolean);
    get bodyBrushType(): StiBodyBrush;
    set bodyBrushType(value: StiBodyBrush);
    get bodyBrushColor(): Color;
    set bodyBrushColor(value: Color);
    get startBodyBrushColor(): Color;
    set startBodyBrushColor(value: Color);
    get endBodyBrushColor(): Color;
    set endBodyBrushColor(value: Color);
    get bodyBrushBackColor(): Color;
    set bodyBrushBackColor(value: Color);
    get bodyBrushForeColor(): Color;
    set bodyBrushForeColor(value: Color);
    get bodyShapeType(): StiQRCodeBodyShapeType;
    set bodyShapeType(value: StiQRCodeBodyShapeType);
    get bodyBrushAngle(): number;
    set bodyBrushAngle(value: number);
    get bodyBrushHatchStyle(): HatchStyle;
    set bodyBrushHatchStyle(value: HatchStyle);
    get bodyBrushFocus(): number;
    set bodyBrushFocus(value: number);
    get bodyBrushBlend(): number;
    set bodyBrushBlend(value: number);
    get bodyBrushDrawHatch(): boolean;
    set bodyBrushDrawHatch(value: boolean);
    get eyeFrameBrushType(): StiBodyBrush;
    set eyeFrameBrushType(value: StiBodyBrush);
    get eyeFrameBrushColor(): Color;
    set eyeFrameBrushColor(value: Color);
    get startEyeFrameBrushColor(): Color;
    set startEyeFrameBrushColor(value: Color);
    get endEyeFrameBrushColor(): Color;
    set endEyeFrameBrushColor(value: Color);
    get eyeFrameBrushBackColor(): Color;
    set eyeFrameBrushBackColor(value: Color);
    get eyeFrameBrushForeColor(): Color;
    set eyeFrameBrushForeColor(value: Color);
    get eyeFrameShapeType(): StiQRCodeEyeFrameShapeType;
    set eyeFrameShapeType(value: StiQRCodeEyeFrameShapeType);
    get eyeFrameBrushAngle(): number;
    set eyeFrameBrushAngle(value: number);
    get eyeFrameBrushHatchStyle(): HatchStyle;
    set eyeFrameBrushHatchStyle(value: HatchStyle);
    get eyeFrameBrushFocus(): number;
    set eyeFrameBrushFocus(value: number);
    get eyeFrameBrushBlend(): number;
    set eyeFrameBrushBlend(value: number);
    get eyeFrameBrushDrawHatch(): boolean;
    set eyeFrameBrushDrawHatch(value: boolean);
    saveToJsonObject(options: any): StiJson;
    loadFromJsonObject(json: StiJson): void;
}
