import { OnDestroy, OnInit } from "@angular/core";
import { Subscription } from "rxjs";
import { StiTableElement } from "../elements/StiTableElement";
import { StiModelService } from "../services/model.service";
import { StiMouseService } from "../services/mouse.service";
import { StiEditableContentService } from "../services/sti-editable-content.service";
import { StiHelperService } from "../services/sti-helper.service";
import Color from "../system/Color";
import { StiNumberElement } from "../system/interfaces";
import * as i0 from "@angular/core";
export declare class StiNumberComponent implements OnInit, OnDestroy {
    model: StiModelService;
    helper: StiHelperService;
    editableService: StiEditableContentService;
    mouseService: StiMouseService;
    element: StiNumberElement;
    index: number;
    table: StiTableElement;
    mouseUpSubscription: Subscription;
    get isNumberBox(): boolean;
    get needToFill(): boolean;
    buttonDown: number;
    mouseOver: boolean;
    focused: boolean;
    get disabled(): boolean;
    private incTimeout;
    constructor(model: StiModelService, helper: StiHelperService, editableService: StiEditableContentService, mouseService: StiMouseService);
    get tabIndex(): any;
    ngOnDestroy(): void;
    clear(): void;
    ngOnInit(): void;
    onFocus(event: any): void;
    get elementBorderColor(): Color;
    get readonly(): boolean;
    get cellBackgroundColor(): Color;
    get elementTextColor(): Color;
    get elementHtmlStyle(): string;
    get elementValue(): number;
    set elementValue(value: number);
    onLostFocus(event: any): void;
    setIncDec(value: number): void;
    incDecTimer(first?: boolean): void;
    get isCurrency(): boolean;
    getCurrency(currency: any): any;
    get value(): string;
    get isPrefix(): boolean;
    get isSuffix(): boolean;
    borderWidth(): string;
    disableDrag(event: any): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<StiNumberComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<StiNumberComponent, "sti-number-component", never, { "element": { "alias": "element"; "required": false; }; "index": { "alias": "index"; "required": false; }; "table": { "alias": "table"; "required": false; }; }, {}, never, never, false, never>;
}
