import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/sti-toolbox.service";
import * as i3 from "../services/sti-toolbar-resizer.service";
import * as i4 from "../services/sti-localization.service";
import * as i5 from "@angular/common";
import * as i6 from "./sti-toolbox-element.component";
import * as i7 from "../components/sti-tooltip/sti-tooltip.directive";
export class StiToolboxComponent {
    get isMaximize() {
        return this.toolbarResizerService.isMaximizeMode;
    }
    constructor(resolver, model, toolboxService, toolbarResizerService, loc) {
        this.resolver = resolver;
        this.model = model;
        this.toolboxService = toolboxService;
        this.toolbarResizerService = toolbarResizerService;
        this.loc = loc;
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiToolboxComponent, deps: [{ token: i0.ComponentFactoryResolver }, { token: i1.StiModelService }, { token: i2.StiToolboxService }, { token: i3.StiToolbarResizerService }, { token: i4.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiToolboxComponent, selector: "sti-toolbox", ngImport: i0, template: `
    <div class="elements" id="Elements" hidden="false">
      <p *ngIf="this.isMaximize">Elements</p>
      <sti-toolbox-element *ngFor="let element of toolboxService.elements" [element]="element"></sti-toolbox-element>
      <!-- <sti-draggable-element-container></sti-draggable-element-container> -->
      <div
        *ngIf="toolboxService.isToolboxOutlineElementsDividerEnabled() && model.getBooleanSetting('showSetupToolbox')"
        class="divider"
        [style.height.px]="4"
        [style.width.px]="28"
      >
        <div [style.height.px]="1" [style.width.px]="22" [style.border-bottom]="'1px solid rgb(170,170,170)'"></div>
      </div>
      <div
        class="element"
        *ngIf="model.getBooleanSetting('showSetupToolbox')"
        (click)="model.showToolboxSetup = true"
        [stiTooltip]="loc.get2('FormDesigner', 'SetupToolbox')"
        tooltipPosition="right"
        showDelay="500"
      >
        <img [src]="model.getImage('images.Other.SmallSetupToolbox.png')" style="pointer-events: none" />
      </div>
    </div>
    <!-- <sti-toolbar-resizer [style.visibility]="this.model.previewMode ? 'hidden' : ''"></sti-toolbar-resizer> -->
  `, isInline: true, styles: [".elements{width:100%;display:flex;flex-direction:column;font-size:18px;justify-content:flex-start;-webkit-touch-callout:none;-webkit-user-select:none}.divider{display:flex;align-items:center;justify-content:center}p{margin-top:1px;margin-bottom:3px;margin-left:5px;font-weight:500;color:var(--text-color)}.element{width:28px;height:28px;background-color:inherit;color:var(--text-color);border-radius:3px;display:flex;flex-wrap:nowrap;font-size:13px;font-weight:500;-webkit-touch-callout:none;-webkit-user-select:none;align-items:center;justify-content:center}.element:hover{background-color:var(--hover-color)}.element.active{background-color:var(--active-color)}img{vertical-align:sub;width:16px;height:16px}\n"], dependencies: [{ kind: "directive", type: i5.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i6.StiToolboxElementComponent, selector: "sti-toolbox-element", inputs: ["element", "forRibbon", "forGroup"] }, { kind: "directive", type: i7.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiToolboxComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-toolbox", template: `
    <div class="elements" id="Elements" hidden="false">
      <p *ngIf="this.isMaximize">Elements</p>
      <sti-toolbox-element *ngFor="let element of toolboxService.elements" [element]="element"></sti-toolbox-element>
      <!-- <sti-draggable-element-container></sti-draggable-element-container> -->
      <div
        *ngIf="toolboxService.isToolboxOutlineElementsDividerEnabled() && model.getBooleanSetting('showSetupToolbox')"
        class="divider"
        [style.height.px]="4"
        [style.width.px]="28"
      >
        <div [style.height.px]="1" [style.width.px]="22" [style.border-bottom]="'1px solid rgb(170,170,170)'"></div>
      </div>
      <div
        class="element"
        *ngIf="model.getBooleanSetting('showSetupToolbox')"
        (click)="model.showToolboxSetup = true"
        [stiTooltip]="loc.get2('FormDesigner', 'SetupToolbox')"
        tooltipPosition="right"
        showDelay="500"
      >
        <img [src]="model.getImage('images.Other.SmallSetupToolbox.png')" style="pointer-events: none" />
      </div>
    </div>
    <!-- <sti-toolbar-resizer [style.visibility]="this.model.previewMode ? 'hidden' : ''"></sti-toolbar-resizer> -->
  `, styles: [".elements{width:100%;display:flex;flex-direction:column;font-size:18px;justify-content:flex-start;-webkit-touch-callout:none;-webkit-user-select:none}.divider{display:flex;align-items:center;justify-content:center}p{margin-top:1px;margin-bottom:3px;margin-left:5px;font-weight:500;color:var(--text-color)}.element{width:28px;height:28px;background-color:inherit;color:var(--text-color);border-radius:3px;display:flex;flex-wrap:nowrap;font-size:13px;font-weight:500;-webkit-touch-callout:none;-webkit-user-select:none;align-items:center;justify-content:center}.element:hover{background-color:var(--hover-color)}.element.active{background-color:var(--active-color)}img{vertical-align:sub;width:16px;height:16px}\n"] }]
        }], ctorParameters: () => [{ type: i0.ComponentFactoryResolver }, { type: i1.StiModelService }, { type: i2.StiToolboxService }, { type: i3.StiToolbarResizerService }, { type: i4.StiLocalizationService }] });
//# sourceMappingURL=data:application/json;base64,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