import { Component, ViewChild } from "@angular/core";
import ResizeObserver from "resize-observer-polyfill";
import StiRectangleGeometryLayout from "../computed/StiRectangleGeometryLayout";
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../components/sti-components-holder.component";
export class StiCloneElementContainerComponent {
    constructor(model, zone, render) {
        this.model = model;
        this.zone = zone;
        this.render = render;
        this.isClone = true;
        model.formEvents.subscribe((e) => {
            if (e.name == "ElementToUpdateChanged" || e.name == "SelectedComponentChanged") {
                this.updateObservable();
            }
        });
    }
    ngOnInit() { }
    ngAfterViewInit() {
        this.observer = new ResizeObserver((entries) => {
            for (let entry of entries) {
                const cr = entry.contentRect;
                let element;
                if (this.model.draggingElement && this.model.draggingElement != this.lastUpdatedElement) {
                    element = this.model.draggingElement;
                }
                else if (this.model.elementToUpdate != null) {
                    element = this.model.elementToUpdate;
                }
                else {
                    this.model.form?.pages.forEach((page) => {
                        page.allElements.forEach((component) => {
                            if (component === this.element) {
                                element = component;
                            }
                        });
                    });
                }
                this.zone.run(() => {
                    this.updateElement(element, cr);
                });
            }
        });
        this.observer?.observe(this.clone?.nativeElement);
    }
    updateElement(component, cr) {
        if (!component || component.type == "TextElement") {
            return;
        }
        if (this.model.draggingElement && this.model.draggingElement == this.lastUpdatedElement) {
            return;
        }
        if (this.lastUpdatedElement != component) {
            this.lastUpdatedElement = component;
        }
        if (this.model.elementToUpdate == null) {
            let bottomElements = [];
            let freeAreaHeight;
            let currentPage = this.model.getElementPage(this.model.selectedComponent?.element);
            let currentPanel = this.model.getElementPanel(this.model.selectedComponent?.element);
            currentPage?.elements?.forEach((elem) => {
                if (elem.y >= this.model.selectedComponent.element.geometry.bottom) {
                    bottomElements.push(elem);
                }
            });
            if (bottomElements.length > 0) {
                let maxBottomPoint = Math.max(...bottomElements.map((elem) => elem.geometry.bottom));
                freeAreaHeight = (currentPage?.contentAreaHeight || currentPanel?.height) - maxBottomPoint;
            }
            else {
                freeAreaHeight =
                    (currentPage?.contentAreaHeight || currentPanel?.height) -
                        this.model.selectedComponent?.element.geometry.bottom;
            }
        }
        let parentContainer = component.getParent(this.model.form) ?? this.model.form.pages[0];
        let sizeChanged = false;
        let minHeight = Number(((Math.round(cr.height) / this.currentVerticalStep) % 1).toFixed(2)) <= 0.5 &&
            Math.round(cr.height) != parentContainer["contentAreaHeight"]
            ? Math.floor(cr.height / this.currentVerticalStep) * this.currentVerticalStep
            : Math.ceil(cr.height / this.currentVerticalStep) * this.currentVerticalStep;
        if (component.geometry.minHeight != minHeight &&
            minHeight <= parentContainer["contentAreaHeight"] &&
            minHeight != 0 &&
            Math.abs(component.geometry.minHeight - minHeight) > 1) {
            component.geometry.minHeight = minHeight;
            sizeChanged = true;
        }
        else if (minHeight >= parentContainer["contentAreaHeight"] - component.geometry.y) {
            component.geometry.minHeight = parentContainer["contentAreaHeight"] - component.geometry.y;
            sizeChanged = true;
        }
        if (parentContainer) {
            let columnWidth = parentContainer.getColumnWidth(this.model.form.settings.gridColumns);
            let minWidth = Math.max(Math.min(Math.ceil(Number(cr.width.toFixed(2)) / columnWidth) * columnWidth, this.maxWidth), columnWidth);
            if (minWidth != component.geometry.minWidth) {
                component.geometry.minWidth = minWidth;
                sizeChanged = true;
            }
            if (sizeChanged && this.model.draggingElement != component) {
                this.render.insertElement(component);
                this.render.checkOutputs(this.model.getElementPage(component));
            }
        }
        else {
            component.geometry.minWidth = Math.max(cr.width, 2);
        }
        this.model.elementToUpdate = null;
    }
    updateObservable() {
        this.observer?.unobserve(this.clone?.nativeElement);
        this.observer?.observe(this.clone?.nativeElement);
    }
    ngOnDestroy() {
        this.observer?.unobserve(this.clone?.nativeElement);
    }
    get element() {
        return this.model.draggingElement
            ? this.model.draggingElement
            : this.model.elementToUpdate ?? this.model.selectedComponent?.element;
    }
    get maxWidth() {
        return this.model?.draggingElement
            ? this.model?.form?.pages[0].contentAreaWidth - this.element?.x
            : this.element?.getParent(this.model.form)?.contentAreaWidth - this.element?.x;
    }
    get currentVerticalStep() {
        return this.model.form?.settings?.gridVerticalStep != 1 ? this.model.form?.settings?.gridVerticalStep : 5;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiCloneElementContainerComponent, deps: [{ token: i1.StiModelService }, { token: i0.NgZone }, { token: StiRectangleGeometryLayout }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiCloneElementContainerComponent, selector: "sti-clone-element-container", viewQueries: [{ propertyName: "clone", first: true, predicate: ["clone"], descendants: true }], ngImport: i0, template: `
    <div
      #clone
      style="position: absolute; top:-9999px; left:-9999px; z-index: -1; opacity:0;white-space:nowrap; userSelect:none;"
      [style.width]="'min-content'"
      [style.height]="'auto'"
      [style.max-width.px]="maxWidth"
    >
      <sti-component-holder [element]="element" [isClone]="this.isClone"></sti-component-holder>
    </div>
  `, isInline: true, dependencies: [{ kind: "component", type: i2.StiComponentHolderComponent, selector: "sti-component-holder", inputs: ["element", "isClone"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiCloneElementContainerComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-clone-element-container",
                    template: `
    <div
      #clone
      style="position: absolute; top:-9999px; left:-9999px; z-index: -1; opacity:0;white-space:nowrap; userSelect:none;"
      [style.width]="'min-content'"
      [style.height]="'auto'"
      [style.max-width.px]="maxWidth"
    >
      <sti-component-holder [element]="element" [isClone]="this.isClone"></sti-component-holder>
    </div>
  `,
                }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i0.NgZone }, { type: StiRectangleGeometryLayout }], propDecorators: { clone: [{
                type: ViewChild,
                args: ["clone"]
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RpLWNsb25lLWVsZW1lbnQtY29udGFpbmVyLmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3N0aW11bHNvZnQtZm9ybXMvc3JjL2xpYi90b29sYm94L3N0aS1jbG9uZS1lbGVtZW50LWNvbnRhaW5lci5jb21wb25lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFpQixTQUFTLEVBQXlDLFNBQVMsRUFBRSxNQUFNLGVBQWUsQ0FBQztBQUMzRyxPQUFPLGNBQWMsTUFBTSwwQkFBMEIsQ0FBQztBQUN0RCxPQUFPLDBCQUEwQixNQUFNLHdDQUF3QyxDQUFDOzs7O0FBa0JoRixNQUFNLE9BQU8saUNBQWlDO0lBTTVDLFlBQW1CLEtBQXNCLEVBQVUsSUFBWSxFQUFTLE1BQWtDO1FBQXZGLFVBQUssR0FBTCxLQUFLLENBQWlCO1FBQVUsU0FBSSxHQUFKLElBQUksQ0FBUTtRQUFTLFdBQU0sR0FBTixNQUFNLENBQTRCO1FBTG5HLFlBQU8sR0FBWSxJQUFJLENBQUM7UUFNN0IsS0FBSyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRTtZQUMvQixJQUFJLENBQUMsQ0FBQyxJQUFJLElBQUksd0JBQXdCLElBQUksQ0FBQyxDQUFDLElBQUksSUFBSSwwQkFBMEIsRUFBRSxDQUFDO2dCQUMvRSxJQUFJLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQztZQUMxQixDQUFDO1FBQ0gsQ0FBQyxDQUFDLENBQUM7SUFDTCxDQUFDO0lBRUQsUUFBUSxLQUFJLENBQUM7SUFFYixlQUFlO1FBQ2IsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLGNBQWMsQ0FBQyxDQUFDLE9BQU8sRUFBRSxFQUFFO1lBQzdDLEtBQUssSUFBSSxLQUFLLElBQUksT0FBTyxFQUFFLENBQUM7Z0JBQzFCLE1BQU0sRUFBRSxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7Z0JBQzdCLElBQUksT0FBTyxDQUFDO2dCQUNaLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxlQUFlLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxlQUFlLElBQUksSUFBSSxDQUFDLGtCQUFrQixFQUFFLENBQUM7b0JBQ3hGLE9BQU8sR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLGVBQWUsQ0FBQztnQkFDdkMsQ0FBQztxQkFBTSxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsZUFBZSxJQUFJLElBQUksRUFBRSxDQUFDO29CQUM5QyxPQUFPLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxlQUFlLENBQUM7Z0JBQ3ZDLENBQUM7cUJBQU0sQ0FBQztvQkFDTixJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUMsSUFBSSxFQUFFLEVBQUU7d0JBQ3RDLElBQUksQ0FBQyxXQUFXLENBQUMsT0FBTyxDQUFDLENBQUMsU0FBUyxFQUFFLEVBQUU7NEJBQ3JDLElBQUksU0FBUyxLQUFLLElBQUksQ0FBQyxPQUFPLEVBQUUsQ0FBQztnQ0FDL0IsT0FBTyxHQUFHLFNBQVMsQ0FBQzs0QkFDdEIsQ0FBQzt3QkFDSCxDQUFDLENBQUMsQ0FBQztvQkFDTCxDQUFDLENBQUMsQ0FBQztnQkFDTCxDQUFDO2dCQUVELElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLEdBQUcsRUFBRTtvQkFDakIsSUFBSSxDQUFDLGFBQWEsQ0FBQyxPQUFPLEVBQUUsRUFBRSxDQUFDLENBQUM7Z0JBQ2xDLENBQUMsQ0FBQyxDQUFDO1lBQ0wsQ0FBQztRQUNILENBQUMsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLFFBQVEsRUFBRSxPQUFPLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRSxhQUFhLENBQUMsQ0FBQztJQUNwRCxDQUFDO0lBRUQsYUFBYSxDQUFDLFNBQXlCLEVBQUUsRUFBTztRQUM5QyxJQUFJLENBQUMsU0FBUyxJQUFJLFNBQVMsQ0FBQyxJQUFJLElBQUksYUFBYSxFQUFFLENBQUM7WUFDbEQsT0FBTztRQUNULENBQUM7UUFDRCxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsZUFBZSxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsZUFBZSxJQUFJLElBQUksQ0FBQyxrQkFBa0IsRUFBRSxDQUFDO1lBQ3hGLE9BQU87UUFDVCxDQUFDO1FBQ0QsSUFBSSxJQUFJLENBQUMsa0JBQWtCLElBQUksU0FBUyxFQUFFLENBQUM7WUFDekMsSUFBSSxDQUFDLGtCQUFrQixHQUFHLFNBQVMsQ0FBQztRQUN0QyxDQUFDO1FBQ0QsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLGVBQWUsSUFBSSxJQUFJLEVBQUUsQ0FBQztZQUN2QyxJQUFJLGNBQWMsR0FBRyxFQUFFLENBQUM7WUFDeEIsSUFBSSxjQUFjLENBQUM7WUFDbkIsSUFBSSxXQUFXLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxPQUFPLENBQUMsQ0FBQztZQUNuRixJQUFJLFlBQVksR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLGVBQWUsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLGlCQUFpQixFQUFFLE9BQU8sQ0FBQyxDQUFDO1lBQ3JGLFdBQVcsRUFBRSxRQUFRLEVBQUUsT0FBTyxDQUFDLENBQUMsSUFBSSxFQUFFLEVBQUU7Z0JBQ3RDLElBQUksSUFBSSxDQUFDLENBQUMsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE9BQU8sQ0FBQyxRQUFRLENBQUMsTUFBTSxFQUFFLENBQUM7b0JBQ25FLGNBQWMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7Z0JBQzVCLENBQUM7WUFDSCxDQUFDLENBQUMsQ0FBQztZQUNILElBQUksY0FBYyxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUUsQ0FBQztnQkFDOUIsSUFBSSxjQUFjLEdBQUcsSUFBSSxDQUFDLEdBQUcsQ0FBQyxHQUFHLGNBQWMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxJQUFJLEVBQUUsRUFBRSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQztnQkFDckYsY0FBYyxHQUFHLENBQUMsV0FBVyxFQUFFLGlCQUFpQixJQUFJLFlBQVksRUFBRSxNQUFNLENBQUMsR0FBRyxjQUFjLENBQUM7WUFDN0YsQ0FBQztpQkFBTSxDQUFDO2dCQUNOLGNBQWM7b0JBQ1osQ0FBQyxXQUFXLEVBQUUsaUJBQWlCLElBQUksWUFBWSxFQUFFLE1BQU0sQ0FBQzt3QkFDeEQsSUFBSSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxPQUFPLENBQUMsUUFBUSxDQUFDLE1BQU0sQ0FBQztZQUMxRCxDQUFDO1FBQ0gsQ0FBQztRQUVELElBQUksZUFBZSxHQUFHLFNBQVMsQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDdkYsSUFBSSxXQUFXLEdBQUcsS0FBSyxDQUFDO1FBRXhCLElBQUksU0FBUyxHQUNYLE1BQU0sQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsTUFBTSxDQUFDLEdBQUcsSUFBSSxDQUFDLG1CQUFtQixDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksR0FBRztZQUNsRixJQUFJLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxNQUFNLENBQUMsSUFBSSxlQUFlLENBQUMsbUJBQW1CLENBQUM7WUFDM0QsQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsRUFBRSxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsbUJBQW1CLENBQUMsR0FBRyxJQUFJLENBQUMsbUJBQW1CO1lBQzdFLENBQUMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLG1CQUFtQixDQUFDLEdBQUcsSUFBSSxDQUFDLG1CQUFtQixDQUFDO1FBQ2pGLElBQ0UsU0FBUyxDQUFDLFFBQVEsQ0FBQyxTQUFTLElBQUksU0FBUztZQUN6QyxTQUFTLElBQUksZUFBZSxDQUFDLG1CQUFtQixDQUFDO1lBQ2pELFNBQVMsSUFBSSxDQUFDO1lBQ2QsSUFBSSxDQUFDLEdBQUcsQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUMsR0FBRyxDQUFDLEVBQ3RELENBQUM7WUFDRCxTQUFTLENBQUMsUUFBUSxDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUM7WUFDekMsV0FBVyxHQUFHLElBQUksQ0FBQztRQUNyQixDQUFDO2FBQU0sSUFBSSxTQUFTLElBQUksZUFBZSxDQUFDLG1CQUFtQixDQUFDLEdBQUcsU0FBUyxDQUFDLFFBQVEsQ0FBQyxDQUFDLEVBQUUsQ0FBQztZQUNwRixTQUFTLENBQUMsUUFBUSxDQUFDLFNBQVMsR0FBRyxlQUFlLENBQUMsbUJBQW1CLENBQUMsR0FBRyxTQUFTLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztZQUMzRixXQUFXLEdBQUcsSUFBSSxDQUFDO1FBQ3JCLENBQUM7UUFFRCxJQUFJLGVBQWUsRUFBRSxDQUFDO1lBQ3BCLElBQUksV0FBVyxHQUFHLGVBQWUsQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLFdBQVcsQ0FBQyxDQUFDO1lBQ3ZGLElBQUksUUFBUSxHQUFHLElBQUksQ0FBQyxHQUFHLENBQ3JCLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsR0FBRyxXQUFXLENBQUMsR0FBRyxXQUFXLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxFQUMzRixXQUFXLENBQ1osQ0FBQztZQUVGLElBQUksUUFBUSxJQUFJLFNBQVMsQ0FBQyxRQUFRLENBQUMsUUFBUSxFQUFFLENBQUM7Z0JBQzVDLFNBQVMsQ0FBQyxRQUFRLENBQUMsUUFBUSxHQUFHLFFBQVEsQ0FBQztnQkFDdkMsV0FBVyxHQUFHLElBQUksQ0FBQztZQUNyQixDQUFDO1lBRUQsSUFBSSxXQUFXLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxlQUFlLElBQUksU0FBUyxFQUFFLENBQUM7Z0JBQzNELElBQUksQ0FBQyxNQUFNLENBQUMsYUFBYSxDQUFDLFNBQVMsQ0FBQyxDQUFDO2dCQUNyQyxJQUFJLENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLGNBQWMsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO1lBQ2pFLENBQUM7UUFDSCxDQUFDO2FBQU0sQ0FBQztZQUNOLFNBQVMsQ0FBQyxRQUFRLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEtBQUssRUFBRSxDQUFDLENBQUMsQ0FBQztRQUN0RCxDQUFDO1FBRUQsSUFBSSxDQUFDLEtBQUssQ0FBQyxlQUFlLEdBQUcsSUFBSSxDQUFDO0lBQ3BDLENBQUM7SUFFRCxnQkFBZ0I7UUFDZCxJQUFJLENBQUMsUUFBUSxFQUFFLFNBQVMsQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLGFBQWEsQ0FBQyxDQUFDO1FBQ3BELElBQUksQ0FBQyxRQUFRLEVBQUUsT0FBTyxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsYUFBYSxDQUFDLENBQUM7SUFDcEQsQ0FBQztJQUNELFdBQVc7UUFDVCxJQUFJLENBQUMsUUFBUSxFQUFFLFNBQVMsQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLGFBQWEsQ0FBQyxDQUFDO0lBQ3RELENBQUM7SUFFRCxJQUFJLE9BQU87UUFDVCxPQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsZUFBZTtZQUMvQixDQUFDLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxlQUFlO1lBQzVCLENBQUMsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLGVBQWUsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLGlCQUFpQixFQUFFLE9BQU8sQ0FBQztJQUMxRSxDQUFDO0lBRUQsSUFBSSxRQUFRO1FBQ1YsT0FBTyxJQUFJLENBQUMsS0FBSyxFQUFFLGVBQWU7WUFDaEMsQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsSUFBSSxFQUFFLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxnQkFBZ0IsR0FBRyxJQUFJLENBQUMsT0FBTyxFQUFFLENBQUM7WUFDL0QsQ0FBQyxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsU0FBUyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLEVBQUUsZ0JBQWdCLEdBQUcsSUFBSSxDQUFDLE9BQU8sRUFBRSxDQUFDLENBQUM7SUFDbkYsQ0FBQztJQUVELElBQUksbUJBQW1CO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUUsUUFBUSxFQUFFLGdCQUFnQixJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUUsUUFBUSxFQUFFLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDNUcsQ0FBQzsrR0EzSVUsaUNBQWlDLHVFQWxCdkMsMEJBQTBCO21HQWtCcEIsaUNBQWlDLG1LQVpsQzs7Ozs7Ozs7OztHQVVUOzs0RkFFVSxpQ0FBaUM7a0JBZDdDLFNBQVM7bUJBQUM7b0JBQ1QsUUFBUSxFQUFFLDZCQUE2QjtvQkFDdkMsUUFBUSxFQUFFOzs7Ozs7Ozs7O0dBVVQ7aUJBQ0Y7OEZBakJNLDBCQUEwQix1QkFzQlgsS0FBSztzQkFBeEIsU0FBUzt1QkFBQyxPQUFPIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQWZ0ZXJWaWV3SW5pdCwgQ29tcG9uZW50LCBFbGVtZW50UmVmLCBOZ1pvbmUsIE9uRGVzdHJveSwgT25Jbml0LCBWaWV3Q2hpbGQgfSBmcm9tIFwiQGFuZ3VsYXIvY29yZVwiO1xyXG5pbXBvcnQgUmVzaXplT2JzZXJ2ZXIgZnJvbSBcInJlc2l6ZS1vYnNlcnZlci1wb2x5ZmlsbFwiO1xyXG5pbXBvcnQgU3RpUmVjdGFuZ2xlR2VvbWV0cnlMYXlvdXQgZnJvbSBcIi4uL2NvbXB1dGVkL1N0aVJlY3RhbmdsZUdlb21ldHJ5TGF5b3V0XCI7XHJcbmltcG9ydCB7IFN0aUZvcm1FbGVtZW50IH0gZnJvbSBcIi4uL2VsZW1lbnRzL2Jhc2UvU3RpRm9ybUVsZW1lbnRcIjtcclxuaW1wb3J0IHsgU3RpTW9kZWxTZXJ2aWNlIH0gZnJvbSBcIi4uL3NlcnZpY2VzL21vZGVsLnNlcnZpY2VcIjtcclxuXHJcbkBDb21wb25lbnQoe1xyXG4gIHNlbGVjdG9yOiBcInN0aS1jbG9uZS1lbGVtZW50LWNvbnRhaW5lclwiLFxyXG4gIHRlbXBsYXRlOiBgXHJcbiAgICA8ZGl2XHJcbiAgICAgICNjbG9uZVxyXG4gICAgICBzdHlsZT1cInBvc2l0aW9uOiBhYnNvbHV0ZTsgdG9wOi05OTk5cHg7IGxlZnQ6LTk5OTlweDsgei1pbmRleDogLTE7IG9wYWNpdHk6MDt3aGl0ZS1zcGFjZTpub3dyYXA7IHVzZXJTZWxlY3Q6bm9uZTtcIlxyXG4gICAgICBbc3R5bGUud2lkdGhdPVwiJ21pbi1jb250ZW50J1wiXHJcbiAgICAgIFtzdHlsZS5oZWlnaHRdPVwiJ2F1dG8nXCJcclxuICAgICAgW3N0eWxlLm1heC13aWR0aC5weF09XCJtYXhXaWR0aFwiXHJcbiAgICA+XHJcbiAgICAgIDxzdGktY29tcG9uZW50LWhvbGRlciBbZWxlbWVudF09XCJlbGVtZW50XCIgW2lzQ2xvbmVdPVwidGhpcy5pc0Nsb25lXCI+PC9zdGktY29tcG9uZW50LWhvbGRlcj5cclxuICAgIDwvZGl2PlxyXG4gIGAsXHJcbn0pXHJcbmV4cG9ydCBjbGFzcyBTdGlDbG9uZUVsZW1lbnRDb250YWluZXJDb21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQsIEFmdGVyVmlld0luaXQsIE9uRGVzdHJveSB7XHJcbiAgcHVibGljIGlzQ2xvbmU6IGJvb2xlYW4gPSB0cnVlO1xyXG4gIHB1YmxpYyBvYnNlcnZlcjtcclxuICBwdWJsaWMgbGFzdFVwZGF0ZWRFbGVtZW50OiBhbnk7XHJcbiAgQFZpZXdDaGlsZChcImNsb25lXCIpIGNsb25lOiBFbGVtZW50UmVmO1xyXG5cclxuICBjb25zdHJ1Y3RvcihwdWJsaWMgbW9kZWw6IFN0aU1vZGVsU2VydmljZSwgcHJpdmF0ZSB6b25lOiBOZ1pvbmUsIHB1YmxpYyByZW5kZXI6IFN0aVJlY3RhbmdsZUdlb21ldHJ5TGF5b3V0KSB7XHJcbiAgICBtb2RlbC5mb3JtRXZlbnRzLnN1YnNjcmliZSgoZSkgPT4ge1xyXG4gICAgICBpZiAoZS5uYW1lID09IFwiRWxlbWVudFRvVXBkYXRlQ2hhbmdlZFwiIHx8IGUubmFtZSA9PSBcIlNlbGVjdGVkQ29tcG9uZW50Q2hhbmdlZFwiKSB7XHJcbiAgICAgICAgdGhpcy51cGRhdGVPYnNlcnZhYmxlKCk7XHJcbiAgICAgIH1cclxuICAgIH0pO1xyXG4gIH1cclxuXHJcbiAgbmdPbkluaXQoKSB7fVxyXG5cclxuICBuZ0FmdGVyVmlld0luaXQoKTogdm9pZCB7XHJcbiAgICB0aGlzLm9ic2VydmVyID0gbmV3IFJlc2l6ZU9ic2VydmVyKChlbnRyaWVzKSA9PiB7XHJcbiAgICAgIGZvciAobGV0IGVudHJ5IG9mIGVudHJpZXMpIHtcclxuICAgICAgICBjb25zdCBjciA9IGVudHJ5LmNvbnRlbnRSZWN0O1xyXG4gICAgICAgIGxldCBlbGVtZW50O1xyXG4gICAgICAgIGlmICh0aGlzLm1vZGVsLmRyYWdnaW5nRWxlbWVudCAmJiB0aGlzLm1vZGVsLmRyYWdnaW5nRWxlbWVudCAhPSB0aGlzLmxhc3RVcGRhdGVkRWxlbWVudCkge1xyXG4gICAgICAgICAgZWxlbWVudCA9IHRoaXMubW9kZWwuZHJhZ2dpbmdFbGVtZW50O1xyXG4gICAgICAgIH0gZWxzZSBpZiAodGhpcy5tb2RlbC5lbGVtZW50VG9VcGRhdGUgIT0gbnVsbCkge1xyXG4gICAgICAgICAgZWxlbWVudCA9IHRoaXMubW9kZWwuZWxlbWVudFRvVXBkYXRlO1xyXG4gICAgICAgIH0gZWxzZSB7XHJcbiAgICAgICAgICB0aGlzLm1vZGVsLmZvcm0/LnBhZ2VzLmZvckVhY2goKHBhZ2UpID0+IHtcclxuICAgICAgICAgICAgcGFnZS5hbGxFbGVtZW50cy5mb3JFYWNoKChjb21wb25lbnQpID0+IHtcclxuICAgICAgICAgICAgICBpZiAoY29tcG9uZW50ID09PSB0aGlzLmVsZW1lbnQpIHtcclxuICAgICAgICAgICAgICAgIGVsZW1lbnQgPSBjb21wb25lbnQ7XHJcbiAgICAgICAgICAgICAgfVxyXG4gICAgICAgICAgICB9KTtcclxuICAgICAgICAgIH0pO1xyXG4gICAgICAgIH1cclxuXHJcbiAgICAgICAgdGhpcy56b25lLnJ1bigoKSA9PiB7XHJcbiAgICAgICAgICB0aGlzLnVwZGF0ZUVsZW1lbnQoZWxlbWVudCwgY3IpO1xyXG4gICAgICAgIH0pO1xyXG4gICAgICB9XHJcbiAgICB9KTtcclxuICAgIHRoaXMub2JzZXJ2ZXI/Lm9ic2VydmUodGhpcy5jbG9uZT8ubmF0aXZlRWxlbWVudCk7XHJcbiAgfVxyXG5cclxuICB1cGRhdGVFbGVtZW50KGNvbXBvbmVudDogU3RpRm9ybUVsZW1lbnQsIGNyOiBhbnkpIHtcclxuICAgIGlmICghY29tcG9uZW50IHx8IGNvbXBvbmVudC50eXBlID09IFwiVGV4dEVsZW1lbnRcIikge1xyXG4gICAgICByZXR1cm47XHJcbiAgICB9XHJcbiAgICBpZiAodGhpcy5tb2RlbC5kcmFnZ2luZ0VsZW1lbnQgJiYgdGhpcy5tb2RlbC5kcmFnZ2luZ0VsZW1lbnQgPT0gdGhpcy5sYXN0VXBkYXRlZEVsZW1lbnQpIHtcclxuICAgICAgcmV0dXJuO1xyXG4gICAgfVxyXG4gICAgaWYgKHRoaXMubGFzdFVwZGF0ZWRFbGVtZW50ICE9IGNvbXBvbmVudCkge1xyXG4gICAgICB0aGlzLmxhc3RVcGRhdGVkRWxlbWVudCA9IGNvbXBvbmVudDtcclxuICAgIH1cclxuICAgIGlmICh0aGlzLm1vZGVsLmVsZW1lbnRUb1VwZGF0ZSA9PSBudWxsKSB7XHJcbiAgICAgIGxldCBib3R0b21FbGVtZW50cyA9IFtdO1xyXG4gICAgICBsZXQgZnJlZUFyZWFIZWlnaHQ7XHJcbiAgICAgIGxldCBjdXJyZW50UGFnZSA9IHRoaXMubW9kZWwuZ2V0RWxlbWVudFBhZ2UodGhpcy5tb2RlbC5zZWxlY3RlZENvbXBvbmVudD8uZWxlbWVudCk7XHJcbiAgICAgIGxldCBjdXJyZW50UGFuZWwgPSB0aGlzLm1vZGVsLmdldEVsZW1lbnRQYW5lbCh0aGlzLm1vZGVsLnNlbGVjdGVkQ29tcG9uZW50Py5lbGVtZW50KTtcclxuICAgICAgY3VycmVudFBhZ2U/LmVsZW1lbnRzPy5mb3JFYWNoKChlbGVtKSA9PiB7XHJcbiAgICAgICAgaWYgKGVsZW0ueSA+PSB0aGlzLm1vZGVsLnNlbGVjdGVkQ29tcG9uZW50LmVsZW1lbnQuZ2VvbWV0cnkuYm90dG9tKSB7XHJcbiAgICAgICAgICBib3R0b21FbGVtZW50cy5wdXNoKGVsZW0pO1xyXG4gICAgICAgIH1cclxuICAgICAgfSk7XHJcbiAgICAgIGlmIChib3R0b21FbGVtZW50cy5sZW5ndGggPiAwKSB7XHJcbiAgICAgICAgbGV0IG1heEJvdHRvbVBvaW50ID0gTWF0aC5tYXgoLi4uYm90dG9tRWxlbWVudHMubWFwKChlbGVtKSA9PiBlbGVtLmdlb21ldHJ5LmJvdHRvbSkpO1xyXG4gICAgICAgIGZyZWVBcmVhSGVpZ2h0ID0gKGN1cnJlbnRQYWdlPy5jb250ZW50QXJlYUhlaWdodCB8fCBjdXJyZW50UGFuZWw/LmhlaWdodCkgLSBtYXhCb3R0b21Qb2ludDtcclxuICAgICAgfSBlbHNlIHtcclxuICAgICAgICBmcmVlQXJlYUhlaWdodCA9XHJcbiAgICAgICAgICAoY3VycmVudFBhZ2U/LmNvbnRlbnRBcmVhSGVpZ2h0IHx8IGN1cnJlbnRQYW5lbD8uaGVpZ2h0KSAtXHJcbiAgICAgICAgICB0aGlzLm1vZGVsLnNlbGVjdGVkQ29tcG9uZW50Py5lbGVtZW50Lmdlb21ldHJ5LmJvdHRvbTtcclxuICAgICAgfVxyXG4gICAgfVxyXG5cclxuICAgIGxldCBwYXJlbnRDb250YWluZXIgPSBjb21wb25lbnQuZ2V0UGFyZW50KHRoaXMubW9kZWwuZm9ybSkgPz8gdGhpcy5tb2RlbC5mb3JtLnBhZ2VzWzBdO1xyXG4gICAgbGV0IHNpemVDaGFuZ2VkID0gZmFsc2U7XHJcblxyXG4gICAgbGV0IG1pbkhlaWdodCA9XHJcbiAgICAgIE51bWJlcigoKE1hdGgucm91bmQoY3IuaGVpZ2h0KSAvIHRoaXMuY3VycmVudFZlcnRpY2FsU3RlcCkgJSAxKS50b0ZpeGVkKDIpKSA8PSAwLjUgJiZcclxuICAgICAgTWF0aC5yb3VuZChjci5oZWlnaHQpICE9IHBhcmVudENvbnRhaW5lcltcImNvbnRlbnRBcmVhSGVpZ2h0XCJdXHJcbiAgICAgICAgPyBNYXRoLmZsb29yKGNyLmhlaWdodCAvIHRoaXMuY3VycmVudFZlcnRpY2FsU3RlcCkgKiB0aGlzLmN1cnJlbnRWZXJ0aWNhbFN0ZXBcclxuICAgICAgICA6IE1hdGguY2VpbChjci5oZWlnaHQgLyB0aGlzLmN1cnJlbnRWZXJ0aWNhbFN0ZXApICogdGhpcy5jdXJyZW50VmVydGljYWxTdGVwO1xyXG4gICAgaWYgKFxyXG4gICAgICBjb21wb25lbnQuZ2VvbWV0cnkubWluSGVpZ2h0ICE9IG1pbkhlaWdodCAmJlxyXG4gICAgICBtaW5IZWlnaHQgPD0gcGFyZW50Q29udGFpbmVyW1wiY29udGVudEFyZWFIZWlnaHRcIl0gJiZcclxuICAgICAgbWluSGVpZ2h0ICE9IDAgJiZcclxuICAgICAgTWF0aC5hYnMoY29tcG9uZW50Lmdlb21ldHJ5Lm1pbkhlaWdodCAtIG1pbkhlaWdodCkgPiAxXHJcbiAgICApIHtcclxuICAgICAgY29tcG9uZW50Lmdlb21ldHJ5Lm1pbkhlaWdodCA9IG1pbkhlaWdodDtcclxuICAgICAgc2l6ZUNoYW5nZWQgPSB0cnVlO1xyXG4gICAgfSBlbHNlIGlmIChtaW5IZWlnaHQgPj0gcGFyZW50Q29udGFpbmVyW1wiY29udGVudEFyZWFIZWlnaHRcIl0gLSBjb21wb25lbnQuZ2VvbWV0cnkueSkge1xyXG4gICAgICBjb21wb25lbnQuZ2VvbWV0cnkubWluSGVpZ2h0ID0gcGFyZW50Q29udGFpbmVyW1wiY29udGVudEFyZWFIZWlnaHRcIl0gLSBjb21wb25lbnQuZ2VvbWV0cnkueTtcclxuICAgICAgc2l6ZUNoYW5nZWQgPSB0cnVlO1xyXG4gICAgfVxyXG5cclxuICAgIGlmIChwYXJlbnRDb250YWluZXIpIHtcclxuICAgICAgbGV0IGNvbHVtbldpZHRoID0gcGFyZW50Q29udGFpbmVyLmdldENvbHVtbldpZHRoKHRoaXMubW9kZWwuZm9ybS5zZXR0aW5ncy5ncmlkQ29sdW1ucyk7XHJcbiAgICAgIGxldCBtaW5XaWR0aCA9IE1hdGgubWF4KFxyXG4gICAgICAgIE1hdGgubWluKE1hdGguY2VpbChOdW1iZXIoY3Iud2lkdGgudG9GaXhlZCgyKSkgLyBjb2x1bW5XaWR0aCkgKiBjb2x1bW5XaWR0aCwgdGhpcy5tYXhXaWR0aCksXHJcbiAgICAgICAgY29sdW1uV2lkdGhcclxuICAgICAgKTtcclxuXHJcbiAgICAgIGlmIChtaW5XaWR0aCAhPSBjb21wb25lbnQuZ2VvbWV0cnkubWluV2lkdGgpIHtcclxuICAgICAgICBjb21wb25lbnQuZ2VvbWV0cnkubWluV2lkdGggPSBtaW5XaWR0aDtcclxuICAgICAgICBzaXplQ2hhbmdlZCA9IHRydWU7XHJcbiAgICAgIH1cclxuXHJcbiAgICAgIGlmIChzaXplQ2hhbmdlZCAmJiB0aGlzLm1vZGVsLmRyYWdnaW5nRWxlbWVudCAhPSBjb21wb25lbnQpIHtcclxuICAgICAgICB0aGlzLnJlbmRlci5pbnNlcnRFbGVtZW50KGNvbXBvbmVudCk7XHJcbiAgICAgICAgdGhpcy5yZW5kZXIuY2hlY2tPdXRwdXRzKHRoaXMubW9kZWwuZ2V0RWxlbWVudFBhZ2UoY29tcG9uZW50KSk7XHJcbiAgICAgIH1cclxuICAgIH0gZWxzZSB7XHJcbiAgICAgIGNvbXBvbmVudC5nZW9tZXRyeS5taW5XaWR0aCA9IE1hdGgubWF4KGNyLndpZHRoLCAyKTtcclxuICAgIH1cclxuXHJcbiAgICB0aGlzLm1vZGVsLmVsZW1lbnRUb1VwZGF0ZSA9IG51bGw7XHJcbiAgfVxyXG5cclxuICB1cGRhdGVPYnNlcnZhYmxlKCk6IHZvaWQge1xyXG4gICAgdGhpcy5vYnNlcnZlcj8udW5vYnNlcnZlKHRoaXMuY2xvbmU/Lm5hdGl2ZUVsZW1lbnQpO1xyXG4gICAgdGhpcy5vYnNlcnZlcj8ub2JzZXJ2ZSh0aGlzLmNsb25lPy5uYXRpdmVFbGVtZW50KTtcclxuICB9XHJcbiAgbmdPbkRlc3Ryb3koKTogdm9pZCB7XHJcbiAgICB0aGlzLm9ic2VydmVyPy51bm9ic2VydmUodGhpcy5jbG9uZT8ubmF0aXZlRWxlbWVudCk7XHJcbiAgfVxyXG5cclxuICBnZXQgZWxlbWVudCgpOiBTdGlGb3JtRWxlbWVudCB7XHJcbiAgICByZXR1cm4gdGhpcy5tb2RlbC5kcmFnZ2luZ0VsZW1lbnRcclxuICAgICAgPyB0aGlzLm1vZGVsLmRyYWdnaW5nRWxlbWVudFxyXG4gICAgICA6IHRoaXMubW9kZWwuZWxlbWVudFRvVXBkYXRlID8/IHRoaXMubW9kZWwuc2VsZWN0ZWRDb21wb25lbnQ/LmVsZW1lbnQ7XHJcbiAgfVxyXG5cclxuICBnZXQgbWF4V2lkdGgoKSB7XHJcbiAgICByZXR1cm4gdGhpcy5tb2RlbD8uZHJhZ2dpbmdFbGVtZW50XHJcbiAgICAgID8gdGhpcy5tb2RlbD8uZm9ybT8ucGFnZXNbMF0uY29udGVudEFyZWFXaWR0aCAtIHRoaXMuZWxlbWVudD8ueFxyXG4gICAgICA6IHRoaXMuZWxlbWVudD8uZ2V0UGFyZW50KHRoaXMubW9kZWwuZm9ybSk/LmNvbnRlbnRBcmVhV2lkdGggLSB0aGlzLmVsZW1lbnQ/Lng7XHJcbiAgfVxyXG5cclxuICBnZXQgY3VycmVudFZlcnRpY2FsU3RlcCgpOiBudW1iZXIge1xyXG4gICAgcmV0dXJuIHRoaXMubW9kZWwuZm9ybT8uc2V0dGluZ3M/LmdyaWRWZXJ0aWNhbFN0ZXAgIT0gMSA/IHRoaXMubW9kZWwuZm9ybT8uc2V0dGluZ3M/LmdyaWRWZXJ0aWNhbFN0ZXAgOiA1O1xyXG4gIH1cclxufVxyXG4iXX0=