/*
{*******************************************************************}
{                                                                   }

{                                                                   }
{                                                                   }
{   Copyright (C)  Stimulsoft                                       }
{   ALL RIGHTS RESERVED                                             }
{                                                                   }
{   The entire contents of this file is protected by U.S. and       }
{   International Copyright Laws. Unauthorized reproduction,        }
{   reverse-engineering, and distribution of all or any portion of  }
{   the code contained in this file is strictly prohibited and may  }
{   result in severe civil and criminal penalties and will be       }
{   prosecuted to the maximum extent possible under the law.        }
{                                                                   }
{   RESTRICTIONS                                                    }
{                                                                   }
{   THIS SOURCE CODE AND ALL RESULTING INTERMEDIATE FILES           }
{   ARE CONFIDENTIAL AND PROPRIETARY                                }
{   TRADE SECRETS OF Stimulsoft                                     }
{                                                                   }
{   CONSULT THE END USER LICENSE AGREEMENT FOR INFORMATION ON       }
{   ADDITIONAL RESTRICTIONS.                                        }
{                                                                   }
{*******************************************************************}
*/
export default class Guid {
    static newGuid() {
        return new Guid(Guid.s4() + Guid.s4() + "-" + Guid.s4() + "-" + Guid.s4() + "-" +
            Guid.s4() + "-" + Guid.s4() + Guid.s4() + Guid.s4());
    }
    static newGuidString() {
        return Guid.s4() + Guid.s4() + Guid.s4() + Guid.s4() +
            Guid.s4() + Guid.s4() + Guid.s4() + Guid.s4();
    }
    static s4() {
        return Math
            .floor((1 + Math.random()) * 0x10000)
            .toString(16)
            .substring(1);
    }
    toString() {
        return this.id;
    }
    static empty() {
        return new Guid("00000000-0000-0000-0000-000000000000");
    }
    static compareTo(value) {
        let x = this.toString();
        let y = value.toString();
        return (x < y ? -1 : (x > y ? 1 : 0));
    }
    constructor(id) {
        this.id = id.toLowerCase();
    }
}
//# sourceMappingURL=data:application/json;base64,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