/*
{*******************************************************************}
{                                                                   }

{                                                                   }
{                                                                   }
{   Copyright (C)  Stimulsoft                                       }
{   ALL RIGHTS RESERVED                                             }
{                                                                   }
{   The entire contents of this file is protected by U.S. and       }
{   International Copyright Laws. Unauthorized reproduction,        }
{   reverse-engineering, and distribution of all or any portion of  }
{   the code contained in this file is strictly prohibited and may  }
{   result in severe civil and criminal penalties and will be       }
{   prosecuted to the maximum extent possible under the law.        }
{                                                                   }
{   RESTRICTIONS                                                    }
{                                                                   }
{   THIS SOURCE CODE AND ALL RESULTING INTERMEDIATE FILES           }
{   ARE CONFIDENTIAL AND PROPRIETARY                                }
{   TRADE SECRETS OF Stimulsoft                                     }
{                                                                   }
{   CONSULT THE END USER LICENSE AGREEMENT FOR INFORMATION ON       }
{   ADDITIONAL RESTRICTIONS.                                        }
{                                                                   }
{*******************************************************************}
*/
import { Char } from "./Char";
export class Enum {
    static getName(enumType, value) {
        let values = "";
        if (enumType[value] == undefined) {
            // eslint-disable-next-line @typescript-eslint/no-for-in-array
            for (let enumValue in enumType) {
                let enumValueNumber = +enumValue;
                if (enumValueNumber != 0 && (value & enumValueNumber) == enumValueNumber) {
                    value -= enumValueNumber;
                    // eslint-disable-next-line @typescript-eslint/restrict-plus-operands
                    values += (values.length > 0 ? ", " : "") + enumType[enumValueNumber];
                }
            }
            if (values.length == 0)
                values = enumType[0];
            return values;
        }
        return enumType[value];
    }
    static parse(enumType, value, upperFirstChar = true) {
        if (value == null)
            return null;
        if (typeof value == "number" || Char.isDigit(value))
            value = Enum.getName(enumType, +value);
        let values = value.toString().split(",");
        let enumValue;
        // tslint:disable-next-line: prefer-for-of
        for (let index = 0; index < values.length; index++) {
            let strValue = upperFirstChar ? this.upperFirstChar(values[index]) : values[index];
            if (typeof enumValue == "undefined")
                enumValue = enumType[strValue];
            else
                enumValue += enumType[strValue];
        }
        return enumValue;
    }
    static upperFirstChar(str) {
        str = str.trim();
        return str.length > 0 ? str.charAt(0).toUpperCase() + str.slice(1) : str;
    }
    static getNames(enumType) {
        let names = [];
        for (let enumValue in enumType) {
            if (typeof enumType[enumValue] != "number")
                names.push(enumType[enumValue]);
        }
        return names;
    }
    static getValues(enumType) {
        let values = [];
        for (let enumValue in enumType) {
            if (typeof enumType[enumValue] != "number")
                values.push(+enumValue);
        }
        return values;
    }
    toString() {
        return this.name;
    }
    /*compareTo(value: Enum): number {
      if (this.value != null)
        return this.value.compareTo(value.value);
  
      return this.name.compareTo(value.name);
    }*/
    constructor(name, value = null) {
        this.name = name;
        this.value = value;
    }
}
//# sourceMappingURL=data:application/json;base64,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