import { Injectable } from "@angular/core";
import { Subject } from "rxjs";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
export class StiThemeService {
    get currentTheme() {
        return this._currentTheme;
    }
    set currentTheme(value) {
        this._currentTheme = value;
        this.currentThemeSubj.next(value);
    }
    getIcon(type) {
        if (type == "All") {
            return this.model.getImage("images.Properties.BorderAll.png");
        }
        else if (type == "None") {
            return this.model.getImage("images.Properties.BorderNone.png");
        }
        else if (type == "Top") {
            return this.model.getImage("images.Properties.BorderTop.png");
        }
        else if (type == "Left") {
            return this.model.getImage("images.Properties.BorderLeft.png");
        }
        else if (type == "Bottom") {
            return this.model.getImage("images.Properties.BorderBottom.png");
        }
        else if (type == "Right") {
            return this.model.getImage("images.Properties.BorderRight.png");
        }
        else if (type == "GridAll") {
            return this.model.getImage("images.Properties.GridLinesAll.png");
        }
        else if (type == "GridNone") {
            return this.model.getImage("images.Properties.GridLinesNone.png");
        }
        else if (type == "Vertical") {
            return this.model.getImage("images.Properties.GridLinesVertical.png");
        }
        else if (type == "Horizontal") {
            return this.model.getImage("images.Properties.GridLinesHorizontal.png");
        }
    }
    changeTheme() {
        if (this.currentTheme == "Light") {
            if (document.getElementById("CurrentTheme")) {
                document.getElementById("CurrentTheme").remove();
            }
            let head = document.getElementsByTagName("head")[0];
            let style = document.createElement("style");
            style.id = "CurrentTheme";
            style.innerHTML = `:root {
        --back-color: rgb(255, 255, 255);
        --workspace-color: rgb(236,236,236);
        --modalNav-color: rgb(236, 236, 236);
        --modalBorder-color: rgb(195, 195, 195);
        --text-color: rgb(85, 85, 85);
        --property-label-color: rgb(118,118,118);
        --input-color: white;
        --inputBorder-color: rgb(107, 107, 107);
        --track-color: rgb(154, 154, 153);
        --trackHover-color: rgb(170, 171, 169);
        --thumb-color: rgb(192, 192, 191);
        --hover-color: rgb(218, 218, 218);
        --active-color: rgb(239, 239, 239);
        --focus-color: rgb(170, 171, 169);
        --formBorder-color: rgb(224, 224, 224);
        --arrowHover-color: rgb(195, 195, 195);
        --columnDeleteHover-color: rgb(209, 208, 207);
        --toolbarResizer-color: white;
        --toolbarResizerBorder-color: rgb(220, 219, 217);
        --pageNavBackground-color: white;
        --pageNavBorder-color: rgb(220, 219, 217);
        --pageNavDisable-color: rgb(244, 244, 244);
    }`;
            head.appendChild(style);
        }
        else {
            if (document.getElementById("CurrentTheme")) {
                document.getElementById("CurrentTheme").remove();
            }
            let head = document.getElementsByTagName("head")[0];
            let style = document.createElement("style");
            style.id = "CurrentTheme";
            style.innerHTML = `:root {
        --back-color: rgb(51, 51, 51);
        --workspace-color: rgb(45,45,45);
        --modalNav-color: rgb(54, 54, 55);
        --modalBorder-color: rgb(45, 45, 45);
        --text-color: rgb(255, 255, 255);
        --property-label-color: rgb(167,167,167);
        --input-color: rgb(43, 43, 43);
        --inputBorder-color: rgb(190, 190, 190);
        --track-color: rgb(71, 71, 71);
        --trackHover-color: rgb(94, 95, 93);
        --thumb-color: rgb(71, 71, 71);
        --hover-color: rgb(80, 80, 80);
        --active-color: rgb(59, 59, 59);
        --focus-color: rgb(91, 91, 91);
        --formBorder-color: rgb(79, 79, 79);
        --arrowHover-color: rgb(124, 124, 124);
        --columnDeleteHover-color: rgb(132, 132, 132);
        --toolbarResizer-color: rgb(71, 71, 71);
        --toolbarResizerBorder-color: rgb(71, 71, 71);
        --pageNavBackground-color: rgb(71, 71, 71);
        --pageNavBorder-color: rgb(64, 64, 64);
        --pageNavDisable-color: rgb(55, 55, 55);
    }`;
            head.appendChild(style);
        }
    }
    constructor(model) {
        this.model = model;
        this.currentThemeSubj = new Subject();
        this.currentThemeSubj.subscribe(() => this.changeTheme());
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiThemeService, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiThemeService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiThemeService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.StiModelService }] });
//# sourceMappingURL=data:application/json;base64,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