import { Injectable } from "@angular/core";
import { StiForm } from "../elements/StiForm";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
export class StiUndoService {
    static { this.UNDO_SIZE = 30; }
    constructor(model) {
        this.model = model;
        this.undos = [];
        this.redos = [];
        model.formEvents.subscribe((e) => {
            if (e.name == "FormChanged") {
                this.addToUndo();
            }
            else if (e.name == "SetForm") {
                this.undos = [];
                this.addToUndo();
            }
        });
    }
    undoRedo(from, to) {
        to.push(from.splice(from.length - 1, 1)[0]);
        if (to.length > StiUndoService.UNDO_SIZE) {
            to.splice(0, 1);
        }
        let fromObj = this.undos[this.undos.length - 1];
        let form = new StiForm();
        form.loadFormJsonString(fromObj.form);
        this.model.selectedComponent = null;
        if (fromObj.guid) {
            form.pages.forEach((p) => {
                if (p.guid == fromObj.guid) {
                    this.model.selectedPage = p;
                }
            });
            form.pages.forEach((p) => p.allElements.forEach((e) => {
                if (e.guid == fromObj.guid) {
                    e.needToSelectComponent = true;
                }
            }));
        }
        this.model.updateForm(form);
        this.model.showTrialLog();
    }
    addToUndo() {
        this.model.showTrialLog();
        let formStr = this.model.form.saveToJsonObject().serialize();
        this.undos.push({
            form: formStr,
            guid: this.model.selectedComponent?.element.guid ?? this.model.selectedPage?.guid,
            num: this.undos.length,
        });
        if (this.undos.length > StiUndoService.UNDO_SIZE) {
            this.undos.splice(0, 1);
        }
        this.redos = [];
    }
    undo() {
        if (this.undos.length > 0) {
            this.undoRedo(this.undos, this.redos);
        }
    }
    redo() {
        if (this.redos.length > 0) {
            this.undoRedo(this.redos, this.undos);
        }
    }
    markCurrentFormAsUnmodified() {
        this.undos.forEach((u) => (u.unmodified = false));
        this.redos.forEach((u) => (u.unmodified = false));
        this.undos[this.undos.length - 1].unmodified = true;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiUndoService, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiUndoService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiUndoService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.StiModelService }] });
//# sourceMappingURL=data:application/json;base64,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