import { Injectable } from "@angular/core";
import { StiTextBoxComponent } from "../components/sti-text-box/sti-text-box.component";
import { StiNumberBoxComponent } from "../components/sti-number-box/sti-number-box.component";
import { StiComboBoxComponent } from "../components/sti-combo-box/sti-combo-box.component";
import { StiListBoxComponent } from "../components/sti-list-box/sti-list-box.component";
import { StiSingleSelectionComponent } from "../components/sti-single-selection/sti-single-selection.component";
import { StiMultipleSelectionComponent } from "../components/sti-multiple-selection/sti-multiple-selection.component";
import { StiCheckBoxComponent } from "../components/sti-check-box/sti-check-box.component";
import { StiLineComponent } from "../components/sti-line/sti-line.component";
import { StiSignatureComponent } from "../components/sti-signature/sti-signature.component";
import { StiDateTimeBoxComponent } from "../components/sti-date-time-box/sti-date-time-box.component";
import { StiTableComponent } from "../components/sti-table/sti-table.component";
import { StiImageComponent } from "../components/sti-image/sti-image.component";
import { StiButtonComponent } from "../components/sti-button/sti-button.component";
import { StiBarcodeComponent } from "../components/sti-barcode/sti-barcode.component";
import { StiTextComponent } from "../components/sti-text/sti-text.component";
import { StiLabelComponent } from "../components/sti-label/sti-label.component";
import { Subject } from "rxjs";
import { StiDraggableService } from "./sti-draggable.service";
import { StiBarcodeElement } from "../elements/StiBarcodeElement";
import { StiButtonElement } from "../elements/StiButtonElement";
import { StiCheckBoxElement } from "../elements/StiCheckBoxElement";
import { StiComboBoxElement } from "../elements/StiComboBoxElement";
import { StiDateTimeBoxElement } from "../elements/StiDateTimeBoxElement";
import { StiImageElement } from "../elements/StiImageElement";
import { StiLabelElement } from "../elements/StiLabelElement";
import StiLineElement from "../elements/StiLineElement";
import { StiListBoxElement } from "../elements/StiListBoxElement";
import { StiMultipleSelectionElement } from "../elements/StiMultipleSelectionElement";
import { StiNumberBoxElement } from "../elements/StiNumberBoxElement";
import { StiPanelElement } from "../elements/StiPanelElement";
import { StiSignatureElement } from "../elements/StiSignatureElement";
import { StiSingleSelectionElement } from "../elements/StiSingleSelectionElement";
import { StiTableElement } from "../elements/StiTableElement";
import { StiTextBoxElement } from "../elements/StiTextBoxElement";
import { StiTextElement } from "../elements/StiTextElement";
import { StiAddressComponent } from "../components/sti-address/sti-address.component";
import { StiAddressElement } from "../elements/StiAddressElement";
import { StiPDFSignatureComponent } from "../components/sti-pdf-signature/sti-pdf-signature.component";
import { StiPDFSignatureElement } from "../elements/StiPDFSignatureElement";
import { StiPanelComponent } from "../components/sti-components-holder.component";
import * as i0 from "@angular/core";
import * as i1 from "./mouse.service";
import * as i2 from "./sti-draggable.service";
import * as i3 from "./model.service";
import * as i4 from "./sti-localization.service";
export class StiToolboxService {
    isEnabled(element) {
        if (this.unusedElements?.find((item) => item == element.id) || !this.isEnabledFromSettings(element)) {
            return false;
        }
        else {
            return true;
        }
    }
    isEnabledFromSettings(element) {
        return this.model.getBooleanSetting(this.idToCamelCase(element?.id)) ?? true;
    }
    getToolboxId(type) {
        if (type == "TextElement" || type == "Text") {
            return "text";
        }
        else if (type == "Text_BoxElement" || type == "TextBox") {
            return "textbox";
        }
        else if (type == "TableElement" || type == "Table") {
            return "table";
        }
        else if (type == "Single_SelectionElement" || type == "SingleSelection") {
            return "singleSelection";
        }
        else if (type == "SignatureElement" || type == "Signature") {
            return "signature";
        }
        else if (type == "PDFSignatureElement" || type == "PDFSignature") {
            return "PDFsignature";
        }
        else if (type == "PanelElement" || type == "Panel") {
            return "panel";
        }
        else if (type == "Number_BoxElement" || type == "NumberBox") {
            return "numberbox";
        }
        else if (type == "Multiple_SelectionElement" || type == "MultipleSelection") {
            return "multipleSelection";
        }
        else if (type == "List_BoxElement" || type == "ListBox") {
            return "listbox";
        }
        else if (type == "LineElement" || type == "Line") {
            return "line";
        }
        else if (type == "LabelElement" || type == "Label") {
            return "label";
        }
        else if (type == "ImageElement" || type == "Image") {
            return "image";
        }
        else if (type == "DateTime_BoxElement" || type == "DateTimeBox") {
            return "dateTime";
        }
        else if (type == "Combo_BoxElement" || type == "ComboBox") {
            return "combobox";
        }
        else if (type == "Check_BoxElement" || type == "CheckBox") {
            return "checkbox";
        }
        else if (type == "ButtonElement" || type == "Button") {
            return "button";
        }
        else if (type == "BarCodeElement" || type == "BarCode") {
            return "barcode";
        }
        else if (type == "AddressElement" || type == "Address") {
            return "address";
        }
    }
    idToCamelCase(id) {
        switch (id) {
            case "textbox":
                return "showTextBox";
            case "numberbox":
                return "showNumberBox";
            case "combobox":
                return "showComboBox";
            case "listbox":
                return "showListBox";
            case "singleSelection":
                return "showSingleSelection";
            case "multipleSelection":
                return "showMultipleSelection";
            case "checkbox":
                return "showCheckBox";
            case "signature":
                return "showSignature";
            /*  case "PDFsignature":
              return "showPDFSignature"; */
            case "dateTime":
                return "showDateTimeBox";
            case "table":
                return "showTable";
            case "button":
                return "showButton";
            case "barcode":
                return "showBarCode";
            case "address":
                return "showAddress";
            case "label":
                return "showLabel";
            case "text":
                return "showText";
            case "image":
                return "showImage";
            case "line":
                return "showLine";
            case "panel":
                return "showPanel";
        }
    }
    isGroupEnabled(group) {
        if (group.caption == "Input" ||
            group.caption == "Selection" ||
            group.caption == "Other" ||
            group.caption == "Divider") {
            if (group.caption == "Input") {
                if (!this.unusedElements?.find((item) => item == "textbox") ||
                    !this.unusedElements?.find((item) => item == "numberbox") ||
                    !this.unusedElements?.find((item) => item == "combobox") ||
                    !this.unusedElements?.find((item) => item == "dateTime")) {
                    return true;
                }
                else {
                    return false;
                }
            }
            else if (group.caption == "Selection") {
                if (!this.unusedElements?.find((item) => item == "singleSelection") ||
                    !this.unusedElements?.find((item) => item == "multipleSelection") ||
                    !this.unusedElements?.find((item) => item == "listbox") ||
                    !this.unusedElements?.find((item) => item == "checkbox")) {
                    return true;
                }
                else {
                    return false;
                }
            }
            else if (group.caption == "Other") {
                if (!this.unusedElements?.find((item) => item == "signature") ||
                    !this.unusedElements?.find((item) => item == "PDFsignature") ||
                    !this.unusedElements?.find((item) => item == "barcode") ||
                    !this.unusedElements?.find((item) => item == "address") ||
                    !this.unusedElements?.find((item) => item == "line")) {
                    return true;
                }
                else {
                    return false;
                }
            }
        }
        else {
            return true;
        }
    }
    isInsertInlineElementsDividerEnabled(element) {
        if (element.caption == "Divider") {
            if (!this.unusedElements?.find((item) => item == "textbox") ||
                !this.unusedElements?.find((item) => item == "numberbox") ||
                !this.unusedElements?.find((item) => item == "combobox") ||
                !this.unusedElements?.find((item) => item == "dateTime") ||
                !this.unusedElements?.find((item) => item == "singleSelection") ||
                !this.unusedElements?.find((item) => item == "multipleSelection") ||
                !this.unusedElements?.find((item) => item == "listbox") ||
                !this.unusedElements?.find((item) => item == "checkbox") ||
                !this.unusedElements?.find((item) => item == "signature") ||
                !this.unusedElements?.find((item) => item == "PDFsignature") ||
                !this.unusedElements?.find((item) => item == "barcode") ||
                !this.unusedElements?.find((item) => item == "address") ||
                !this.unusedElements?.find((item) => item == "line")) {
                return true;
            }
            else {
                return false;
            }
        }
        else {
            return false;
        }
    }
    isToolboxInlineElementsDividerEnabled(element) {
        if (element.caption == "Divider") {
            if (!this.unusedElements?.find((item) => item == "textbox") ||
                !this.unusedElements?.find((item) => item == "numberbox") ||
                !this.unusedElements?.find((item) => item == "combobox") ||
                !this.unusedElements?.find((item) => item == "dateTime") ||
                !this.unusedElements?.find((item) => item == "singleSelection") ||
                !this.unusedElements?.find((item) => item == "multipleSelection") ||
                !this.unusedElements?.find((item) => item == "listbox") ||
                !this.unusedElements?.find((item) => item == "checkbox") ||
                !this.unusedElements?.find((item) => item == "signature") ||
                !this.unusedElements?.find((item) => item == "PDFsignature") ||
                !this.unusedElements?.find((item) => item == "barcode") ||
                !this.unusedElements?.find((item) => item == "address") ||
                !this.unusedElements?.find((item) => item == "table") ||
                !this.unusedElements?.find((item) => item == "button")) {
                return true;
            }
            else {
                return false;
            }
        }
        else {
            return false;
        }
    }
    isInsertOutlineElementsDividerEnabled() {
        if (!this.unusedElements?.find((item) => item == "table") ||
            !this.unusedElements?.find((item) => item == "button") ||
            !this.unusedElements?.find((item) => item == "label") ||
            !this.unusedElements?.find((item) => item == "text") ||
            !this.unusedElements?.find((item) => item == "image") ||
            !this.unusedElements?.find((item) => item == "panel")) {
            return true;
        }
        else {
            return false;
        }
    }
    isToolboxOutlineElementsDividerEnabled() {
        if (!this.unusedElements?.find((item) => item == "label") ||
            !this.unusedElements?.find((item) => item == "text") ||
            !this.unusedElements?.find((item) => item == "image") ||
            !this.unusedElements?.find((item) => item == "line") ||
            !this.unusedElements?.find((item) => item == "panel")) {
            return true;
        }
        else {
            return false;
        }
    }
    haveEnabledComponents() {
        let isEnabled = false;
        for (let element of this.elements) {
            if (element.enabled) {
                isEnabled = true;
                break;
            }
        }
        return isEnabled;
    }
    constructor(mouseService, draggableService, model, loc) {
        this.mouseService = mouseService;
        this.draggableService = draggableService;
        this.model = model;
        this.loc = loc;
        this.showGroupPreview = false;
        this.elementsForRibbon = [
            {
                caption: "Input",
                image: "images.Toolbox.StiTextBoxElement.png",
                category: "PropertyMain",
            },
            {
                caption: "Selection",
                image: "images.Toolbox.StiSingleSelectionElement.png",
            },
            {
                caption: "Others",
                image: "images.Toolbox.StiSignatureElement.png",
                category: "FormDesigner",
            },
            { caption: "Divider" },
            {
                caption: "StiTable",
                image: "images.Toolbox.StiTableElement.png",
                id: "table",
                component: StiTableComponent,
                element: StiTableElement,
                setForm: true
            },
            {
                caption: "StiButton",
                image: "images.Toolbox.StiButtonElement.png",
                id: "button",
                component: StiButtonComponent,
                element: StiButtonElement,
            },
            {
                caption: "StiLabelControl",
                image: "images.Toolbox.StiLabelElement.png",
                id: "label",
                component: StiLabelComponent,
                element: StiLabelElement,
                category: "Dialogs",
            },
            {
                caption: "StiText",
                image: "images.Toolbox.StiRichTextElement.png",
                id: "text",
                component: StiTextComponent,
                element: StiTextElement,
            },
            {
                caption: "StiImage",
                image: "images.Toolbox.StiImageElement.png",
                id: "image",
                component: StiImageComponent,
                element: StiImageElement,
            },
            {
                caption: "StiPanel",
                image: "images.Toolbox.StiPanelElement.png",
                id: "panel",
                component: StiPanelComponent,
                element: StiPanelElement,
            },
        ];
        this.inputGroup = [
            {
                caption: "StiTextBoxControl",
                image: "images.Toolbox.StiTextBoxElement.png",
                id: "textbox",
                component: StiTextBoxComponent,
                element: StiTextBoxElement,
                category: "Dialogs",
            },
            {
                caption: "StiNumberBox",
                image: "images.Toolbox.StiNumberBoxElement.png",
                id: "numberbox",
                component: StiNumberBoxComponent,
                element: StiNumberBoxElement,
            },
            {
                caption: "StiComboBox",
                image: "images.Toolbox.StiComboBoxElement.png",
                id: "combobox",
                component: StiComboBoxComponent,
                element: StiComboBoxElement,
            },
            {
                caption: "StiDateTimePickerControl",
                image: "images.Toolbox.StiDateTimeBoxElement.png",
                id: "dateTime",
                component: StiDateTimeBoxComponent,
                element: StiDateTimeBoxElement,
                setForm: true,
                category: "Dialogs",
            },
        ];
        this.selectionGroup = [
            {
                caption: "StiSingleSelection",
                image: "images.Toolbox.StiSingleSelectionElement.png",
                id: "singleSelection",
                component: StiSingleSelectionComponent,
                element: StiSingleSelectionElement,
            },
            {
                caption: "StiMultipleSelection",
                image: "images.Toolbox.StiMultipleSelectionElement.png",
                id: "multipleSelection",
                component: StiMultipleSelectionComponent,
                element: StiMultipleSelectionElement,
            },
            {
                caption: "StiListBox",
                image: "images.Toolbox.StiListBoxElement.png",
                id: "listbox",
                component: StiListBoxComponent,
                element: StiListBoxElement,
            },
            {
                caption: "StiCheckBox",
                image: "images.Toolbox.StiCheckBoxElement.png",
                id: "checkbox",
                component: StiCheckBoxComponent,
                element: StiCheckBoxElement,
            },
        ];
        this.otherGroup = [
            {
                caption: "StiElectronicSignature",
                image: "images.Toolbox.StiElectronicSignature.png",
                id: "signature",
                component: StiSignatureComponent,
                element: StiSignatureElement,
            },
            {
                caption: "StiPdfDigitalSignature",
                image: "images.Toolbox.StiPdfDigitalSignature.png",
                id: "PDFsignature",
                component: StiPDFSignatureComponent,
                element: StiPDFSignatureElement,
            },
            {
                caption: "StiBarCode",
                image: "images.Toolbox.StiBarCodeElement.png",
                id: "barcode",
                component: StiBarcodeComponent,
                element: StiBarcodeElement,
            },
            {
                caption: "Address",
                image: "images.Toolbox.Address.png",
                id: "address",
                component: StiAddressComponent,
                element: StiAddressElement,
                category: "Report",
            },
            {
                caption: "Line",
                image: "images.Toolbox.StiLineElement.png",
                id: "line",
                component: StiLineComponent,
                element: StiLineElement,
                category: "Chart",
            },
        ];
        this.elements = [
            {
                caption: "StiTextBoxControl",
                image: "images.Toolbox.StiTextBoxElement.png",
                id: "textbox",
                component: StiTextBoxComponent,
                element: StiTextBoxElement,
                enabled: true,
                category: "Dialogs",
            },
            {
                caption: "StiNumberBox",
                image: "images.Toolbox.StiNumberBoxElement.png",
                id: "numberbox",
                component: StiNumberBoxComponent,
                element: StiNumberBoxElement,
                enabled: true,
            },
            {
                caption: "StiComboBox",
                image: "images.Toolbox.StiComboBoxElement.png",
                id: "combobox",
                component: StiComboBoxComponent,
                element: StiComboBoxElement,
                enabled: true,
            },
            {
                caption: "StiListBox",
                image: "images.Toolbox.StiListBoxElement.png",
                id: "listbox",
                component: StiListBoxComponent,
                element: StiListBoxElement,
                enabled: true,
            },
            {
                caption: "StiSingleSelection",
                image: "images.Toolbox.StiSingleSelectionElement.png",
                id: "singleSelection",
                component: StiSingleSelectionComponent,
                element: StiSingleSelectionElement,
                enabled: true,
            },
            {
                caption: "StiMultipleSelection",
                image: "images.Toolbox.StiMultipleSelectionElement.png",
                id: "multipleSelection",
                component: StiMultipleSelectionComponent,
                element: StiMultipleSelectionElement,
                enabled: true,
            },
            {
                caption: "StiCheckBox",
                image: "images.Toolbox.StiCheckBoxElement.png",
                id: "checkbox",
                component: StiCheckBoxComponent,
                element: StiCheckBoxElement,
                enabled: true,
            },
            {
                caption: "StiElectronicSignature",
                image: "images.Toolbox.StiElectronicSignature.png",
                id: "signature",
                component: StiSignatureComponent,
                element: StiSignatureElement,
                enabled: true,
            },
            {
                caption: "StiPdfDigitalSignature",
                image: "images.Toolbox.StiPdfDigitalSignature.png",
                id: "PDFsignature",
                component: StiPDFSignatureComponent,
                element: StiPDFSignatureElement,
                enabled: true,
            },
            {
                caption: "StiDateTimePickerControl",
                image: "images.Toolbox.StiDateTimeBoxElement.png",
                id: "dateTime",
                component: StiDateTimeBoxComponent,
                element: StiDateTimeBoxElement,
                enabled: true,
                category: "Dialogs",
            },
            {
                caption: "StiTable",
                image: "images.Toolbox.StiTableElement.png",
                id: "table",
                component: StiTableComponent,
                element: StiTableElement,
                enabled: true,
                setForm: true
            },
            {
                caption: "StiButton",
                image: "images.Toolbox.StiButtonElement.png",
                id: "button",
                component: StiButtonComponent,
                element: StiButtonElement,
                enabled: true,
            },
            {
                caption: "StiBarCode",
                image: "images.Toolbox.StiBarCodeElement.png",
                id: "barcode",
                component: StiBarcodeComponent,
                element: StiBarcodeElement,
                enabled: true,
            },
            {
                caption: "Address",
                image: "images.Toolbox.Address.png",
                id: "address",
                component: StiAddressComponent,
                element: StiAddressElement,
                enabled: true,
                category: "Report",
            },
            { caption: "Divider" },
            {
                caption: "StiLabelControl",
                image: "images.Toolbox.StiLabelElement.png",
                id: "label",
                component: StiLabelComponent,
                element: StiLabelElement,
                enabled: true,
                category: "Dialogs",
            },
            {
                caption: "StiText",
                image: "images.Toolbox.StiRichTextElement.png",
                id: "text",
                component: StiTextComponent,
                element: StiTextElement,
                enabled: true,
            },
            {
                caption: "StiImage",
                image: "images.Toolbox.StiImageElement.png",
                id: "image",
                component: StiImageComponent,
                element: StiImageElement,
                enabled: true,
            },
            {
                caption: "Line",
                image: "images.Toolbox.StiLineElement.png",
                id: "line",
                component: StiLineComponent,
                element: StiLineElement,
                enabled: true,
                category: "Chart",
            },
            {
                caption: "StiPanel",
                image: "images.Toolbox.StiPanelElement.png",
                id: "panel",
                component: StiPanelComponent,
                element: StiPanelElement,
                enabled: true,
            },
        ];
        this.unusedElements = [];
        this.subject = new Subject();
        this.showToolbox = true;
        mouseService.getDocumentMouseMove().subscribe((event) => {
            this.onMouseMove(event);
        });
        mouseService.getDocumentMouseUp().subscribe(() => {
            // this.mouseDownComponent = null;
        });
    }
    getMessage() {
        return this.subject.asObservable();
    }
    elementMouseDown(component, event) {
        this.mouseDownComponent = component;
        this.mouseDownX = event.clientX;
        this.mouseDownY = event.clientY;
    }
    elementDoubleClick(component) {
        this.mouseDownComponent = null;
        let element = new component.element.element(component.element.setForm ? this.model.form : undefined);
        this.model.form.settings.applySettings(element);
        this.draggableService.addingByDoubleClick(element);
    }
    onMouseMove(event) {
        if (this.mouseDownComponent &&
            Math.max(Math.abs(this.mouseDownX - event.clientX), Math.abs(this.mouseDownY - event.clientY)) >
                StiDraggableService.MOUSE_DELTA) {
            let element = new this.mouseDownComponent.element.element(this.mouseDownComponent.element.setForm ? this.model.form : undefined);
            this.model.form.settings.applySettings(element);
            this.model.elementToUpdate = element;
            this.draggableService.startDrag(event, element);
            if (this.model.showGroupPreview) {
                this.model.showGroupPreview = false;
            }
            this.mouseDownComponent = null;
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiToolboxService, deps: [{ token: i1.StiMouseService }, { token: i2.StiDraggableService }, { token: i3.StiModelService }, { token: i4.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiToolboxService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiToolboxService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.StiMouseService }, { type: i2.StiDraggableService }, { type: i3.StiModelService }, { type: i4.StiLocalizationService }] });
//# sourceMappingURL=data:application/json;base64,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