import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
export class StiTabIndexService {
    constructor(model) {
        this.model = model;
        model.interfaceEvent.subscribe((event) => {
            if (event.name == "setRibbon" && event.data?.ribbon === "Preview") {
                this.arrangeTabIndex();
            }
        });
        model.formEvents.subscribe((event) => {
            if (event.name == "SetForm" && model.viewerMode) {
                this.arrangeTabIndex();
            }
        });
    }
    arrangeTabIndex() {
        let elements = [];
        this.model.form?.pages.forEach((form, pageIndex) => {
            form.allElements.filter(e => e["setTabIndex"] != null).forEach(element => {
                elements.push({
                    element: element,
                    geometry: element.geometry,
                    pageIndex: pageIndex
                });
            });
        });
        elements.sort((e1, e2) => {
            if (e1.pageIndex != e2.pageIndex) {
                return e1.pageIndex > e2.pageIndex ? 1 : -1;
            }
            else if (e1.geometry.y != e2.geometry.y) {
                return e1.geometry.y > e2.geometry.y ? 1 : -1;
            }
            else {
                return e1.geometry.x > e2.geometry.x ? 1 : -1;
            }
        });
        let tabIndex = 100;
        elements.forEach(e => tabIndex = e.element.setTabIndex(tabIndex));
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTabIndexService, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTabIndexService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTabIndexService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.StiModelService }] });
//# sourceMappingURL=data:application/json;base64,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