import { Injectable } from "@angular/core";
import { Subject } from "rxjs";
import { StiSignatureElement } from "../elements/StiSignatureElement";
import { StiTextItem } from "../elements/text/StiTextItem";
import StiJson from "../system/StiJson";
import { StiImageEditorResult } from "../elements/signature/StiImageEditorResult";
import { StiHorizontalAlignment, StiVerticalAlignment } from "../system/enums";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
export class SignatureService {
    checkLoading() {
        if (this.completedLoadingImages === this.currentActiveLoadingImages) {
            this.completedLoading.next(true);
            this.completedLoadingImages = 0;
            this.currentActiveLoadingImages = 0;
        }
        else {
            setTimeout(() => {
                this.checkLoading();
            });
        }
    }
    getVerticalPosition(verticalAlignment) {
        switch (verticalAlignment) {
            case StiVerticalAlignment.Top:
                return "top";
            case StiVerticalAlignment.Bottom:
                return "bottom";
            case StiVerticalAlignment.Center:
                return "center";
        }
    }
    getHorizontalPosition(horizontalAlignment) {
        switch (horizontalAlignment) {
            case StiHorizontalAlignment.Left:
                return "left";
            case StiHorizontalAlignment.Right:
                return "right";
            case StiHorizontalAlignment.Center:
                return "center";
        }
    }
    getClass(item) {
        if (item == "Text") {
            return StiTextItem;
        }
        else if (item == "Image") {
            return StiImageEditorResult;
        }
    }
    setTemplate(template) {
        if (template.type == "Image") {
            this.currentEditableImage = template.image;
            this.currentEditableText = template.text;
            this.currentCanvasContent = template.drawedImage;
            this.selectedMode = "Draw";
        }
        else {
            this.currentPreviewFont = template.specialFont;
            this.currentEditableFullName = template.fullName;
            this.currentEditableInitials = template.initials;
            this.selectedMode = "Type";
        }
        this.showSavedTemplates = false;
    }
    getTemplateImage(template) {
        return "url(" + template?.image?.loadedImage + ")";
    }
    getTemplateDrawedImage(template) {
        return "url(" + template?.image?.drawedImage + ")";
    }
    deleteTemplate(index) {
        this.savedTemplates.splice(index, 1);
    }
    getTemplateHorizontalAlignment(template) {
        if (template.image.horizontalAlignment == StiHorizontalAlignment.Center) {
            return "center";
        }
        else if (template.image.horizontalAlignment == StiHorizontalAlignment.Left) {
            return "start";
        }
        else {
            return "end";
        }
    }
    getTemplateBackgroundSize(template, container) {
        if (!template?.image?.loadedImage) {
            return;
        }
        if (template?.image?.aspectRatio) {
            return "contain";
        }
        if (template?.image?.stretch) {
            return `${container.offsetWidth}px ${container.offsetHeight}px`;
        }
        else {
            return `${template?.image?.naturalWidth}px ${template?.image?.naturalHeight}px`;
        }
    }
    getTemplateBackgroundPosition(template) {
        if (!template?.image?.aspectRatio && !template?.image?.stretch) {
            if (template?.image?.verticalAlignment == StiVerticalAlignment.Center) {
                return "center center";
            }
            else if (template?.image?.verticalAlignment == StiVerticalAlignment.Top) {
                return "top center";
            }
            else {
                return "bottom center";
            }
        }
        else {
            return "center";
        }
    }
    cloneProperty(property, propertyClass) {
        let result = new propertyClass();
        let jObject = new StiJson();
        jObject.deserialize(property.saveToJsonObject({}).serialize());
        result.loadFromJsonObject(jObject);
        return result;
    }
    get editorComponentX() {
        return this._editorComponentX;
    }
    set editorComponentX(value) {
        value <= 0 ? (this._editorComponentX = 0) : (this._editorComponentX = value);
    }
    get editorComponentY() {
        return this._editorComponentY;
    }
    set editorComponentY(value) {
        value <= 0 ? (this._editorComponentY = 0) : (this._editorComponentY = value);
    }
    get y() {
        if (this.isSignature) {
            let container = document.getElementById(this.model.selectedComponent?.element.guid);
            let geom = this.model.getPositionRelativeToForm(container);
            return geom.y;
        }
        else {
            return 0;
        }
    }
    get x() {
        if (this.isSignature) {
            let container = document.getElementById(this.model.selectedComponent?.element.guid);
            let geom = this.model.getPositionRelativeToForm(container);
            return geom.x + geom.width + 5;
        }
        else {
            return 0;
        }
    }
    changeDrawingMode() {
        this.textMode = false;
        this.drawingMode = !this.drawingMode;
    }
    changeTextMode() {
        this.drawingMode = false;
        this.textMode = !this.textMode;
    }
    clear() {
        this.clearButtonClick.next(true);
    }
    onFileSelected() {
        let input = document.createElement("input");
        input.type = "file";
        input.accept = ".png, .jpg, .jpeg";
        let this_ = this;
        input.onchange = (_) => {
            this_.clear();
            let file = Array.from(input.files)[0];
            var reader = new FileReader();
            reader.readAsDataURL(file);
            reader.onload = function (e) {
                this_.loadedImage.next(e.target.result);
            };
        };
        input.click();
    }
    get isSignature() {
        return this.model.selectedComponent?.element instanceof StiSignatureElement ? true : false;
    }
    constructor(model) {
        this.model = model;
        this._editorComponentX = 0;
        this._editorComponentY = 0;
        this.textMode = false;
        this.selectedMode = "Draw";
        this.previewFonts = ["Teddy Bear", "MADE Likes Script", "Denistina"];
        this.currentPreviewFont = "Teddy Bear";
        this.drawingMode = false;
        this.showFontsPreview = false;
        this.loadedImage = new Subject();
        this.clearButtonClick = new Subject();
        this.updateSignature = new Subject();
        this.getInsertedInformation = new Subject();
        this.currentEditableText = new StiTextItem();
        this.editorComponentHeight = 350;
        this.editorComponentWidth = 365;
        this.fontsPreviewX = 0;
        this.fontsPreviewY = 0;
        this.templatesPreviewX = 0;
        this.templatesPreviewY = 0;
        this.showSavedTemplates = false;
        this.savedTemplates = [];
        this.currentActiveLoadingImages = 0;
        this.completedLoadingImages = 0;
        this.completedLoading = new Subject();
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: SignatureService, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: SignatureService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: SignatureService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.StiModelService }] });
//# sourceMappingURL=data:application/json;base64,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