import { Injectable } from "@angular/core";
import StiRectangleGeometryLayout from "../computed/StiRectangleGeometryLayout";
import { StiAddressElement } from "../elements/StiAddressElement";
import { StiBarcodeElement } from "../elements/StiBarcodeElement";
import { StiButtonElement } from "../elements/StiButtonElement";
import { StiCheckBoxElement } from "../elements/StiCheckBoxElement";
import { StiComboBoxElement } from "../elements/StiComboBoxElement";
import { StiDateTimeBoxElement } from "../elements/StiDateTimeBoxElement";
import { StiForm } from "../elements/StiForm";
import { StiFormPageElement } from "../elements/StiFormPageElement";
import { StiImageElement } from "../elements/StiImageElement";
import { StiLabelElement } from "../elements/StiLabelElement";
import StiLineElement from "../elements/StiLineElement";
import { StiListBoxElement } from "../elements/StiListBoxElement";
import { StiMultipleSelectionElement } from "../elements/StiMultipleSelectionElement";
import { StiNumberBoxElement } from "../elements/StiNumberBoxElement";
import { StiPanelElement } from "../elements/StiPanelElement";
import { StiPDFSignatureElement } from "../elements/StiPDFSignatureElement";
import { StiSignatureElement } from "../elements/StiSignatureElement";
import { StiSingleSelectionElement } from "../elements/StiSingleSelectionElement";
import { StiTableElement } from "../elements/StiTableElement";
import { StiTextBoxElement } from "../elements/StiTextBoxElement";
import { StiTextElement } from "../elements/StiTextElement";
import { StiLabelColumnItem } from "../elements/table/columns/StiLabelColumnItem";
import { StiNumberBoxColumnItem } from "../elements/table/columns/StiNumberBoxColumnItem";
import { StiTotalsFieldItem } from "../elements/table/StiTotalsFieldItem";
import { Enum } from "../system/Enum";
import { StiBarcodeType } from "../system/enums";
import Guid from "../system/Guid";
import StiJson from "../system/StiJson";
import { StiLocalizationService } from "./sti-localization.service";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./sti-localization.service";
export class StiHelperService {
    getProperty(element, prop) {
        let props = prop.split(".");
        return prop.indexOf(".") == -1
            ? element[prop]
            : this.getProperty(element[props[0]], props.splice(1, props.length).join("."));
    }
    setProperty(element, prop, value) {
        let props = prop.split(".");
        if (prop.indexOf(".") == -1) {
            element[prop] = value;
        }
        else {
            element[props[0]][props[1]] = value;
        }
    }
    constructor(model, render, loc, zone) {
        this.model = model;
        this.render = render;
        this.loc = loc;
        this.zone = zone;
        this._fonts = [];
        this._numberTypes = [];
        this._rangeFormats = [];
        this._signatureTypes = [];
        this._dateTimeTypes = [];
        this._buttonTypes = [];
        this._columnTypes = [];
        this._buttonSendTypes = [];
        this._thousandSeparators = [];
        this._barcodeTypes = [];
        this._dateTimeValues = [];
        this._themes = [];
        this._borderWeights = [];
        this._unitAlignment = [];
        this._minUnitAlignment = [];
        this._labelFormat = [];
        this._penStyles = [];
        this._algorithmExpressions = [];
        this._dateTimeFormats = [];
        this._dateFormats = [];
        this._timeFormats = [];
        this._cultures = [];
        this._signatureEditorModes = [];
        this._signatureSpecialFonts = [];
        this._fontSizes = [5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16, 18, 20, 22, 24, 26, 28, 36, 44, 58, 72];
        this._richTextFontSizes = [];
        this._errorCorrectionLevel = ["Level1", "Level2", "Level3", "Level4"];
        this._fileMenuItems = [];
        this._dataMatrixSize = [
            "Automatic",
            "v1",
            "v2",
            "v3",
            "v4",
            "v5",
            "v6",
            "v7",
            "v8",
            "v9",
            "v10",
            "v11",
            "v12",
            "v13",
            "v14",
            "v15",
            "v16",
            "v17",
            "v18",
            "v19",
            "v20",
            "v21",
            "v22",
            "v23",
            "v24",
            "v25",
            "v26",
            "v27",
            "v28",
            "v29",
            "v30",
            "v31",
            "v32",
            "v33",
            "v34",
            "v35",
            "v36",
            "v37",
            "v38",
            "v39",
            "v40",
        ];
        this._bodyShapeType = [
            "Square",
            "RoundedSquare",
            "Dot",
            "Circle",
            "Diamond",
            "Star",
            "ZebraHorizontal",
            "ZebraVertical",
            "ZebraCross1",
            "ZebraCross2",
            "Circular",
            "DockedDiamonds",
        ];
        this._eyeFrameShapeType = ["Square", "Dots", "Circle", "Round", "Round1", "Round3"];
        this._eyeBallShapeType = [
            "Square",
            "Dots",
            "Circle",
            "Round",
            "Round1",
            "Round3",
            "Star",
            "ZebraHorizontal",
            "ZebraVertical",
        ];
        this._brushIdent = ["Empty", "Solid", "Gradient", "Glare", "Glass", "Hatch", "Default", "Style"];
        this._bodyBrush = ["Empty", "Solid", "Hatch", "Gradient", "Glare", "Glass"];
        this.hatchStyle = [
            { name: "Horizontal", value: 0 },
            { name: "Vertical", value: 1 },
            { name: "ForwardDiagonal", value: 2 },
            { name: "BackwardDiagonal", value: 3 },
            { name: "Cross", value: 4 },
            { name: "DiagonalCross", value: 5 },
            { name: "Percent05", value: 6 },
            { name: "Percent10", value: 7 },
            { name: "Percent20", value: 8 },
            { name: "Percent25", value: 9 },
            { name: "Percent30", value: 10 },
            { name: "Percent40", value: 11 },
            { name: "Percent50", value: 12 },
            { name: "Percent60", value: 13 },
            { name: "Percent70", value: 14 },
            { name: "Percent75", value: 0xf },
            { name: "Percent80", value: 0x10 },
            { name: "Percent90", value: 17 },
            { name: "LightDownwardDiagonal", value: 18 },
            { name: "LightUpwardDiagonal", value: 19 },
            { name: "DarkDownwardDiagonal", value: 20 },
            { name: "DarkUpwardDiagonal", value: 21 },
            { name: "WideDownwardDiagonal", value: 22 },
            { name: "WideUpwardDiagonal", value: 23 },
            { name: "LightVertical", value: 24 },
            { name: "LightHorizontal", value: 25 },
            { name: "NarrowVertical", value: 26 },
            { name: "NarrowHorizontal", value: 27 },
            { name: "DarkVertical", value: 28 },
            { name: "DarkHorizontal", value: 29 },
            { name: "DashedDownwardDiagonal", value: 30 },
            { name: "DashedUpwardDiagonal", value: 0x1f },
            { name: "DashedHorizontal", value: 0x20 },
            { name: "DashedVertical", value: 33 },
            { name: "SmallConfetti", value: 34 },
            { name: "LargeConfetti", value: 35 },
            { name: "ZigZag", value: 36 },
            { name: "Wave", value: 37 },
            { name: "DiagonalBrick", value: 38 },
            { name: "HorizontalBrick", value: 39 },
            { name: "Weave", value: 40 },
            { name: "Plaid", value: 41 },
            { name: "Divot", value: 42 },
            { name: "DottedGrid", value: 43 },
            { name: "DottedDiamond", value: 44 },
            { name: "Shingle", value: 45 },
            { name: "Trellis", value: 46 },
            { name: "Sphere", value: 47 },
            { name: "SmallGrid", value: 48 },
            { name: "SmallCheckerBoard", value: 49 },
            { name: "LargeCheckerBoard", value: 50 },
            { name: "OutlinedDiamond", value: 51 },
            { name: "SolidDiamond", value: 52 },
            { name: "LargeGrid", value: 4 },
            { name: "Min", value: 0 },
            { name: "Max", value: 4 },
        ];
        this.justifyOptions = [
            {
                image: "images.Properties.AlignLeft.png",
                value: 1,
                name: "Left",
            },
            {
                image: "images.Properties.AlignCenter.png",
                value: 2,
                name: "Center",
            },
            {
                image: "images.Properties.AlignRight.png",
                value: 3,
                name: "Right",
            },
        ];
        this.labelAlignment = [
            {
                image: "images.Properties.Left.png",
                value: 1,
                name: "Left",
            },
            {
                image: "images.Properties.Right.png",
                value: 2,
                name: "Right",
            },
            {
                image: "images.Properties.Top.png",
                value: 3,
                name: "Top",
            },
        ];
        this.verticalAlignment = [
            {
                image: "images.Properties.AlignTop.png",
                value: 1,
                name: "Top",
            },
            {
                image: "images.Properties.AlignMiddle.png",
                value: 2,
                name: "Center",
            },
            {
                image: "images.Properties.AlignBottom.png",
                value: 3,
                name: "Bottom",
            },
        ];
        this.styleOptions = [
            {
                name: "B",
                value: "Bold",
                image: "images.Properties.FontStyleBold.png",
            },
            {
                name: "I",
                value: "Italic",
                image: "images.Properties.FontStyleItalic.png",
            },
            {
                name: "U",
                value: "Underline",
                image: "images.Properties.FontStyleUnderline.png",
            },
        ];
        this.countries = [
            { name: "Afghanistan", code: "AF" },
            { name: "Åland Islands", code: "AX" },
            { name: "Albania", code: "AL" },
            { name: "Algeria", code: "DZ" },
            { name: "American Samoa", code: "AS" },
            { name: "AndorrA", code: "AD" },
            { name: "Angola", code: "AO" },
            { name: "Anguilla", code: "AI" },
            { name: "Antarctica", code: "AQ" },
            { name: "Antigua and Barbuda", code: "AG" },
            { name: "Argentina", code: "AR" },
            { name: "Armenia", code: "AM" },
            { name: "Aruba", code: "AW" },
            { name: "Australia", code: "AU" },
            { name: "Austria", code: "AT" },
            { name: "Azerbaijan", code: "AZ" },
            { name: "Bahamas", code: "BS" },
            { name: "Bahrain", code: "BH" },
            { name: "Bangladesh", code: "BD" },
            { name: "Barbados", code: "BB" },
            { name: "Belarus", code: "BY" },
            { name: "Belgium", code: "BE" },
            { name: "Belize", code: "BZ" },
            { name: "Benin", code: "BJ" },
            { name: "Bermuda", code: "BM" },
            { name: "Bhutan", code: "BT" },
            { name: "Bolivia", code: "BO" },
            { name: "Bosnia and Herzegovina", code: "BA" },
            { name: "Botswana", code: "BW" },
            { name: "Bouvet Island", code: "BV" },
            { name: "Brazil", code: "BR" },
            { name: "British Indian Ocean Territory", code: "IO" },
            { name: "Brunei Darussalam", code: "BN" },
            { name: "Bulgaria", code: "BG" },
            { name: "Burkina Faso", code: "BF" },
            { name: "Burundi", code: "BI" },
            { name: "Cambodia", code: "KH" },
            { name: "Cameroon", code: "CM" },
            { name: "Canada", code: "CA" },
            { name: "Cape Verde", code: "CV" },
            { name: "Cayman Islands", code: "KY" },
            { name: "Central African Republic", code: "CF" },
            { name: "Chad", code: "TD" },
            { name: "Chile", code: "CL" },
            { name: "China", code: "CN" },
            { name: "Christmas Island", code: "CX" },
            { name: "Cocos (Keeling) Islands", code: "CC" },
            { name: "Colombia", code: "CO" },
            { name: "Comoros", code: "KM" },
            { name: "Congo", code: "CG" },
            { name: "Congo, The Democratic Republic of the", code: "CD" },
            { name: "Cook Islands", code: "CK" },
            { name: "Costa Rica", code: "CR" },
            { name: "Cote D'Ivoire", code: "CI" },
            { name: "Croatia", code: "HR" },
            { name: "Cuba", code: "CU" },
            { name: "Cyprus", code: "CY" },
            { name: "Czech Republic", code: "CZ" },
            { name: "Denmark", code: "DK" },
            { name: "Djibouti", code: "DJ" },
            { name: "Dominica", code: "DM" },
            { name: "Dominican Republic", code: "DO" },
            { name: "Ecuador", code: "EC" },
            { name: "Egypt", code: "EG" },
            { name: "El Salvador", code: "SV" },
            { name: "Equatorial Guinea", code: "GQ" },
            { name: "Eritrea", code: "ER" },
            { name: "Estonia", code: "EE" },
            { name: "Ethiopia", code: "ET" },
            { name: "Falkland Islands (Malvinas)", code: "FK" },
            { name: "Faroe Islands", code: "FO" },
            { name: "Fiji", code: "FJ" },
            { name: "Finland", code: "FI" },
            { name: "France", code: "FR" },
            { name: "French Guiana", code: "GF" },
            { name: "French Polynesia", code: "PF" },
            { name: "French Southern Territories", code: "TF" },
            { name: "Gabon", code: "GA" },
            { name: "Gambia", code: "GM" },
            { name: "Georgia", code: "GE" },
            { name: "Germany", code: "DE" },
            { name: "Ghana", code: "GH" },
            { name: "Gibraltar", code: "GI" },
            { name: "Greece", code: "GR" },
            { name: "Greenland", code: "GL" },
            { name: "Grenada", code: "GD" },
            { name: "Guadeloupe", code: "GP" },
            { name: "Guam", code: "GU" },
            { name: "Guatemala", code: "GT" },
            { name: "Guernsey", code: "GG" },
            { name: "Guinea", code: "GN" },
            { name: "Guinea-Bissau", code: "GW" },
            { name: "Guyana", code: "GY" },
            { name: "Haiti", code: "HT" },
            { name: "Heard Island and Mcdonald Islands", code: "HM" },
            { name: "Holy See (Vatican City State)", code: "VA" },
            { name: "Honduras", code: "HN" },
            { name: "Hong Kong", code: "HK" },
            { name: "Hungary", code: "HU" },
            { name: "Iceland", code: "IS" },
            { name: "India", code: "IN" },
            { name: "Indonesia", code: "ID" },
            { name: "Iran, Islamic Republic Of", code: "IR" },
            { name: "Iraq", code: "IQ" },
            { name: "Ireland", code: "IE" },
            { name: "Isle of Man", code: "IM" },
            { name: "Israel", code: "IL" },
            { name: "Italy", code: "IT" },
            { name: "Jamaica", code: "JM" },
            { name: "Japan", code: "JP" },
            { name: "Jersey", code: "JE" },
            { name: "Jordan", code: "JO" },
            { name: "Kazakhstan", code: "KZ" },
            { name: "Kenya", code: "KE" },
            { name: "Kiribati", code: "KI" },
            { name: "Korea, Democratic People'S Republic of", code: "KP" },
            { name: "Korea, Republic of", code: "KR" },
            { name: "Kuwait", code: "KW" },
            { name: "Kyrgyzstan", code: "KG" },
            { name: "Lao People'S Democratic Republic", code: "LA" },
            { name: "Latvia", code: "LV" },
            { name: "Lebanon", code: "LB" },
            { name: "Lesotho", code: "LS" },
            { name: "Liberia", code: "LR" },
            { name: "Libyan Arab Jamahiriya", code: "LY" },
            { name: "Liechtenstein", code: "LI" },
            { name: "Lithuania", code: "LT" },
            { name: "Luxembourg", code: "LU" },
            { name: "Macao", code: "MO" },
            { name: "Macedonia, The Former Yugoslav Republic of", code: "MK" },
            { name: "Madagascar", code: "MG" },
            { name: "Malawi", code: "MW" },
            { name: "Malaysia", code: "MY" },
            { name: "Maldives", code: "MV" },
            { name: "Mali", code: "ML" },
            { name: "Malta", code: "MT" },
            { name: "Marshall Islands", code: "MH" },
            { name: "Martinique", code: "MQ" },
            { name: "Mauritania", code: "MR" },
            { name: "Mauritius", code: "MU" },
            { name: "Mayotte", code: "YT" },
            { name: "Mexico", code: "MX" },
            { name: "Micronesia, Federated States of", code: "FM" },
            { name: "Moldova, Republic of", code: "MD" },
            { name: "Monaco", code: "MC" },
            { name: "Mongolia", code: "MN" },
            { name: "Montserrat", code: "MS" },
            { name: "Morocco", code: "MA" },
            { name: "Mozambique", code: "MZ" },
            { name: "Myanmar", code: "MM" },
            { name: "Namibia", code: "NA" },
            { name: "Nauru", code: "NR" },
            { name: "Nepal", code: "NP" },
            { name: "Netherlands", code: "NL" },
            { name: "Netherlands Antilles", code: "AN" },
            { name: "New Caledonia", code: "NC" },
            { name: "New Zealand", code: "NZ" },
            { name: "Nicaragua", code: "NI" },
            { name: "Niger", code: "NE" },
            { name: "Nigeria", code: "NG" },
            { name: "Niue", code: "NU" },
            { name: "Norfolk Island", code: "NF" },
            { name: "Northern Mariana Islands", code: "MP" },
            { name: "Norway", code: "NO" },
            { name: "Oman", code: "OM" },
            { name: "Pakistan", code: "PK" },
            { name: "Palau", code: "PW" },
            { name: "Palestinian Territory, Occupied", code: "PS" },
            { name: "Panama", code: "PA" },
            { name: "Papua New Guinea", code: "PG" },
            { name: "Paraguay", code: "PY" },
            { name: "Peru", code: "PE" },
            { name: "Philippines", code: "PH" },
            { name: "Pitcairn", code: "PN" },
            { name: "Poland", code: "PL" },
            { name: "Portugal", code: "PT" },
            { name: "Puerto Rico", code: "PR" },
            { name: "Qatar", code: "QA" },
            { name: "Reunion", code: "RE" },
            { name: "Romania", code: "RO" },
            { name: "Russian Federation", code: "RU" },
            { name: "RWANDA", code: "RW" },
            { name: "Saint Helena", code: "SH" },
            { name: "Saint Kitts and Nevis", code: "KN" },
            { name: "Saint Lucia", code: "LC" },
            { name: "Saint Pierre and Miquelon", code: "PM" },
            { name: "Saint Vincent and the Grenadines", code: "VC" },
            { name: "Samoa", code: "WS" },
            { name: "San Marino", code: "SM" },
            { name: "Sao Tome and Principe", code: "ST" },
            { name: "Saudi Arabia", code: "SA" },
            { name: "Senegal", code: "SN" },
            { name: "Serbia and Montenegro", code: "CS" },
            { name: "Seychelles", code: "SC" },
            { name: "Sierra Leone", code: "SL" },
            { name: "Singapore", code: "SG" },
            { name: "Slovakia", code: "SK" },
            { name: "Slovenia", code: "SI" },
            { name: "Solomon Islands", code: "SB" },
            { name: "Somalia", code: "SO" },
            { name: "South Africa", code: "ZA" },
            { name: "South Georgia and the South Sandwich Islands", code: "GS" },
            { name: "Spain", code: "ES" },
            { name: "Sri Lanka", code: "LK" },
            { name: "Sudan", code: "SD" },
            { name: "Suriname", code: "SR" },
            { name: "Svalbard and Jan Mayen", code: "SJ" },
            { name: "Swaziland", code: "SZ" },
            { name: "Sweden", code: "SE" },
            { name: "Switzerland", code: "CH" },
            { name: "Syrian Arab Republic", code: "SY" },
            { name: "Taiwan, Province of China", code: "TW" },
            { name: "Tajikistan", code: "TJ" },
            { name: "Tanzania, United Republic of", code: "TZ" },
            { name: "Thailand", code: "TH" },
            { name: "Timor-Leste", code: "TL" },
            { name: "Togo", code: "TG" },
            { name: "Tokelau", code: "TK" },
            { name: "Tonga", code: "TO" },
            { name: "Trinidad and Tobago", code: "TT" },
            { name: "Tunisia", code: "TN" },
            { name: "Turkey", code: "TR" },
            { name: "Turkmenistan", code: "TM" },
            { name: "Turks and Caicos Islands", code: "TC" },
            { name: "Tuvalu", code: "TV" },
            { name: "Uganda", code: "UG" },
            { name: "Ukraine", code: "UA" },
            { name: "United Arab Emirates", code: "AE" },
            { name: "United Kingdom", code: "GB" },
            { name: "United States", code: "US" },
            { name: "United States Minor Outlying Islands", code: "UM" },
            { name: "Uruguay", code: "UY" },
            { name: "Uzbekistan", code: "UZ" },
            { name: "Vanuatu", code: "VU" },
            { name: "Venezuela", code: "VE" },
            { name: "Viet Nam", code: "VN" },
            { name: "Virgin Islands, British", code: "VG" },
            { name: "Virgin Islands, U.S.", code: "VI" },
            { name: "Wallis and Futuna", code: "WF" },
            { name: "Western Sahara", code: "EH" },
            { name: "Yemen", code: "YE" },
            { name: "Zambia", code: "ZM" },
            { name: "Zimbabwe", code: "ZW" },
        ];
        this.currencyInfo = [
            {
                englishName: "Afghan Afghani (\u060B)",
                nativeName: "\u0627\u0641\u063A\u0627\u0646\u06CC \u0627\u0641\u063A\u0627\u0646\u0633\u062A\u0627\u0646",
                code: "AFN",
                symbol: "\u060B",
            },
            {
                englishName: "Albanian Lek (Lek\u00EB)",
                nativeName: "Leku shqiptar",
                code: "ALL",
                symbol: "Lek\u00EB",
            },
            {
                englishName: "Algerian Dinar (\u062F.\u062C.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u062C\u0632\u0627\u0626\u0631\u064A",
                code: "DZD",
                symbol: "\u062F.\u062C.\u200F",
            },
            {
                englishName: "Angolan Kwanza (Kz)",
                nativeName: "Kwanza ya Ang\u00F3la",
                code: "AOA",
                symbol: "Kz",
            },
            {
                englishName: "Argentine Peso ($)",
                nativeName: "peso argentino",
                code: "ARS",
                symbol: "$",
            },
            {
                englishName: "Armenian Dram (\u058F)",
                nativeName: "\u0570\u0561\u0575\u056F\u0561\u056F\u0561\u0576 \u0564\u0580\u0561\u0574",
                code: "AMD",
                symbol: "\u058F",
            },
            {
                englishName: "Aruban Florin (Afl.)",
                nativeName: "Arubaanse gulden",
                code: "AWG",
                symbol: "Afl.",
            },
            {
                englishName: "Australian Dollar ($)",
                nativeName: "Australian Dollar",
                code: "AUD",
                symbol: "$",
            },
            {
                englishName: "Azerbaijani Manat (\u20BC)",
                nativeName: "AZN",
                code: "AZN",
                symbol: "\u20BC",
            },
            {
                englishName: "Bahamian Dollar ($)",
                nativeName: "Bahamian Dollar",
                code: "BSD",
                symbol: "$",
            },
            {
                englishName: "Bahraini Dinar (\u062F.\u0628.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u0628\u062D\u0631\u064A\u0646\u064A",
                code: "BHD",
                symbol: "\u062F.\u0628.\u200F",
            },
            {
                englishName: "Bangladeshi Taka (\u09F3)",
                nativeName: "\u09AC\u09BE\u0982\u09B2\u09BE\u09A6\u09C7\u09B6\u09C0 \u099F\u09BE\u0995\u09BE",
                code: "BDT",
                symbol: "\u09F3",
            },
            {
                englishName: "Barbadian Dollar ($)",
                nativeName: "Barbadian Dollar",
                code: "BBD",
                symbol: "$",
            },
            {
                englishName: "Belarusian Ruble (Br)",
                nativeName: "\u0431\u0435\u043B\u0430\u0440\u0443\u0441\u043A\u0456 \u0440\u0443\u0431\u0435\u043B\u044C",
                code: "BYN",
                symbol: "Br",
            },
            {
                englishName: "Belize Dollar ($)",
                nativeName: "Belize Dollar",
                code: "BZD",
                symbol: "$",
            },
            {
                englishName: "Bermudan Dollar ($)",
                nativeName: "Bermudan Dollar",
                code: "BMD",
                symbol: "$",
            },
            {
                englishName: "Bhutanese Ngultrum (Nu.)",
                nativeName: "\u0F51\u0F44\u0F74\u0F63\u0F0B\u0F40\u0FB2\u0F58",
                code: "BTN",
                symbol: "Nu.",
            },
            {
                englishName: "Bolivian Boliviano (Bs)",
                nativeName: "boliviano",
                code: "BOB",
                symbol: "Bs",
            },
            {
                englishName: "Bosnia-Herzegovina Convertible Mark (\u041A\u041C)",
                nativeName: "\u041A\u043E\u043D\u0432\u0435\u0440\u0442\u0438\u0431\u0438\u043B\u043D\u0430 \u043C\u0430\u0440\u043A\u0430",
                code: "BAM",
                symbol: "\u041A\u041C",
            },
            {
                englishName: "Botswanan Pula (P)",
                nativeName: "Botswanan Pula",
                code: "BWP",
                symbol: "P",
            },
            {
                englishName: "Brazilian Real (R$)",
                nativeName: "real brasile\u00F1o",
                code: "BRL",
                symbol: "R$",
            },
            {
                englishName: "British Pound (\u00A3)",
                nativeName: "Punt Prydain",
                code: "GBP",
                symbol: "\u00A3",
            },
            {
                englishName: "Brunei Dollar ($)",
                nativeName: "Dolar Brunei",
                code: "BND",
                symbol: "$",
            },
            {
                englishName: "Bulgarian Lev (\u043B\u0432.)",
                nativeName: "\u0411\u044A\u043B\u0433\u0430\u0440\u0441\u043A\u0438 \u043B\u0435\u0432",
                code: "BGN",
                symbol: "\u043B\u0432.",
            },
            {
                englishName: "Burundian Franc (FBu)",
                nativeName: "Burundian Franc",
                code: "BIF",
                symbol: "FBu",
            },
            {
                englishName: "Cambodian Riel (\u17DB)",
                nativeName: "\u179A\u17C0\u179B\u200B\u1780\u1798\u17D2\u1796\u17BB\u1787\u17B6",
                code: "KHR",
                symbol: "\u17DB",
            },
            {
                englishName: "Canadian Dollar ($)",
                nativeName: "Canadian Dollar",
                code: "CAD",
                symbol: "$",
            },
            {
                englishName: "Cape Verdean Escudo (\u200B)",
                nativeName: "Skudu Kabuverdianu",
                code: "CVE",
                symbol: "\u200B",
            },
            {
                englishName: "Cayman Islands Dollar ($)",
                nativeName: "Cayman Islands Dollar",
                code: "KYD",
                symbol: "$",
            },
            {
                englishName: "Central African CFA Franc (FCFA)",
                nativeName: "CFA F\u00E0l\u00E2\u014B BEAC",
                code: "XAF",
                symbol: "FCFA",
            },
            {
                englishName: "CFP Franc (FCFP)",
                nativeName: "franc CFP",
                code: "XPF",
                symbol: "FCFP",
            },
            {
                englishName: "Chilean Peso (CLP)",
                nativeName: "CLP",
                code: "CLP",
                symbol: "CLP",
            },
            {
                englishName: "Chinese Yuan (\u00A5)",
                nativeName: "\u0F61\u0F74\u0F0B\u0F68\u0F53\u0F0B",
                code: "CNY",
                symbol: "\u00A5",
            },
            {
                englishName: "Colombian Peso ($)",
                nativeName: "peso colombiano",
                code: "COP",
                symbol: "$",
            },
            {
                englishName: "Comorian Franc (CF)",
                nativeName: "\u0641\u0631\u0646\u0643 \u062C\u0632\u0631 \u0627\u0644\u0642\u0645\u0631",
                code: "KMF",
                symbol: "CF",
            },
            {
                englishName: "Congolese Franc (FC)",
                nativeName: "franc congolais",
                code: "CDF",
                symbol: "FC",
            },
            {
                englishName: "Costa Rican Col\u00F3n (\u20A1)",
                nativeName: "col\u00F3n costarricense",
                code: "CRC",
                symbol: "\u20A1",
            },
            {
                englishName: "Croatian Kuna (HRK)",
                nativeName: "hrvatska kuna",
                code: "HRK",
                symbol: "HRK",
            },
            {
                englishName: "Cuban Peso ($)",
                nativeName: "peso cubano",
                code: "CUP",
                symbol: "$",
            },
            {
                englishName: "Czech Koruna (K\u010D)",
                nativeName: "\u010Desk\u00E1 koruna",
                code: "CZK",
                symbol: "K\u010D",
            },
            {
                englishName: "Danish Krone (kr.)",
                nativeName: "dansk krone",
                code: "DKK",
                symbol: "kr.",
            },
            {
                englishName: "Djiboutian Franc (Fdj)",
                nativeName: "DJF",
                code: "DJF",
                symbol: "Fdj",
            },
            {
                englishName: "Dominican Peso (RD$)",
                nativeName: "peso dominicano",
                code: "DOP",
                symbol: "RD$",
            },
            {
                englishName: "East Caribbean Dollar ($)",
                nativeName: "East Caribbean Dollar",
                code: "XCD",
                symbol: "$",
            },
            {
                englishName: "Egyptian Pound (\u062C.\u0645.\u200F)",
                nativeName: "\u062C\u0646\u064A\u0647 \u0645\u0635\u0631\u064A",
                code: "EGP",
                symbol: "\u062C.\u0645.\u200F",
            },
            {
                englishName: "Eritrean Nakfa (Nfk)",
                nativeName: "ERN",
                code: "ERN",
                symbol: "Nfk",
            },
            {
                englishName: "Ethiopian Birr (Br)",
                nativeName: "ETB",
                code: "ETB",
                symbol: "Br",
            },
            {
                englishName: "Euro (\u20AC)",
                nativeName: "euro",
                code: "EUR",
                symbol: "\u20AC",
            },
            {
                englishName: "Falkland Islands Pound (\u00A3)",
                nativeName: "Falkland Islands Pound",
                code: "FKP",
                symbol: "\u00A3",
            },
            {
                englishName: "Fijian Dollar ($)",
                nativeName: "Fijian Dollar",
                code: "FJD",
                symbol: "$",
            },
            {
                englishName: "Gambian Dalasi (D)",
                nativeName: "Gambian Dalasi",
                code: "GMD",
                symbol: "D",
            },
            {
                englishName: "Georgian Lari (\u20BE)",
                nativeName: "\u10E5\u10D0\u10E0\u10D7\u10E3\u10DA\u10D8 \u10DA\u10D0\u10E0\u10D8",
                code: "GEL",
                symbol: "\u20BE",
            },
            {
                englishName: "Ghanaian Cedi (GH\u20B5)",
                nativeName: "Ghana Sidi",
                code: "GHS",
                symbol: "GH\u20B5",
            },
            {
                englishName: "Gibraltar Pound (\u00A3)",
                nativeName: "Gibraltar Pound",
                code: "GIP",
                symbol: "\u00A3",
            },
            {
                englishName: "Guatemalan Quetzal (Q)",
                nativeName: "quetzal",
                code: "GTQ",
                symbol: "Q",
            },
            {
                englishName: "Guinean Franc (FG)",
                nativeName: "GNF",
                code: "GNF",
                symbol: "FG",
            },
            {
                englishName: "Guyanaese Dollar ($)",
                nativeName: "Guyanaese Dollar",
                code: "GYD",
                symbol: "$",
            },
            {
                englishName: "Haitian Gourde (G)",
                nativeName: "gourde ha\u00EFtienne",
                code: "HTG",
                symbol: "G",
            },
            {
                englishName: "Honduran Lempira (L)",
                nativeName: "lempira hondure\u00F1o",
                code: "HNL",
                symbol: "L",
            },
            {
                englishName: "Hong Kong Dollar (HK$)",
                nativeName: "Hong Kong Dollar",
                code: "HKD",
                symbol: "HK$",
            },
            {
                englishName: "Hungarian Forint (Ft)",
                nativeName: "magyar forint",
                code: "HUF",
                symbol: "Ft",
            },
            {
                englishName: "Icelandic Kr\u00F3na (ISK)",
                nativeName: "\u00EDslensk kr\u00F3na",
                code: "ISK",
                symbol: "ISK",
            },
            {
                englishName: "Indian Rupee (\u20B9)",
                nativeName: "\u09AD\u09BE\u09F0\u09A4\u09C0\u09AF\u09BC \u09F0\u09C1\u09AA\u09C0",
                code: "INR",
                symbol: "\u20B9",
            },
            {
                englishName: "Indonesian Rupiah (Rp)",
                nativeName: "Rupiah Indonesia",
                code: "IDR",
                symbol: "Rp",
            },
            {
                englishName: "Iranian Rial (IRR)",
                nativeName: "IRR",
                code: "IRR",
                symbol: "IRR",
            },
            {
                englishName: "Iraqi Dinar (\u062F.\u0639.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u0639\u0631\u0627\u0642\u064A",
                code: "IQD",
                symbol: "\u062F.\u0639.\u200F",
            },
            {
                englishName: "Israeli New Shekel (\u20AA)",
                nativeName: "\u0634\u064A\u0643\u0644 \u0625\u0633\u0631\u0627\u0626\u064A\u0644\u064A \u062C\u062F\u064A\u062F",
                code: "ILS",
                symbol: "\u20AA",
            },
            {
                englishName: "Jamaican Dollar ($)",
                nativeName: "Jamaican Dollar",
                code: "JMD",
                symbol: "$",
            },
            {
                englishName: "Japanese Yen (\uFFE5)",
                nativeName: "\u65E5\u672C\u5186",
                code: "JPY",
                symbol: "\uFFE5",
            },
            {
                englishName: "Jordanian Dinar (\u062F.\u0623.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u0623\u0631\u062F\u0646\u064A",
                code: "JOD",
                symbol: "\u062F.\u0623.\u200F",
            },
            {
                englishName: "Kazakhstani Tenge (\u20B8)",
                nativeName: "\u049A\u0430\u0437\u0430\u049B\u0441\u0442\u0430\u043D \u0442\u0435\u04A3\u0433\u0435\u0441\u0456",
                code: "KZT",
                symbol: "\u20B8",
            },
            {
                englishName: "Kenyan Shilling (Ksh)",
                nativeName: "Shilingi ya Kenya",
                code: "KES",
                symbol: "Ksh",
            },
            {
                englishName: "Kuwaiti Dinar (\u062F.\u0643.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u0643\u0648\u064A\u062A\u064A",
                code: "KWD",
                symbol: "\u062F.\u0643.\u200F",
            },
            {
                englishName: "Kyrgystani Som (\u0441\u043E\u043C)",
                nativeName: "\u041A\u044B\u0440\u0433\u044B\u0437\u0441\u0442\u0430\u043D \u0441\u043E\u043C\u0443",
                code: "KGS",
                symbol: "\u0441\u043E\u043C",
            },
            {
                englishName: "Laotian Kip (\u20AD)",
                nativeName: "\u0EA5\u0EB2\u0EA7 \u0E81\u0EB5\u0E9A",
                code: "LAK",
                symbol: "\u20AD",
            },
            {
                englishName: "Lebanese Pound (\u0644.\u0644.\u200F)",
                nativeName: "\u062C\u0646\u064A\u0647 \u0644\u0628\u0646\u0627\u0646\u064A",
                code: "LBP",
                symbol: "\u0644.\u0644.\u200F",
            },
            {
                englishName: "Liberian Dollar ($)",
                nativeName: "Liberian Dollar",
                code: "LRD",
                symbol: "$",
            },
            {
                englishName: "Libyan Dinar (\u062F.\u0644.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u0644\u064A\u0628\u064A",
                code: "LYD",
                symbol: "\u062F.\u0644.\u200F",
            },
            {
                englishName: "Macanese Pataca (MOP$)",
                nativeName: "Macanese Pataca",
                code: "MOP",
                symbol: "MOP$",
            },
            {
                englishName: "Macedonian Denar (\u0434\u0435\u043D)",
                nativeName: "\u041C\u0430\u043A\u0435\u0434\u043E\u043D\u0441\u043A\u0438 \u0434\u0435\u043D\u0430\u0440",
                code: "MKD",
                symbol: "\u0434\u0435\u043D",
            },
            {
                englishName: "Malagasy Ariary (Ar)",
                nativeName: "Malagasy Ariary",
                code: "MGA",
                symbol: "Ar",
            },
            {
                englishName: "Malawian Kwacha (MK)",
                nativeName: "Malawian Kwacha",
                code: "MWK",
                symbol: "MK",
            },
            {
                englishName: "Malaysian Ringgit (RM)",
                nativeName: "Malaysian Ringgit",
                code: "MYR",
                symbol: "RM",
            },
            {
                englishName: "Maldivian Rufiyaa (\u0783.)",
                nativeName: "MVR",
                code: "MVR",
                symbol: "\u0783.",
            },
            {
                englishName: "Mauritanian Ouguiya (\u0623.\u0645.)",
                nativeName: "\u0623\u0648\u0642\u064A\u0629 \u0645\u0648\u0631\u064A\u062A\u0627\u0646\u064A\u0629",
                code: "MRU",
                symbol: "\u0623.\u0645.",
            },
            {
                englishName: "Mauritian Rupee (Rs)",
                nativeName: "Mauritian Rupee",
                code: "MUR",
                symbol: "Rs",
            },
            {
                englishName: "Mexican Peso ($)",
                nativeName: "peso mexicano",
                code: "MXN",
                symbol: "$",
            },
            {
                englishName: "Moldovan Leu (L)",
                nativeName: "leu moldovenesc",
                code: "MDL",
                symbol: "L",
            },
            {
                englishName: "Mongolian Tugrik (\u20AE)",
                nativeName: "\u0442\u04E9\u0433\u0440\u04E9\u0433",
                code: "MNT",
                symbol: "\u20AE",
            },
            {
                englishName: "Moroccan Dirham (\u062F.\u0645.\u200F)",
                nativeName: "\u062F\u0631\u0647\u0645 \u0645\u063A\u0631\u0628\u064A",
                code: "MAD",
                symbol: "\u062F.\u0645.\u200F",
            },
            {
                englishName: "Mozambican Metical (MTn)",
                nativeName: "MZN",
                code: "MZN",
                symbol: "MTn",
            },
            {
                englishName: "Myanmar Kyat (K)",
                nativeName: "\u1019\u103C\u1014\u103A\u1019\u102C \u1000\u103B\u1015\u103A",
                code: "MMK",
                symbol: "K",
            },
            {
                englishName: "Namibian Dollar ($)",
                nativeName: "Namibiese dollar",
                code: "NAD",
                symbol: "$",
            },
            {
                englishName: "Nepalese Rupee (\u0928\u0947\u0930\u0942)",
                nativeName: "\u0928\u0947\u092A\u093E\u0932\u0940 \u0930\u0942\u092A\u0948\u092F\u093E\u0901",
                code: "NPR",
                symbol: "\u0928\u0947\u0930\u0942",
            },
            {
                englishName: "Netherlands Antillean Guilder (NAf.)",
                nativeName: "Netherlands Antillean Guilder",
                code: "ANG",
                symbol: "NAf.",
            },
            {
                englishName: "New Taiwan Dollar ($)",
                nativeName: "\u65B0\u53F0\u5E63",
                code: "TWD",
                symbol: "$",
            },
            {
                englishName: "New Zealand Dollar ($)",
                nativeName: "New Zealand Dollar",
                code: "NZD",
                symbol: "$",
            },
            {
                englishName: "Nicaraguan C\u00F3rdoba (C$)",
                nativeName: "c\u00F3rdoba nicarag\u00FCense",
                code: "NIO",
                symbol: "C$",
            },
            {
                englishName: "Nigerian Naira (\u20A6)",
                nativeName: "Nigerian Naira",
                code: "NGN",
                symbol: "\u20A6",
            },
            {
                englishName: "North Korean Won (KPW)",
                nativeName: "\uC870\uC120 \uBBFC\uC8FC\uC8FC\uC758 \uC778\uBBFC \uACF5\uD654\uAD6D \uC6D0",
                code: "KPW",
                symbol: "KPW",
            },
            {
                englishName: "Norwegian Krone (kr)",
                nativeName: "norske kroner",
                code: "NOK",
                symbol: "kr",
            },
            {
                englishName: "Omani Rial (\u0631.\u0639.\u200F)",
                nativeName: "\u0631\u064A\u0627\u0644 \u0639\u0645\u0627\u0646\u064A",
                code: "OMR",
                symbol: "\u0631.\u0639.\u200F",
            },
            {
                englishName: "Pakistani Rupee (Rs)",
                nativeName: "Pakistani Rupee",
                code: "PKR",
                symbol: "Rs",
            },
            {
                englishName: "Panamanian Balboa (B/.)",
                nativeName: "balboa paname\u00F1o",
                code: "PAB",
                symbol: "B/.",
            },
            {
                englishName: "Papua New Guinean Kina (K)",
                nativeName: "Papua New Guinean Kina",
                code: "PGK",
                symbol: "K",
            },
            {
                englishName: "Paraguayan Guarani (Gs.)",
                nativeName: "guaran\u00ED paraguayo",
                code: "PYG",
                symbol: "Gs.",
            },
            {
                englishName: "Peruvian Sol (S/)",
                nativeName: "sol peruano",
                code: "PEN",
                symbol: "S/",
            },
            {
                englishName: "Philippine Piso (\u20B1)",
                nativeName: "PHP",
                code: "PHP",
                symbol: "\u20B1",
            },
            {
                englishName: "Polish Zloty (z\u0142)",
                nativeName: "z\u0142oty polski",
                code: "PLN",
                symbol: "z\u0142",
            },
            {
                englishName: "Qatari Rial (\u0631.\u0642.\u200F)",
                nativeName: "\u0631\u064A\u0627\u0644 \u0642\u0637\u0631\u064A",
                code: "QAR",
                symbol: "\u0631.\u0642.\u200F",
            },
            {
                englishName: "Romanian Leu (RON)",
                nativeName: "leu rom\u00E2nesc",
                code: "RON",
                symbol: "RON",
            },
            {
                englishName: "Russian Ruble (RUB)",
                nativeName: "RUB",
                code: "RUB",
                symbol: "RUB",
            },
            {
                englishName: "Rwandan Franc (RF)",
                nativeName: "Rwandan Franc",
                code: "RWF",
                symbol: "RF",
            },
            {
                englishName: "Samoan Tala (WS$)",
                nativeName: "Samoan Tala",
                code: "WST",
                symbol: "WS$",
            },
            {
                englishName: "S\u00E3o Tom\u00E9 \u0026 Pr\u00EDncipe Dobra (Db)",
                nativeName: "dobra de S\u00E3o Tom\u00E9 e Pr\u00EDncipe",
                code: "STN",
                symbol: "Db",
            },
            {
                englishName: "Saudi Riyal (\u0631.\u0633.\u200F)",
                nativeName: "\u0631\u064A\u0627\u0644 \u0633\u0639\u0648\u062F\u064A",
                code: "SAR",
                symbol: "\u0631.\u0633.\u200F",
            },
            {
                englishName: "Serbian Dinar (RSD)",
                nativeName: "\u0421\u0440\u043F\u0441\u043A\u0438 \u0434\u0438\u043D\u0430\u0440",
                code: "RSD",
                symbol: "RSD",
            },
            {
                englishName: "Seychellois Rupee (SR)",
                nativeName: "Seychellois Rupee",
                code: "SCR",
                symbol: "SR",
            },
            {
                englishName: "Sierra Leonean Leone (Le)",
                nativeName: "Sierra Leonean Leone",
                code: "SLL",
                symbol: "Le",
            },
            {
                englishName: "Singapore Dollar ($)",
                nativeName: "Singapore Dollar",
                code: "SGD",
                symbol: "$",
            },
            {
                englishName: "Solomon Islands Dollar ($)",
                nativeName: "Solomon Islands Dollar",
                code: "SBD",
                symbol: "$",
            },
            {
                englishName: "Somali Shilling (S)",
                nativeName: "\u0634\u0644\u0646 \u0635\u0648\u0645\u0627\u0644\u064A",
                code: "SOS",
                symbol: "S",
            },
            {
                englishName: "South African Rand (R)",
                nativeName: "Suid-Afrikaanse rand",
                code: "ZAR",
                symbol: "R",
            },
            {
                englishName: "South Korean Won (\u20A9)",
                nativeName: "\uB300\uD55C\uBBFC\uAD6D \uC6D0",
                code: "KRW",
                symbol: "\u20A9",
            },
            {
                englishName: "South Sudanese Pound (\u00A3)",
                nativeName: "\u062C\u0646\u064A\u0647 \u062C\u0646\u0648\u0628 \u0627\u0644\u0633\u0648\u062F\u0627\u0646",
                code: "SSP",
                symbol: "\u00A3",
            },
            {
                englishName: "Sri Lankan Rupee (\u0DBB\u0DD4.)",
                nativeName: "\u0DC1\u0DCA\u200D\u0DBB\u0DD3 \u0DBD\u0D82\u0D9A\u0DCF \u0DBB\u0DD4\u0DB4\u0DD2\u0DBA\u0DBD",
                code: "LKR",
                symbol: "\u0DBB\u0DD4.",
            },
            {
                englishName: "St. Helena Pound (\u00A3)",
                nativeName: "St. Helena Pound",
                code: "SHP",
                symbol: "\u00A3",
            },
            {
                englishName: "Sudanese Pound (\u062C.\u0633.)",
                nativeName: "\u062C\u0646\u064A\u0647 \u0633\u0648\u062F\u0627\u0646\u064A",
                code: "SDG",
                symbol: "\u062C.\u0633.",
            },
            {
                englishName: "Surinamese Dollar ($)",
                nativeName: "Surinaamse dollar",
                code: "SRD",
                symbol: "$",
            },
            {
                englishName: "Swazi Lilangeni (E)",
                nativeName: "Swazi Lilangeni",
                code: "SZL",
                symbol: "E",
            },
            {
                englishName: "Swedish Krona (kr)",
                nativeName: "Swedish Krona",
                code: "SEK",
                symbol: "kr",
            },
            {
                englishName: "Swiss Franc (CHF)",
                nativeName: "Schweizer Franken",
                code: "CHF",
                symbol: "CHF",
            },
            {
                englishName: "Syrian Pound (\u0644.\u0633.\u200F)",
                nativeName: "\u0644\u064A\u0631\u0629 \u0633\u0648\u0631\u064A\u0629",
                code: "SYP",
                symbol: "\u0644.\u0633.\u200F",
            },
            {
                englishName: "Tajikistani Somoni (\u0441\u043E\u043C.)",
                nativeName: "\u0421\u043E\u043C\u043E\u043D\u04E3",
                code: "TJS",
                symbol: "\u0441\u043E\u043C.",
            },
            {
                englishName: "Tanzanian Shilling (TSh)",
                nativeName: "shilingi ya Tandhania",
                code: "TZS",
                symbol: "TSh",
            },
            {
                englishName: "Thai Baht (\u0E3F)",
                nativeName: "\u0E1A\u0E32\u0E17",
                code: "THB",
                symbol: "\u0E3F",
            },
            {
                englishName: "Tongan Pa\u02BBanga (T$)",
                nativeName: "Tongan Pa\u02BBanga",
                code: "TOP",
                symbol: "T$",
            },
            {
                englishName: "Trinidad \u0026 Tobago Dollar ($)",
                nativeName: "Trinidad \u0026 Tobago Dollar",
                code: "TTD",
                symbol: "$",
            },
            {
                englishName: "Tunisian Dinar (\u062F.\u062A.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u062A\u0648\u0646\u0633\u064A",
                code: "TND",
                symbol: "\u062F.\u062A.\u200F",
            },
            {
                englishName: "Turkish Lira (\u20BA)",
                nativeName: "T\u00FCrk Liras\u0131",
                code: "TRY",
                symbol: "\u20BA",
            },
            {
                englishName: "Turkmenistani Manat (TMT)",
                nativeName: "T\u00FCrkmen manady",
                code: "TMT",
                symbol: "TMT",
            },
            {
                englishName: "Ugandan Shilling (USh)",
                nativeName: "Eshiringi ya Uganda",
                code: "UGX",
                symbol: "USh",
            },
            {
                englishName: "Ukrainian Hryvnia (\u20B4)",
                nativeName: "\u0443\u043A\u0440\u0430\u0438\u043D\u0441\u043A\u0430\u044F \u0433\u0440\u0438\u0432\u043D\u0430",
                code: "UAH",
                symbol: "\u20B4",
            },
            {
                englishName: "United Arab Emirates Dirham (\u062F.\u0625.\u200F)",
                nativeName: "\u062F\u0631\u0647\u0645 \u0625\u0645\u0627\u0631\u0627\u062A\u064A",
                code: "AED",
                symbol: "\u062F.\u0625.\u200F",
            },
            {
                englishName: "Uruguayan Peso ($)",
                nativeName: "peso uruguayo",
                code: "UYU",
                symbol: "$",
            },
            {
                englishName: "US Dollar ($)",
                nativeName: "US \u13A0\u13D5\u13B3",
                code: "USD",
                symbol: "$",
            },
            {
                englishName: "Uzbekistani Som (\u0441\u045E\u043C)",
                nativeName: "\u040E\u0437\u0431\u0435\u043A\u0438\u0441\u0442\u043E\u043D \u0441\u045E\u043C",
                code: "UZS",
                symbol: "\u0441\u045E\u043C",
            },
            {
                englishName: "Vanuatu Vatu (VT)",
                nativeName: "Vanuatu Vatu",
                code: "VUV",
                symbol: "VT",
            },
            {
                englishName: "Venezuelan Bol\u00EDvar (Bs.S)",
                nativeName: "bol\u00EDvar soberano",
                code: "VES",
                symbol: "Bs.S",
            },
            {
                englishName: "Vietnamese Dong (\u20AB)",
                nativeName: "\u0110\u1ED3ng Vi\u1EC7t Nam",
                code: "VND",
                symbol: "\u20AB",
            },
            {
                englishName: "West African CFA Franc (CFA)",
                nativeName: "sefa Fra\u014B (BCEAO)",
                code: "XOF",
                symbol: "CFA",
            },
            {
                englishName: "Yemeni Rial (\u0631.\u064A.\u200F)",
                nativeName: "\u0631\u064A\u0627\u0644 \u064A\u0645\u0646\u064A",
                code: "YER",
                symbol: "\u0631.\u064A.\u200F",
            },
            {
                englishName: "Zambian Kwacha (K)",
                nativeName: "ZMW",
                code: "ZMW",
                symbol: "K",
            },
        ];
        this.elementTypes = {
            AddressElement: "Address",
            Text_BoxElement: "StiTextBoxControl",
            TextElement: "StiText",
            TableElement: "StiTable",
            Single_SelectionElement: "StiSingleSelection",
            SignatureElement: "StiElectronicSignature",
            PDFSignatureElement: "StiPdfDigitalSignature",
            PanelElement: "StiPanel",
            Number_BoxElement: "StiNumberBox",
            Multiple_SelectionElement: "StiMultipleSelection",
            List_BoxElement: "StiListBox",
            LabelElement: "StiLabelControl",
            ImageElement: "StiImage",
            LineElement: "Line",
            DateTime_BoxElement: "StiDateTimePickerControl",
            Combo_BoxElement: "StiComboBox",
            Check_BoxElement: "StiCheckBox",
            ButtonElement: "StiButton",
            BarCodeElement: "StiBarCode",
            StiPageElement: "StiPage",
        };
        this.elementCategories = {
            AddressElement: "Report",
            Text_BoxElement: "Dialogs",
            LineElement: "Chart",
            DateTime_BoxElement: "Dialogs",
            LabelElement: "Dialogs",
        };
        StiLocalizationService.needToRefresh.subscribe(() => {
            this.updateHelper();
        });
    }
    get richTextFontSizes() {
        if (this._richTextFontSizes.length === 0) {
            this._richTextFontSizes.push({ name: "8", value: 1 });
            this._richTextFontSizes.push({ name: "10", value: 2 });
            this._richTextFontSizes.push({ name: "12", value: 3 });
            this._richTextFontSizes.push({ name: "14", value: 4 });
            this._richTextFontSizes.push({ name: "18", value: 5 });
            this._richTextFontSizes.push({ name: "24", value: 6 });
            this._richTextFontSizes.push({ name: "36", value: 7 });
        }
        return this._richTextFontSizes;
    }
    get fontSizes() {
        return this._fontSizes;
    }
    getLocalizationKey(type) {
        return this.elementTypes[type];
    }
    getLocalizationCategory(type) {
        return this.elementCategories[type] ? this.elementCategories[type] : "Components";
    }
    get errorCorrectionLevel() {
        return this._errorCorrectionLevel;
    }
    get bodyShapeType() {
        return this._bodyShapeType;
    }
    get eyeFrameShapeType() {
        return this._eyeFrameShapeType;
    }
    get eyeBallShapeType() {
        return this._eyeBallShapeType;
    }
    get brushIdent() {
        return this._brushIdent;
    }
    get bodyBrush() {
        return this._bodyBrush;
    }
    get dataMatrixSize() {
        return this._dataMatrixSize;
    }
    get numberTypes() {
        if (this._numberTypes.length === 0) {
            this._numberTypes.push({
                name: StiLocalizationService.get("FormFormatEditor", "Number"),
                value: "Decimal",
            });
            this._numberTypes.push({
                name: StiLocalizationService.get("FormFormatEditor", "Currency"),
                value: "Currency",
            });
        }
        return this._numberTypes;
    }
    get rangeFormats() {
        if (this._rangeFormats.length === 0) {
            this._rangeFormats.push({
                name: StiLocalizationService.get("PropertyEnum", "Digits"),
                value: "Digits",
            });
            this._rangeFormats.push({
                name: StiLocalizationService.get("PropertyEnum", "Values"),
                value: "Values",
            });
        }
        return this._rangeFormats;
    }
    get signatureTypes() {
        if (this._signatureTypes.length === 0) {
            this._signatureTypes.push({
                name: StiLocalizationService.get("Components", "StiElectronicSignature"),
                value: "Signature",
            });
            this._signatureTypes.push({
                name: StiLocalizationService.get("Components", "StiPdfDigitalSignature"),
                value: "DigitalSignature",
            });
        }
        return this._signatureTypes;
    }
    get columnTypes() {
        if (this._columnTypes.length === 0) {
            this._columnTypes.push({ name: StiLocalizationService.get("Components", "StiCheckBox"), value: "CheckBox" });
            this._columnTypes.push({ name: StiLocalizationService.get("Components", "StiComboBox"), value: "ComboBox" });
            this._columnTypes.push({ name: StiLocalizationService.get("Dialogs", "StiLabelControl"), value: "Label" });
            this._columnTypes.push({
                name: StiLocalizationService.get("Components", "StiSingleSelection"),
                value: "RadioButton",
            });
            this._columnTypes.push({ name: StiLocalizationService.get("Dialogs", "StiTextBoxControl"), value: "TextBox" });
            this._columnTypes.push({ name: StiLocalizationService.get("Components", "StiNumberBox"), value: "NumberBox" });
        }
        return this._columnTypes;
    }
    get buttonTypes() {
        if (this._buttonTypes.length === 0) {
            this._buttonTypes.push({
                name: StiLocalizationService.get("Gui", "monthcalendar_clearbutton"),
                value: "ClearForm",
            });
            this._buttonTypes.push({
                name: StiLocalizationService.get("A_WebViewer", "ButtonSend"),
                value: "SendForm",
            });
            this._buttonTypes.push({
                name: StiLocalizationService.get("Buttons", "Attach"),
                value: "AttachFiles",
            });
        }
        return this._buttonTypes;
    }
    get algorithmExpressions() {
        if (this._algorithmExpressions.length === 0) {
            this._algorithmExpressions.push({ name: "Constant", value: "Constant" });
            this._algorithmExpressions.push({ name: "Number cell value", value: "NumberCellValue" });
            this._algorithmExpressions.push({ name: "Number column max", value: "NumberColumnMax" });
            this._algorithmExpressions.push({ name: "Number column sum", value: "NumberColumnSum" });
        }
        return this._algorithmExpressions;
    }
    get buttonSendTypes() {
        if (this._buttonSendTypes.length === 0) {
            this._buttonSendTypes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiButtonSendTypeFDF"),
                value: "FDF",
            });
            this._buttonSendTypes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiButtonSendTypeHTML"),
                value: "HTML",
            });
            this._buttonSendTypes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiButtonSendTypeXFDF"),
                value: "XFDF",
            });
            this._buttonSendTypes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiButtonSendTypePDF"),
                value: "PDF",
            });
        }
        return this._buttonSendTypes;
    }
    get barcodeTypes() {
        if (this._barcodeTypes.length === 0) {
            Enum.getValues(StiBarcodeType).forEach((t) => {
                let name = Enum.getName(StiBarcodeType, t);
                this._barcodeTypes.push({ name: name, value: name });
            });
        }
        return this._barcodeTypes;
    }
    get dateTimeTypes() {
        if (this._dateTimeTypes.length === 0) {
            this._dateTimeTypes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiDateTimeTypeDateAndTime"),
                value: "DateTime",
            });
            this._dateTimeTypes.push({ name: StiLocalizationService.get("FormFormatEditor", "Date"), value: "Date" });
            this._dateTimeTypes.push({ name: StiLocalizationService.get("FormFormatEditor", "Time"), value: "Time" });
        }
        return this._dateTimeTypes;
    }
    get penStyles() {
        if (this._penStyles.length === 0) {
            this._penStyles.push({ name: StiLocalizationService.get("PropertyEnum", "StiPenStyleSolid"), value: "Solid" });
            this._penStyles.push({ name: StiLocalizationService.get("PropertyEnum", "StiPenStyleDash"), value: "Dash" });
            this._penStyles.push({ name: StiLocalizationService.get("PropertyEnum", "StiPenStyleDot"), value: "Dot" });
        }
        return this._penStyles;
    }
    get dateTimeFormats() {
        if (this._dateTimeFormats.length === 0) {
            this._dateTimeFormats.push({ name: "m/d/yy h:MM tt", value: "m/d/yy h:MM tt" });
            this._dateTimeFormats.push({ name: "m/d/yyyy h:MM tt", value: "m/d/yyyy h:MM tt" });
            this._dateTimeFormats.push({ name: "m/d/yy HH:MM", value: "m/d/yy HH:MM" });
            this._dateTimeFormats.push({ name: "m/d/yyyy HH:MM", value: "m/d/yyyy HH:MM" });
            this._dateTimeFormats.push({ name: "m/d", value: "m/d" });
            this._dateTimeFormats.push({ name: "m/d/yy", value: "m/d/yy" });
            this._dateTimeFormats.push({ name: "m/d/yyyy", value: "m/d/yyyy" });
            this._dateTimeFormats.push({ name: "mm/dd/yy", value: "mm/dd/yy" });
            this._dateTimeFormats.push({ name: "mm/dd/yyyy", value: "mm/dd/yyyy" });
            this._dateTimeFormats.push({ name: "mm/yy", value: "mm/yy" });
            this._dateTimeFormats.push({ name: "mm/yyyy", value: "mm/yyyy" });
            this._dateTimeFormats.push({ name: "mmm-yy", value: "mmm-yy" });
            this._dateTimeFormats.push({ name: "mmm-yyyy", value: "mmm-yyyy" });
            this._dateTimeFormats.push({ name: "mmmm-yy", value: "mmmm-yy" });
            this._dateTimeFormats.push({ name: "mmmm-yyyy", value: "mmmm-yyyy" });
            this._dateTimeFormats.push({ name: "mmm d, yyyy", value: "mmm d, yyyy" });
            this._dateTimeFormats.push({ name: "mmmm d, yyyy", value: "mmmm d, yyyy" });
            this._dateTimeFormats.push({ name: "dd.mm.yyyy HH:MM", value: "dd.mm.yyyy HH:MM" });
            this._dateTimeFormats.push({ name: "d-mmm", value: "d-mmm" });
            this._dateTimeFormats.push({ name: "d-mmm-yy", value: "d-mmm-yy" });
            this._dateTimeFormats.push({ name: "d-mmm-yyyy", value: "d-mmm-yyyy" });
            this._dateTimeFormats.push({ name: "dd-mmm-yy", value: "dd-mmm-yy" });
            this._dateTimeFormats.push({ name: "dd-mmm-yyyy", value: "dd-mmm-yyyy" });
            this._dateTimeFormats.push({ name: "dd.mm.yyyy", value: "dd.mm.yyyy" });
            this._dateTimeFormats.push({ name: "yy-mm-dd", value: "yy-mm-dd" });
            this._dateTimeFormats.push({ name: "yyyy-mm-dd", value: "yyyy-mm-dd" });
            this._dateTimeFormats.push({ name: "HH:MM", value: "HH:MM" });
            this._dateTimeFormats.push({ name: "h:MM tt", value: "h:MM tt" });
            this._dateTimeFormats.push({ name: "HH:MM:ss", value: "HH:MM:ss" });
            this._dateTimeFormats.push({ name: "h:MM:ss tt", value: "h:MM:ss tt" });
        }
        return this._dateTimeFormats;
    }
    get dateFormats() {
        if (this._dateFormats.length === 0) {
            this._dateFormats.push({ name: "m/d", value: "m/d" });
            this._dateFormats.push({ name: "m/d/yy", value: "m/d/yy" });
            this._dateFormats.push({ name: "m/d/yyyy", value: "m/d/yyyy" });
            this._dateFormats.push({ name: "mm/dd/yy", value: "mm/dd/yy" });
            this._dateFormats.push({ name: "mm/dd/yyyy", value: "mm/dd/yyyy" });
            this._dateFormats.push({ name: "mm/yy", value: "mm/yy" });
            this._dateFormats.push({ name: "mm/yyyy", value: "mm/yyyy" });
            this._dateFormats.push({ name: "mmm-yy", value: "mmm-yy" });
            this._dateFormats.push({ name: "mmm-yyyy", value: "mmm-yyyy" });
            this._dateFormats.push({ name: "mmmm-yy", value: "mmmm-yy" });
            this._dateFormats.push({ name: "mmmm-yyyy", value: "mmmm-yyyy" });
            this._dateFormats.push({ name: "mmm d, yyyy", value: "mmm d, yyyy" });
            this._dateFormats.push({ name: "mmmm d, yyyy", value: "mmmm d, yyyy" });
            this._dateFormats.push({ name: "d-mmm", value: "d-mmm" });
            this._dateFormats.push({ name: "d-mmm-yy", value: "d-mmm-yy" });
            this._dateFormats.push({ name: "d-mmm-yyyy", value: "d-mmm-yyyy" });
            this._dateFormats.push({ name: "dd-mmm-yy", value: "dd-mmm-yy" });
            this._dateFormats.push({ name: "dd-mmm-yyyy", value: "dd-mmm-yyyy" });
            this._dateFormats.push({ name: "dd.mm.yyyy", value: "dd.mm.yyyy" });
            this._dateFormats.push({ name: "yy-mm-dd", value: "yy-mm-dd" });
            this._dateFormats.push({ name: "yyyy-mm-dd", value: "yyyy-mm-dd" });
        }
        return this._dateFormats;
    }
    get timeFormats() {
        if (this._timeFormats.length === 0) {
            this._timeFormats.push({ name: "HH:MM", value: "HH:MM" });
            this._timeFormats.push({ name: "h:MM tt", value: "h:MM tt" });
            this._timeFormats.push({ name: "HH:MM:ss", value: "HH:MM:ss" });
            this._timeFormats.push({ name: "h:MM:ss tt", value: "h:MM:ss tt" });
        }
        return this._timeFormats;
    }
    get signatureEditorModes() {
        if (this._signatureEditorModes.length === 0) {
            this._signatureEditorModes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiSignatureTypeType"),
                value: "Type",
            });
            this._signatureEditorModes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiSignatureTypeDraw"),
                value: "Draw",
            });
        }
        return this._signatureEditorModes;
    }
    get signatureSpecialFonts() {
        if (this._signatureSpecialFonts.length === 0) {
            this._signatureSpecialFonts.push({
                name: `${StiLocalizationService.get("PropertyMain", "Style")}${1}`,
                value: "Teddy Bear",
            });
            this._signatureSpecialFonts.push({
                name: `${StiLocalizationService.get("PropertyMain", "Style")}${2}`,
                value: "MADE Likes Script",
            });
            this._signatureSpecialFonts.push({
                name: `${StiLocalizationService.get("PropertyMain", "Style")}${3}`,
                value: "Denistina",
            });
        }
        return this._signatureSpecialFonts;
    }
    get dateTimeValues() {
        if (this._dateTimeValues.length === 0) {
            this._dateTimeValues.push({
                name: StiLocalizationService.get("Gui", "colorpickerdialog_currentcolorlabel"),
                value: "Current",
            });
            this._dateTimeValues.push({
                name: StiLocalizationService.get("PropertyEnum", "DateTimePickerFormatCustom"),
                value: "Custom",
            });
        }
        return this._dateTimeValues;
    }
    get themes() {
        if (this._themes.length === 0) {
            this._themes.push({ name: "Light" });
            this._themes.push({ name: "Dark" });
        }
        return this._themes;
    }
    get borderWeights() {
        if (this._borderWeights.length === 0) {
            this._borderWeights.push({
                name: StiLocalizationService.get("PropertyEnum", "StiLineWeightThin"),
                value: "Thin",
            });
            this._borderWeights.push({
                name: StiLocalizationService.get("PropertyEnum", "StiLineWeightNormal"),
                value: "Normal",
            });
            this._borderWeights.push({
                name: StiLocalizationService.get("PropertyEnum", "StiLineWeightThick"),
                value: "Thick",
            });
        }
        return this._borderWeights;
    }
    get unitAlignment() {
        if (this._unitAlignment.length === 0) {
            this._unitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentPrefix"),
                value: 1,
            });
            this._unitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentSuffix"),
                value: 2,
            });
            this._unitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentPrefixInside"),
                value: 3,
            });
            this._unitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentPrefixInsideWithSpace"),
                value: 4,
            });
            this._unitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentSuffixInside"),
                value: 5,
            });
            this._unitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentSuffixInsideWithSpace"),
                value: 6,
            });
        }
        return this._unitAlignment;
    }
    get minUnitAlignment() {
        if (this._minUnitAlignment.length === 0) {
            this._minUnitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentPrefix"),
                value: 1,
            });
            this._minUnitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentSuffix"),
                value: 2,
            });
        }
        return this._minUnitAlignment;
    }
    get labelFormat() {
        if (this._labelFormat.length === 0) {
            this._labelFormat.push({ name: "Symbol", value: 1 });
            this._labelFormat.push({ name: "Code", value: 2 });
        }
        return this._labelFormat;
    }
    get thousandSeparators() {
        if (this._thousandSeparators.length === 0) {
            this._thousandSeparators.push({ name: "1234567.89", value: "None" });
            this._thousandSeparators.push({ name: "1234567,89", value: "NoneComma" });
            this._thousandSeparators.push({ name: "1,234,567.89", value: "Comma" });
            this._thousandSeparators.push({ name: "1.234.567,89", value: "Dot" });
            this._thousandSeparators.push({ name: "1`234`567.89", value: "Apostrophe" });
        }
        return this._thousandSeparators;
    }
    updateHelper() {
        this._minUnitAlignment = [];
        this._unitAlignment = [];
        this._borderWeights = [];
        this._dateTimeValues = [];
        this._penStyles = [];
        this._dateTimeTypes = [];
        this._buttonSendTypes = [];
        this._buttonTypes = [];
        this._signatureTypes = [];
        this._numberTypes = [];
    }
    deleteSelectedComponent() {
        let fromPanel = true;
        if (this.model.selectedComponent) {
            let container = this.model.getElementPage(this.model.selectedComponent.element) ??
                this.model.getElementPanel(this.model.selectedComponent.element);
            container.elements.splice(container.elements.indexOf(this.model.selectedComponent.element), 1);
            this.render.removeElement(this.model.selectedComponent.element, container.elements);
            this.model.selectedComponent = null;
            this.model.formEvents.next({ name: "ComponentDeleted" });
            this.model.cursor = "default";
        }
    }
    getElementClass(type) {
        if (type == "TextElement" || type == "Text") {
            return StiTextElement;
        }
        else if (type == "Text_BoxElement" || type == "TextBox") {
            return StiTextBoxElement;
        }
        else if (type == "TableElement" || type == "Table") {
            return StiTableElement;
        }
        else if (type == "Single_SelectionElement" || type == "SingleSelection") {
            return StiSingleSelectionElement;
        }
        else if (type == "SignatureElement" || type == "Signature") {
            return StiSignatureElement;
        }
        else if (type == "PDFSignatureElement" || type == "PDFSignature") {
            return StiPDFSignatureElement;
        }
        else if (type == "PanelElement" || type == "Panel") {
            return StiPanelElement;
        }
        else if (type == "Number_BoxElement" || type == "NumberBox") {
            return StiNumberBoxElement;
        }
        else if (type == "Multiple_SelectionElement" || type == "MultipleSelection") {
            return StiMultipleSelectionElement;
        }
        else if (type == "List_BoxElement" || type == "ListBox") {
            return StiListBoxElement;
        }
        else if (type == "LineElement" || type == "Line") {
            return StiLineElement;
        }
        else if (type == "LabelElement" || type == "Label") {
            return StiLabelElement;
        }
        else if (type == "ImageElement" || type == "Image") {
            return StiImageElement;
        }
        else if (type == "DateTime_BoxElement" || type == "DateTimeBox") {
            return StiDateTimeBoxElement;
        }
        else if (type == "Combo_BoxElement" || type == "ComboBox") {
            return StiComboBoxElement;
        }
        else if (type == "Check_BoxElement" || type == "CheckBox") {
            return StiCheckBoxElement;
        }
        else if (type == "ButtonElement" || type == "Button") {
            return StiButtonElement;
        }
        else if (type == "BarCodeElement" || type == "BarCode") {
            return StiBarcodeElement;
        }
        else if (type == "AddressElement" || type == "Address") {
            return StiAddressElement;
        }
        else if (type == "Page") {
            return StiFormPageElement;
        }
        else if (type == "Form") {
            return StiForm;
        }
        // return this.pageElement.getElementTypes()[type] ?? StiPanelElement;
    }
    clone(element) {
        let clazz = this.getElementClass(element.type);
        let result = new clazz();
        let jObject = new StiJson();
        jObject.deserialize(element.saveToJsonObject({}).serialize());
        result.loadFromJsonObject(jObject);
        result.guid = Guid.newGuid().toString();
        if ("displayValue" in element) {
            result["displayValue"] = element["displayValue"];
        }
        if ("form" in element) {
            result["form"] = element["form"];
        }
        return result;
    }
    clonePage(page) {
        let result = new StiFormPageElement(page.form);
        let jObject = new StiJson();
        jObject.deserialize(page.saveToJsonObject({}).serialize());
        result.loadFromJsonObject(jObject);
        result.guid = Guid.newGuid().toString();
        result.form = page.form;
        return result;
    }
    get fileMenuItems() {
        if (this._fileMenuItems.length == 0) {
            this._fileMenuItems = [
                // { caption: StiLocalizationService.get("PropertyMain", "Info"), image: "assets/Images/Other/FileMenu/Home.png" },
                {
                    caption: StiLocalizationService.get("MainMenu", "menuFileNew").replace("&amp", "").replace(";", ""),
                    image: "images.Other.FileMenu.Report.png",
                    name: "New",
                },
                {
                    caption: StiLocalizationService.get("MainMenu", "menuFileOpen")
                        .replace("&amp", "")
                        .replace(";", "")
                        .replace("...", ""),
                    image: "images.Other.FileMenu.Folder.png",
                    name: "Open",
                },
                { name: "Divider" },
                {
                    caption: StiLocalizationService.get("MainMenu", "menuFileSave").replace("&amp", "").replace(";", ""),
                    name: "Save",
                },
                { caption: StiLocalizationService.get("MainMenu", "menuFileSaveAs").replace("...", ""), name: "SaveAs" },
                /*  { caption: StiLocalizationService.get("PropertyMain", "Share") },
                { caption: StiLocalizationService.get("PropertyMain", "Help") },
                { caption: StiLocalizationService.get("PropertyMain", "Close") }, */
                { name: "Divider" },
                /*  { caption: StiLocalizationService.get("PropertyMain", "Account") },
                { caption: StiLocalizationService.get("PropertyMain", "Options") }, */
                {
                    caption: StiLocalizationService.get("MainMenu", "menuHelpAboutProgramm")
                        .replace("&amp", "")
                        .replace(";", "")
                        .replace("...", ""),
                    name: "About",
                },
            ];
        }
        return this._fileMenuItems;
    }
    getAddTotalMenuItems() {
        let table = this.model.selectedComponent?.element;
        let this_ = this;
        if (!this.addTotalMenuItems && table?.columns?.length > 0) {
            this.addTotalMenuItems = [];
            let commands = [
                { name: this.loc.getP("Summary"), type: "Sum" },
                { name: this.loc.getP("Minimum"), type: "Min" },
                { name: this.loc.getP("Maximum"), type: "Max" },
                { name: this.loc.getP("Count"), type: "Count" },
            ];
            commands.forEach((command) => {
                let items = [];
                table.columns.forEach((column, index) => {
                    if (column instanceof StiNumberBoxColumnItem || column instanceof StiLabelColumnItem) {
                        items.push({
                            label: column.label?.length > 0 ? column.label : `${this.loc.get2("PropertyMain", "Column")} ${index + 1}`,
                            command: () => {
                                this_.zone.run(() => {
                                    table.totalsFields.push(new StiTotalsFieldItem(command.type, `{${command.type}(Col(${index + 1}))}`, this.model.form));
                                    this.model.showColumnPreview(table.totalsFields.length - 1, "totals");
                                });
                            },
                        });
                    }
                });
                if (items.length > 0) {
                    this.addTotalMenuItems.push({ label: command.name, items: items });
                }
            });
            let items = [];
            table.columns.forEach((column, index) => {
                let rowItems = [];
                table.rowLabels.forEach((rowLabel, rowIndex) => {
                    rowItems.push({
                        label: `Row ${rowIndex + 1}`,
                        command: () => {
                            this_.zone.run(() => {
                                table.totalsFields.push(new StiTotalsFieldItem("Cell", `{Cell(${index + 1}, ${rowIndex + 1})}`, this.model.form));
                                this.model.showColumnPreview(table.totalsFields.length - 1, "totals");
                            });
                        },
                    });
                });
                items.push({
                    label: column.label?.length > 0 ? column.label : `${this.loc.get2("PropertyMain", "Column")} ${index + 1}`,
                    items: rowItems,
                });
            });
            this.addTotalMenuItems.push({ label: this.loc.get2("PropertyCategory", "CellCategory"), items: items });
            this.addTotalMenuItems.push({
                label: this.loc.get2("Report", "StiEmptyBrush"),
                command: () => {
                    this_.zone.run(() => {
                        table.totalsFields.push(new StiTotalsFieldItem("", "", this.model.form));
                        this.model.showColumnPreview(table.totalsFields.length - 1, "totals");
                    });
                }
            });
        }
        return this.addTotalMenuItems;
    }
    base64Encode(input) {
        if (input == null)
            return "";
        // Decode from UTF-8 text
        if (typeof unescape != "undefined") {
            input = unescape(encodeURIComponent(input));
        }
        else {
            input = input.replace(/\r\n/g, "\n");
            var utftext = "";
            for (var n = 0; n < input.length; n++) {
                var c = input.charCodeAt(n);
                if (c < 128) {
                    utftext += String.fromCharCode(c);
                }
                else if (c > 127 && c < 2048) {
                    utftext += String.fromCharCode((c >> 6) | 192);
                    utftext += String.fromCharCode((c & 63) | 128);
                }
                else {
                    utftext += String.fromCharCode((c >> 12) | 224);
                    utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                    utftext += String.fromCharCode((c & 63) | 128);
                }
            }
            input = utftext;
        }
        // Encode to Base64 string
        if (typeof window.btoa != "undefined")
            return window.btoa(input);
        var output = "";
        var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
        var i = 0;
        while (i < input.length) {
            chr1 = input.charCodeAt(i++);
            chr2 = input.charCodeAt(i++);
            chr3 = input.charCodeAt(i++);
            enc1 = chr1 >> 2;
            enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
            enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
            enc4 = chr3 & 63;
            if (isNaN(chr2))
                enc3 = enc4 = 64;
            else if (isNaN(chr3))
                enc4 = 64;
            output =
                output +
                    this._keyStr.charAt(enc1) +
                    this._keyStr.charAt(enc2) +
                    this._keyStr.charAt(enc3) +
                    this._keyStr.charAt(enc4);
        }
        return output;
    }
    base64Decode(input) {
        if (input == null)
            return "";
        var output = "";
        // Decode from Base64 string
        if (typeof window.atob != "undefined") {
            output = window.atob(input);
        }
        else {
            var chr1, chr2, chr3;
            var enc1, enc2, enc3, enc4;
            var i = 0;
            input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
            while (i < input.length) {
                enc1 = this._keyStr.indexOf(input.charAt(i++));
                enc2 = this._keyStr.indexOf(input.charAt(i++));
                enc3 = this._keyStr.indexOf(input.charAt(i++));
                enc4 = this._keyStr.indexOf(input.charAt(i++));
                chr1 = (enc1 << 2) | (enc2 >> 4);
                chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
                chr3 = ((enc3 & 3) << 6) | enc4;
                output = output + String.fromCharCode(chr1);
                if (enc3 != 64) {
                    output = output + String.fromCharCode(chr2);
                }
                if (enc4 != 64) {
                    output = output + String.fromCharCode(chr3);
                }
            }
        }
        // Encode to UTF-8 string
        if (typeof escape != "undefined")
            return decodeURIComponent(escape(output));
        var string = "";
        var i = 0;
        var c = 0;
        var c1 = 0;
        var c2 = 0;
        var c3 = 0;
        while (i < output.length) {
            c = output.charCodeAt(i);
            if (c < 128) {
                string += String.fromCharCode(c);
                i++;
            }
            else if (c > 191 && c < 224) {
                c2 = output.charCodeAt(i + 1);
                string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                i += 2;
            }
            else {
                c2 = output.charCodeAt(i + 1);
                c3 = output.charCodeAt(i + 2);
                string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                i += 3;
            }
        }
        return string;
    }
    get cultures() {
        if (this._cultures.length == 0)
            this._cultures = [
                {
                    "name": " ",
                    "value": ""
                },
                {
                    "name": "Afar (Djibouti)  (aa-DJ)",
                    "value": "aa-DJ"
                },
                {
                    "name": "Afar (Eritrea)  (aa-ER)",
                    "value": "aa-ER"
                },
                {
                    "name": "Afar (Ethiopia)  (aa-ET)",
                    "value": "aa-ET"
                },
                {
                    "name": "Afrikaans (Namibia)  (af-NA)",
                    "value": "af-NA"
                },
                {
                    "name": "Afrikaans (South Africa)  (af-ZA)",
                    "value": "af-ZA"
                },
                {
                    "name": "Aghem (Cameroon)  (agq-CM)",
                    "value": "agq-CM"
                },
                {
                    "name": "Akan (Ghana)  (ak-GH)",
                    "value": "ak-GH"
                },
                {
                    "name": "Albanian (Albania)  (sq-AL)",
                    "value": "sq-AL"
                },
                {
                    "name": "Albanian (Kosovo)  (sq-XK)",
                    "value": "sq-XK"
                },
                {
                    "name": "Albanian (North Macedonia)  (sq-MK)",
                    "value": "sq-MK"
                },
                {
                    "name": "Alsatian (France)  (gsw-FR)",
                    "value": "gsw-FR"
                },
                {
                    "name": "Alsatian (Liechtenstein)  (gsw-LI)",
                    "value": "gsw-LI"
                },
                {
                    "name": "Alsatian (Switzerland)  (gsw-CH)",
                    "value": "gsw-CH"
                },
                {
                    "name": "Amharic (Ethiopia)  (am-ET)",
                    "value": "am-ET"
                },
                {
                    "name": "Arabic (Algeria)  (ar-DZ)",
                    "value": "ar-DZ"
                },
                {
                    "name": "Arabic (Bahrain)  (ar-BH)",
                    "value": "ar-BH"
                },
                {
                    "name": "Arabic (Chad)  (ar-TD)",
                    "value": "ar-TD"
                },
                {
                    "name": "Arabic (Comoros)  (ar-KM)",
                    "value": "ar-KM"
                },
                {
                    "name": "Arabic (Djibouti)  (ar-DJ)",
                    "value": "ar-DJ"
                },
                {
                    "name": "Arabic (Egypt)  (ar-EG)",
                    "value": "ar-EG"
                },
                {
                    "name": "Arabic (Eritrea)  (ar-ER)",
                    "value": "ar-ER"
                },
                {
                    "name": "Arabic (Iraq)  (ar-IQ)",
                    "value": "ar-IQ"
                },
                {
                    "name": "Arabic (Israel)  (ar-IL)",
                    "value": "ar-IL"
                },
                {
                    "name": "Arabic (Jordan)  (ar-JO)",
                    "value": "ar-JO"
                },
                {
                    "name": "Arabic (Kuwait)  (ar-KW)",
                    "value": "ar-KW"
                },
                {
                    "name": "Arabic (Lebanon)  (ar-LB)",
                    "value": "ar-LB"
                },
                {
                    "name": "Arabic (Libya)  (ar-LY)",
                    "value": "ar-LY"
                },
                {
                    "name": "Arabic (Mauritania)  (ar-MR)",
                    "value": "ar-MR"
                },
                {
                    "name": "Arabic (Morocco)  (ar-MA)",
                    "value": "ar-MA"
                },
                {
                    "name": "Arabic (Oman)  (ar-OM)",
                    "value": "ar-OM"
                },
                {
                    "name": "Arabic (Palestinian Authority)  (ar-PS)",
                    "value": "ar-PS"
                },
                {
                    "name": "Arabic (Qatar)  (ar-QA)",
                    "value": "ar-QA"
                },
                {
                    "name": "Arabic (Saudi Arabia)  (ar-SA)",
                    "value": "ar-SA"
                },
                {
                    "name": "Arabic (Somalia)  (ar-SO)",
                    "value": "ar-SO"
                },
                {
                    "name": "Arabic (South Sudan)  (ar-SS)",
                    "value": "ar-SS"
                },
                {
                    "name": "Arabic (Sudan)  (ar-SD)",
                    "value": "ar-SD"
                },
                {
                    "name": "Arabic (Syria)  (ar-SY)",
                    "value": "ar-SY"
                },
                {
                    "name": "Arabic (Tunisia)  (ar-TN)",
                    "value": "ar-TN"
                },
                {
                    "name": "Arabic (U.A.E.)  (ar-AE)",
                    "value": "ar-AE"
                },
                {
                    "name": "Arabic (World)  (ar-001)",
                    "value": "ar-001"
                },
                {
                    "name": "Arabic (Yemen)  (ar-YE)",
                    "value": "ar-YE"
                },
                {
                    "name": "Armenian (Armenia)  (hy-AM)",
                    "value": "hy-AM"
                },
                {
                    "name": "Assamese (India)  (as-IN)",
                    "value": "as-IN"
                },
                {
                    "name": "Asturian (Spain)  (ast-ES)",
                    "value": "ast-ES"
                },
                {
                    "name": "Asu (Tanzania)  (asa-TZ)",
                    "value": "asa-TZ"
                },
                {
                    "name": "Azerbaijani (Cyrillic, Azerbaijan)  (az-Cyrl-AZ)",
                    "value": "az-Cyrl-AZ"
                },
                {
                    "name": "Azerbaijani (Latin, Azerbaijan)  (az-Latn-AZ)",
                    "value": "az-Latn-AZ"
                },
                {
                    "name": "Bafia (Cameroon)  (ksf-CM)",
                    "value": "ksf-CM"
                },
                {
                    "name": "Bambara (Latin, Mali)  (bm-Latn-ML)",
                    "value": "bm-Latn-ML"
                },
                {
                    "name": "Bangla (Bangladesh)  (bn-BD)",
                    "value": "bn-BD"
                },
                {
                    "name": "Bangla (India)  (bn-IN)",
                    "value": "bn-IN"
                },
                {
                    "name": "Basaa (Cameroon)  (bas-CM)",
                    "value": "bas-CM"
                },
                {
                    "name": "Bashkir (Russia)  (ba-RU)",
                    "value": "ba-RU"
                },
                {
                    "name": "Basque (Basque)  (eu-ES)",
                    "value": "eu-ES"
                },
                {
                    "name": "Belarusian (Belarus)  (be-BY)",
                    "value": "be-BY"
                },
                {
                    "name": "Bemba (Zambia)  (bem-ZM)",
                    "value": "bem-ZM"
                },
                {
                    "name": "Bena (Tanzania)  (bez-TZ)",
                    "value": "bez-TZ"
                },
                {
                    "name": "Blin (Eritrea)  (byn-ER)",
                    "value": "byn-ER"
                },
                {
                    "name": "Bodo (India)  (brx-IN)",
                    "value": "brx-IN"
                },
                {
                    "name": "Bosnian (Cyrillic, Bosnia and Herzegovina)  (bs-Cyrl-BA)",
                    "value": "bs-Cyrl-BA"
                },
                {
                    "name": "Bosnian (Latin, Bosnia and Herzegovina)  (bs-Latn-BA)",
                    "value": "bs-Latn-BA"
                },
                {
                    "name": "Breton (France)  (br-FR)",
                    "value": "br-FR"
                },
                {
                    "name": "Bulgarian (Bulgaria)  (bg-BG)",
                    "value": "bg-BG"
                },
                {
                    "name": "Burmese (Myanmar)  (my-MM)",
                    "value": "my-MM"
                },
                {
                    "name": "Catalan (Andorra)  (ca-AD)",
                    "value": "ca-AD"
                },
                {
                    "name": "Catalan (Catalan)  (ca-ES)",
                    "value": "ca-ES"
                },
                {
                    "name": "Catalan (France)  (ca-FR)",
                    "value": "ca-FR"
                },
                {
                    "name": "Catalan (Italy)  (ca-IT)",
                    "value": "ca-IT"
                },
                {
                    "name": "Cebuano (Latin, Philippines)  (ceb-Latn-PH)",
                    "value": "ceb-Latn-PH"
                },
                {
                    "name": "Central Atlas Tamazight (Arabic, Morocco)  (tzm-Arab-MA)",
                    "value": "tzm-Arab-MA"
                },
                {
                    "name": "Central Atlas Tamazight (Latin, Morocco)  (tzm-Latn-MA)",
                    "value": "tzm-Latn-MA"
                },
                {
                    "name": "Central Atlas Tamazight (Tifinagh, Morocco)  (tzm-Tfng-MA)",
                    "value": "tzm-Tfng-MA"
                },
                {
                    "name": "Central Kurdish (Iraq)  (ku-Arab-IQ)",
                    "value": "ku-Arab-IQ"
                },
                {
                    "name": "Chakma (Chakma, Bangladesh)  (ccp-Cakm-BD)",
                    "value": "ccp-Cakm-BD"
                },
                {
                    "name": "Chakma (Chakma, India)  (ccp-Cakm-IN)",
                    "value": "ccp-Cakm-IN"
                },
                {
                    "name": "Chechen (Russia)  (ce-RU)",
                    "value": "ce-RU"
                },
                {
                    "name": "Cherokee (Cherokee)  (chr-Cher-US)",
                    "value": "chr-Cher-US"
                },
                {
                    "name": "Chiga (Uganda)  (cgg-UG)",
                    "value": "cgg-UG"
                },
                {
                    "name": "Chinese (Simplified Han, Hong Kong SAR)  (zh-Hans-HK)",
                    "value": "zh-Hans-HK"
                },
                {
                    "name": "Chinese (Simplified Han, Macao SAR)  (zh-Hans-MO)",
                    "value": "zh-Hans-MO"
                },
                {
                    "name": "Chinese (Simplified, PRC)  (zh-CN)",
                    "value": "zh-CN"
                },
                {
                    "name": "Chinese (Simplified, Singapore)  (zh-SG)",
                    "value": "zh-SG"
                },
                {
                    "name": "Chinese (Traditional, Hong Kong S.A.R.)  (zh-HK)",
                    "value": "zh-HK"
                },
                {
                    "name": "Chinese (Traditional, Macao S.A.R.)  (zh-MO)",
                    "value": "zh-MO"
                },
                {
                    "name": "Chinese (Traditional, Taiwan)  (zh-TW)",
                    "value": "zh-TW"
                },
                {
                    "name": "Church Slavic (Russia)  (cu-RU)",
                    "value": "cu-RU"
                },
                {
                    "name": "Cornish (United Kingdom)  (kw-GB)",
                    "value": "kw-GB"
                },
                {
                    "name": "Corsican (France)  (co-FR)",
                    "value": "co-FR"
                },
                {
                    "name": "Croatian (Croatia)  (hr-HR)",
                    "value": "hr-HR"
                },
                {
                    "name": "Croatian (Latin, Bosnia and Herzegovina)  (hr-BA)",
                    "value": "hr-BA"
                },
                {
                    "name": "Czech (Czech Republic)  (cs-CZ)",
                    "value": "cs-CZ"
                },
                {
                    "name": "Danish (Denmark)  (da-DK)",
                    "value": "da-DK"
                },
                {
                    "name": "Danish (Greenland)  (da-GL)",
                    "value": "da-GL"
                },
                {
                    "name": "Dari (Afghanistan)  (prs-AF)",
                    "value": "prs-AF"
                },
                {
                    "name": "Divehi (Maldives)  (dv-MV)",
                    "value": "dv-MV"
                },
                {
                    "name": "Duala (Cameroon)  (dua-CM)",
                    "value": "dua-CM"
                },
                {
                    "name": "Dutch (Aruba)  (nl-AW)",
                    "value": "nl-AW"
                },
                {
                    "name": "Dutch (Belgium)  (nl-BE)",
                    "value": "nl-BE"
                },
                {
                    "name": "Dutch (Bonaire, Sint Eustatius and Saba)  (nl-BQ)",
                    "value": "nl-BQ"
                },
                {
                    "name": "Dutch (Curaçao)  (nl-CW)",
                    "value": "nl-CW"
                },
                {
                    "name": "Dutch (Netherlands)  (nl-NL)",
                    "value": "nl-NL"
                },
                {
                    "name": "Dutch (Sint Maarten)  (nl-SX)",
                    "value": "nl-SX"
                },
                {
                    "name": "Dutch (Suriname)  (nl-SR)",
                    "value": "nl-SR"
                },
                {
                    "name": "Dzongkha (Bhutan)  (dz-BT)",
                    "value": "dz-BT"
                },
                {
                    "name": "Edo (Nigeria)  (bin-NG)",
                    "value": "bin-NG"
                },
                {
                    "name": "Embu (Kenya)  (ebu-KE)",
                    "value": "ebu-KE"
                },
                {
                    "name": "English (American Samoa)  (en-AS)",
                    "value": "en-AS"
                },
                {
                    "name": "English (Anguilla)  (en-AI)",
                    "value": "en-AI"
                },
                {
                    "name": "English (Antigua and Barbuda)  (en-AG)",
                    "value": "en-AG"
                },
                {
                    "name": "English (Australia)  (en-AU)",
                    "value": "en-AU"
                },
                {
                    "name": "English (Austria)  (en-AT)",
                    "value": "en-AT"
                },
                {
                    "name": "English (Bahamas)  (en-BS)",
                    "value": "en-BS"
                },
                {
                    "name": "English (Barbados)  (en-BB)",
                    "value": "en-BB"
                },
                {
                    "name": "English (Belgium)  (en-BE)",
                    "value": "en-BE"
                },
                {
                    "name": "English (Belize)  (en-BZ)",
                    "value": "en-BZ"
                },
                {
                    "name": "English (Bermuda)  (en-BM)",
                    "value": "en-BM"
                },
                {
                    "name": "English (Botswana)  (en-BW)",
                    "value": "en-BW"
                },
                {
                    "name": "English (British Indian Ocean Territory)  (en-IO)",
                    "value": "en-IO"
                },
                {
                    "name": "English (British Virgin Islands)  (en-VG)",
                    "value": "en-VG"
                },
                {
                    "name": "English (Burundi)  (en-BI)",
                    "value": "en-BI"
                },
                {
                    "name": "English (Cameroon)  (en-CM)",
                    "value": "en-CM"
                },
                {
                    "name": "English (Canada)  (en-CA)",
                    "value": "en-CA"
                },
                {
                    "name": "English (Caribbean)  (en-029)",
                    "value": "en-029"
                },
                {
                    "name": "English (Cayman Islands)  (en-KY)",
                    "value": "en-KY"
                },
                {
                    "name": "English (Christmas Island)  (en-CX)",
                    "value": "en-CX"
                },
                {
                    "name": "English (Cocos [Keeling] Islands)  (en-CC)",
                    "value": "en-CC"
                },
                {
                    "name": "English (Cook Islands)  (en-CK)",
                    "value": "en-CK"
                },
                {
                    "name": "English (Cyprus)  (en-CY)",
                    "value": "en-CY"
                },
                {
                    "name": "English (Denmark)  (en-DK)",
                    "value": "en-DK"
                },
                {
                    "name": "English (Dominica)  (en-DM)",
                    "value": "en-DM"
                },
                {
                    "name": "English (Eritrea)  (en-ER)",
                    "value": "en-ER"
                },
                {
                    "name": "English (Europe)  (en-150)",
                    "value": "en-150"
                },
                {
                    "name": "English (Falkland Islands)  (en-FK)",
                    "value": "en-FK"
                },
                {
                    "name": "English (Fiji)  (en-FJ)",
                    "value": "en-FJ"
                },
                {
                    "name": "English (Finland)  (en-FI)",
                    "value": "en-FI"
                },
                {
                    "name": "English (Gambia)  (en-GM)",
                    "value": "en-GM"
                },
                {
                    "name": "English (Germany)  (en-DE)",
                    "value": "en-DE"
                },
                {
                    "name": "English (Ghana)  (en-GH)",
                    "value": "en-GH"
                },
                {
                    "name": "English (Gibraltar)  (en-GI)",
                    "value": "en-GI"
                },
                {
                    "name": "English (Grenada)  (en-GD)",
                    "value": "en-GD"
                },
                {
                    "name": "English (Guam)  (en-GU)",
                    "value": "en-GU"
                },
                {
                    "name": "English (Guernsey)  (en-GG)",
                    "value": "en-GG"
                },
                {
                    "name": "English (Guyana)  (en-GY)",
                    "value": "en-GY"
                },
                {
                    "name": "English (Hong Kong SAR)  (en-HK)",
                    "value": "en-HK"
                },
                {
                    "name": "English (India)  (en-IN)",
                    "value": "en-IN"
                },
                {
                    "name": "English (Indonesia)  (en-ID)",
                    "value": "en-ID"
                },
                {
                    "name": "English (Ireland)  (en-IE)",
                    "value": "en-IE"
                },
                {
                    "name": "English (Isle of Man)  (en-IM)",
                    "value": "en-IM"
                },
                {
                    "name": "English (Israel)  (en-IL)",
                    "value": "en-IL"
                },
                {
                    "name": "English (Jamaica)  (en-JM)",
                    "value": "en-JM"
                },
                {
                    "name": "English (Jersey)  (en-JE)",
                    "value": "en-JE"
                },
                {
                    "name": "English (Kenya)  (en-KE)",
                    "value": "en-KE"
                },
                {
                    "name": "English (Kiribati)  (en-KI)",
                    "value": "en-KI"
                },
                {
                    "name": "English (Lesotho)  (en-LS)",
                    "value": "en-LS"
                },
                {
                    "name": "English (Liberia)  (en-LR)",
                    "value": "en-LR"
                },
                {
                    "name": "English (Macao SAR)  (en-MO)",
                    "value": "en-MO"
                },
                {
                    "name": "English (Madagascar)  (en-MG)",
                    "value": "en-MG"
                },
                {
                    "name": "English (Malawi)  (en-MW)",
                    "value": "en-MW"
                },
                {
                    "name": "English (Malaysia)  (en-MY)",
                    "value": "en-MY"
                },
                {
                    "name": "English (Malta)  (en-MT)",
                    "value": "en-MT"
                },
                {
                    "name": "English (Marshall Islands)  (en-MH)",
                    "value": "en-MH"
                },
                {
                    "name": "English (Mauritius)  (en-MU)",
                    "value": "en-MU"
                },
                {
                    "name": "English (Micronesia)  (en-FM)",
                    "value": "en-FM"
                },
                {
                    "name": "English (Montserrat)  (en-MS)",
                    "value": "en-MS"
                },
                {
                    "name": "English (Namibia)  (en-NA)",
                    "value": "en-NA"
                },
                {
                    "name": "English (Nauru)  (en-NR)",
                    "value": "en-NR"
                },
                {
                    "name": "English (Netherlands)  (en-NL)",
                    "value": "en-NL"
                },
                {
                    "name": "English (New Zealand)  (en-NZ)",
                    "value": "en-NZ"
                },
                {
                    "name": "English (Nigeria)  (en-NG)",
                    "value": "en-NG"
                },
                {
                    "name": "English (Niue)  (en-NU)",
                    "value": "en-NU"
                },
                {
                    "name": "English (Norfolk Island)  (en-NF)",
                    "value": "en-NF"
                },
                {
                    "name": "English (Northern Mariana Islands)  (en-MP)",
                    "value": "en-MP"
                },
                {
                    "name": "English (Pakistan)  (en-PK)",
                    "value": "en-PK"
                },
                {
                    "name": "English (Palau)  (en-PW)",
                    "value": "en-PW"
                },
                {
                    "name": "English (Papua New Guinea)  (en-PG)",
                    "value": "en-PG"
                },
                {
                    "name": "English (Pitcairn Islands)  (en-PN)",
                    "value": "en-PN"
                },
                {
                    "name": "English (Puerto Rico)  (en-PR)",
                    "value": "en-PR"
                },
                {
                    "name": "English (Republic of the Philippines)  (en-PH)",
                    "value": "en-PH"
                },
                {
                    "name": "English (Rwanda)  (en-RW)",
                    "value": "en-RW"
                },
                {
                    "name": "English (Saint Kitts and Nevis)  (en-KN)",
                    "value": "en-KN"
                },
                {
                    "name": "English (Saint Lucia)  (en-LC)",
                    "value": "en-LC"
                },
                {
                    "name": "English (Saint Vincent and the Grenadines)  (en-VC)",
                    "value": "en-VC"
                },
                {
                    "name": "English (Samoa)  (en-WS)",
                    "value": "en-WS"
                },
                {
                    "name": "English (Seychelles)  (en-SC)",
                    "value": "en-SC"
                },
                {
                    "name": "English (Sierra Leone)  (en-SL)",
                    "value": "en-SL"
                },
                {
                    "name": "English (Singapore)  (en-SG)",
                    "value": "en-SG"
                },
                {
                    "name": "English (Sint Maarten)  (en-SX)",
                    "value": "en-SX"
                },
                {
                    "name": "English (Slovenia)  (en-SI)",
                    "value": "en-SI"
                },
                {
                    "name": "English (Solomon Islands)  (en-SB)",
                    "value": "en-SB"
                },
                {
                    "name": "English (South Africa)  (en-ZA)",
                    "value": "en-ZA"
                },
                {
                    "name": "English (South Sudan)  (en-SS)",
                    "value": "en-SS"
                },
                {
                    "name": "English (St Helena, Ascension, Tristan da Cunha)  (en-SH)",
                    "value": "en-SH"
                },
                {
                    "name": "English (Sudan)  (en-SD)",
                    "value": "en-SD"
                },
                {
                    "name": "English (Swaziland)  (en-SZ)",
                    "value": "en-SZ"
                },
                {
                    "name": "English (Sweden)  (en-SE)",
                    "value": "en-SE"
                },
                {
                    "name": "English (Switzerland)  (en-CH)",
                    "value": "en-CH"
                },
                {
                    "name": "English (Tanzania)  (en-TZ)",
                    "value": "en-TZ"
                },
                {
                    "name": "English (Tokelau)  (en-TK)",
                    "value": "en-TK"
                },
                {
                    "name": "English (Tonga)  (en-TO)",
                    "value": "en-TO"
                },
                {
                    "name": "English (Trinidad and Tobago)  (en-TT)",
                    "value": "en-TT"
                },
                {
                    "name": "English (Turks and Caicos Islands)  (en-TC)",
                    "value": "en-TC"
                },
                {
                    "name": "English (Tuvalu)  (en-TV)",
                    "value": "en-TV"
                },
                {
                    "name": "English (Uganda)  (en-UG)",
                    "value": "en-UG"
                },
                {
                    "name": "English (United Arab Emirates)  (en-AE)",
                    "value": "en-AE"
                },
                {
                    "name": "English (United Kingdom)  (en-GB)",
                    "value": "en-GB"
                },
                {
                    "name": "English (United States)  (en-US)",
                    "value": "en-US"
                },
                {
                    "name": "English (US Minor Outlying Islands)  (en-UM)",
                    "value": "en-UM"
                },
                {
                    "name": "English (US Virgin Islands)  (en-VI)",
                    "value": "en-VI"
                },
                {
                    "name": "English (Vanuatu)  (en-VU)",
                    "value": "en-VU"
                },
                {
                    "name": "English (World)  (en-001)",
                    "value": "en-001"
                },
                {
                    "name": "English (Zambia)  (en-ZM)",
                    "value": "en-ZM"
                },
                {
                    "name": "English (Zimbabwe)  (en-ZW)",
                    "value": "en-ZW"
                },
                {
                    "name": "Esperanto (World)  (eo-001)",
                    "value": "eo-001"
                },
                {
                    "name": "Estonian (Estonia)  (et-EE)",
                    "value": "et-EE"
                },
                {
                    "name": "Ewe (Ghana)  (ee-GH)",
                    "value": "ee-GH"
                },
                {
                    "name": "Ewe (Togo)  (ee-TG)",
                    "value": "ee-TG"
                },
                {
                    "name": "Ewondo (Cameroon)  (ewo-CM)",
                    "value": "ewo-CM"
                },
                {
                    "name": "Faroese (Denmark)  (fo-DK)",
                    "value": "fo-DK"
                },
                {
                    "name": "Faroese (Faroe Islands)  (fo-FO)",
                    "value": "fo-FO"
                },
                {
                    "name": "Filipino (Philippines)  (fil-PH)",
                    "value": "fil-PH"
                },
                {
                    "name": "Finnish (Finland)  (fi-FI)",
                    "value": "fi-FI"
                },
                {
                    "name": "French (Algeria)  (fr-DZ)",
                    "value": "fr-DZ"
                },
                {
                    "name": "French (Belgium)  (fr-BE)",
                    "value": "fr-BE"
                },
                {
                    "name": "French (Benin)  (fr-BJ)",
                    "value": "fr-BJ"
                },
                {
                    "name": "French (Burkina Faso)  (fr-BF)",
                    "value": "fr-BF"
                },
                {
                    "name": "French (Burundi)  (fr-BI)",
                    "value": "fr-BI"
                },
                {
                    "name": "French (Cameroon)  (fr-CM)",
                    "value": "fr-CM"
                },
                {
                    "name": "French (Canada)  (fr-CA)",
                    "value": "fr-CA"
                },
                {
                    "name": "French (Caribbean)  (fr-029)",
                    "value": "fr-029"
                },
                {
                    "name": "French (Central African Republic)  (fr-CF)",
                    "value": "fr-CF"
                },
                {
                    "name": "French (Chad)  (fr-TD)",
                    "value": "fr-TD"
                },
                {
                    "name": "French (Comoros)  (fr-KM)",
                    "value": "fr-KM"
                },
                {
                    "name": "French (Congo DRC)  (fr-CD)",
                    "value": "fr-CD"
                },
                {
                    "name": "French (Congo)  (fr-CG)",
                    "value": "fr-CG"
                },
                {
                    "name": "French (Côte d’Ivoire)  (fr-CI)",
                    "value": "fr-CI"
                },
                {
                    "name": "French (Djibouti)  (fr-DJ)",
                    "value": "fr-DJ"
                },
                {
                    "name": "French (Equatorial Guinea)  (fr-GQ)",
                    "value": "fr-GQ"
                },
                {
                    "name": "French (France)  (fr-FR)",
                    "value": "fr-FR"
                },
                {
                    "name": "French (French Guiana)  (fr-GF)",
                    "value": "fr-GF"
                },
                {
                    "name": "French (French Polynesia)  (fr-PF)",
                    "value": "fr-PF"
                },
                {
                    "name": "French (Gabon)  (fr-GA)",
                    "value": "fr-GA"
                },
                {
                    "name": "French (Guadeloupe)  (fr-GP)",
                    "value": "fr-GP"
                },
                {
                    "name": "French (Guinea)  (fr-GN)",
                    "value": "fr-GN"
                },
                {
                    "name": "French (Haiti)  (fr-HT)",
                    "value": "fr-HT"
                },
                {
                    "name": "French (Luxembourg)  (fr-LU)",
                    "value": "fr-LU"
                },
                {
                    "name": "French (Madagascar)  (fr-MG)",
                    "value": "fr-MG"
                },
                {
                    "name": "French (Mali)  (fr-ML)",
                    "value": "fr-ML"
                },
                {
                    "name": "French (Martinique)  (fr-MQ)",
                    "value": "fr-MQ"
                },
                {
                    "name": "French (Mauritania)  (fr-MR)",
                    "value": "fr-MR"
                },
                {
                    "name": "French (Mauritius)  (fr-MU)",
                    "value": "fr-MU"
                },
                {
                    "name": "French (Mayotte)  (fr-YT)",
                    "value": "fr-YT"
                },
                {
                    "name": "French (Monaco)  (fr-MC)",
                    "value": "fr-MC"
                },
                {
                    "name": "French (Morocco)  (fr-MA)",
                    "value": "fr-MA"
                },
                {
                    "name": "French (New Caledonia)  (fr-NC)",
                    "value": "fr-NC"
                },
                {
                    "name": "French (Niger)  (fr-NE)",
                    "value": "fr-NE"
                },
                {
                    "name": "French (Reunion)  (fr-RE)",
                    "value": "fr-RE"
                },
                {
                    "name": "French (Rwanda)  (fr-RW)",
                    "value": "fr-RW"
                },
                {
                    "name": "French (Saint Barthélemy)  (fr-BL)",
                    "value": "fr-BL"
                },
                {
                    "name": "French (Saint Martin)  (fr-MF)",
                    "value": "fr-MF"
                },
                {
                    "name": "French (Saint Pierre and Miquelon)  (fr-PM)",
                    "value": "fr-PM"
                },
                {
                    "name": "French (Senegal)  (fr-SN)",
                    "value": "fr-SN"
                },
                {
                    "name": "French (Seychelles)  (fr-SC)",
                    "value": "fr-SC"
                },
                {
                    "name": "French (Switzerland)  (fr-CH)",
                    "value": "fr-CH"
                },
                {
                    "name": "French (Syria)  (fr-SY)",
                    "value": "fr-SY"
                },
                {
                    "name": "French (Togo)  (fr-TG)",
                    "value": "fr-TG"
                },
                {
                    "name": "French (Tunisia)  (fr-TN)",
                    "value": "fr-TN"
                },
                {
                    "name": "French (Vanuatu)  (fr-VU)",
                    "value": "fr-VU"
                },
                {
                    "name": "French (Wallis and Futuna)  (fr-WF)",
                    "value": "fr-WF"
                },
                {
                    "name": "Frisian (Netherlands)  (fy-NL)",
                    "value": "fy-NL"
                },
                {
                    "name": "Friulian (Italy)  (fur-IT)",
                    "value": "fur-IT"
                },
                {
                    "name": "Fulah (Latin, Burkina Faso)  (ff-Latn-BF)",
                    "value": "ff-Latn-BF"
                },
                {
                    "name": "Fulah (Latin, Cameroon)  (ff-Latn-CM)",
                    "value": "ff-Latn-CM"
                },
                {
                    "name": "Fulah (Latin, Gambia)  (ff-Latn-GM)",
                    "value": "ff-Latn-GM"
                },
                {
                    "name": "Fulah (Latin, Ghana)  (ff-Latn-GH)",
                    "value": "ff-Latn-GH"
                },
                {
                    "name": "Fulah (Latin, Guinea)  (ff-Latn-GN)",
                    "value": "ff-Latn-GN"
                },
                {
                    "name": "Fulah (Latin, Guinea-Bissau)  (ff-Latn-GW)",
                    "value": "ff-Latn-GW"
                },
                {
                    "name": "Fulah (Latin, Liberia)  (ff-Latn-LR)",
                    "value": "ff-Latn-LR"
                },
                {
                    "name": "Fulah (Latin, Mauritania)  (ff-Latn-MR)",
                    "value": "ff-Latn-MR"
                },
                {
                    "name": "Fulah (Latin, Niger)  (ff-Latn-NE)",
                    "value": "ff-Latn-NE"
                },
                {
                    "name": "Fulah (Latin, Nigeria)  (ff-Latn-NG)",
                    "value": "ff-Latn-NG"
                },
                {
                    "name": "Fulah (Latin, Senegal)  (ff-Latn-SN)",
                    "value": "ff-Latn-SN"
                },
                {
                    "name": "Fulah (Latin, Sierra Leone)  (ff-Latn-SL)",
                    "value": "ff-Latn-SL"
                },
                {
                    "name": "Galician (Galician)  (gl-ES)",
                    "value": "gl-ES"
                },
                {
                    "name": "Ganda (Uganda)  (lg-UG)",
                    "value": "lg-UG"
                },
                {
                    "name": "Georgian (Georgia)  (ka-GE)",
                    "value": "ka-GE"
                },
                {
                    "name": "German (Austria)  (de-AT)",
                    "value": "de-AT"
                },
                {
                    "name": "German (Belgium)  (de-BE)",
                    "value": "de-BE"
                },
                {
                    "name": "German (Germany)  (de-DE)",
                    "value": "de-DE"
                },
                {
                    "name": "German (Italy)  (de-IT)",
                    "value": "de-IT"
                },
                {
                    "name": "German (Liechtenstein)  (de-LI)",
                    "value": "de-LI"
                },
                {
                    "name": "German (Luxembourg)  (de-LU)",
                    "value": "de-LU"
                },
                {
                    "name": "German (Switzerland)  (de-CH)",
                    "value": "de-CH"
                },
                {
                    "name": "Greek (Cyprus)  (el-CY)",
                    "value": "el-CY"
                },
                {
                    "name": "Greek (Greece)  (el-GR)",
                    "value": "el-GR"
                },
                {
                    "name": "Greenlandic (Greenland)  (kl-GL)",
                    "value": "kl-GL"
                },
                {
                    "name": "Guarani (Paraguay)  (gn-PY)",
                    "value": "gn-PY"
                },
                {
                    "name": "Gujarati (India)  (gu-IN)",
                    "value": "gu-IN"
                },
                {
                    "name": "Gusii (Kenya)  (guz-KE)",
                    "value": "guz-KE"
                },
                {
                    "name": "Hausa (Latin, Ghana)  (ha-Latn-GH)",
                    "value": "ha-Latn-GH"
                },
                {
                    "name": "Hausa (Latin, Niger)  (ha-Latn-NE)",
                    "value": "ha-Latn-NE"
                },
                {
                    "name": "Hausa (Latin, Nigeria)  (ha-Latn-NG)",
                    "value": "ha-Latn-NG"
                },
                {
                    "name": "Hawaiian (United States)  (haw-US)",
                    "value": "haw-US"
                },
                {
                    "name": "Hebrew (Israel)  (he-IL)",
                    "value": "he-IL"
                },
                {
                    "name": "Hindi (India)  (hi-IN)",
                    "value": "hi-IN"
                },
                {
                    "name": "Hungarian (Hungary)  (hu-HU)",
                    "value": "hu-HU"
                },
                {
                    "name": "Ibibio (Nigeria)  (ibb-NG)",
                    "value": "ibb-NG"
                },
                {
                    "name": "Icelandic (Iceland)  (is-IS)",
                    "value": "is-IS"
                },
                {
                    "name": "Igbo (Nigeria)  (ig-NG)",
                    "value": "ig-NG"
                },
                {
                    "name": "Indonesian (Indonesia)  (id-ID)",
                    "value": "id-ID"
                },
                {
                    "name": "Interlingua (World)  (ia-001)",
                    "value": "ia-001"
                },
                {
                    "name": "Inuktitut (Latin, Canada)  (iu-Latn-CA)",
                    "value": "iu-Latn-CA"
                },
                {
                    "name": "Inuktitut (Syllabics, Canada)  (iu-Cans-CA)",
                    "value": "iu-Cans-CA"
                },
                {
                    "name": "Irish (Ireland)  (ga-IE)",
                    "value": "ga-IE"
                },
                {
                    "name": "isiXhosa (South Africa)  (xh-ZA)",
                    "value": "xh-ZA"
                },
                {
                    "name": "isiZulu (South Africa)  (zu-ZA)",
                    "value": "zu-ZA"
                },
                {
                    "name": "Italian (Italy)  (it-IT)",
                    "value": "it-IT"
                },
                {
                    "name": "Italian (San Marino)  (it-SM)",
                    "value": "it-SM"
                },
                {
                    "name": "Italian (Switzerland)  (it-CH)",
                    "value": "it-CH"
                },
                {
                    "name": "Italian (Vatican City)  (it-VA)",
                    "value": "it-VA"
                },
                {
                    "name": "Japanese (Japan)  (ja-JP)",
                    "value": "ja-JP"
                },
                {
                    "name": "Javanese (Indonesia)  (jv-Latn-ID)",
                    "value": "jv-Latn-ID"
                },
                {
                    "name": "Javanese (Javanese, Indonesia)  (jv-Java-ID)",
                    "value": "jv-Java-ID"
                },
                {
                    "name": "Jola-Fonyi (Senegal)  (dyo-SN)",
                    "value": "dyo-SN"
                },
                {
                    "name": "Kabuverdianu (Cabo Verde)  (kea-CV)",
                    "value": "kea-CV"
                },
                {
                    "name": "Kabyle (Algeria)  (kab-DZ)",
                    "value": "kab-DZ"
                },
                {
                    "name": "Kako (Cameroon)  (kkj-CM)",
                    "value": "kkj-CM"
                },
                {
                    "name": "Kalenjin (Kenya)  (kln-KE)",
                    "value": "kln-KE"
                },
                {
                    "name": "Kamba (Kenya)  (kam-KE)",
                    "value": "kam-KE"
                },
                {
                    "name": "Kannada (India)  (kn-IN)",
                    "value": "kn-IN"
                },
                {
                    "name": "Kanuri (Nigeria)  (kr-Latn-NG)",
                    "value": "kr-Latn-NG"
                },
                {
                    "name": "Kashmiri (Devanagari, India)  (ks-Deva-IN)",
                    "value": "ks-Deva-IN"
                },
                {
                    "name": "Kashmiri (Perso-Arabic)  (ks-Arab-IN)",
                    "value": "ks-Arab-IN"
                },
                {
                    "name": "Kazakh (Kazakhstan)  (kk-KZ)",
                    "value": "kk-KZ"
                },
                {
                    "name": "Khmer (Cambodia)  (km-KH)",
                    "value": "km-KH"
                },
                {
                    "name": "K'iche' (Guatemala)  (quc-Latn-GT)",
                    "value": "quc-Latn-GT"
                },
                {
                    "name": "Kikuyu (Kenya)  (ki-KE)",
                    "value": "ki-KE"
                },
                {
                    "name": "Kinyarwanda (Rwanda)  (rw-RW)",
                    "value": "rw-RW"
                },
                {
                    "name": "Kiswahili (Congo DRC)  (sw-CD)",
                    "value": "sw-CD"
                },
                {
                    "name": "Kiswahili (Kenya)  (sw-KE)",
                    "value": "sw-KE"
                },
                {
                    "name": "Kiswahili (Tanzania)  (sw-TZ)",
                    "value": "sw-TZ"
                },
                {
                    "name": "Kiswahili (Uganda)  (sw-UG)",
                    "value": "sw-UG"
                },
                {
                    "name": "Konkani (India)  (kok-IN)",
                    "value": "kok-IN"
                },
                {
                    "name": "Korean (Korea)  (ko-KR)",
                    "value": "ko-KR"
                },
                {
                    "name": "Korean (North Korea)  (ko-KP)",
                    "value": "ko-KP"
                },
                {
                    "name": "Koyra Chiini (Mali)  (khq-ML)",
                    "value": "khq-ML"
                },
                {
                    "name": "Koyraboro Senni (Mali)  (ses-ML)",
                    "value": "ses-ML"
                },
                {
                    "name": "Kurdish (Perso-Arabic, Iran)  (ku-Arab-IR)",
                    "value": "ku-Arab-IR"
                },
                {
                    "name": "Kwasio (Cameroon)  (nmg-CM)",
                    "value": "nmg-CM"
                },
                {
                    "name": "Kyrgyz (Kyrgyzstan)  (ky-KG)",
                    "value": "ky-KG"
                },
                {
                    "name": "Lakota (United States)  (lkt-US)",
                    "value": "lkt-US"
                },
                {
                    "name": "Langi (Tanzania)  (lag-TZ)",
                    "value": "lag-TZ"
                },
                {
                    "name": "Lao (Lao P.D.R.)  (lo-LA)",
                    "value": "lo-LA"
                },
                {
                    "name": "Latin (World)  (la-001)",
                    "value": "la-001"
                },
                {
                    "name": "Latvian (Latvia)  (lv-LV)",
                    "value": "lv-LV"
                },
                {
                    "name": "Lingala (Angola)  (ln-AO)",
                    "value": "ln-AO"
                },
                {
                    "name": "Lingala (Central African Republic)  (ln-CF)",
                    "value": "ln-CF"
                },
                {
                    "name": "Lingala (Congo DRC)  (ln-CD)",
                    "value": "ln-CD"
                },
                {
                    "name": "Lingala (Congo)  (ln-CG)",
                    "value": "ln-CG"
                },
                {
                    "name": "Lithuanian (Lithuania)  (lt-LT)",
                    "value": "lt-LT"
                },
                {
                    "name": "Low German (Germany)  (nds-DE)",
                    "value": "nds-DE"
                },
                {
                    "name": "Low German (Netherlands)  (nds-NL)",
                    "value": "nds-NL"
                },
                {
                    "name": "Lower Sorbian (Germany)  (dsb-DE)",
                    "value": "dsb-DE"
                },
                {
                    "name": "Luba-Katanga (Congo DRC)  (lu-CD)",
                    "value": "lu-CD"
                },
                {
                    "name": "Luo (Kenya)  (luo-KE)",
                    "value": "luo-KE"
                },
                {
                    "name": "Luxembourgish (Luxembourg)  (lb-LU)",
                    "value": "lb-LU"
                },
                {
                    "name": "Luyia (Kenya)  (luy-KE)",
                    "value": "luy-KE"
                },
                {
                    "name": "Macedonian (North Macedonia)  (mk-MK)",
                    "value": "mk-MK"
                },
                {
                    "name": "Machame (Tanzania)  (jmc-TZ)",
                    "value": "jmc-TZ"
                },
                {
                    "name": "Makhuwa-Meetto (Mozambique)  (mgh-MZ)",
                    "value": "mgh-MZ"
                },
                {
                    "name": "Makonde (Tanzania)  (kde-TZ)",
                    "value": "kde-TZ"
                },
                {
                    "name": "Malagasy (Madagascar)  (mg-MG)",
                    "value": "mg-MG"
                },
                {
                    "name": "Malay (Brunei Darussalam)  (ms-BN)",
                    "value": "ms-BN"
                },
                {
                    "name": "Malay (Latin, Singapore)  (ms-SG)",
                    "value": "ms-SG"
                },
                {
                    "name": "Malay (Malaysia)  (ms-MY)",
                    "value": "ms-MY"
                },
                {
                    "name": "Malayalam (India)  (ml-IN)",
                    "value": "ml-IN"
                },
                {
                    "name": "Maltese (Malta)  (mt-MT)",
                    "value": "mt-MT"
                },
                {
                    "name": "Manipuri (India)  (mni-IN)",
                    "value": "mni-IN"
                },
                {
                    "name": "Manx (Isle of Man)  (gv-IM)",
                    "value": "gv-IM"
                },
                {
                    "name": "Maori (New Zealand)  (mi-NZ)",
                    "value": "mi-NZ"
                },
                {
                    "name": "Mapudungun (Chile)  (arn-CL)",
                    "value": "arn-CL"
                },
                {
                    "name": "Marathi (India)  (mr-IN)",
                    "value": "mr-IN"
                },
                {
                    "name": "Masai (Kenya)  (mas-KE)",
                    "value": "mas-KE"
                },
                {
                    "name": "Masai (Tanzania)  (mas-TZ)",
                    "value": "mas-TZ"
                },
                {
                    "name": "Mazanderani (Iran)  (mzn-IR)",
                    "value": "mzn-IR"
                },
                {
                    "name": "Meru (Kenya)  (mer-KE)",
                    "value": "mer-KE"
                },
                {
                    "name": "Meta' (Cameroon)  (mgo-CM)",
                    "value": "mgo-CM"
                },
                {
                    "name": "Mohawk (Mohawk)  (moh-CA)",
                    "value": "moh-CA"
                },
                {
                    "name": "Mongolian (Cyrillic, Mongolia)  (mn-MN)",
                    "value": "mn-MN"
                },
                {
                    "name": "Mongolian (Traditional Mongolian, Mongolia)  (mn-Mong-MN)",
                    "value": "mn-Mong-MN"
                },
                {
                    "name": "Mongolian (Traditional Mongolian, PRC)  (mn-Mong-CN)",
                    "value": "mn-Mong-CN"
                },
                {
                    "name": "Morisyen (Mauritius)  (mfe-MU)",
                    "value": "mfe-MU"
                },
                {
                    "name": "Mundang (Cameroon)  (mua-CM)",
                    "value": "mua-CM"
                },
                {
                    "name": "Nama (Namibia)  (naq-NA)",
                    "value": "naq-NA"
                },
                {
                    "name": "Nepali (India)  (ne-IN)",
                    "value": "ne-IN"
                },
                {
                    "name": "Nepali (Nepal)  (ne-NP)",
                    "value": "ne-NP"
                },
                {
                    "name": "Ngiemboon (Cameroon)  (nnh-CM)",
                    "value": "nnh-CM"
                },
                {
                    "name": "Ngomba (Cameroon)  (jgo-CM)",
                    "value": "jgo-CM"
                },
                {
                    "name": "N'ko (Guinea)  (nqo-GN)",
                    "value": "nqo-GN"
                },
                {
                    "name": "North Ndebele (Zimbabwe)  (nd-ZW)",
                    "value": "nd-ZW"
                },
                {
                    "name": "Northern Luri (Iran)  (lrc-IR)",
                    "value": "lrc-IR"
                },
                {
                    "name": "Northern Luri (Iraq)  (lrc-IQ)",
                    "value": "lrc-IQ"
                },
                {
                    "name": "Norwegian, Bokmål (Norway)  (nb-NO)",
                    "value": "nb-NO"
                },
                {
                    "name": "Norwegian, Bokmål (Svalbard and Jan Mayen)  (nb-SJ)",
                    "value": "nb-SJ"
                },
                {
                    "name": "Norwegian, Nynorsk (Norway)  (nn-NO)",
                    "value": "nn-NO"
                },
                {
                    "name": "Nuer (South Sudan)  (nus-SS)",
                    "value": "nus-SS"
                },
                {
                    "name": "Nyankole (Uganda)  (nyn-UG)",
                    "value": "nyn-UG"
                },
                {
                    "name": "Occitan (France)  (oc-FR)",
                    "value": "oc-FR"
                },
                {
                    "name": "Odia (India)  (or-IN)",
                    "value": "or-IN"
                },
                {
                    "name": "Oromo (Ethiopia)  (om-ET)",
                    "value": "om-ET"
                },
                {
                    "name": "Oromo (Kenya)  (om-KE)",
                    "value": "om-KE"
                },
                {
                    "name": "Ossetian (Cyrillic, Georgia)  (os-GE)",
                    "value": "os-GE"
                },
                {
                    "name": "Ossetian (Cyrillic, Russia)  (os-RU)",
                    "value": "os-RU"
                },
                {
                    "name": "Papiamento (Caribbean)  (pap-029)",
                    "value": "pap-029"
                },
                {
                    "name": "Pashto (Afghanistan)  (ps-AF)",
                    "value": "ps-AF"
                },
                {
                    "name": "Pashto (Pakistan)  (ps-PK)",
                    "value": "ps-PK"
                },
                {
                    "name": "Persian (Iran)  (fa-IR)",
                    "value": "fa-IR"
                },
                {
                    "name": "Polish (Poland)  (pl-PL)",
                    "value": "pl-PL"
                },
                {
                    "name": "Portuguese (Angola)  (pt-AO)",
                    "value": "pt-AO"
                },
                {
                    "name": "Portuguese (Brazil)  (pt-BR)",
                    "value": "pt-BR"
                },
                {
                    "name": "Portuguese (Cabo Verde)  (pt-CV)",
                    "value": "pt-CV"
                },
                {
                    "name": "Portuguese (Equatorial Guinea)  (pt-GQ)",
                    "value": "pt-GQ"
                },
                {
                    "name": "Portuguese (Guinea-Bissau)  (pt-GW)",
                    "value": "pt-GW"
                },
                {
                    "name": "Portuguese (Luxembourg)  (pt-LU)",
                    "value": "pt-LU"
                },
                {
                    "name": "Portuguese (Macao SAR)  (pt-MO)",
                    "value": "pt-MO"
                },
                {
                    "name": "Portuguese (Mozambique)  (pt-MZ)",
                    "value": "pt-MZ"
                },
                {
                    "name": "Portuguese (Portugal)  (pt-PT)",
                    "value": "pt-PT"
                },
                {
                    "name": "Portuguese (São Tomé and Príncipe)  (pt-ST)",
                    "value": "pt-ST"
                },
                {
                    "name": "Portuguese (Switzerland)  (pt-CH)",
                    "value": "pt-CH"
                },
                {
                    "name": "Portuguese (Timor-Leste)  (pt-TL)",
                    "value": "pt-TL"
                },
                {
                    "name": "Prussian (World)  (prg-001)",
                    "value": "prg-001"
                },
                {
                    "name": "Punjabi (India)  (pa-IN)",
                    "value": "pa-IN"
                },
                {
                    "name": "Punjabi (Islamic Republic of Pakistan)  (pa-Arab-PK)",
                    "value": "pa-Arab-PK"
                },
                {
                    "name": "Quechua (Bolivia)  (quz-BO)",
                    "value": "quz-BO"
                },
                {
                    "name": "Quechua (Ecuador)  (quz-EC)",
                    "value": "quz-EC"
                },
                {
                    "name": "Quechua (Peru)  (quz-PE)",
                    "value": "quz-PE"
                },
                {
                    "name": "Ripuarian (Germany)  (ksh-DE)",
                    "value": "ksh-DE"
                },
                {
                    "name": "Romanian (Moldova)  (ro-MD)",
                    "value": "ro-MD"
                },
                {
                    "name": "Romanian (Romania)  (ro-RO)",
                    "value": "ro-RO"
                },
                {
                    "name": "Romansh (Switzerland)  (rm-CH)",
                    "value": "rm-CH"
                },
                {
                    "name": "Rombo (Tanzania)  (rof-TZ)",
                    "value": "rof-TZ"
                },
                {
                    "name": "Rundi (Burundi)  (rn-BI)",
                    "value": "rn-BI"
                },
                {
                    "name": "Russian (Belarus)  (ru-BY)",
                    "value": "ru-BY"
                },
                {
                    "name": "Russian (Kazakhstan)  (ru-KZ)",
                    "value": "ru-KZ"
                },
                {
                    "name": "Russian (Kyrgyzstan)  (ru-KG)",
                    "value": "ru-KG"
                },
                {
                    "name": "Russian (Moldova)  (ru-MD)",
                    "value": "ru-MD"
                },
                {
                    "name": "Russian (Russia)  (ru-RU)",
                    "value": "ru-RU"
                },
                {
                    "name": "Russian (Ukraine)  (ru-UA)",
                    "value": "ru-UA"
                },
                {
                    "name": "Rwa (Tanzania)  (rwk-TZ)",
                    "value": "rwk-TZ"
                },
                {
                    "name": "Saho (Eritrea)  (ssy-ER)",
                    "value": "ssy-ER"
                },
                {
                    "name": "Sakha (Russia)  (sah-RU)",
                    "value": "sah-RU"
                },
                {
                    "name": "Samburu (Kenya)  (saq-KE)",
                    "value": "saq-KE"
                },
                {
                    "name": "Sami, Inari (Finland)  (smn-FI)",
                    "value": "smn-FI"
                },
                {
                    "name": "Sami, Lule (Norway)  (smj-NO)",
                    "value": "smj-NO"
                },
                {
                    "name": "Sami, Lule (Sweden)  (smj-SE)",
                    "value": "smj-SE"
                },
                {
                    "name": "Sami, Northern (Finland)  (se-FI)",
                    "value": "se-FI"
                },
                {
                    "name": "Sami, Northern (Norway)  (se-NO)",
                    "value": "se-NO"
                },
                {
                    "name": "Sami, Northern (Sweden)  (se-SE)",
                    "value": "se-SE"
                },
                {
                    "name": "Sami, Skolt (Finland)  (sms-FI)",
                    "value": "sms-FI"
                },
                {
                    "name": "Sami, Southern (Norway)  (sma-NO)",
                    "value": "sma-NO"
                },
                {
                    "name": "Sami, Southern (Sweden)  (sma-SE)",
                    "value": "sma-SE"
                },
                {
                    "name": "Sango (Central African Republic)  (sg-CF)",
                    "value": "sg-CF"
                },
                {
                    "name": "Sangu (Tanzania)  (sbp-TZ)",
                    "value": "sbp-TZ"
                },
                {
                    "name": "Sanskrit (India)  (sa-IN)",
                    "value": "sa-IN"
                },
                {
                    "name": "Scottish Gaelic (United Kingdom)  (gd-GB)",
                    "value": "gd-GB"
                },
                {
                    "name": "Sena (Mozambique)  (seh-MZ)",
                    "value": "seh-MZ"
                },
                {
                    "name": "Serbian (Cyrillic, Bosnia and Herzegovina)  (sr-Cyrl-BA)",
                    "value": "sr-Cyrl-BA"
                },
                {
                    "name": "Serbian (Cyrillic, Kosovo)  (sr-Cyrl-XK)",
                    "value": "sr-Cyrl-XK"
                },
                {
                    "name": "Serbian (Cyrillic, Montenegro)  (sr-Cyrl-ME)",
                    "value": "sr-Cyrl-ME"
                },
                {
                    "name": "Serbian (Cyrillic, Serbia)  (sr-Cyrl-RS)",
                    "value": "sr-Cyrl-RS"
                },
                {
                    "name": "Serbian (Latin, Bosnia and Herzegovina)  (sr-Latn-BA)",
                    "value": "sr-Latn-BA"
                },
                {
                    "name": "Serbian (Latin, Kosovo)  (sr-Latn-XK)",
                    "value": "sr-Latn-XK"
                },
                {
                    "name": "Serbian (Latin, Montenegro)  (sr-Latn-ME)",
                    "value": "sr-Latn-ME"
                },
                {
                    "name": "Serbian (Latin, Serbia)  (sr-Latn-RS)",
                    "value": "sr-Latn-RS"
                },
                {
                    "name": "Sesotho (Lesotho)  (st-LS)",
                    "value": "st-LS"
                },
                {
                    "name": "Sesotho sa Leboa (South Africa)  (nso-ZA)",
                    "value": "nso-ZA"
                },
                {
                    "name": "Setswana (Botswana)  (tn-BW)",
                    "value": "tn-BW"
                },
                {
                    "name": "Setswana (South Africa)  (tn-ZA)",
                    "value": "tn-ZA"
                },
                {
                    "name": "Shambala (Tanzania)  (ksb-TZ)",
                    "value": "ksb-TZ"
                },
                {
                    "name": "Shona (Latin, Zimbabwe)  (sn-Latn-ZW)",
                    "value": "sn-Latn-ZW"
                },
                {
                    "name": "Sindhi (Devanagari, India)  (sd-Deva-IN)",
                    "value": "sd-Deva-IN"
                },
                {
                    "name": "Sindhi (Islamic Republic of Pakistan)  (sd-Arab-PK)",
                    "value": "sd-Arab-PK"
                },
                {
                    "name": "Sinhala (Sri Lanka)  (si-LK)",
                    "value": "si-LK"
                },
                {
                    "name": "Slovak (Slovakia)  (sk-SK)",
                    "value": "sk-SK"
                },
                {
                    "name": "Slovenian (Slovenia)  (sl-SI)",
                    "value": "sl-SI"
                },
                {
                    "name": "Soga (Uganda)  (xog-UG)",
                    "value": "xog-UG"
                },
                {
                    "name": "Somali (Djibouti)  (so-DJ)",
                    "value": "so-DJ"
                },
                {
                    "name": "Somali (Ethiopia)  (so-ET)",
                    "value": "so-ET"
                },
                {
                    "name": "Somali (Kenya)  (so-KE)",
                    "value": "so-KE"
                },
                {
                    "name": "Somali (Somalia)  (so-SO)",
                    "value": "so-SO"
                },
                {
                    "name": "South Ndebele (South Africa)  (nr-ZA)",
                    "value": "nr-ZA"
                },
                {
                    "name": "Southern Sotho (South Africa)  (st-ZA)",
                    "value": "st-ZA"
                },
                {
                    "name": "Spanish (Argentina)  (es-AR)",
                    "value": "es-AR"
                },
                {
                    "name": "Spanish (Belize)  (es-BZ)",
                    "value": "es-BZ"
                },
                {
                    "name": "Spanish (Bolivarian Republic of Venezuela)  (es-VE)",
                    "value": "es-VE"
                },
                {
                    "name": "Spanish (Bolivia)  (es-BO)",
                    "value": "es-BO"
                },
                {
                    "name": "Spanish (Brazil)  (es-BR)",
                    "value": "es-BR"
                },
                {
                    "name": "Spanish (Chile)  (es-CL)",
                    "value": "es-CL"
                },
                {
                    "name": "Spanish (Colombia)  (es-CO)",
                    "value": "es-CO"
                },
                {
                    "name": "Spanish (Costa Rica)  (es-CR)",
                    "value": "es-CR"
                },
                {
                    "name": "Spanish (Cuba)  (es-CU)",
                    "value": "es-CU"
                },
                {
                    "name": "Spanish (Dominican Republic)  (es-DO)",
                    "value": "es-DO"
                },
                {
                    "name": "Spanish (Ecuador)  (es-EC)",
                    "value": "es-EC"
                },
                {
                    "name": "Spanish (El Salvador)  (es-SV)",
                    "value": "es-SV"
                },
                {
                    "name": "Spanish (Equatorial Guinea)  (es-GQ)",
                    "value": "es-GQ"
                },
                {
                    "name": "Spanish (Guatemala)  (es-GT)",
                    "value": "es-GT"
                },
                {
                    "name": "Spanish (Honduras)  (es-HN)",
                    "value": "es-HN"
                },
                {
                    "name": "Spanish (Latin America)  (es-419)",
                    "value": "es-419"
                },
                {
                    "name": "Spanish (Mexico)  (es-MX)",
                    "value": "es-MX"
                },
                {
                    "name": "Spanish (Nicaragua)  (es-NI)",
                    "value": "es-NI"
                },
                {
                    "name": "Spanish (Panama)  (es-PA)",
                    "value": "es-PA"
                },
                {
                    "name": "Spanish (Paraguay)  (es-PY)",
                    "value": "es-PY"
                },
                {
                    "name": "Spanish (Peru)  (es-PE)",
                    "value": "es-PE"
                },
                {
                    "name": "Spanish (Philippines)  (es-PH)",
                    "value": "es-PH"
                },
                {
                    "name": "Spanish (Puerto Rico)  (es-PR)",
                    "value": "es-PR"
                },
                {
                    "name": "Spanish (Spain)  (es-ES)",
                    "value": "es-ES"
                },
                {
                    "name": "Spanish (United States)  (es-US)",
                    "value": "es-US"
                },
                {
                    "name": "Spanish (Uruguay)  (es-UY)",
                    "value": "es-UY"
                },
                {
                    "name": "Standard Moroccan Tamazight (Tifinagh, Morocco)  (zgh-Tfng-MA)",
                    "value": "zgh-Tfng-MA"
                },
                {
                    "name": "Swati (South Africa)  (ss-ZA)",
                    "value": "ss-ZA"
                },
                {
                    "name": "Swati (Swaziland)  (ss-SZ)",
                    "value": "ss-SZ"
                },
                {
                    "name": "Swedish (Åland Islands)  (sv-AX)",
                    "value": "sv-AX"
                },
                {
                    "name": "Swedish (Finland)  (sv-FI)",
                    "value": "sv-FI"
                },
                {
                    "name": "Swedish (Sweden)  (sv-SE)",
                    "value": "sv-SE"
                },
                {
                    "name": "Syriac (Syria)  (syr-SY)",
                    "value": "syr-SY"
                },
                {
                    "name": "Tachelhit (Latin, Morocco)  (shi-Latn-MA)",
                    "value": "shi-Latn-MA"
                },
                {
                    "name": "Tachelhit (Tifinagh, Morocco)  (shi-Tfng-MA)",
                    "value": "shi-Tfng-MA"
                },
                {
                    "name": "Taita (Kenya)  (dav-KE)",
                    "value": "dav-KE"
                },
                {
                    "name": "Tajik (Cyrillic, Tajikistan)  (tg-Cyrl-TJ)",
                    "value": "tg-Cyrl-TJ"
                },
                {
                    "name": "Tamazight (Latin, Algeria)  (tzm-Latn-DZ)",
                    "value": "tzm-Latn-DZ"
                },
                {
                    "name": "Tamil (India)  (ta-IN)",
                    "value": "ta-IN"
                },
                {
                    "name": "Tamil (Malaysia)  (ta-MY)",
                    "value": "ta-MY"
                },
                {
                    "name": "Tamil (Singapore)  (ta-SG)",
                    "value": "ta-SG"
                },
                {
                    "name": "Tamil (Sri Lanka)  (ta-LK)",
                    "value": "ta-LK"
                },
                {
                    "name": "Tasawaq (Niger)  (twq-NE)",
                    "value": "twq-NE"
                },
                {
                    "name": "Tatar (Russia)  (tt-RU)",
                    "value": "tt-RU"
                },
                {
                    "name": "Telugu (India)  (te-IN)",
                    "value": "te-IN"
                },
                {
                    "name": "Teso (Kenya)  (teo-KE)",
                    "value": "teo-KE"
                },
                {
                    "name": "Teso (Uganda)  (teo-UG)",
                    "value": "teo-UG"
                },
                {
                    "name": "Thai (Thailand)  (th-TH)",
                    "value": "th-TH"
                },
                {
                    "name": "Tibetan (India)  (bo-IN)",
                    "value": "bo-IN"
                },
                {
                    "name": "Tibetan (PRC)  (bo-CN)",
                    "value": "bo-CN"
                },
                {
                    "name": "Tigre (Eritrea)  (tig-ER)",
                    "value": "tig-ER"
                },
                {
                    "name": "Tigrinya (Eritrea)  (ti-ER)",
                    "value": "ti-ER"
                },
                {
                    "name": "Tigrinya (Ethiopia)  (ti-ET)",
                    "value": "ti-ET"
                },
                {
                    "name": "Tongan (Tonga)  (to-TO)",
                    "value": "to-TO"
                },
                {
                    "name": "Tsonga (South Africa)  (ts-ZA)",
                    "value": "ts-ZA"
                },
                {
                    "name": "Turkish (Cyprus)  (tr-CY)",
                    "value": "tr-CY"
                },
                {
                    "name": "Turkish (Turkey)  (tr-TR)",
                    "value": "tr-TR"
                },
                {
                    "name": "Turkmen (Turkmenistan)  (tk-TM)",
                    "value": "tk-TM"
                },
                {
                    "name": "Ukrainian (Ukraine)  (uk-UA)",
                    "value": "uk-UA"
                },
                {
                    "name": "Upper Sorbian (Germany)  (hsb-DE)",
                    "value": "hsb-DE"
                },
                {
                    "name": "Urdu (India)  (ur-IN)",
                    "value": "ur-IN"
                },
                {
                    "name": "Urdu (Islamic Republic of Pakistan)  (ur-PK)",
                    "value": "ur-PK"
                },
                {
                    "name": "Uyghur (PRC)  (ug-CN)",
                    "value": "ug-CN"
                },
                {
                    "name": "Uzbek (Cyrillic, Uzbekistan)  (uz-Cyrl-UZ)",
                    "value": "uz-Cyrl-UZ"
                },
                {
                    "name": "Uzbek (Latin, Uzbekistan)  (uz-Latn-UZ)",
                    "value": "uz-Latn-UZ"
                },
                {
                    "name": "Uzbek (Perso-Arabic, Afghanistan)  (uz-Arab-AF)",
                    "value": "uz-Arab-AF"
                },
                {
                    "name": "Vai (Latin, Liberia)  (vai-Latn-LR)",
                    "value": "vai-Latn-LR"
                },
                {
                    "name": "Vai (Vai, Liberia)  (vai-Vaii-LR)",
                    "value": "vai-Vaii-LR"
                },
                {
                    "name": "Valencian (Spain)  (ca-ES-valencia)",
                    "value": "ca-ES-valencia"
                },
                {
                    "name": "Venda (South Africa)  (ve-ZA)",
                    "value": "ve-ZA"
                },
                {
                    "name": "Vietnamese (Vietnam)  (vi-VN)",
                    "value": "vi-VN"
                },
                {
                    "name": "Volapük (World)  (vo-001)",
                    "value": "vo-001"
                },
                {
                    "name": "Vunjo (Tanzania)  (vun-TZ)",
                    "value": "vun-TZ"
                },
                {
                    "name": "Walser (Switzerland)  (wae-CH)",
                    "value": "wae-CH"
                },
                {
                    "name": "Welsh (United Kingdom)  (cy-GB)",
                    "value": "cy-GB"
                },
                {
                    "name": "Wolaytta (Ethiopia)  (wal-ET)",
                    "value": "wal-ET"
                },
                {
                    "name": "Wolof (Senegal)  (wo-SN)",
                    "value": "wo-SN"
                },
                {
                    "name": "Yangben (Cameroon)  (yav-CM)",
                    "value": "yav-CM"
                },
                {
                    "name": "Yi (PRC)  (ii-CN)",
                    "value": "ii-CN"
                },
                {
                    "name": "Yiddish (World)  (yi-001)",
                    "value": "yi-001"
                },
                {
                    "name": "Yoruba (Benin)  (yo-BJ)",
                    "value": "yo-BJ"
                },
                {
                    "name": "Yoruba (Nigeria)  (yo-NG)",
                    "value": "yo-NG"
                },
                {
                    "name": "Zarma (Niger)  (dje-NE)",
                    "value": "dje-NE"
                }
            ];
        return this._cultures;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiHelperService, deps: [{ token: i1.StiModelService }, { token: StiRectangleGeometryLayout }, { token: i2.StiLocalizationService }, { token: i0.NgZone }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiHelperService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiHelperService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: StiRectangleGeometryLayout }, { type: i2.StiLocalizationService }, { type: i0.NgZone }] });
//# sourceMappingURL=data:application/json;base64,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