import { Injectable } from "@angular/core";
import { Subject } from "rxjs";
import { StiFormElement } from "../elements/base/StiFormElement";
import { StiLabelElement } from "../elements/StiLabelElement";
import { StiTableElement } from "../elements/StiTableElement";
import { StiLabelColumnItem } from "../elements/table/columns/StiLabelColumnItem";
import { StiColumnItem } from "../elements/table/StiColumnItem";
import { StiTotalsFieldItem } from "../elements/table/StiTotalsFieldItem";
import { StiRowLabel } from "../elements/table/StiRowLabel";
import { StiStaticHelperService } from "./sti-static-helper.service";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./mouse.service";
export class StiExpressionService {
    static { this.MOUSE_DELTA = 3; }
    getExpressionString(startItem) {
        let expressionObject = { previewString: "", startObject: null, lastCaretOffset: 1 };
        expressionObject.startObject = startItem;
        if (typeof startItem.object == "string") {
            if (startItem.object.length == 1) {
                expressionObject.previewString = startItem.object;
            }
            else {
                let string = "";
                if (startItem.object.toLowerCase() == "value") {
                    string = startItem.object + `('')`;
                }
                else if (startItem.object.toLowerCase() == "line" ||
                    startItem.object.toLowerCase() == "today" ||
                    startItem.object.toLowerCase() == "time") {
                    string = startItem.object;
                }
                else if (startItem.object.toLowerCase() == "cell") {
                    string = startItem.object + "(,,'')";
                }
                else if (startItem.object.toLowerCase() == "total" ||
                    startItem.object.toLowerCase() == "col" ||
                    startItem.object.toLowerCase() == "row") {
                    string = startItem.object + "(,'')";
                }
                else {
                    string = startItem.object + "()";
                }
                expressionObject.previewString = string;
            }
        }
        else {
            if (startItem.object instanceof StiFormElement) {
                expressionObject.previewString = `Value('${startItem.object.name}')`;
            }
            else {
                if (startItem.object instanceof StiTotalsFieldItem) {
                    expressionObject.previewString = `Total(${startItem.object.eParent.totalsFields.indexOf(startItem.object) + 1},'${startItem.object.eParent.name}')`;
                }
                else if (startItem.object instanceof StiColumnItem && !startItem.isCell) {
                    expressionObject.previewString = `Col(${startItem.object.eParent.columns.indexOf(startItem.object) + 1},'${startItem.object.eParent.name}')`;
                }
                else {
                    expressionObject.previewString = `Cell(${startItem.object.eParent.columns.indexOf(startItem.object) + 1},${startItem.index},'${startItem.object.eParent.name}')`;
                }
            }
        }
        return expressionObject;
    }
    startContainerDrag(object) {
        this.startExpressionDraggingX = object.event.clientX;
        this.startExpressionDraggingY = object.event.clientY;
        this.draggableExpressionObject = this.getExpressionString(object);
        this.isDragging = true;
        let elem = this.elementRef.nativeElement;
        elem.focus();
    }
    moveContainer(event) {
        if (this.isDragging) {
            event.preventDefault();
            let elements = document.elementsFromPoint(event.clientX, event.clientY);
            if (elements.find((elem) => elem.classList.contains("expression-preview"))) {
                let currentRange;
                if (document.caretRangeFromPoint) {
                    currentRange = document.caretRangeFromPoint(event.clientX, event.clientY);
                }
                else {
                    let sel = window.getSelection();
                    sel.collapse(event.rangeParent, event.rangeOffset);
                    currentRange = sel.getRangeAt(0);
                }
                this.currentCarretOffset = currentRange.startOffset;
                setTimeout(() => {
                    var range = document.createRange();
                    var sel = window.getSelection();
                    if (this.elementRef.nativeElement.childNodes[0]) {
                        range?.setStart(this.elementRef.nativeElement.childNodes[0], this.currentCarretOffset);
                        range?.collapse(true);
                        sel.removeAllRanges();
                        sel.addRange(range);
                        this.draggableExpressionObject.lastCaretOffset = this.currentCarretOffset;
                    }
                });
            }
            let deltaX = event.clientX - this.startExpressionDraggingX;
            let deltaY = event.clientY - this.startExpressionDraggingY;
            if (this.startExpressionDraggingX - 10 + deltaX < 0) {
                this.expressionDraggableContainerX = 0;
            }
            else if (this.startExpressionDraggingX - 10 + deltaX >
                window.innerWidth - this.elementRef?.nativeElement.clientWidth) {
                this.expressionDraggableContainerX = window.innerWidth - this.elementRef?.nativeElement.clientWidth;
            }
            else {
                this.expressionDraggableContainerX = this.startExpressionDraggingX - 10 + deltaX;
            }
            if (this.startExpressionDraggingY - 10 + deltaY < 0) {
                this.expressionDraggableContainerY = 0;
            }
            else if (this.startExpressionDraggingY - 10 + deltaY >
                window.innerHeight - this.elementRef?.nativeElement.clientHeight) {
                this.expressionDraggableContainerY = window.innerHeight - this.elementRef?.nativeElement.clientHeight;
            }
            else {
                this.expressionDraggableContainerY = this.startExpressionDraggingY - 10 + deltaY;
            }
        }
    }
    endContainerDrag(event) {
        if (this.isDragging) {
            if (document
                .elementsFromPoint(event.clientX, event.clientY)
                .find((element) => element.classList.contains("expression-preview"))) {
                this.needToAddExpression.next(this.draggableExpressionObject);
            }
            this.isDragging = false;
            this.draggableExpressionObject = null;
        }
    }
    constructor(model, mouseService) {
        this.model = model;
        this.mouseService = mouseService;
        this.started = false;
        this.status = {};
        this.componentWidth = 700;
        this.componentHeight = 482;
        this.needToAddExpression = new Subject();
        this.expressionPreviewString = "";
        this.isDragging = false;
        window.onresize = (event) => {
            if (window.innerWidth > this.componentWidth) {
                if (window.innerWidth < this.componentX + this.componentWidth) {
                    this.componentX = (window.innerWidth - this.componentWidth) / 2;
                }
            }
            else {
                this.componentX = 0;
            }
            if (window.innerHeight > this.componentHeight) {
                if (window.innerHeight < this.componentY + this.componentHeight) {
                    this.componentY = (window.innerHeight - this.componentHeight) / 2;
                }
            }
            else {
                this.componentY = 0;
            }
        };
        this.mouseService.getDocumentMouseMove().subscribe((event) => {
            this.moveContainer(event);
        });
        this.mouseService.getDocumentMouseUp().subscribe((event) => {
            this.endContainerDrag(event);
        });
    }
    getCaretOffset(element) {
        let caretOffset = 0;
        let doc = element.ownerDocument || element.document;
        let win = doc.defaultView || doc.parentWindow;
        let sel;
        if (typeof win.getSelection != "undefined") {
            sel = win.getSelection();
            if (sel.rangeCount > 0) {
                let range = win.getSelection().getRangeAt(0);
                let preCaretRange = range.cloneRange();
                preCaretRange.selectNodeContents(element);
                preCaretRange.setEnd(range.endContainer, range.endOffset);
                caretOffset = preCaretRange.toString().length;
            }
        }
        else if ((sel = doc.selection) && sel.type != "Control") {
            let textRange = sel.createRange();
            let preCaretTextRange = doc.body.createTextRange();
            preCaretTextRange.moveToElementText(element);
            preCaretTextRange.setEndPoint("EndToEnd", textRange);
            caretOffset = preCaretTextRange.text.length;
        }
        return caretOffset;
    }
    start() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.model.formEvents.subscribe((e) => {
            if (e.name == "ValueChanged" || e.name == "ComponentDeleted" || e.name == "SetForm" || e.name == "UpdateForm") {
                setTimeout(() => {
                    this.calculate();
                }, 0);
            }
        });
    }
    addDependency(expression, names, dependecies, excludeName) {
        let regex = /(\{.+?\})/g;
        let exec;
        while ((exec = regex.exec(expression)) !== null) {
            names.forEach(n => {
                if (excludeName != n && exec[0].indexOf(`'${n}'`) > 0 && dependecies.indexOf(n) == -1) {
                    dependecies.push(n);
                }
            });
        }
    }
    calculate() {
        let elements = {};
        let dependencies = {};
        let allElements = this.model.form.allElements.filter(el => (el instanceof StiTableElement || el instanceof StiLabelElement));
        let names = allElements.map(e => e.name);
        allElements.forEach((e) => {
            if (e instanceof StiTableElement) {
                let dep = [];
                let table = e;
                table.columns.filter(c => c instanceof StiLabelColumnItem).
                    forEach((col) => this.addDependency(col.expression, names, dep, table.name));
                table.totalsFields.forEach(t => this.addDependency(t.value, names, dep, table.name));
                dependencies[table.name] = dep;
            }
            else if (e instanceof StiLabelElement) {
                let dep = [];
                let label = e;
                this.addDependency(label.text.value, names, dep, label.name);
                dependencies[label.name] = dep;
            }
        });
        let calculatedElements = [];
        let excludeElements = ["dummy"];
        while (excludeElements.length > 0) {
            excludeElements = [];
            allElements.forEach((e) => {
                if (dependencies[e.name].length == 0 || dependencies[e.name].every(name => calculatedElements.indexOf(name) >= 0)) {
                    excludeElements.push(e);
                    calculatedElements.push(e.name);
                    if (e instanceof StiTableElement) {
                        let table = e;
                        table.columns.forEach((c, colIndex) => {
                            if (c instanceof StiLabelColumnItem) {
                                let label = c;
                                label.cells.forEach((c, rowIndex) => {
                                    this.exec(label, elements, table, colIndex, rowIndex);
                                });
                            }
                        });
                        table.totalsFields.forEach((t, index) => {
                            let total = t;
                            this.exec(total, elements, table, null, null, index);
                        });
                        table.rowLabelsContentEditable.forEach((r, index) => {
                            let row = r;
                            this.exec(row, elements, table, null, index);
                        });
                    }
                    else if (e instanceof StiLabelElement) {
                        let label = e;
                        this.exec(label, elements);
                    }
                }
            });
            allElements = allElements.filter(e => excludeElements.indexOf(e) == -1);
        }
    }
    getElementName(element, row) {
        if (element instanceof StiTotalsFieldItem ||
            element instanceof StiLabelColumnItem ||
            element instanceof StiRowLabel) {
            let tables = [];
            this.model.form.pages.forEach((p) => p.allElements.forEach((e) => {
                if (e instanceof StiTableElement) {
                    tables.push(e);
                }
            }));
            let table = tables.find((t) => t.totalsFields?.indexOf(element) >= 0 ||
                t.columns?.indexOf(element) >= 0 ||
                t.rowLabelsContentEditable?.indexOf(element) >= 0);
            if (element instanceof StiRowLabel) {
                return `${table.name}.Row.${row}`;
            }
            if (element instanceof StiTotalsFieldItem) {
                return `${table.name}.0.0.${table.totalsFields.indexOf(element)}`;
            }
            else {
                return `${table.name}.${table.columns?.indexOf(element)}.${row}`;
            }
        }
        else {
            return element.name;
        }
    }
    exec(element, elements, table, col, row, total) {
        let elName = this.getElementName(element, row);
        if (elements[elName] || !("expression" in element)) {
            return;
        }
        else if (this.haveExpression(element)) {
            try {
                elements[elName] = true;
                let this_ = this;
                let Value = function (elementName) {
                    let el = this_.findElement(elementName);
                    if (el) {
                        this_.exec(el, elements);
                        return el.value;
                    }
                    return null;
                };
                let Sum = function (elements) {
                    let sum = 0;
                    try {
                        elements.forEach((element) => {
                            if (this_.isNumber(element)) {
                                sum += element;
                            }
                        });
                    }
                    catch { }
                    return sum;
                };
                let Line = function () {
                    try {
                        return row + 1;
                    }
                    catch {
                        return 0;
                    }
                };
                let Today = function () {
                    try {
                        return StiStaticHelperService.formatDate(new Date(), this_.model.form.settings.dateFormat, this_.model.form.settings.culture);
                    }
                    catch {
                        return null;
                    }
                };
                let Time = function () {
                    try {
                        return StiStaticHelperService.formatDate(new Date(), this_.model.form.settings.timeFormat, this_.model.form.settings.culture);
                    }
                    catch {
                        return null;
                    }
                };
                let Max = function (elements) {
                    let res;
                    try {
                        elements.forEach((element) => {
                            if (this_.isNumber(element)) {
                                if (res == null) {
                                    res = element;
                                }
                                res = Math.max(element, res);
                            }
                        });
                    }
                    catch { }
                    return res;
                };
                let Min = function (elements) {
                    let res;
                    try {
                        elements.forEach((element) => {
                            if (this_.isNumber(element)) {
                                if (res == null) {
                                    res = element;
                                }
                                res = Math.min(element, res);
                            }
                        });
                    }
                    catch { }
                    return res;
                };
                let Total = function (index, tableName) {
                    try {
                        let curTable = tableName ? this_.model.form.getElementByName(tableName) : table;
                        let total = typeof index == "number"
                            ? curTable.totalsFields[index - 1]
                            : curTable.totalsFields.find((t) => t.header == index);
                        this_.exec(total, elements, curTable, null, null, index);
                        return total.value;
                    }
                    catch { }
                };
                let Count = function (elements) {
                    try {
                        return elements.length;
                    }
                    catch {
                        return 0;
                    }
                };
                let Col = function (name, tableName) {
                    try {
                        let curTable = tableName ? this_.model.form.getElementByName(tableName) : table;
                        let column = this_.isNumber(name)
                            ? curTable.columns[name - 1]
                            : curTable.columns.find((c) => c.label.toLowerCase() == name.toLowerCase());
                        let result = [];
                        column["cells"].forEach((cell, index) => {
                            try {
                                this_.exec(column, elements, curTable, curTable.columns.indexOf(column), index);
                                result.push(cell["value"] != undefined ? cell.value : cell);
                            }
                            catch {
                                result.push(undefined);
                            }
                        });
                        return row != null ? result[row] : result;
                    }
                    catch { }
                };
                let Row = function (name, tableName) {
                    try {
                        let curTable = tableName ? this_.model.form.getElementByName(tableName) : table;
                        let rowIndex = this_.isNumber(name)
                            ? name - 1
                            : curTable.rowLabels.findIndex((value) => value.toLowerCase() == name.toLowerCase());
                        let result = [];
                        curTable.columns.forEach((ccol, index) => {
                            try {
                                let cell = ccol["cells"][rowIndex];
                                if (typeof cell == "number") {
                                    result.push(cell);
                                }
                                else {
                                    this_.exec(cell, elements, curTable, index, rowIndex);
                                    result.push(cell["value"] != undefined ? cell.value : cell);
                                }
                            }
                            catch {
                                result.push(undefined);
                            }
                        });
                        return col != null ? result[col] : result;
                    }
                    catch { }
                };
                let Cell = function (colIndex, rowIndex, tableName) {
                    try {
                        let curTable = tableName ? this_.model.form.getElementByName(tableName) : table;
                        let ccol = this_.isNumber(colIndex)
                            ? curTable.columns[colIndex - 1]
                            : curTable.columns.find((c) => c.label == colIndex);
                        let curRowIndex = this_.isNumber(rowIndex)
                            ? rowIndex - 1
                            : curTable.rowLabels.findIndex((value) => value.toLowerCase() == rowIndex.toLowerCase());
                        let cell = ccol["cells"][curRowIndex];
                        this_.exec(cell["value"] != undefined ? cell : ccol, elements, curTable, colIndex, rowIndex);
                        return cell["value"] != undefined ? cell.value : cell;
                    }
                    catch { }
                };
                let regex = /(\{.+?\})/g;
                let exp = element["expression"].toString();
                let exec;
                let displayValue = exp;
                while ((exec = regex.exec(exp)) !== null) {
                    let value = this.isSystemVariables(exec[0]) ? eval(this.replaceSystemVariables(exec[0])) : eval(exec[0]);
                    if (element instanceof StiRowLabel) {
                        value = value;
                    }
                    else {
                        value = typeof value == "function" ? "" : value;
                        value = Number.isNaN(value) || value === undefined ? exec[0] : value;
                    }
                    if (element instanceof StiLabelColumnItem) {
                        element.cells[row] = value;
                    }
                    else if (element instanceof StiRowLabel) {
                        element.value = exec.input;
                    }
                    else {
                        element.value = value;
                    }
                    if (this_.isNumber(value) && !this_.isSystemVariables(exec[0])) {
                        let formattedElement = element instanceof StiLabelElement ? this_.model.form.settings : element;
                        value = this_.model.getFormattedValue(formattedElement, value);
                    }
                    displayValue = displayValue.replace(exec[0], Number.isNaN(value) || value === undefined ? exec[0] : value);
                    if (exec.index > 1 &&
                        !(element instanceof StiLabelElement) &&
                        !(element instanceof StiRowLabel)) {
                        if (element instanceof StiLabelColumnItem) {
                            element.cells[row] = displayValue;
                        }
                        else {
                            element.value = displayValue;
                        }
                    }
                }
                if (element instanceof StiLabelElement || element instanceof StiRowLabel) {
                    element.displayValue = displayValue;
                }
            }
            catch {
                this.resetValue(element, row, element["expression"]);
            }
        }
        else {
            this.resetValue(element, row, element["expression"]);
        }
    }
    replaceSystemVariables(expressionString) {
        let value = expressionString.replace(/\s/g, "").toLowerCase();
        let startIndex;
        let slicedValue;
        if (value.indexOf("line") != -1) {
            startIndex = value.indexOf("line");
        }
        else if (value.indexOf("today") != -1) {
            startIndex = value.indexOf("today");
        }
        else {
            startIndex = value.indexOf("time");
        }
        if (value.slice(startIndex, startIndex + 5) == "today") {
            slicedValue = value.slice(startIndex, startIndex + 5);
        }
        else {
            slicedValue = value.slice(startIndex, startIndex + 4);
        }
        let valueForReplace = slicedValue.split();
        valueForReplace.push("(");
        valueForReplace.push(")");
        let resultString = valueForReplace.join().replace(/,/g, "");
        resultString = resultString[0].toUpperCase() + resultString.slice(1);
        return value.replace(slicedValue, resultString);
    }
    resetValue(element, row, expression) {
        if (element instanceof StiLabelElement) {
            element.displayValue = undefined;
            element.value = null;
        }
        else {
            let value = this.haveExpression(element) && expression?.toString() == parseFloat(expression).toString()
                ? parseFloat(expression)
                : expression?.toString() == parseFloat(expression).toString()
                    ? parseFloat(expression)
                    : expression;
            if (element instanceof StiLabelColumnItem) {
                element.cells[row] = value;
            }
            else {
                element.value = value;
            }
        }
    }
    isNumber(value) {
        return typeof value === "number" && !isNaN(value);
    }
    haveExpression(element) {
        let str = element["expression"];
        let regex = /(\{.+?\})/g;
        let regex2 = /{.+?\}/g;
        return element instanceof StiLabelElement || element instanceof StiRowLabel
            ? regex.test(str)
            : (element instanceof StiTotalsFieldItem || element instanceof StiLabelColumnItem) && regex2.test(str);
    }
    isSystemVariables(string) {
        let value = string.replace(/\s/g, "");
        return (value.toLowerCase().indexOf("line") != -1 ||
            value.toLowerCase().indexOf("today") != -1 ||
            value.toLowerCase().indexOf("time") != -1);
    }
    findElement(name) {
        let el;
        this.model.form.pages.forEach((p) => p.allElements.forEach((e) => {
            if (e.name == name) {
                el = e;
            }
        }));
        return el;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiExpressionService, deps: [{ token: i1.StiModelService }, { token: i2.StiMouseService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiExpressionService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiExpressionService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiMouseService }] });
//# sourceMappingURL=data:application/json;base64,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