import { Injectable } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./http-client.service";
export class StiExportService {
    constructor(model, httpService) {
        this.model = model;
        this.httpService = httpService;
        this.showModalWindow = false;
        this.useReadOnly = false;
        this.usePdfA = false;
        this.openAfterExport = false;
    }
    exportToPdf() {
        let currentForm = this.model.form.saveToReportJsonObject().serialize();
        let data = {
            action: "GeneratePDF",
            form: currentForm,
            settings: {
                usePdfA: this.usePdfA,
                readOnly: this.useReadOnly,
            },
        };
        this.httpService.post(this.model.requestUrl, data, "byteArray", { showProgress: true }).subscribe((data) => {
            let pdfBytes = new Int8Array(data);
            this.model.showProgress = false;
            this.model.downloadFiles(pdfBytes, "ExportFromForm.pdf");
        });
    }
    getPdfBytes() {
        let currentForm = this.model.form.saveToReportJsonObject().serialize();
        let data = {
            action: "GeneratePDF",
            form: currentForm,
            settings: {
                usePdfA: this.usePdfA,
                readOnly: this.useReadOnly,
            },
        };
        return this.httpService
            .post(this.model.requestUrl, data, "byteArray", { showProgress: true })
            .toPromise()
            .then((res) => {
            this.model.showProgress = false;
            return new Int8Array(res);
        });
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiExportService, deps: [{ token: i1.StiModelService }, { token: i2.StiHttpClientService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiExportService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiExportService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHttpClientService }] });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RpLWV4cG9ydC5zZXJ2aWNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc3RpbXVsc29mdC1mb3Jtcy9zcmMvbGliL3NlcnZpY2VzL3N0aS1leHBvcnQuc2VydmljZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsVUFBVSxFQUFFLE1BQU0sZUFBZSxDQUFDOzs7O0FBSzNDLE1BQU0sT0FBTyxnQkFBZ0I7SUFLM0IsWUFBbUIsS0FBc0IsRUFBUyxXQUFpQztRQUFoRSxVQUFLLEdBQUwsS0FBSyxDQUFpQjtRQUFTLGdCQUFXLEdBQVgsV0FBVyxDQUFzQjtRQUo1RSxvQkFBZSxHQUFZLEtBQUssQ0FBQztRQUNqQyxnQkFBVyxHQUFZLEtBQUssQ0FBQztRQUM3QixZQUFPLEdBQVksS0FBSyxDQUFDO1FBQ3pCLG9CQUFlLEdBQVksS0FBSyxDQUFDO0lBQzhDLENBQUM7SUFFaEYsV0FBVztRQUNoQixJQUFJLFdBQVcsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxzQkFBc0IsRUFBRSxDQUFDLFNBQVMsRUFBRSxDQUFDO1FBQ3ZFLElBQUksSUFBSSxHQUFHO1lBQ1QsTUFBTSxFQUFFLGFBQWE7WUFDckIsSUFBSSxFQUFFLFdBQVc7WUFDakIsUUFBUSxFQUFFO2dCQUNSLE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBTztnQkFDckIsUUFBUSxFQUFFLElBQUksQ0FBQyxXQUFXO2FBQzNCO1NBQ0YsQ0FBQztRQUNGLElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxFQUFFLElBQUksRUFBRSxXQUFXLEVBQUUsRUFBRSxZQUFZLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQyxJQUFJLEVBQUUsRUFBRTtZQUN6RyxJQUFJLFFBQVEsR0FBRyxJQUFJLFNBQVMsQ0FBQyxJQUFtQixDQUFDLENBQUM7WUFDbEQsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDO1lBQ2hDLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxDQUFDLFFBQVEsRUFBRSxvQkFBb0IsQ0FBQyxDQUFDO1FBQzNELENBQUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUNNLFdBQVc7UUFDaEIsSUFBSSxXQUFXLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsc0JBQXNCLEVBQUUsQ0FBQyxTQUFTLEVBQUUsQ0FBQztRQUN2RSxJQUFJLElBQUksR0FBRztZQUNULE1BQU0sRUFBRSxhQUFhO1lBQ3JCLElBQUksRUFBRSxXQUFXO1lBQ2pCLFFBQVEsRUFBRTtnQkFDUixPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87Z0JBQ3JCLFFBQVEsRUFBRSxJQUFJLENBQUMsV0FBVzthQUMzQjtTQUNGLENBQUM7UUFDRixPQUFPLElBQUksQ0FBQyxXQUFXO2FBQ3BCLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsRUFBRSxJQUFJLEVBQUUsV0FBVyxFQUFFLEVBQUUsWUFBWSxFQUFFLElBQUksRUFBRSxDQUFDO2FBQ3RFLFNBQVMsRUFBRTthQUNYLElBQUksQ0FBQyxDQUFDLEdBQUcsRUFBRSxFQUFFO1lBQ1osSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDO1lBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsR0FBa0IsQ0FBQyxDQUFDO1FBQzNDLENBQUMsQ0FBQyxDQUFDO0lBQ1AsQ0FBQzsrR0F4Q1UsZ0JBQWdCO21IQUFoQixnQkFBZ0I7OzRGQUFoQixnQkFBZ0I7a0JBRDVCLFVBQVUiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBJbmplY3RhYmxlIH0gZnJvbSBcIkBhbmd1bGFyL2NvcmVcIjtcclxuaW1wb3J0IHsgU3RpSHR0cENsaWVudFNlcnZpY2UgfSBmcm9tIFwiLi9odHRwLWNsaWVudC5zZXJ2aWNlXCI7XHJcbmltcG9ydCB7IFN0aU1vZGVsU2VydmljZSB9IGZyb20gXCIuL21vZGVsLnNlcnZpY2VcIjtcclxuXHJcbkBJbmplY3RhYmxlKClcclxuZXhwb3J0IGNsYXNzIFN0aUV4cG9ydFNlcnZpY2Uge1xyXG4gIHB1YmxpYyBzaG93TW9kYWxXaW5kb3c6IGJvb2xlYW4gPSBmYWxzZTtcclxuICBwdWJsaWMgdXNlUmVhZE9ubHk6IGJvb2xlYW4gPSBmYWxzZTtcclxuICBwdWJsaWMgdXNlUGRmQTogYm9vbGVhbiA9IGZhbHNlO1xyXG4gIHB1YmxpYyBvcGVuQWZ0ZXJFeHBvcnQ6IGJvb2xlYW4gPSBmYWxzZTtcclxuICBjb25zdHJ1Y3RvcihwdWJsaWMgbW9kZWw6IFN0aU1vZGVsU2VydmljZSwgcHVibGljIGh0dHBTZXJ2aWNlOiBTdGlIdHRwQ2xpZW50U2VydmljZSkge31cclxuXHJcbiAgcHVibGljIGV4cG9ydFRvUGRmKCkge1xyXG4gICAgbGV0IGN1cnJlbnRGb3JtID0gdGhpcy5tb2RlbC5mb3JtLnNhdmVUb1JlcG9ydEpzb25PYmplY3QoKS5zZXJpYWxpemUoKTtcclxuICAgIGxldCBkYXRhID0ge1xyXG4gICAgICBhY3Rpb246IFwiR2VuZXJhdGVQREZcIixcclxuICAgICAgZm9ybTogY3VycmVudEZvcm0sXHJcbiAgICAgIHNldHRpbmdzOiB7XHJcbiAgICAgICAgdXNlUGRmQTogdGhpcy51c2VQZGZBLFxyXG4gICAgICAgIHJlYWRPbmx5OiB0aGlzLnVzZVJlYWRPbmx5LFxyXG4gICAgICB9LFxyXG4gICAgfTtcclxuICAgIHRoaXMuaHR0cFNlcnZpY2UucG9zdCh0aGlzLm1vZGVsLnJlcXVlc3RVcmwsIGRhdGEsIFwiYnl0ZUFycmF5XCIsIHsgc2hvd1Byb2dyZXNzOiB0cnVlIH0pLnN1YnNjcmliZSgoZGF0YSkgPT4ge1xyXG4gICAgICBsZXQgcGRmQnl0ZXMgPSBuZXcgSW50OEFycmF5KGRhdGEgYXMgQXJyYXlCdWZmZXIpO1xyXG4gICAgICB0aGlzLm1vZGVsLnNob3dQcm9ncmVzcyA9IGZhbHNlO1xyXG4gICAgICB0aGlzLm1vZGVsLmRvd25sb2FkRmlsZXMocGRmQnl0ZXMsIFwiRXhwb3J0RnJvbUZvcm0ucGRmXCIpO1xyXG4gICAgfSk7XHJcbiAgfVxyXG4gIHB1YmxpYyBnZXRQZGZCeXRlcygpIHtcclxuICAgIGxldCBjdXJyZW50Rm9ybSA9IHRoaXMubW9kZWwuZm9ybS5zYXZlVG9SZXBvcnRKc29uT2JqZWN0KCkuc2VyaWFsaXplKCk7XHJcbiAgICBsZXQgZGF0YSA9IHtcclxuICAgICAgYWN0aW9uOiBcIkdlbmVyYXRlUERGXCIsXHJcbiAgICAgIGZvcm06IGN1cnJlbnRGb3JtLFxyXG4gICAgICBzZXR0aW5nczoge1xyXG4gICAgICAgIHVzZVBkZkE6IHRoaXMudXNlUGRmQSxcclxuICAgICAgICByZWFkT25seTogdGhpcy51c2VSZWFkT25seSxcclxuICAgICAgfSxcclxuICAgIH07XHJcbiAgICByZXR1cm4gdGhpcy5odHRwU2VydmljZVxyXG4gICAgICAucG9zdCh0aGlzLm1vZGVsLnJlcXVlc3RVcmwsIGRhdGEsIFwiYnl0ZUFycmF5XCIsIHsgc2hvd1Byb2dyZXNzOiB0cnVlIH0pXHJcbiAgICAgIC50b1Byb21pc2UoKVxyXG4gICAgICAudGhlbigocmVzKSA9PiB7XHJcbiAgICAgICAgdGhpcy5tb2RlbC5zaG93UHJvZ3Jlc3MgPSBmYWxzZTtcclxuICAgICAgICByZXR1cm4gbmV3IEludDhBcnJheShyZXMgYXMgQXJyYXlCdWZmZXIpO1xyXG4gICAgICB9KTtcclxuICB9XHJcbn1cclxuIl19