import { Injectable } from "@angular/core";
import StiRectangleGeometryLayout from "../computed/StiRectangleGeometryLayout";
import { StiAddressElement } from "../elements/StiAddressElement";
import { StiButtonElement } from "../elements/StiButtonElement";
import { StiDragPreviewElement } from "../elements/StiDragPreviewElement";
import { StiLabelElement } from "../elements/StiLabelElement";
import StiLineElement from "../elements/StiLineElement";
import { StiPanelElement } from "../elements/StiPanelElement";
import { StiSignatureElement } from "../elements/StiSignatureElement";
import { StiTableElement } from "../elements/StiTableElement";
import Guid from "../system/Guid";
import * as i0 from "@angular/core";
import * as i1 from "./mouse.service";
import * as i2 from "./model.service";
import * as i3 from "./sti-name.service";
import * as i4 from "./sti-helper.service";
export class StiDraggableService {
    static { this.MOUSE_DELTA = 5; }
    constructor(mouseService, model, nameService, helper, render) {
        this.mouseService = mouseService;
        this.model = model;
        this.nameService = nameService;
        this.helper = helper;
        this.render = render;
        this.newElement = true;
        this.dragPreview = new StiDragPreviewElement();
        mouseService.getDocumentMouseMove().subscribe((event) => {
            this.drag(event);
        });
        mouseService.getDocumentMouseUp().subscribe((event) => {
            this.endDrag(event);
        });
    }
    drag(event) {
        if (this.model.draggingElement) {
            let bottomPage = this.model.getPageFromPoint(event.clientX, event.clientY);
            if (this.model.lastUsedPage != bottomPage && bottomPage != null && bottomPage != undefined) {
                this.model.lastUsedPage = bottomPage;
            }
            this.model.cursor = bottomPage ? "move" : "not-allowed";
            this.left = event.clientX - this.startX;
            this.top = event.clientY - this.startY;
            if (this.newElement) {
                if (bottomPage) {
                    if (this.model.draggingElement instanceof StiTableElement ||
                        this.model.draggingElement instanceof StiLineElement ||
                        this.model.draggingElement instanceof StiPanelElement) {
                        this.model.draggingElement.width = this.model.lastUsedPage.contentAreaWidth;
                    }
                    else if (this.model.draggingElement instanceof StiButtonElement) {
                        this.model.draggingElement.width =
                            this.model.lastUsedPage.contentAreaWidth / this.model.form.settings.gridColumns > 1
                                ? Math.round(this.model.form.settings.gridColumns * 0.2)
                                : 1;
                    }
                    else {
                        this.model.draggingElement.width =
                            this.model.lastUsedPage.contentAreaWidth / this.model.form.settings.gridColumns > 1
                                ? Math.round(this.model.form.settings.gridColumns * 0.4)
                                : 1;
                    }
                }
                else {
                    //this.model.draggingElement.width = 0; ???
                }
            }
            this.moveDragPreview(event);
        }
    }
    endDrag(event) {
        if (this.model.draggingElement) {
            let page = this.model.getElementPage(this.dragPreview);
            let panel = this.model.getElementPanel(this.dragPreview);
            let elements = page ? page?.elements : panel?.elements;
            this.model.draggingElement.x = this.dragPreview.x;
            this.model.draggingElement.y = this.dragPreview.y;
            this.model.draggingElement.width = this.dragPreview.width;
            if (elements) {
                if (this.model.draggingElement instanceof StiLabelElement) {
                    elements.splice(elements.indexOf(this.dragPreview), 1);
                    elements.splice(0, 0, this.model.draggingElement);
                }
                else {
                    elements.splice(elements.indexOf(this.dragPreview), 1, this.model.draggingElement);
                }
                if (this.newElement) {
                    this.model.draggingElement.guid = Guid.newGuid().toString();
                    this.model.draggingElement.name = this.nameService.getElementName(this.model.draggingElement);
                    this.model.draggingElement.hasGeometry = true;
                }
                this.model.draggingElement.position = "absolute";
                this.model.draggingElement.needToSelectComponent = true;
                this.model.draggingElement.isAdded = true;
                if (this.model.draggingElement instanceof StiTableElement) {
                    this.model.currentTablePropertyHeader.next("Table");
                }
            }
            else {
                if (!this.model.overToolbar(event.clientX, event.clientY) && !this.newElement) {
                    this.model.lastUsedPage.elements.push(this.currentUsableElement);
                    this.render.insertElement(this.currentUsableElement);
                }
                else {
                    this.render.removeElement(this.model.draggingElement, this.model.lastUsedPage.elements);
                    this.model.selectedComponent = null;
                }
            }
            this.render.checkOutputs(this.model.getElementPage(this.model.draggingElement));
            this.model.cursor = "default";
            this.model.draggingElement = null;
            this.model.pageWithGrid = null;
            this.newElement = false;
        }
    }
    addingByDoubleClick(element) {
        element.hasGeometry = false;
        element.position = "absolute";
        element.guid = Guid.newGuid().toString();
        let columnWidth = this.model.lastUsedPage.getColumnWidth(this.model.form.settings.gridColumns);
        if (element instanceof StiTableElement || element instanceof StiLineElement || element instanceof StiPanelElement) {
            element.width = this.model.lastUsedPage.contentAreaWidth;
        }
        else if (element instanceof StiButtonElement) {
            element.width = Number((columnWidth *
                (this.model.form.settings.gridColumns > 1 ? Math.round(this.model.form.settings.gridColumns * 0.2) : 1)).toFixed(2));
        }
        else {
            element.width = Number((columnWidth *
                (this.model.form.settings.gridColumns > 1 ? Math.round(this.model.form.settings.gridColumns * 0.4) : 1)).toFixed(2));
        }
        element.name = this.nameService.getElementName(element);
        element.needToSelectComponent = true;
        element.isAdded = true;
        let lastPage = this.model.form.pages[this.model.form.pages.length - 1];
        element.x = 0;
        element.y = lastPage.contentAreaHeight - element.height;
        if (element instanceof StiLabelElement) {
            lastPage.elements.splice(0, 0, element);
        }
        else if (element instanceof StiSignatureElement) {
            lastPage.elements.splice(lastPage.elements.length, 0, element);
        }
        else {
            lastPage.elements.splice(lastPage.elements.length - 1, 0, element);
        }
        this.render.insertElement(element);
        this.model.lastUsedPage = lastPage;
        this.newElement = false;
        if (element instanceof StiTableElement) {
            this.model.currentTablePropertyHeader.next("Table");
        }
        this.render.checkOutputs(this.model.getElementPage(element));
    }
    startDrag(event, element, newElement = true, isClone, layerX, layerY, page) {
        this.showDragPreview(element);
        this.currentUsableElement = this.helper.clone(element);
        element.isAdded = false;
        element.position = "relative";
        element.geometry.x = 0;
        element.geometry.y = 0;
        this.model.draggingElement = element;
        this.newElement = newElement;
        if (newElement) {
            let formRect = this.model?.rootFormElement?.getBoundingClientRect();
            this.startX = (formRect ? formRect.x + 15 : 15) * this.model.zoom;
            this.startY = (formRect ? formRect.y + 5 : 5) * this.model.zoom;
            let cf = 0.4;
            if (element instanceof StiTableElement ||
                element instanceof StiLineElement ||
                element instanceof StiPanelElement) {
                cf = 1;
            }
            if (element instanceof StiButtonElement) {
                cf = 0.2;
            }
            if (element instanceof StiAddressElement) {
                cf = 0.6;
            }
            this.draggingElementWidthInColumns = Math.max(Math.round(this.model.form.settings.gridColumns * cf), 1);
            this.model.draggingElement.width =
                this.model.lastUsedPage.getColumnWidth(this.model.form.settings.gridColumns) *
                    this.draggingElementWidthInColumns;
        }
        else {
            this.draggingElementWidth = element.width;
            if (!isClone) {
                this.startX = layerX;
                this.startY = layerY;
            }
            else {
                this.startX = this.model.draggingElement.width / 2;
                this.startY = this.model.draggingElement.height / 2;
            }
        }
        this.drag(event);
    }
    showDragPreview(element) {
        let page = this.model.getElementPage(element);
        page?.elements.splice(page.elements.indexOf(element), 1);
        let panel = this.model.getElementPanel(element);
        panel?.elements.splice(panel.elements.indexOf(element), 1);
        this.dragPreview.geometry = element.geometry.clone();
        setTimeout(() => {
            this.dragPreview.height = element.height;
        });
        panel ? panel.elements?.push(this.dragPreview) : (page ?? this.model.lastUsedPage).elements?.push(this.dragPreview);
    }
    moveDragPreview(event) {
        let excludeId = this.model.draggingElement instanceof StiPanelElement ? this.model.draggingElement.guid : null;
        let mouseOnPanel = this.model.getPanelFromPoint(event.clientX, event.clientY, excludeId);
        let mouseOnPage = mouseOnPanel
            ? null
            : this.model.getPageFromPoint(event.clientX, event.clientY);
        this.model.pageWithGrid = mouseOnPage;
        let dragPreviewPage = this.model.getElementPage(this.dragPreview);
        let dragPreviewPanel = this.model.getElementPanel(this.dragPreview);
        let dragPreviewContainer = dragPreviewPage ?? dragPreviewPanel;
        if (!mouseOnPage && !mouseOnPanel && (dragPreviewPage || dragPreviewPanel)) {
            dragPreviewContainer.elements.splice(dragPreviewContainer.elements.indexOf(this.dragPreview), 1);
            this.render.removeElement(this.dragPreview, dragPreviewContainer.elements);
        }
        else if ((mouseOnPage || mouseOnPanel) && !dragPreviewPage && !dragPreviewPanel) {
            (mouseOnPage ?? mouseOnPanel).elements.push(this.dragPreview);
        }
        else if ((mouseOnPanel && dragPreviewPage) ||
            (mouseOnPage && dragPreviewPanel) ||
            (mouseOnPage && dragPreviewPage && mouseOnPage != dragPreviewPage) ||
            (mouseOnPanel && dragPreviewPanel && mouseOnPanel != dragPreviewPanel)) {
            dragPreviewContainer.elements.splice(dragPreviewContainer.elements.indexOf(this.dragPreview), 1);
            this.render.removeElement(this.dragPreview, dragPreviewContainer.elements);
            (mouseOnPage ?? mouseOnPanel).elements.push(this.dragPreview);
        }
        this.dragPreview.geometry.minWidth = this.model.draggingElement.geometry.minWidth;
        let container = mouseOnPage ?? mouseOnPanel;
        if (container) {
            let columnWidth = container?.getColumnWidth(this.model.form.settings.gridColumns) ?? 1;
            var mousePos = mouseOnPage
                ? this.model.getMouseOverPagePosition(event)
                : this.model.getMouseOverPanelPosition(event, excludeId);
            if (mousePos != null) {
                let cols = this.draggingElementWidthInColumns;
                if (this.newElement && mouseOnPanel && this.model.draggingElement instanceof StiPanelElement) {
                    cols = Math.max(1, Math.ceil(cols * 0.3));
                }
                else if (!this.newElement) {
                    cols = Math.min(Math.round(this.draggingElementWidth / columnWidth), this.model.form.settings.gridColumns);
                }
                let otherElements = Array.from(container.elements);
                otherElements.splice(otherElements.indexOf(this.dragPreview), 1);
                this.render.removeElement(this.dragPreview, otherElements);
                this.model.draggingElement.width = columnWidth * cols;
                this.dragPreview.width = this.model.draggingElement.width;
                if (mousePos.x - this.startX <= columnWidth * this.model.zoom) {
                    this.dragPreview.x = 0;
                }
                else if (mousePos.x - this.startX >=
                    (container.contentAreaWidth - this.dragPreview.geometry.minWidth) * this.model.zoom) {
                    this.dragPreview.x = container.contentAreaWidth - this.dragPreview.geometry.minWidth;
                }
                else if (Math.abs(mousePos.x - this.startX) >= columnWidth * this.model.zoom) {
                    let step = Math.floor(Math.abs(mousePos.x - this.startX) / (columnWidth * this.model.zoom));
                    this.dragPreview.x = step * columnWidth;
                }
                if ((mousePos.y - this.startY) / this.model.zoom <= 0) {
                    this.dragPreview.y = 0;
                }
                else {
                    this.dragPreview.y = (mousePos.y - this.startY) / this.model.zoom;
                }
                this.render.insertElement(this.dragPreview, container.contentAreaWidth);
            }
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiDraggableService, deps: [{ token: i1.StiMouseService }, { token: i2.StiModelService }, { token: i3.StiNameService }, { token: i4.StiHelperService }, { token: StiRectangleGeometryLayout }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiDraggableService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiDraggableService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.StiMouseService }, { type: i2.StiModelService }, { type: i3.StiNameService }, { type: i4.StiHelperService }, { type: StiRectangleGeometryLayout }] });
//# sourceMappingURL=data:application/json;base64,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