import { Injectable } from "@angular/core";
import { StiDraggableService } from "./sti-draggable.service";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./mouse.service";
import * as i3 from "./http-client.service";
export class StiColumnDraggableService {
    constructor(model, mouseService, httpService) {
        this.model = model;
        this.mouseService = mouseService;
        this.httpService = httpService;
        this.isDragging = false;
        this.cursor = "";
        this.canDrop = false;
        this.fromTable = false;
        this._insertIndex = -1;
        this.headerClicked = false;
        mouseService.getDocumentMouseMove().subscribe((event) => {
            this.mouseMove(event);
        });
        mouseService.getDocumentMouseUp().subscribe((event) => {
            this.endDrag();
        });
    }
    mouseMove(event) {
        if (this.headerClicked) {
            if (!this.isDragging &&
                Math.max(Math.abs(this.mouseDownX - event.clientX), Math.abs(this.mouseDownY - event.clientY)) >
                    StiDraggableService.MOUSE_DELTA) {
                this.isDragging = true;
            }
            else if (this.isDragging) {
                this.left = event.clientX - this.startX + "px";
                this.top = event.clientY - this.startY + "px";
                this.getIndexOfBottomItem(event);
                this.canDrop ? (this.model.cursor = "copy") : (this.model.cursor = "not-allowed");
                //
            }
        }
    }
    endDrag() {
        if (this.isDragging) {
            if (this._insertIndex > this.items.indexOf(this.item)) {
                this._insertIndex--;
            }
            this.items["stopFit"] = true;
            this.items.splice(this.items.indexOf(this.item), 1);
            this.items.splice(this._insertIndex, 0, this.item);
            this.items["stopFit"] = false;
        }
        this.isDragging = false;
        this.fromTable = false;
        this.parentElement = null;
        this.canDrop = false;
        this.headerClicked = false;
        this.model.cursor = "default";
    }
    onHeaderClick(event, item, items, fromTable, parentElement) {
        this.mouseDownX = event.clientX;
        this.mouseDownY = event.clientY;
        this._item = item;
        this.items = items;
        this.itemLabel = item.label ?? item.header;
        this.headerClicked = true;
        if (fromTable) {
            this.startX = event.offsetX;
            this.startY = event.offsetY;
        }
        this._insertIndex = items.indexOf(item);
        this.headerRect = this.model.getPositionRelativeToForm(event.currentTarget);
        if (fromTable) {
            this.fromTable = true;
            this.parentElement = parentElement;
        }
    }
    getIndexOfBottomItem(event) {
        let index;
        let elements = document.elementsFromPoint(event.clientX, event.clientY);
        this.canDrop = false;
        if (this.fromTable) {
            elements.forEach((element) => {
                if (element?.classList.contains("column-drop-area")) {
                    this.canDrop = true;
                }
            });
        }
        else {
            elements.forEach((element) => {
                if (element?.classList.contains("drop-area")) {
                    this.canDrop = true;
                }
            });
        }
    }
    get insertIndex() {
        return this.isDragging ? this._insertIndex : -1;
    }
    set insertIndex(value) {
        this._insertIndex = value;
    }
    get item() {
        return this.isDragging ? this._item : null;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiColumnDraggableService, deps: [{ token: i1.StiModelService }, { token: i2.StiMouseService }, { token: i3.StiHttpClientService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiColumnDraggableService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiColumnDraggableService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiMouseService }, { type: i3.StiHttpClientService }] });
//# sourceMappingURL=data:application/json;base64,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