import { Injectable } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
export class StiColorDialogService {
    rgbToHex(rgb) {
        let rgbArray = rgb.split(",");
        let hex = "#";
        rgbArray.forEach((item) => {
            hex += this.componentToHex(Number(item));
        });
        return hex;
    }
    componentToHex(c) {
        let hex = c.toString(16);
        return hex.length == 1 ? "0" + hex : hex;
    }
    openDialog(element, object, isRichText) {
        this.isRichText = isRichText;
        let elementRect = this.model.getPositionRelativeToForm(element);
        let windowHeight = window.innerHeight;
        let windowWidth = window.innerWidth;
        this.currentColorObject = object;
        this.cloneOfCurrentColorObject = object.clone();
        if (elementRect.bottom + this.dialogHeight > windowHeight - 32) {
            this.dialogY = elementRect.top - this.dialogHeight;
        }
        else {
            this.dialogY = elementRect.bottom;
        }
        if (elementRect.left + this.dialogWidth > windowWidth) {
            this.dialogX = windowWidth - this.dialogWidth;
        }
        else {
            this.dialogX = elementRect.left;
        }
        this.model.showColorDialog = true;
    }
    constructor(model) {
        this.model = model;
        this.dialogWidth = 185;
        this.dialogHeight = 236;
        this.browserColors = [
            { name: "Transparent", color: "transparent" },
            { name: "Black", color: "0,0,0" },
            { name: "DimGray", color: "105,105,105" },
            { name: "Gray", color: "128,128,128" },
            { name: "DarkGray", color: "169,169,169" },
            { name: "Silver", color: "192,192,192" },
            { name: "LightGray", color: "211,211,211" },
            { name: "Gainsboro", color: "220,220,220" },
            { name: "WhiteSmoke", color: "245,245,245" },
            { name: "White", color: "255,255,255" },
            { name: "RosyBrown", color: "188,143,143" },
            { name: "IndianRed", color: "205,92,92" },
            { name: "Brown", color: "165,42,42" },
            { name: "Firebrick", color: "178,34,34" },
            { name: "LightCoral", color: "240,128,12" },
            { name: "Maroon", color: "128,0,0" },
            { name: "DarkRed", color: "139,0,0" },
            { name: "Red", color: "255,0,0" },
            { name: "Snow", color: "255,250,250" },
            { name: "MistyRose", color: "255,228,225" },
            { name: "Salmon", color: "250,128,114" },
            { name: "Tomato", color: "255,99,71" },
            { name: "DarkSalmon", color: "233,150,122" },
            { name: "Coral", color: "255,127,80" },
            { name: "OrangeRed", color: "255,69,0" },
            { name: "LightSalmon", color: "255,160,122" },
            { name: "Sienna", color: "160,82,45" },
            { name: "SeaShell", color: "255,245,23" },
            { name: "Chocolate", color: "210,105,30" },
            { name: "SaddleBrown", color: "139,69,19" },
            { name: "SandyBrown", color: "244,164,96" },
            { name: "PeachPuff", color: "255,218,185" },
            { name: "Peru", color: "205,133,63" },
            { name: "Linen", color: "250,240,230" },
            { name: "Bisque", color: "255,228,196" },
            { name: "DarkOrange", color: "255,140,0" },
            { name: "BurlyWood", color: "222,184,135" },
            { name: "Tan", color: "210,180,140" },
            { name: "AntiqueWhite", color: "250,235,215" },
            { name: "NavajoWhite", color: "255,222,173" },
            { name: "BlanchedAlmond", color: "255,235,205" },
            { name: "PapayaWhip", color: "255,239,213" },
            { name: "Moccasin", color: "255,228,181" },
            { name: "Orange", color: "255,165,0" },
            { name: "Wheat", color: "245,222,179" },
            { name: "OldLace", color: "253,245,230" },
            { name: "FloralWhite", color: "255,250,240" },
            { name: "DarkGoldenrod", color: "184,134,11" },
            { name: "Goldenrod", color: "218,165,32" },
            { name: "Cornsilk", color: "255,248,220" },
            { name: "Gold", color: "255,215,0" },
            { name: "Khaki", color: "240,230,140" },
            { name: "LemonChiffon", color: "255,250,205" },
            { name: "PaleGoldenrod", color: "238,232,170" },
            { name: "DarkKhaki", color: "189,183,107" },
            { name: "Beige", color: "245,245,220" },
            { name: "LightGoldenrodYellow", color: "250,250,210" },
            { name: "Olive", color: "128,128,0" },
            { name: "Yellow", color: "255,255,0" },
            { name: "LightYellow", color: "255,255,224" },
            { name: "Ivory", color: "255,255,240" },
            { name: "OliveDrab", color: "107,142,35" },
            { name: "YellowGreen", color: "154,205,50" },
            { name: "DarkOliveGreen", color: "85,107,47" },
            { name: "GreenYellow", color: "173,255,47" },
            { name: "Chartreuse", color: "127,255,0" },
            { name: "LawnGreen", color: "124,252,0" },
            { name: "DarkSeaGreen", color: "143,188,139" },
            { name: "ForestGreen", color: "34,139,34" },
            { name: "LimeGreen", color: "50,205,50" },
            { name: "LightGreen", color: "144,238,144" },
            { name: "PaleGreen", color: "152,251,152" },
            { name: "DarkGreen", color: "0,100,0" },
            { name: "Green", color: "0,128,0" },
            { name: "Lime", color: "0,255,0" },
            { name: "Honeydew", color: "240,255,240" },
            { name: "SeaGreen", color: "46,139,87" },
            { name: "MediumSeaGreen", color: "60,179,113" },
            { name: "SpringGreen", color: "0,255,127" },
            { name: "MintCream", color: "245,255,250" },
            { name: "MediumSpringGreen", color: "0,250,154" },
            { name: "MediumAquamarine", color: "102,205,170" },
            { name: "Aquamarine", color: "127,255,212" },
            { name: "Turquoise", color: "64,224,20" },
            { name: "LightSeaGreen", color: "32,178,170" },
            { name: "MediumTurquoise", color: "72,209,204" },
            { name: "DarkSlateGray", color: "47,79,79" },
            { name: "PaleTurquoise", color: "175,238,23" },
            { name: "Teal", color: "0,128,12" },
            { name: "DarkCyan", color: "0,139,139" },
            { name: "Aqua", color: "0,255,255" },
            { name: "Cyan", color: "0,255,255" },
            { name: "LightCyan", color: "224,255,255" },
            { name: "Azure", color: "240,255,255" },
            { name: "DarkTurquoise", color: "0,206,209" },
            { name: "CadetBlue", color: "95,158,160" },
            { name: "PowderBlue", color: "176,224,230" },
            { name: "LightBlue", color: "173,216,230" },
            { name: "DeepSkyBlue", color: "0,191,255" },
            { name: "SkyBlue", color: "135,206,235" },
            { name: "LightSkyBlue", color: "135,206,250" },
            { name: "SteelBlue", color: "70,130,180" },
            { name: "AliceBlue", color: "240,248,255" },
            { name: "DodgerBlue", color: "30,144,255" },
            { name: "SlateGray", color: "112,128,144" },
            { name: "LightSlateGray", color: "119,136,153" },
            { name: "LightSteelBlue", color: "176,196,222" },
            { name: "CornflowerBlue", color: "100,149,237" },
            { name: "RoyalBlue", color: "65,105,225" },
            { name: "MidnightBlue", color: "25,25,112" },
            { name: "Lavender", color: "230,230,250" },
            { name: "Navy", color: "0,0,12" },
            { name: "DarkBlue", color: "0,0,139" },
            { name: "MediumBlue", color: "0,0,205" },
            { name: "Blue", color: "0,0,255" },
            { name: "GhostWhite", color: "248,248,255" },
            { name: "SlateBlue", color: "106,90,205" },
            { name: "DarkSlateBlue", color: "72,61,139" },
            { name: "MediumSlateBlue", color: "123,104,23" },
            { name: "MediumPurple", color: "147,112,219" },
            { name: "BlueViolet", color: "138,43,226" },
            { name: "Indigo", color: "75,0,130" },
            { name: "DarkOrchid", color: "153,50,204" },
            { name: "DarkViolet", color: "148,0,211" },
            { name: "MediumOrchid", color: "186,85,211" },
            { name: "Thistle", color: "216,191,216" },
            { name: "Plum", color: "221,160,221" },
            { name: "Violet", color: "238,130,23" },
            { name: "Purple", color: "128,0,12" },
            { name: "DarkMagenta", color: "139,0,139" },
            { name: "Magenta", color: "255,0,255" },
            { name: "Fuchsia", color: "255,0,255" },
            { name: "Orchid", color: "218,112,214" },
            { name: "MediumVioletRed", color: "199,21,133" },
            { name: "DeepPink", color: "255,20,147" },
            { name: "HotPink", color: "255,105,180" },
            { name: "LavenderBlush", color: "255,240,245" },
            { name: "PaleVioletRed", color: "219,112,147" },
            { name: "Crimson", color: "220,20,60" },
            { name: "Pink", color: "255,192,203" },
            { name: "LightPink", color: "255,182,193" },
        ];
        this.themeColors = [
            { color: "255,255,255" },
            { color: "0,0,0" },
            { color: "231,230,230" },
            { color: "68,84,106" },
            { color: "91,155,213" },
            { color: "237,125,49" },
            { color: "165,165,165" },
            { color: "255,192,0" },
            { color: "68,114,196" },
            { color: "112,173,71" },
            { color: "242,242,242" },
            { color: "127,127,127" },
            { color: "208,206,206" },
            { color: "214,220,228" },
            { color: "222,235,246" },
            { color: "251,229,213" },
            { color: "237,237,237" },
            { color: "255,242,204" },
            { color: "217,226,243" },
            { color: "226,239,217" },
            { color: "216,216,216" },
            { color: "89,89,89" },
            { color: "174,171,171" },
            { color: "173,185,202" },
            { color: "189,215,238" },
            { color: "247,203,172" },
            { color: "219,219,219" },
            { color: "254,229,153" },
            { color: "180,198,231" },
            { color: "197,224,179" },
            { color: "191,191,191" },
            { color: "63,63,63" },
            { color: "117,112,112" },
            { color: "132,150,176" },
            { color: "156,195,229" },
            { color: "224,177,131" },
            { color: "201,201,201" },
            { color: "255,217,101" },
            { color: "142,170,219" },
            { color: "168,208,141" },
            { color: "165,165,165" },
            { color: "38,38,38" },
            { color: "58,56,56" },
            { color: "50,63,79" },
            { color: "46,117,181" },
            { color: "197,90,17" },
            { color: "123,123,123" },
            { color: "191,144,0" },
            { color: "47,84,150" },
            { color: "83,129,53" },
            { color: "127,127,127" },
            { color: "12,12,12" },
            { color: "23,22,22" },
            { color: "34,42,53" },
            { color: "30,78,121" },
            { color: "131,60,11" },
            { color: "82,82,82" },
            { color: "127,96,0" },
            { color: "31,56,100" },
            { color: "55,86,35" },
        ];
        this.standardColors = [
            { color: "192,0,0" },
            { color: "255,0,0" },
            { color: "255,192,0" },
            { color: "255,255,0" },
            { color: "146,208,80" },
            { color: "0,176,80" },
            { color: "0,176,240" },
            { color: "0,112,192" },
            { color: "0,32,96" },
            { color: "112,48,160" },
        ];
        this.isRichText = false;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiColorDialogService, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiColorDialogService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiColorDialogService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.StiModelService }] });
//# sourceMappingURL=data:application/json;base64,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