import { StiFormSaveMode } from "../system/enums";
export class StiToolboxElement {
    constructor(caption, image, component, element, setForm) {
        this.caption = caption;
        this.image = image;
        this.component = component;
        this.element = element;
        this.setForm = setForm;
    }
}
export class StiEvent {
    constructor(name, value) {
        this.name = name;
        this.value = value;
    }
}
export class StiEditorProperty {
    constructor(type, property, label, tooltip) {
        this.type = type;
        this.property = property;
        this.label = label;
        this.tooltip = tooltip;
    }
}
export class Item {
    constructor(name, caption, imageName, key, haveSubMenu, imageSizes, selected, type) {
        this.name = name;
        this.caption = caption;
        this.imageName = imageName;
        this.key = key;
        this.haveSubMenu = haveSubMenu;
        this.imageSizes = imageSizes;
        this.selected = selected;
        this.type = type;
    }
}
export class MenuItem {
    constructor(name, caption, img, type, selected, imageSize, value, label, items, command) {
        this.name = name;
        this.caption = caption;
        this.img = img;
        this.type = type;
        this.selected = selected;
        this.imageSize = imageSize;
        this.value = value;
        this.label = label;
        this.items = items;
        this.command = command;
    }
}
export class Menu {
    constructor(name, items, parent, type, state, menuEl, top, left, innerContent, width, height, menuStyleName, verticalItems, action, itemStyleName, value, sizeStyle) {
        this.name = name;
        this.items = items;
        this.parent = parent;
        this.type = type;
        this.state = state;
        this.menuEl = menuEl;
        this.top = top;
        this.left = left;
        this.innerContent = innerContent;
        this.width = width;
        this.height = height;
        this.menuStyleName = menuStyleName;
        this.verticalItems = verticalItems;
        this.action = action;
        this.itemStyleName = itemStyleName;
        this.value = value;
        this.sizeStyle = sizeStyle;
    }
}
export class StiWebFormOptions {
    constructor() {
        this.saveMode = StiFormSaveMode.Automatic;
    }
}
export class StiLocalizationObject {
}
export class FormEvent {
    constructor(name, value) {
        this.name = name;
        this.value = value;
    }
}
export class UsedFont {
    constructor(fontFamily, fontStyle, fontSize) {
        this.fontFamily = fontFamily;
        this.fontStyle = fontStyle;
        this.fontSize = fontSize;
    }
}
export class StiUsedFontsList {
    constructor() {
        this.fonts = [];
    }
    add(fontFamily, fontStyle, fontSize) {
        if (!this.fonts.find((u) => u.fontFamily == fontFamily &&
            u.fontStyle.length == fontStyle.length &&
            u.fontStyle == fontStyle &&
            u.fontSize == fontSize)) {
            this.fonts.push({ fontFamily: fontFamily, fontStyle: fontStyle, fontSize: fontSize });
        }
    }
}
export class StiInterfaceEvent {
    constructor(name, data) {
        this.name = name;
        this.data = data;
    }
}
export class StiClipboardData {
    constructor(value, type, displayValue, clipboardId = "StiFormsClipboard") {
        this.value = value;
        this.type = type;
        this.displayValue = displayValue;
        this.clipboardId = clipboardId;
    }
}
//# sourceMappingURL=data:application/json;base64,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