import Color from "../system/Color";
import { Enum } from "../system/Enum";
import { StiPenStyle } from "../system/enums";
import StiJson from "../system/StiJson";
export class StiPen {
    static dimGraySolid() {
        return new StiPen(Color.dimGray(), StiPenStyle.Solid, 1);
    }
    constructor(color, style = StiPenStyle.Solid, width = 1) {
        this.color = color;
        this.style = style;
        this.width = width;
    }
    get width() {
        return this._width;
    }
    set width(value) {
        if (value <= 0) {
            this._width = 0;
        }
        else if (value >= 395) {
            this._width = 395;
        }
        else {
            this._width = value;
        }
    }
    saveToJsonObject(options) {
        let json = new StiJson();
        json.addPropertyColor("Color", this.color);
        json.addPropertyEnum("Style", StiPenStyle, this.style);
        json.addPropertyNumber("Width", this.width);
        return json;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Color":
                    this.color = new Color();
                    this.color.deserializeFromString(property.value);
                    break;
                case "Style":
                    this.style = Enum.parse(StiPenStyle, property.value);
                    break;
                case "Width":
                    this.width = property.value;
                    break;
            }
        }
    }
    toHtmlBorder() {
        return `${this.width}px ${this.getHtmlStyle()} ${this.color.toHtmlColor()}`;
    }
    getHtmlStyle() {
        switch (this.style) {
            case StiPenStyle.Solid:
                return "solid";
            case StiPenStyle.Dash:
                return "dashed";
            case StiPenStyle.Dot:
                return "dotted";
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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