import Color from "../../system/Color";
import { Enum } from "../../system/Enum";
import { StiLabelAlignment, StiVerticalAlignment } from "../../system/enums";
import { Font } from "../../system/Font";
import { StiTextItem } from "./StiTextItem";
export class StiLabelItem extends StiTextItem {
    constructor(parent, value = "", font = new Font("Segoe UI", 10), color = Color.black(), alignment = StiLabelAlignment.Left, verticalAlignment = StiVerticalAlignment.Top, width = 150) {
        super(value, font, color, null);
        this.font = font;
        this.color = color;
        this.alignment = alignment;
        this.eVerticalAlignment = verticalAlignment;
        this.width = width;
        this.eParent = parent;
    }
    get alignment() {
        return this._alignment;
    }
    set alignment(value) {
        this._alignment = value;
        this._isChanged = true;
        if (this.eParent?.fitTable) {
            this.eParent?.fitTable();
        }
    }
    get eVerticalAlignment() {
        return this._verticalAlignment;
    }
    set eVerticalAlignment(value) {
        this._verticalAlignment = value;
        this._isChanged = true;
    }
    get verticalAlignment() {
        return this.isUnchangedVAlign() ? StiVerticalAlignment.Center : this.eVerticalAlignment;
    }
    set verticalAlignment(value) {
        this.eVerticalAlignment = value;
    }
    get width() {
        return this._width;
    }
    set width(value) {
        if (value <= 0) {
            this._width = 0;
        }
        else {
            this._width = value;
        }
        this._isChanged = true;
    }
    haveContentAlignment() {
        return false;
    }
    haveVerticalAlignment() {
        return true;
    }
    setProperty(propName, value, oldObject) {
        super.setProperty(propName, value, oldObject);
        if (this[propName] && (oldObject === null || this[propName] == oldObject)) {
            this[propName] = value.clone ? value.clone() : value;
        }
    }
    saveToJsonObject(options) {
        let json = super.saveToJsonObject(options);
        json.addPropertyEnum("Alignment", StiLabelAlignment, this.alignment);
        json.addPropertyEnum("VerticalAlignment", StiVerticalAlignment, this.isUnchangedVAlign() ? StiVerticalAlignment.Center : this.eVerticalAlignment);
        if (this.width != null) {
            json.addPropertyNumber("Width", this.width);
        }
        return json;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Alignment":
                    this.alignment = Enum.parse(StiLabelAlignment, property.value);
                    break;
                case "Width":
                    this.width = property.value;
                    break;
                case "VerticalAlignment":
                    this._verticalAlignment = Enum.parse(StiVerticalAlignment, property.value);
                    break;
            }
        }
    }
    htmlStyle() {
        return `${super.htmlStyle()};text-align:${this.alignment == StiLabelAlignment.Top ? "Center" : Enum.getName(StiLabelAlignment, this.alignment)}`;
    }
    isUnchangedVAlign() {
        return (this.eParent.type == "Text_BoxElement" ||
            this.eParent.type == "Number_BoxElement" ||
            this.eParent.type == "Combo_BoxElement" ||
            this.eParent.type == "Check_BoxElement" ||
            this.eParent.type == "DateTime_BoxElement");
    }
}
//# sourceMappingURL=data:application/json;base64,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