import Color from "../../system/Color";
import { Font } from "../../system/Font";
import { StiTextItem } from "./StiTextItem";
export class StiBackgroundedTextItem extends StiTextItem {
    constructor(value = "", font = new Font("Segoe UI", 9), color = Color.black(), backgroundColor = Color.white()) {
        super(value, font, color, backgroundColor);
        this.font = font;
        this.color = color;
        this.backgroundColor = backgroundColor;
    }
    saveToJsonObject(options) {
        let json = super.saveToJsonObject(options);
        json.addPropertyColor("BackgroundColor", this.backgroundColor);
        return json;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "BackgroundColor":
                    this.backgroundColor = new Color();
                    this.backgroundColor.deserializeFromString(property.value);
                    break;
            }
        }
    }
    getBackgroundColor() {
        return this.backgroundColor;
    }
    haveContentAlignment() {
        return false;
    }
    haveBackgoundColor() {
        return true;
    }
}
//# sourceMappingURL=data:application/json;base64,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