import { Enum } from "../../../system/Enum";
import { StiThousandSeparator } from "../../../system/enums";
import { StiColumnItem } from "../StiColumnItem";
export class StiLabelColumnItem extends StiColumnItem {
    constructor(label, form) {
        super(label, form);
        this.label = label;
        this.form = form;
        this._decimalDigits = 2;
        this.type = "LabelColumn";
        this.expression = "";
        this.prefix = "";
        this.suffix = "";
        this.cells = [];
        this.thousandSeparator = StiThousandSeparator.None;
        if (form) {
            this._decimalDigits = form.settings.decimalDigits;
            this.thousandSeparator = form.settings.thousandSeparator;
        }
    }
    copyFrom(parentItem) {
        super.copyFrom(parentItem);
        if (parentItem instanceof StiLabelColumnItem) {
            let label = parentItem;
            this._decimalDigits = label._decimalDigits;
            this.thousandSeparator = label.thousandSeparator;
            this.prefix = label.prefix;
            this.suffix = label.suffix;
        }
    }
    createCell() {
        return "";
    }
    setDefaultValues() {
        this.cells.forEach((cell) => {
            cell = "";
        });
    }
    get value() {
        let result = [];
        this.cells.forEach((c) => result.push(c));
        return result;
    }
    set value(value) { }
    get decimalDigits() {
        return this.expression?.indexOf("{Line}") >= 0 ? 0 : this._decimalDigits;
    }
    set decimalDigits(value) {
        this._decimalDigits = Math.max(0, Math.min(value, 10));
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyArray("Cells", this.cells);
        jObject.addPropertyString("Expression", this.expression);
        jObject.addPropertyString("Prefix", this.prefix);
        jObject.addPropertyString("Suffix", this.suffix);
        jObject.addPropertyNumber("DecimalDigits", this.decimalDigits);
        jObject.addPropertyEnum("ThousandSeparator", StiThousandSeparator, this.thousandSeparator);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Expression":
                    this.expression = property.value;
                    break;
                case "Cells":
                    this.cells = [];
                    property.value.properties().forEach((p) => this.cells.push(p.value));
                    break;
                case "ThousandSeparator":
                    this.thousandSeparator = Enum.parse(StiThousandSeparator, property.value);
                    break;
                case "DecimalDigits":
                    this.decimalDigits = property.value;
                    break;
                case "Prefix":
                    this.prefix = property.value;
                    break;
                case "Suffix":
                    this.suffix = property.value;
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU3RpTGFiZWxDb2x1bW5JdGVtLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc3RpbXVsc29mdC1mb3Jtcy9zcmMvbGliL2VsZW1lbnRzL3RhYmxlL2NvbHVtbnMvU3RpTGFiZWxDb2x1bW5JdGVtLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUNBLE9BQU8sRUFBRSxJQUFJLEVBQUUsTUFBTSxzQkFBc0IsQ0FBQztBQUM1QyxPQUFPLEVBQUUsb0JBQW9CLEVBQW9CLE1BQU0sdUJBQXVCLENBQUM7QUFJL0UsT0FBTyxFQUFFLGFBQWEsRUFBRSxNQUFNLGtCQUFrQixDQUFDO0FBRWpELE1BQU0sT0FBTyxrQkFBbUIsU0FBUSxhQUFhO0lBVW5ELFlBQW1CLEtBQWMsRUFBUyxJQUFjO1FBQ3RELEtBQUssQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFERixVQUFLLEdBQUwsS0FBSyxDQUFTO1FBQVMsU0FBSSxHQUFKLElBQUksQ0FBVTtRQVRoRCxtQkFBYyxHQUFXLENBQUMsQ0FBQztRQUU1QixTQUFJLEdBQUcsYUFBYSxDQUFDO1FBQ3JCLGVBQVUsR0FBVyxFQUFFLENBQUM7UUFDeEIsV0FBTSxHQUFXLEVBQUUsQ0FBQztRQUNwQixXQUFNLEdBQVcsRUFBRSxDQUFDO1FBQ3BCLFVBQUssR0FBRyxFQUFFLENBQUM7UUFDWCxzQkFBaUIsR0FBeUIsb0JBQW9CLENBQUMsSUFBSSxDQUFDO1FBSXpFLElBQUksSUFBSSxFQUFFLENBQUM7WUFDVCxJQUFJLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsYUFBYSxDQUFDO1lBQ2xELElBQUksQ0FBQyxpQkFBaUIsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLGlCQUFpQixDQUFDO1FBQzNELENBQUM7SUFDSCxDQUFDO0lBR00sUUFBUSxDQUFDLFVBQXlCO1FBQ3ZDLEtBQUssQ0FBQyxRQUFRLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDM0IsSUFBSSxVQUFVLFlBQVksa0JBQWtCLEVBQUUsQ0FBQztZQUM3QyxJQUFJLEtBQUssR0FBdUIsVUFBZ0MsQ0FBQztZQUNqRSxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQyxjQUFjLENBQUM7WUFDM0MsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQztZQUNqRCxJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQyxNQUFNLENBQUM7WUFDM0IsSUFBSSxDQUFDLE1BQU0sR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDO1FBQzdCLENBQUM7SUFDSCxDQUFDO0lBRU0sVUFBVTtRQUNmLE9BQU8sRUFBRSxDQUFDO0lBQ1osQ0FBQztJQUVELGdCQUFnQjtRQUNkLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUMsSUFBSSxFQUFFLEVBQUU7WUFDMUIsSUFBSSxHQUFHLEVBQUUsQ0FBQztRQUNaLENBQUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUNELElBQVcsS0FBSztRQUNkLElBQUksTUFBTSxHQUFHLEVBQUUsQ0FBQztRQUNoQixJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQzFDLE9BQU8sTUFBTSxDQUFDO0lBQ2hCLENBQUM7SUFFRCxJQUFXLEtBQUssQ0FBQyxLQUFVLElBQUksQ0FBQztJQUVoQyxJQUFJLGFBQWE7UUFDZixPQUFPLElBQUksQ0FBQyxVQUFVLEVBQUUsT0FBTyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDO0lBQzNFLENBQUM7SUFDRCxJQUFJLGFBQWEsQ0FBQyxLQUFhO1FBQzdCLElBQUksQ0FBQyxjQUFjLEdBQUcsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDLEVBQUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQztJQUN6RCxDQUFDO0lBRUQsZ0JBQWdCLENBQUMsT0FBWTtRQUMzQixJQUFJLE9BQU8sR0FBRyxLQUFLLENBQUMsZ0JBQWdCLENBQUMsT0FBTyxDQUFDLENBQUM7UUFDOUMsT0FBTyxDQUFDLGdCQUFnQixDQUFDLE9BQU8sRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDOUMsT0FBTyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDekQsT0FBTyxDQUFDLGlCQUFpQixDQUFDLFFBQVEsRUFBRSxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUM7UUFDakQsT0FBTyxDQUFDLGlCQUFpQixDQUFDLFFBQVEsRUFBRSxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUM7UUFDakQsT0FBTyxDQUFDLGlCQUFpQixDQUFDLGVBQWUsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUM7UUFDL0QsT0FBTyxDQUFDLGVBQWUsQ0FBQyxtQkFBbUIsRUFBRSxvQkFBb0IsRUFBRSxJQUFJLENBQUMsaUJBQWlCLENBQUMsQ0FBQztRQUUzRixPQUFPLE9BQU8sQ0FBQztJQUNqQixDQUFDO0lBRU0sa0JBQWtCLENBQUMsSUFBYTtRQUNyQyxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDL0IsS0FBSyxJQUFJLFFBQVEsSUFBSSxJQUFJLENBQUMsVUFBVSxFQUFFLEVBQUUsQ0FBQztZQUN2QyxRQUFRLFFBQVEsQ0FBQyxJQUFJLEVBQUUsQ0FBQztnQkFDdEIsS0FBSyxZQUFZO29CQUNmLElBQUksQ0FBQyxVQUFVLEdBQUcsUUFBUSxDQUFDLEtBQUssQ0FBQztvQkFDakMsTUFBTTtnQkFDUixLQUFLLE9BQU87b0JBQ1YsSUFBSSxDQUFDLEtBQUssR0FBRyxFQUFFLENBQUM7b0JBQ2YsUUFBUSxDQUFDLEtBQWlCLENBQUMsVUFBVSxFQUFFLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztvQkFDbEYsTUFBTTtnQkFDUixLQUFLLG1CQUFtQjtvQkFDdEIsSUFBSSxDQUFDLGlCQUFpQixHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsb0JBQW9CLEVBQUUsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO29CQUMxRSxNQUFNO2dCQUNSLEtBQUssZUFBZTtvQkFDbEIsSUFBSSxDQUFDLGFBQWEsR0FBRyxRQUFRLENBQUMsS0FBSyxDQUFDO29CQUNwQyxNQUFNO2dCQUNSLEtBQUssUUFBUTtvQkFDWCxJQUFJLENBQUMsTUFBTSxHQUFHLFFBQVEsQ0FBQyxLQUFLLENBQUM7b0JBQzdCLE1BQU07Z0JBQ1IsS0FBSyxRQUFRO29CQUNYLElBQUksQ0FBQyxNQUFNLEdBQUcsUUFBUSxDQUFDLEtBQUssQ0FBQztvQkFDN0IsTUFBTTtZQUNWLENBQUM7UUFDSCxDQUFDO0lBQ0gsQ0FBQztDQUNGIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgU3RpTW9kZWxTZXJ2aWNlIH0gZnJvbSBcIi4uLy4uLy4uL3NlcnZpY2VzL21vZGVsLnNlcnZpY2VcIjtcclxuaW1wb3J0IHsgRW51bSB9IGZyb20gXCIuLi8uLi8uLi9zeXN0ZW0vRW51bVwiO1xyXG5pbXBvcnQgeyBTdGlUaG91c2FuZFNlcGFyYXRvciwgU3RpVW5pdEFsaWdubWVudCB9IGZyb20gXCIuLi8uLi8uLi9zeXN0ZW0vZW51bXNcIjtcclxuaW1wb3J0IHsgU3RpRm9ybWF0dGVkRWxlbWVudCwgU3RpVmFsdWVFbGVtZW50IH0gZnJvbSBcIi4uLy4uLy4uL3N5c3RlbS9pbnRlcmZhY2VzXCI7XHJcbmltcG9ydCBTdGlKc29uIGZyb20gXCIuLi8uLi8uLi9zeXN0ZW0vU3RpSnNvblwiO1xyXG5pbXBvcnQgeyBTdGlGb3JtIH0gZnJvbSBcIi4uLy4uL1N0aUZvcm1cIjtcclxuaW1wb3J0IHsgU3RpQ29sdW1uSXRlbSB9IGZyb20gXCIuLi9TdGlDb2x1bW5JdGVtXCI7XHJcblxyXG5leHBvcnQgY2xhc3MgU3RpTGFiZWxDb2x1bW5JdGVtIGV4dGVuZHMgU3RpQ29sdW1uSXRlbSBpbXBsZW1lbnRzIFN0aVZhbHVlRWxlbWVudCwgU3RpRm9ybWF0dGVkRWxlbWVudCB7XHJcbiAgcHJpdmF0ZSBfZGVjaW1hbERpZ2l0czogbnVtYmVyID0gMjtcclxuXHJcbiAgcHVibGljIHR5cGUgPSBcIkxhYmVsQ29sdW1uXCI7XHJcbiAgcHVibGljIGV4cHJlc3Npb246IHN0cmluZyA9IFwiXCI7XHJcbiAgcHVibGljIHByZWZpeDogc3RyaW5nID0gXCJcIjtcclxuICBwdWJsaWMgc3VmZml4OiBzdHJpbmcgPSBcIlwiO1xyXG4gIHB1YmxpYyBjZWxscyA9IFtdO1xyXG4gIHB1YmxpYyB0aG91c2FuZFNlcGFyYXRvcjogU3RpVGhvdXNhbmRTZXBhcmF0b3IgPSBTdGlUaG91c2FuZFNlcGFyYXRvci5Ob25lO1xyXG5cclxuICBjb25zdHJ1Y3RvcihwdWJsaWMgbGFiZWw/OiBzdHJpbmcsIHB1YmxpYyBmb3JtPzogU3RpRm9ybSkge1xyXG4gICAgc3VwZXIobGFiZWwsIGZvcm0pO1xyXG4gICAgaWYgKGZvcm0pIHtcclxuICAgICAgdGhpcy5fZGVjaW1hbERpZ2l0cyA9IGZvcm0uc2V0dGluZ3MuZGVjaW1hbERpZ2l0cztcclxuICAgICAgdGhpcy50aG91c2FuZFNlcGFyYXRvciA9IGZvcm0uc2V0dGluZ3MudGhvdXNhbmRTZXBhcmF0b3I7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuXHJcbiAgcHVibGljIGNvcHlGcm9tKHBhcmVudEl0ZW06IFN0aUNvbHVtbkl0ZW0pIHtcclxuICAgIHN1cGVyLmNvcHlGcm9tKHBhcmVudEl0ZW0pO1xyXG4gICAgaWYgKHBhcmVudEl0ZW0gaW5zdGFuY2VvZiBTdGlMYWJlbENvbHVtbkl0ZW0pIHtcclxuICAgICAgbGV0IGxhYmVsOiBTdGlMYWJlbENvbHVtbkl0ZW0gPSBwYXJlbnRJdGVtIGFzIFN0aUxhYmVsQ29sdW1uSXRlbTtcclxuICAgICAgdGhpcy5fZGVjaW1hbERpZ2l0cyA9IGxhYmVsLl9kZWNpbWFsRGlnaXRzO1xyXG4gICAgICB0aGlzLnRob3VzYW5kU2VwYXJhdG9yID0gbGFiZWwudGhvdXNhbmRTZXBhcmF0b3I7XHJcbiAgICAgIHRoaXMucHJlZml4ID0gbGFiZWwucHJlZml4O1xyXG4gICAgICB0aGlzLnN1ZmZpeCA9IGxhYmVsLnN1ZmZpeDtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIHB1YmxpYyBjcmVhdGVDZWxsKCk6IGFueSB7XHJcbiAgICByZXR1cm4gXCJcIjtcclxuICB9XHJcblxyXG4gIHNldERlZmF1bHRWYWx1ZXMoKSB7XHJcbiAgICB0aGlzLmNlbGxzLmZvckVhY2goKGNlbGwpID0+IHtcclxuICAgICAgY2VsbCA9IFwiXCI7XHJcbiAgICB9KTtcclxuICB9XHJcbiAgcHVibGljIGdldCB2YWx1ZSgpOiBhbnkge1xyXG4gICAgbGV0IHJlc3VsdCA9IFtdO1xyXG4gICAgdGhpcy5jZWxscy5mb3JFYWNoKChjKSA9PiByZXN1bHQucHVzaChjKSk7XHJcbiAgICByZXR1cm4gcmVzdWx0O1xyXG4gIH1cclxuXHJcbiAgcHVibGljIHNldCB2YWx1ZSh2YWx1ZTogYW55KSB7IH1cclxuXHJcbiAgZ2V0IGRlY2ltYWxEaWdpdHMoKSB7XHJcbiAgICByZXR1cm4gdGhpcy5leHByZXNzaW9uPy5pbmRleE9mKFwie0xpbmV9XCIpID49IDAgPyAwIDogdGhpcy5fZGVjaW1hbERpZ2l0cztcclxuICB9XHJcbiAgc2V0IGRlY2ltYWxEaWdpdHModmFsdWU6IG51bWJlcikge1xyXG4gICAgdGhpcy5fZGVjaW1hbERpZ2l0cyA9IE1hdGgubWF4KDAsIE1hdGgubWluKHZhbHVlLCAxMCkpO1xyXG4gIH1cclxuXHJcbiAgc2F2ZVRvSnNvbk9iamVjdChvcHRpb25zOiBhbnkpOiBTdGlKc29uIHtcclxuICAgIGxldCBqT2JqZWN0ID0gc3VwZXIuc2F2ZVRvSnNvbk9iamVjdChvcHRpb25zKTtcclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlBcnJheShcIkNlbGxzXCIsIHRoaXMuY2VsbHMpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eVN0cmluZyhcIkV4cHJlc3Npb25cIiwgdGhpcy5leHByZXNzaW9uKTtcclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlTdHJpbmcoXCJQcmVmaXhcIiwgdGhpcy5wcmVmaXgpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eVN0cmluZyhcIlN1ZmZpeFwiLCB0aGlzLnN1ZmZpeCk7XHJcbiAgICBqT2JqZWN0LmFkZFByb3BlcnR5TnVtYmVyKFwiRGVjaW1hbERpZ2l0c1wiLCB0aGlzLmRlY2ltYWxEaWdpdHMpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUVudW0oXCJUaG91c2FuZFNlcGFyYXRvclwiLCBTdGlUaG91c2FuZFNlcGFyYXRvciwgdGhpcy50aG91c2FuZFNlcGFyYXRvcik7XHJcblxyXG4gICAgcmV0dXJuIGpPYmplY3Q7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgbG9hZEZyb21Kc29uT2JqZWN0KGpzb246IFN0aUpzb24pIHtcclxuICAgIHN1cGVyLmxvYWRGcm9tSnNvbk9iamVjdChqc29uKTtcclxuICAgIGZvciAobGV0IHByb3BlcnR5IG9mIGpzb24ucHJvcGVydGllcygpKSB7XHJcbiAgICAgIHN3aXRjaCAocHJvcGVydHkubmFtZSkge1xyXG4gICAgICAgIGNhc2UgXCJFeHByZXNzaW9uXCI6XHJcbiAgICAgICAgICB0aGlzLmV4cHJlc3Npb24gPSBwcm9wZXJ0eS52YWx1ZTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJDZWxsc1wiOlxyXG4gICAgICAgICAgdGhpcy5jZWxscyA9IFtdO1xyXG4gICAgICAgICAgKHByb3BlcnR5LnZhbHVlIGFzIFN0aUpzb24pLnByb3BlcnRpZXMoKS5mb3JFYWNoKChwKSA9PiB0aGlzLmNlbGxzLnB1c2gocC52YWx1ZSkpO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIlRob3VzYW5kU2VwYXJhdG9yXCI6XHJcbiAgICAgICAgICB0aGlzLnRob3VzYW5kU2VwYXJhdG9yID0gRW51bS5wYXJzZShTdGlUaG91c2FuZFNlcGFyYXRvciwgcHJvcGVydHkudmFsdWUpO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIkRlY2ltYWxEaWdpdHNcIjpcclxuICAgICAgICAgIHRoaXMuZGVjaW1hbERpZ2l0cyA9IHByb3BlcnR5LnZhbHVlO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIlByZWZpeFwiOlxyXG4gICAgICAgICAgdGhpcy5wcmVmaXggPSBwcm9wZXJ0eS52YWx1ZTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJTdWZmaXhcIjpcclxuICAgICAgICAgIHRoaXMuc3VmZml4ID0gcHJvcGVydHkudmFsdWU7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgfVxyXG4gICAgfVxyXG4gIH1cclxufVxyXG4iXX0=