export class StiRowLabel {
    get eFont() {
        return this.table.font;
    }
    set eFont(value) {
        this.table.font = value;
    }
    get eColor() {
        return this.table.rowHeadersColor;
    }
    set eColor(value) {
        this.table.rowHeadersColor = value;
    }
    get eBackgroundColor() {
        return this.table.rowHeadersBackground;
    }
    set eBackgroundColor(value) {
        this.table.rowHeadersBackground = value;
    }
    get expression() {
        return this.value;
    }
    haveBackgoundColor() {
        return true;
    }
    get eContentAlignment() {
        return this.table.rowLabelsHorizontalAlignment;
    }
    set eContentAlignment(value) {
        this.table.rowLabelsHorizontalAlignment = value;
    }
    haveContentAlignment() {
        return true;
    }
    haveVerticalAlignment() {
        return false;
    }
    getDefaultEditableContent() {
        return this;
    }
    htmlStyle() {
        return this.table ? `${this.eFont.htmlStyle()};color: inherit` : "";
    }
    set value(value) {
        this._value = value;
        this.table.nativeRowLabels[this.index] = value;
    }
    get value() {
        return this._value;
    }
    set eValue(value) {
        this.value = value;
    }
    get eValue() {
        return this.value;
    }
    constructor(value, table, index) {
        this.table = table;
        this.index = index;
        this._value = value;
    }
}
//# sourceMappingURL=data:application/json;base64,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