import { Enum } from "../../system/Enum";
import StiJson from "../../system/StiJson";
import { StiVerticalAlignment, StiHorizontalAlignment } from "../../system/enums";
export class StiImageEditorResult {
    constructor() {
        this.loadedImage = "";
        this.verticalAlignment = StiVerticalAlignment.Center;
        this.horizontalAlignment = StiHorizontalAlignment.Center;
        this.aspectRatio = false;
        this.stretch = false;
        this.naturalWidth = 0;
        this.naturalHeight = 0;
    }
    saveToJsonObject(options) {
        let json = new StiJson();
        json.addPropertyBool("AspectRatio", this.aspectRatio);
        json.addPropertyBool("Stretch", this.stretch);
        if (!(options && options["notSerializeImages"])) {
            json.addPropertyStringNullOrEmpty("LoadedImage", this.loadedImage?.substring(this.loadedImage.indexOf("base64,") + 7));
        }
        json.addPropertyNumber("NaturalWidth", this.naturalWidth);
        json.addPropertyNumber("NaturalHeight", this.naturalHeight);
        json.addPropertyEnum("HorizontalAlignment", StiHorizontalAlignment, this.horizontalAlignment);
        json.addPropertyEnum("VerticalAlignment", StiVerticalAlignment, this.verticalAlignment);
        return json;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "AspectRatio":
                    this.aspectRatio = property.value;
                    break;
                case "Stretch":
                    this.stretch = property.value;
                    break;
                case "LoadedImage":
                    this.loadedImage = `data:image/png;base64,${property.value}`;
                    break;
                case "NaturalWidth":
                    this.naturalWidth = property.value;
                    break;
                case "NaturalHeight":
                    this.naturalHeight = property.value;
                    break;
                case "HorizontalAlignment":
                    this.horizontalAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "VerticalAlignment":
                    this.verticalAlignment = Enum.parse(StiVerticalAlignment, property.value);
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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