import StiPadding from "../../properties/StiPadding";
import { Enum } from "../../system/Enum";
import { StiDisplayCurrencyAs, StiThousandSeparator, StiUnitAlignment } from "../../system/enums";
import StiJson from "../../system/StiJson";
import { StiDescriptionSettings } from "./StiDescriptionSettings";
import { StiInnerTextSettings } from "./StiInnerTextSettings";
import { StiLabelSettings } from "./StiLabelSettings";
export class StiFormSettings {
    constructor(form) {
        this.form = form;
        this._label = new StiLabelSettings(this);
        this._description = new StiDescriptionSettings(this);
        this._innerText = new StiInnerTextSettings(this);
        this._dateTimeFormat = "m/d/yy h:MM tt";
        this._dateFomat = "dd.mm.yyyy";
        this._timeFormat = "HH:MM:ss";
        this._currency = "USD";
        this._currencyFormat = StiDisplayCurrencyAs.Code;
        this._unitAlignment = StiUnitAlignment.Prefix;
        this._thousandSeparator = StiThousandSeparator.Comma;
        this._decimalDigits = 2;
        this._padding = new StiPadding(8, 8, 8, 8, this);
        this._gridColumns = 12;
        this._gridVerticalStep = 5;
    }
    getCulture() {
        return this.culture || navigator.language || navigator.userLanguage;
    }
    set culture(value) {
        this._culture = value;
        this.form?.updateCultureDependecies();
    }
    get culture() {
        return this._culture;
    }
    get reportImage() {
        return this.form.reportImage;
    }
    set reportImage(value) {
        let oldValue = this.reportImage;
        this.form.reportImage = value;
        if (oldValue != value) {
            this.propertyChanged("reportImage", value, {});
        }
    }
    get formName() {
        return this.form.formName;
    }
    set formName(value) {
        let oldValue = this.form.formName;
        this.form.formName = value;
        if (oldValue != value) {
            this.propertyChanged("formName", value, {});
        }
    }
    get gridColumns() {
        return this._gridColumns;
    }
    set gridColumns(value) {
        let oldValue = this._gridColumns;
        if (typeof value != "number" ? Number(value) < 12 : value < 12) {
            this._gridColumns = 12;
        }
        else {
            this._gridColumns = value;
        }
        if (oldValue != value) {
            this.propertyChanged("gridColumns", value, {});
        }
    }
    get gridVerticalStep() {
        return this._gridVerticalStep;
    }
    set gridVerticalStep(value) {
        let oldValue = this._gridVerticalStep;
        if (value <= 1) {
            this._gridVerticalStep = 1;
        }
        else if (this.form?.pages.length > 0 && value > this.form.pages[this.form.pages.length - 1].contentAreaHeight) {
            this._gridVerticalStep = this.form.pages[this.form.pages.length - 1].contentAreaHeight;
        }
        else {
            this._gridVerticalStep = value;
        }
        if (oldValue != value) {
            this.propertyChanged("gridVerticalStep", value, {});
        }
    }
    get padding() {
        return this._padding;
    }
    set padding(value) {
        let oldObject = this._padding.clone();
        this._padding = value;
        this._padding.changesInterceptor = this;
        this.propertyChanged("padding", value, oldObject);
    }
    get label() {
        return this._label;
    }
    set label(value) {
        this._label = value;
    }
    get description() {
        return this._description;
    }
    set description(value) {
        this._description = value;
    }
    get innerText() {
        return this._innerText;
    }
    set innerText(value) {
        this._innerText = value;
    }
    get dateTimeFormat() {
        return this._dateTimeFormat;
    }
    set dateTimeFormat(value) {
        let oldValue = this._dateTimeFormat;
        this._dateTimeFormat = value;
        if (oldValue != value) {
            this.propertyChanged("dateTimeFormat", value, oldValue);
        }
    }
    get dateFormat() {
        return this._dateFomat;
    }
    set dateFormat(value) {
        let oldValue = this._dateFomat;
        this._dateFomat = value;
        if (oldValue != value) {
            this.propertyChanged("dateFormat", value, oldValue);
        }
    }
    get timeFormat() {
        return this._timeFormat;
    }
    set timeFormat(value) {
        let oldValue = this._timeFormat;
        this._timeFormat = value;
        if (oldValue != value) {
            this.propertyChanged("timeFormat", value, oldValue);
        }
    }
    get currency() {
        return this._currency;
    }
    set currency(value) {
        let oldValue = this._currency;
        this._currency = value;
        if (oldValue != value) {
            this.propertyChanged("currency", value, oldValue);
        }
    }
    get currencyFormat() {
        return this._currencyFormat;
    }
    set currencyFormat(value) {
        let oldValue = this._currencyFormat;
        this._currencyFormat = value;
        if (oldValue != value) {
            this.propertyChanged("currencyFormat", value, oldValue);
        }
    }
    get unitAlignment() {
        return this._unitAlignment;
    }
    set unitAlignment(value) {
        let oldValue = this._unitAlignment;
        this._unitAlignment = value;
        if (oldValue != value) {
            this.propertyChanged("unitAlignment", value, oldValue);
        }
    }
    get thousandSeparator() {
        return this._thousandSeparator;
    }
    set thousandSeparator(value) {
        let oldValue = this._thousandSeparator;
        this._thousandSeparator = value;
        if (oldValue != value) {
            this.propertyChanged("thousandSeparator", value, oldValue);
        }
    }
    get decimalDigits() {
        return this._decimalDigits;
    }
    set decimalDigits(value) {
        let oldValue = this._decimalDigits;
        if (value <= 0) {
            this._decimalDigits = 0;
        }
        else {
            this._decimalDigits = value;
        }
        if (oldValue != value) {
            this.propertyChanged("decimalDigits", value, oldValue);
        }
    }
    propertyChanged(propName, value, oldObject) {
        this.form.pages.forEach((p) => p.allElements.forEach((el) => {
            el.setProperty(propName, value["clone"] ? value.clone() : value, oldObject);
        }));
        if (propName.toLowerCase().indexOf("color") == -1) {
            this.form.formEvents.next({ name: "UpdateAllSizes" });
        }
        if (propName == "thousandSeparator" || propName == "decimalDigits") {
            this.form.formEvents.next({ name: "UpdateForm" });
        }
    }
    saveToJsonObject(options) {
        let json = new StiJson();
        json.addPropertyJObject("Label", this.label.saveToJsonObject(options));
        json.addPropertyJObject("Description", this.description.saveToJsonObject(options));
        json.addPropertyJObject("InnerText", this.innerText.saveToJsonObject(options));
        json.addPropertyString("TimeFormat", this.timeFormat);
        json.addPropertyString("DateFormat", this.dateFormat);
        json.addPropertyString("DateTimeFormat", this.dateTimeFormat);
        json.addPropertyNumber("DecimalDigits", this.decimalDigits);
        json.addPropertyNumber("GridColumns", this.gridColumns);
        json.addPropertyNumber("GridVerticalStep", this.gridVerticalStep);
        json.addPropertyString("Currency", this.currency);
        json.addPropertyEnum("CurrencyFormat", StiDisplayCurrencyAs, this.currencyFormat);
        json.addPropertyEnum("UnitAlignment", StiUnitAlignment, this.unitAlignment);
        json.addPropertyEnum("ThousandSeparator", StiThousandSeparator, this.thousandSeparator);
        json.addPropertyJObject("Padding", this.padding.saveToJsonObject(options));
        json.addPropertyString("Culture", this.culture);
        return json;
    }
    loadFormJsonString(text) {
        let jObject = new StiJson();
        jObject.deserialize(text);
        this.loadFromJsonObject(jObject);
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Label":
                    this._label = new StiLabelSettings(this);
                    this._label.loadFromJsonObject(property.value);
                    break;
                case "Description":
                    this._description = new StiDescriptionSettings(this);
                    this._description.loadFromJsonObject(property.value);
                    break;
                case "InnerText":
                    this._innerText = new StiInnerTextSettings(this);
                    this._innerText.loadFromJsonObject(property.value);
                    break;
                case "TimeFormat":
                    this.timeFormat = property.value;
                    break;
                case "DateFormat":
                    this.dateFormat = property.value;
                    break;
                case "DateTimeFormat":
                    this.dateTimeFormat = property.value;
                    break;
                case "DecimalDigits":
                    this.decimalDigits = property.value;
                    break;
                case "Culture":
                    this.culture = property.value;
                    break;
                case "GridColumns":
                    this.gridColumns = property.value < 12 ? 12 : property.value;
                    break;
                case "GridVerticalStep":
                    this.gridVerticalStep = property.value;
                    break;
                case "Currency":
                    this._currency = property.value;
                    break;
                case "CurrencyFormat":
                    this._currencyFormat = Enum.parse(StiDisplayCurrencyAs, property.value);
                    break;
                case "UnitAlignment":
                    this._unitAlignment = Enum.parse(StiUnitAlignment, property.value);
                    break;
                case "Separator":
                case "ThousandSeparator":
                    this._thousandSeparator = Enum.parse(StiThousandSeparator, property.value);
                    break;
                case "Padding":
                    this._padding = new StiPadding();
                    this._padding.loadFromJsonObject(property.value);
                    break;
            }
        }
    }
    applySettings(element) {
        element.setProperty("label.font.family", this.label.font.family, null);
        element.setProperty("label.font.style", this.label.font.cloneStyle, null);
        element.setProperty("label.font.size", this.label.font.size, null);
        element.setProperty("label.color", this.label.color, null);
        element.setProperty("label.alignment", this.label.alignment, null);
        element.setProperty("label.width", this.label.width, null);
        element.setProperty("padding", this.padding, null);
        element.setProperty("description.font.family", this.description.font.family, null);
        element.setProperty("description.font.style", this.description.font.cloneStyle, null);
        element.setProperty("description.font.size", this.description.font.size, null);
        element.setProperty("description.color", this.description.color.clone(), null);
        element.setProperty("innerText.font.family", this.innerText.font.family, null);
        element.setProperty("innerText.font.style", this.innerText.font.cloneStyle, null);
        element.setProperty("innerText.font.size", this.innerText.font.size, null);
        element.setProperty("innerText.color", this.innerText.color.clone(), null);
        element.setProperty("innerText.backgroundColor", this.innerText.backgroundColor.clone(), null);
        element.setProperty("innerText.borderColor", this.innerText.borderColor.clone(), null);
        element.setProperty("innerText.borderWeight", this.innerText.borderWeight, null);
        element.setProperty("innerText.checkColor", this.innerText.checkColor.clone(), null);
        element.setProperty("innerText.contentAlignment", this.innerText.contentAlignment, null);
        element.setProperty("timeFormat", this.timeFormat, null);
        element.setProperty("dateFormat", this.dateFormat, null);
        element.setProperty("dateTimeFormat", this.dateTimeFormat, null);
        element.setProperty("currency", this.currency, null);
        element.setProperty("currencyFormat", this.currencyFormat, null);
        element.setProperty("unitAlignment", this.unitAlignment, null);
        element.setProperty("thousandSeparator", this.thousandSeparator, null);
        element.setProperty("decimalDigits", this.decimalDigits, null);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU3RpRm9ybVNldHRpbmdzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc3RpbXVsc29mdC1mb3Jtcy9zcmMvbGliL2VsZW1lbnRzL3NldHRpbmdzL1N0aUZvcm1TZXR0aW5ncy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLFVBQVUsTUFBTSw2QkFBNkIsQ0FBQztBQUNyRCxPQUFPLEVBQUUsSUFBSSxFQUFFLE1BQU0sbUJBQW1CLENBQUM7QUFDekMsT0FBTyxFQUFFLG9CQUFvQixFQUFFLG9CQUFvQixFQUFFLGdCQUFnQixFQUFFLE1BQU0sb0JBQW9CLENBQUM7QUFFbEcsT0FBTyxPQUFPLE1BQU0sc0JBQXNCLENBQUM7QUFFM0MsT0FBTyxFQUFFLHNCQUFzQixFQUFFLE1BQU0sMEJBQTBCLENBQUM7QUFDbEUsT0FBTyxFQUFFLG9CQUFvQixFQUFFLE1BQU0sd0JBQXdCLENBQUM7QUFDOUQsT0FBTyxFQUFFLGdCQUFnQixFQUFFLE1BQU0sb0JBQW9CLENBQUM7QUFFdEQsTUFBTSxPQUFPLGVBQWU7SUFpQjFCLFlBQW1CLElBQWE7UUFBYixTQUFJLEdBQUosSUFBSSxDQUFTO1FBaEJ4QixXQUFNLEdBQXFCLElBQUksZ0JBQWdCLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDdEQsaUJBQVksR0FBMkIsSUFBSSxzQkFBc0IsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUN4RSxlQUFVLEdBQXlCLElBQUksb0JBQW9CLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDbEUsb0JBQWUsR0FBVyxnQkFBZ0IsQ0FBQztRQUMzQyxlQUFVLEdBQVcsWUFBWSxDQUFDO1FBQ2xDLGdCQUFXLEdBQVcsVUFBVSxDQUFDO1FBQ2pDLGNBQVMsR0FBRyxLQUFLLENBQUM7UUFDbEIsb0JBQWUsR0FBeUIsb0JBQW9CLENBQUMsSUFBSSxDQUFDO1FBQ2xFLG1CQUFjLEdBQXFCLGdCQUFnQixDQUFDLE1BQU0sQ0FBQztRQUMzRCx1QkFBa0IsR0FBeUIsb0JBQW9CLENBQUMsS0FBSyxDQUFDO1FBQ3RFLG1CQUFjLEdBQUcsQ0FBQyxDQUFDO1FBQ25CLGFBQVEsR0FBZSxJQUFJLFVBQVUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDeEQsaUJBQVksR0FBVyxFQUFFLENBQUM7UUFDMUIsc0JBQWlCLEdBQVcsQ0FBQyxDQUFDO0lBR0YsQ0FBQztJQUU5QixVQUFVO1FBQ2YsT0FBTyxJQUFJLENBQUMsT0FBTyxJQUFJLFNBQVMsQ0FBQyxRQUFRLElBQUssU0FBaUIsQ0FBQyxZQUFZLENBQUM7SUFDL0UsQ0FBQztJQUVELElBQVcsT0FBTyxDQUFDLEtBQWE7UUFDOUIsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUM7UUFDdEIsSUFBSSxDQUFDLElBQUksRUFBRSx3QkFBd0IsRUFBRSxDQUFDO0lBQ3hDLENBQUM7SUFFRCxJQUFXLE9BQU87UUFDaEIsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDO0lBQ3ZCLENBQUM7SUFFRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQztJQUMvQixDQUFDO0lBQ0QsSUFBVyxXQUFXLENBQUMsS0FBYTtRQUNsQyxJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDO1FBQ2hDLElBQUksQ0FBQyxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQztRQUM5QixJQUFJLFFBQVEsSUFBSSxLQUFLLEVBQUUsQ0FBQztZQUN0QixJQUFJLENBQUMsZUFBZSxDQUFDLGFBQWEsRUFBRSxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDakQsQ0FBQztJQUNILENBQUM7SUFDRCxJQUFXLFFBQVE7UUFDakIsT0FBTyxJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQztJQUM1QixDQUFDO0lBQ0QsSUFBVyxRQUFRLENBQUMsS0FBYTtRQUMvQixJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQztRQUNsQyxJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUM7UUFDM0IsSUFBSSxRQUFRLElBQUksS0FBSyxFQUFFLENBQUM7WUFDdEIsSUFBSSxDQUFDLGVBQWUsQ0FBQyxVQUFVLEVBQUUsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQzlDLENBQUM7SUFDSCxDQUFDO0lBQ0QsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBQ0QsSUFBVyxXQUFXLENBQUMsS0FBYTtRQUNsQyxJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDO1FBQ2pDLElBQUksT0FBTyxLQUFLLElBQUksUUFBUSxDQUFDLENBQUMsQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSxDQUFDLENBQUMsQ0FBQyxLQUFLLEdBQUcsRUFBRSxFQUFFLENBQUM7WUFDL0QsSUFBSSxDQUFDLFlBQVksR0FBRyxFQUFFLENBQUM7UUFDekIsQ0FBQzthQUFNLENBQUM7WUFDTixJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQztRQUM1QixDQUFDO1FBQ0QsSUFBSSxRQUFRLElBQUksS0FBSyxFQUFFLENBQUM7WUFDdEIsSUFBSSxDQUFDLGVBQWUsQ0FBQyxhQUFhLEVBQUUsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pELENBQUM7SUFDSCxDQUFDO0lBQ0QsSUFBVyxnQkFBZ0I7UUFDekIsT0FBTyxJQUFJLENBQUMsaUJBQWlCLENBQUM7SUFDaEMsQ0FBQztJQUNELElBQVcsZ0JBQWdCLENBQUMsS0FBYTtRQUN2QyxJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsaUJBQWlCLENBQUM7UUFDdEMsSUFBSSxLQUFLLElBQUksQ0FBQyxFQUFFLENBQUM7WUFDZixJQUFJLENBQUMsaUJBQWlCLEdBQUcsQ0FBQyxDQUFDO1FBQzdCLENBQUM7YUFBTSxJQUFJLElBQUksQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLE1BQU0sR0FBRyxDQUFDLElBQUksS0FBSyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUMsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO1lBQ2hILElBQUksQ0FBQyxpQkFBaUIsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFDLENBQUMsaUJBQWlCLENBQUM7UUFDekYsQ0FBQzthQUFNLENBQUM7WUFDTixJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDO1FBQ2pDLENBQUM7UUFDRCxJQUFJLFFBQVEsSUFBSSxLQUFLLEVBQUUsQ0FBQztZQUN0QixJQUFJLENBQUMsZUFBZSxDQUFDLGtCQUFrQixFQUFFLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUN0RCxDQUFDO0lBQ0gsQ0FBQztJQUVELElBQUksT0FBTztRQUNULE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQztJQUN2QixDQUFDO0lBRUQsSUFBSSxPQUFPLENBQUMsS0FBaUI7UUFDM0IsSUFBSSxTQUFTLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUN0QyxJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQztRQUN0QixJQUFJLENBQUMsUUFBUSxDQUFDLGtCQUFrQixHQUFHLElBQUksQ0FBQztRQUN4QyxJQUFJLENBQUMsZUFBZSxDQUFDLFNBQVMsRUFBRSxLQUFLLEVBQUUsU0FBUyxDQUFDLENBQUM7SUFDcEQsQ0FBQztJQUVELElBQUksS0FBSztRQUNQLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQztJQUNyQixDQUFDO0lBRUQsSUFBSSxLQUFLLENBQUMsS0FBdUI7UUFDL0IsSUFBSSxDQUFDLE1BQU0sR0FBRyxLQUFLLENBQUM7SUFDdEIsQ0FBQztJQUVELElBQUksV0FBVztRQUNiLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBRUQsSUFBSSxXQUFXLENBQUMsS0FBNkI7UUFDM0MsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7SUFDNUIsQ0FBQztJQUVELElBQUksU0FBUztRQUNYLE9BQU8sSUFBSSxDQUFDLFVBQVUsQ0FBQztJQUN6QixDQUFDO0lBRUQsSUFBSSxTQUFTLENBQUMsS0FBMkI7UUFDdkMsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUM7SUFDMUIsQ0FBQztJQUVELElBQUksY0FBYztRQUNoQixPQUFPLElBQUksQ0FBQyxlQUFlLENBQUM7SUFDOUIsQ0FBQztJQUVELElBQUksY0FBYyxDQUFDLEtBQWE7UUFDOUIsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLGVBQWUsQ0FBQztRQUNwQyxJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQztRQUM3QixJQUFJLFFBQVEsSUFBSSxLQUFLLEVBQUUsQ0FBQztZQUN0QixJQUFJLENBQUMsZUFBZSxDQUFDLGdCQUFnQixFQUFFLEtBQUssRUFBRSxRQUFRLENBQUMsQ0FBQztRQUMxRCxDQUFDO0lBQ0gsQ0FBQztJQUNELElBQUksVUFBVTtRQUNaLE9BQU8sSUFBSSxDQUFDLFVBQVUsQ0FBQztJQUN6QixDQUFDO0lBQ0QsSUFBSSxVQUFVLENBQUMsS0FBYTtRQUMxQixJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDO1FBQy9CLElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDO1FBQ3hCLElBQUksUUFBUSxJQUFJLEtBQUssRUFBRSxDQUFDO1lBQ3RCLElBQUksQ0FBQyxlQUFlLENBQUMsWUFBWSxFQUFFLEtBQUssRUFBRSxRQUFRLENBQUMsQ0FBQztRQUN0RCxDQUFDO0lBQ0gsQ0FBQztJQUVELElBQUksVUFBVTtRQUNaLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztJQUMxQixDQUFDO0lBRUQsSUFBSSxVQUFVLENBQUMsS0FBYTtRQUMxQixJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDO1FBQ2hDLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDO1FBQ3pCLElBQUksUUFBUSxJQUFJLEtBQUssRUFBRSxDQUFDO1lBQ3RCLElBQUksQ0FBQyxlQUFlLENBQUMsWUFBWSxFQUFFLEtBQUssRUFBRSxRQUFRLENBQUMsQ0FBQztRQUN0RCxDQUFDO0lBQ0gsQ0FBQztJQUVELElBQUksUUFBUTtRQUNWLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDO0lBRUQsSUFBSSxRQUFRLENBQUMsS0FBYTtRQUN4QixJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDO1FBQzlCLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDO1FBQ3ZCLElBQUksUUFBUSxJQUFJLEtBQUssRUFBRSxDQUFDO1lBQ3RCLElBQUksQ0FBQyxlQUFlLENBQUMsVUFBVSxFQUFFLEtBQUssRUFBRSxRQUFRLENBQUMsQ0FBQztRQUNwRCxDQUFDO0lBQ0gsQ0FBQztJQUVELElBQUksY0FBYztRQUNoQixPQUFPLElBQUksQ0FBQyxlQUFlLENBQUM7SUFDOUIsQ0FBQztJQUVELElBQUksY0FBYyxDQUFDLEtBQTJCO1FBQzVDLElBQUksUUFBUSxHQUFHLElBQUksQ0FBQyxlQUFlLENBQUM7UUFDcEMsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUM7UUFDN0IsSUFBSSxRQUFRLElBQUksS0FBSyxFQUFFLENBQUM7WUFDdEIsSUFBSSxDQUFDLGVBQWUsQ0FBQyxnQkFBZ0IsRUFBRSxLQUFLLEVBQUUsUUFBUSxDQUFDLENBQUM7UUFDMUQsQ0FBQztJQUNILENBQUM7SUFFRCxJQUFJLGFBQWE7UUFDZixPQUFPLElBQUksQ0FBQyxjQUFjLENBQUM7SUFDN0IsQ0FBQztJQUVELElBQUksYUFBYSxDQUFDLEtBQXVCO1FBQ3ZDLElBQUksUUFBUSxHQUFHLElBQUksQ0FBQyxjQUFjLENBQUM7UUFDbkMsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUM7UUFDNUIsSUFBSSxRQUFRLElBQUksS0FBSyxFQUFFLENBQUM7WUFDdEIsSUFBSSxDQUFDLGVBQWUsQ0FBQyxlQUFlLEVBQUUsS0FBSyxFQUFFLFFBQVEsQ0FBQyxDQUFDO1FBQ3pELENBQUM7SUFDSCxDQUFDO0lBRUQsSUFBSSxpQkFBaUI7UUFDbkIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUM7SUFDakMsQ0FBQztJQUVELElBQUksaUJBQWlCLENBQUMsS0FBMkI7UUFDL0MsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLGtCQUFrQixDQUFDO1FBQ3ZDLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUM7UUFDaEMsSUFBSSxRQUFRLElBQUksS0FBSyxFQUFFLENBQUM7WUFDdEIsSUFBSSxDQUFDLGVBQWUsQ0FBQyxtQkFBbUIsRUFBRSxLQUFLLEVBQUUsUUFBUSxDQUFDLENBQUM7UUFDN0QsQ0FBQztJQUNILENBQUM7SUFFRCxJQUFJLGFBQWE7UUFDZixPQUFPLElBQUksQ0FBQyxjQUFjLENBQUM7SUFDN0IsQ0FBQztJQUVELElBQUksYUFBYSxDQUFDLEtBQWE7UUFDN0IsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQztRQUNuQyxJQUFJLEtBQUssSUFBSSxDQUFDLEVBQUUsQ0FBQztZQUNmLElBQUksQ0FBQyxjQUFjLEdBQUcsQ0FBQyxDQUFDO1FBQzFCLENBQUM7YUFBTSxDQUFDO1lBQ04sSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUM7UUFDOUIsQ0FBQztRQUNELElBQUksUUFBUSxJQUFJLEtBQUssRUFBRSxDQUFDO1lBQ3RCLElBQUksQ0FBQyxlQUFlLENBQUMsZUFBZSxFQUFFLEtBQUssRUFBRSxRQUFRLENBQUMsQ0FBQztRQUN6RCxDQUFDO0lBQ0gsQ0FBQztJQUVELGVBQWUsQ0FBQyxRQUFnQixFQUFFLEtBQVUsRUFBRSxTQUFjO1FBQzFELElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQzVCLENBQUMsQ0FBQyxXQUFXLENBQUMsT0FBTyxDQUFDLENBQUMsRUFBRSxFQUFFLEVBQUU7WUFDM0IsRUFBRSxDQUFDLFdBQVcsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUMsQ0FBQyxDQUFDLEtBQUssRUFBRSxTQUFTLENBQUMsQ0FBQztRQUM5RSxDQUFDLENBQUMsQ0FDSCxDQUFDO1FBRUYsSUFBSSxRQUFRLENBQUMsV0FBVyxFQUFFLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQyxFQUFFLENBQUM7WUFDbEQsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLEVBQUUsSUFBSSxFQUFFLGdCQUFnQixFQUFFLENBQUMsQ0FBQztRQUN4RCxDQUFDO1FBRUQsSUFBSSxRQUFRLElBQUksbUJBQW1CLElBQUksUUFBUSxJQUFJLGVBQWUsRUFBRSxDQUFDO1lBQ25FLElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxFQUFFLElBQUksRUFBRSxZQUFZLEVBQUUsQ0FBQyxDQUFDO1FBQ3BELENBQUM7SUFDSCxDQUFDO0lBRU0sZ0JBQWdCLENBQUMsT0FBWTtRQUNsQyxJQUFJLElBQUksR0FBRyxJQUFJLE9BQU8sRUFBRSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO1FBQ3ZFLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxhQUFhLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO1FBQ25GLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxXQUFXLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO1FBQy9FLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQ3RELElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQ3RELElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxJQUFJLENBQUMsY0FBYyxDQUFDLENBQUM7UUFDOUQsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGVBQWUsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUM7UUFDNUQsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUM7UUFDeEQsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGtCQUFrQixFQUFFLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO1FBQ2xFLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQ2xELElBQUksQ0FBQyxlQUFlLENBQUMsZ0JBQWdCLEVBQUUsb0JBQW9CLEVBQUUsSUFBSSxDQUFDLGNBQWMsQ0FBQyxDQUFDO1FBQ2xGLElBQUksQ0FBQyxlQUFlLENBQUMsZUFBZSxFQUFFLGdCQUFnQixFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQztRQUM1RSxJQUFJLENBQUMsZUFBZSxDQUFDLG1CQUFtQixFQUFFLG9CQUFvQixFQUFFLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO1FBQ3hGLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO1FBQzNFLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQ2hELE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUNNLGtCQUFrQixDQUFDLElBQVk7UUFDcEMsSUFBSSxPQUFPLEdBQUcsSUFBSSxPQUFPLEVBQUUsQ0FBQztRQUM1QixPQUFPLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQzFCLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUNuQyxDQUFDO0lBQ00sa0JBQWtCLENBQUMsSUFBYTtRQUNyQyxLQUFLLElBQUksUUFBUSxJQUFJLElBQUksQ0FBQyxVQUFVLEVBQUUsRUFBRSxDQUFDO1lBQ3ZDLFFBQVEsUUFBUSxDQUFDLElBQUksRUFBRSxDQUFDO2dCQUN0QixLQUFLLE9BQU87b0JBQ1YsSUFBSSxDQUFDLE1BQU0sR0FBRyxJQUFJLGdCQUFnQixDQUFDLElBQUksQ0FBQyxDQUFDO29CQUN6QyxJQUFJLENBQUMsTUFBTSxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztvQkFDL0MsTUFBTTtnQkFDUixLQUFLLGFBQWE7b0JBQ2hCLElBQUksQ0FBQyxZQUFZLEdBQUcsSUFBSSxzQkFBc0IsQ0FBQyxJQUFJLENBQUMsQ0FBQztvQkFDckQsSUFBSSxDQUFDLFlBQVksQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7b0JBQ3JELE1BQU07Z0JBQ1IsS0FBSyxXQUFXO29CQUNkLElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsQ0FBQztvQkFDakQsSUFBSSxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7b0JBQ25ELE1BQU07Z0JBQ1IsS0FBSyxZQUFZO29CQUNmLElBQUksQ0FBQyxVQUFVLEdBQUcsUUFBUSxDQUFDLEtBQUssQ0FBQztvQkFDakMsTUFBTTtnQkFDUixLQUFLLFlBQVk7b0JBQ2YsSUFBSSxDQUFDLFVBQVUsR0FBRyxRQUFRLENBQUMsS0FBSyxDQUFDO29CQUNqQyxNQUFNO2dCQUNSLEtBQUssZ0JBQWdCO29CQUNuQixJQUFJLENBQUMsY0FBYyxHQUFHLFFBQVEsQ0FBQyxLQUFLLENBQUM7b0JBQ3JDLE1BQU07Z0JBQ1IsS0FBSyxlQUFlO29CQUNsQixJQUFJLENBQUMsYUFBYSxHQUFHLFFBQVEsQ0FBQyxLQUFLLENBQUM7b0JBQ3BDLE1BQU07Z0JBQ1IsS0FBSyxTQUFTO29CQUNaLElBQUksQ0FBQyxPQUFPLEdBQUcsUUFBUSxDQUFDLEtBQUssQ0FBQztvQkFDOUIsTUFBTTtnQkFDUixLQUFLLGFBQWE7b0JBQ2hCLElBQUksQ0FBQyxXQUFXLEdBQUcsUUFBUSxDQUFDLEtBQUssR0FBRyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQztvQkFDN0QsTUFBTTtnQkFDUixLQUFLLGtCQUFrQjtvQkFDckIsSUFBSSxDQUFDLGdCQUFnQixHQUFHLFFBQVEsQ0FBQyxLQUFLLENBQUM7b0JBQ3ZDLE1BQU07Z0JBQ1IsS0FBSyxVQUFVO29CQUNiLElBQUksQ0FBQyxTQUFTLEdBQUcsUUFBUSxDQUFDLEtBQUssQ0FBQztvQkFDaEMsTUFBTTtnQkFDUixLQUFLLGdCQUFnQjtvQkFDbkIsSUFBSSxDQUFDLGVBQWUsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLG9CQUFvQixFQUFFLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztvQkFDeEUsTUFBTTtnQkFDUixLQUFLLGVBQWU7b0JBQ2xCLElBQUksQ0FBQyxjQUFjLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxnQkFBZ0IsRUFBRSxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7b0JBQ25FLE1BQU07Z0JBQ1IsS0FBSyxXQUFXLENBQUM7Z0JBQ2pCLEtBQUssbUJBQW1CO29CQUN0QixJQUFJLENBQUMsa0JBQWtCLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxvQkFBb0IsRUFBRSxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7b0JBQzNFLE1BQU07Z0JBQ1IsS0FBSyxTQUFTO29CQUNaLElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxVQUFVLEVBQUUsQ0FBQztvQkFDakMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7b0JBQ2pELE1BQU07WUFDVixDQUFDO1FBQ0gsQ0FBQztJQUNILENBQUM7SUFFTSxhQUFhLENBQUMsT0FBdUI7UUFDMUMsT0FBTyxDQUFDLFdBQVcsQ0FBQyxtQkFBbUIsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDdkUsT0FBTyxDQUFDLFdBQVcsQ0FBQyxrQkFBa0IsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDMUUsT0FBTyxDQUFDLFdBQVcsQ0FBQyxpQkFBaUIsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDbkUsT0FBTyxDQUFDLFdBQVcsQ0FBQyxhQUFhLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDM0QsT0FBTyxDQUFDLFdBQVcsQ0FBQyxpQkFBaUIsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUNuRSxPQUFPLENBQUMsV0FBVyxDQUFDLGFBQWEsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssRUFBRSxJQUFJLENBQUMsQ0FBQztRQUMzRCxPQUFPLENBQUMsV0FBVyxDQUFDLFNBQVMsRUFBRSxJQUFJLENBQUMsT0FBTyxFQUFFLElBQUksQ0FBQyxDQUFDO1FBRW5ELE9BQU8sQ0FBQyxXQUFXLENBQUMseUJBQXlCLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQ25GLE9BQU8sQ0FBQyxXQUFXLENBQUMsd0JBQXdCLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsVUFBVSxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQ3RGLE9BQU8sQ0FBQyxXQUFXLENBQUMsdUJBQXVCLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQy9FLE9BQU8sQ0FBQyxXQUFXLENBQUMsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFFL0UsT0FBTyxDQUFDLFdBQVcsQ0FBQyx1QkFBdUIsRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDL0UsT0FBTyxDQUFDLFdBQVcsQ0FBQyxzQkFBc0IsRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDbEYsT0FBTyxDQUFDLFdBQVcsQ0FBQyxxQkFBcUIsRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDM0UsT0FBTyxDQUFDLFdBQVcsQ0FBQyxpQkFBaUIsRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUMzRSxPQUFPLENBQUMsV0FBVyxDQUFDLDJCQUEyQixFQUFFLElBQUksQ0FBQyxTQUFTLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQy9GLE9BQU8sQ0FBQyxXQUFXLENBQUMsdUJBQXVCLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxXQUFXLENBQUMsS0FBSyxFQUFFLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDdkYsT0FBTyxDQUFDLFdBQVcsQ0FBQyx3QkFBd0IsRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLFlBQVksRUFBRSxJQUFJLENBQUMsQ0FBQztRQUNqRixPQUFPLENBQUMsV0FBVyxDQUFDLHNCQUFzQixFQUFFLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLEtBQUssRUFBRSxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQ3JGLE9BQU8sQ0FBQyxXQUFXLENBQUMsNEJBQTRCLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxnQkFBZ0IsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUV6RixPQUFPLENBQUMsV0FBVyxDQUFDLFlBQVksRUFBRSxJQUFJLENBQUMsVUFBVSxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQ3pELE9BQU8sQ0FBQyxXQUFXLENBQUMsWUFBWSxFQUFFLElBQUksQ0FBQyxVQUFVLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDekQsT0FBTyxDQUFDLFdBQVcsQ0FBQyxnQkFBZ0IsRUFBRSxJQUFJLENBQUMsY0FBYyxFQUFFLElBQUksQ0FBQyxDQUFDO1FBRWpFLE9BQU8sQ0FBQyxXQUFXLENBQUMsVUFBVSxFQUFFLElBQUksQ0FBQyxRQUFRLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDckQsT0FBTyxDQUFDLFdBQVcsQ0FBQyxnQkFBZ0IsRUFBRSxJQUFJLENBQUMsY0FBYyxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQ2pFLE9BQU8sQ0FBQyxXQUFXLENBQUMsZUFBZSxFQUFFLElBQUksQ0FBQyxhQUFhLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDL0QsT0FBTyxDQUFDLFdBQVcsQ0FBQyxtQkFBbUIsRUFBRSxJQUFJLENBQUMsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDdkUsT0FBTyxDQUFDLFdBQVcsQ0FBQyxlQUFlLEVBQUUsSUFBSSxDQUFDLGFBQWEsRUFBRSxJQUFJLENBQUMsQ0FBQztJQUNqRSxDQUFDO0NBQ0YiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgU3RpUGFkZGluZyBmcm9tIFwiLi4vLi4vcHJvcGVydGllcy9TdGlQYWRkaW5nXCI7XHJcbmltcG9ydCB7IEVudW0gfSBmcm9tIFwiLi4vLi4vc3lzdGVtL0VudW1cIjtcclxuaW1wb3J0IHsgU3RpRGlzcGxheUN1cnJlbmN5QXMsIFN0aVRob3VzYW5kU2VwYXJhdG9yLCBTdGlVbml0QWxpZ25tZW50IH0gZnJvbSBcIi4uLy4uL3N5c3RlbS9lbnVtc1wiO1xyXG5pbXBvcnQgeyBTdGlDaGFuZ2VzSW50ZXJjZXB0b3IsIFN0aUZvcm1hdHRlZEVsZW1lbnQsIFN0aVNldFByb3BlcnR5IH0gZnJvbSBcIi4uLy4uL3N5c3RlbS9pbnRlcmZhY2VzXCI7XHJcbmltcG9ydCBTdGlKc29uIGZyb20gXCIuLi8uLi9zeXN0ZW0vU3RpSnNvblwiO1xyXG5pbXBvcnQgeyBTdGlGb3JtIH0gZnJvbSBcIi4uL1N0aUZvcm1cIjtcclxuaW1wb3J0IHsgU3RpRGVzY3JpcHRpb25TZXR0aW5ncyB9IGZyb20gXCIuL1N0aURlc2NyaXB0aW9uU2V0dGluZ3NcIjtcclxuaW1wb3J0IHsgU3RpSW5uZXJUZXh0U2V0dGluZ3MgfSBmcm9tIFwiLi9TdGlJbm5lclRleHRTZXR0aW5nc1wiO1xyXG5pbXBvcnQgeyBTdGlMYWJlbFNldHRpbmdzIH0gZnJvbSBcIi4vU3RpTGFiZWxTZXR0aW5nc1wiO1xyXG5cclxuZXhwb3J0IGNsYXNzIFN0aUZvcm1TZXR0aW5ncyBpbXBsZW1lbnRzIFN0aUNoYW5nZXNJbnRlcmNlcHRvciwgU3RpRm9ybWF0dGVkRWxlbWVudCB7XHJcbiAgcHJpdmF0ZSBfbGFiZWw6IFN0aUxhYmVsU2V0dGluZ3MgPSBuZXcgU3RpTGFiZWxTZXR0aW5ncyh0aGlzKTtcclxuICBwcml2YXRlIF9kZXNjcmlwdGlvbjogU3RpRGVzY3JpcHRpb25TZXR0aW5ncyA9IG5ldyBTdGlEZXNjcmlwdGlvblNldHRpbmdzKHRoaXMpO1xyXG4gIHByaXZhdGUgX2lubmVyVGV4dDogU3RpSW5uZXJUZXh0U2V0dGluZ3MgPSBuZXcgU3RpSW5uZXJUZXh0U2V0dGluZ3ModGhpcyk7XHJcbiAgcHJpdmF0ZSBfZGF0ZVRpbWVGb3JtYXQ6IHN0cmluZyA9IFwibS9kL3l5IGg6TU0gdHRcIjtcclxuICBwcml2YXRlIF9kYXRlRm9tYXQ6IHN0cmluZyA9IFwiZGQubW0ueXl5eVwiO1xyXG4gIHByaXZhdGUgX3RpbWVGb3JtYXQ6IHN0cmluZyA9IFwiSEg6TU06c3NcIjtcclxuICBwcml2YXRlIF9jdXJyZW5jeSA9IFwiVVNEXCI7XHJcbiAgcHJpdmF0ZSBfY3VycmVuY3lGb3JtYXQ6IFN0aURpc3BsYXlDdXJyZW5jeUFzID0gU3RpRGlzcGxheUN1cnJlbmN5QXMuQ29kZTtcclxuICBwcml2YXRlIF91bml0QWxpZ25tZW50OiBTdGlVbml0QWxpZ25tZW50ID0gU3RpVW5pdEFsaWdubWVudC5QcmVmaXg7XHJcbiAgcHJpdmF0ZSBfdGhvdXNhbmRTZXBhcmF0b3I6IFN0aVRob3VzYW5kU2VwYXJhdG9yID0gU3RpVGhvdXNhbmRTZXBhcmF0b3IuQ29tbWE7XHJcbiAgcHJpdmF0ZSBfZGVjaW1hbERpZ2l0cyA9IDI7XHJcbiAgcHJpdmF0ZSBfcGFkZGluZzogU3RpUGFkZGluZyA9IG5ldyBTdGlQYWRkaW5nKDgsIDgsIDgsIDgsIHRoaXMpO1xyXG4gIHByaXZhdGUgX2dyaWRDb2x1bW5zOiBudW1iZXIgPSAxMjtcclxuICBwcml2YXRlIF9ncmlkVmVydGljYWxTdGVwOiBudW1iZXIgPSA1O1xyXG4gIHByaXZhdGUgX2N1bHR1cmU6IHN0cmluZztcclxuXHJcbiAgY29uc3RydWN0b3IocHVibGljIGZvcm06IFN0aUZvcm0pIHsgfVxyXG5cclxuICBwdWJsaWMgZ2V0Q3VsdHVyZSgpOiBzdHJpbmcge1xyXG4gICAgcmV0dXJuIHRoaXMuY3VsdHVyZSB8fCBuYXZpZ2F0b3IubGFuZ3VhZ2UgfHwgKG5hdmlnYXRvciBhcyBhbnkpLnVzZXJMYW5ndWFnZTtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBzZXQgY3VsdHVyZSh2YWx1ZTogc3RyaW5nKSB7XHJcbiAgICB0aGlzLl9jdWx0dXJlID0gdmFsdWU7XHJcbiAgICB0aGlzLmZvcm0/LnVwZGF0ZUN1bHR1cmVEZXBlbmRlY2llcygpO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCBjdWx0dXJlKCk6IHN0cmluZyB7XHJcbiAgICByZXR1cm4gdGhpcy5fY3VsdHVyZTtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBnZXQgcmVwb3J0SW1hZ2UoKTogc3RyaW5nIHtcclxuICAgIHJldHVybiB0aGlzLmZvcm0ucmVwb3J0SW1hZ2U7XHJcbiAgfVxyXG4gIHB1YmxpYyBzZXQgcmVwb3J0SW1hZ2UodmFsdWU6IHN0cmluZykge1xyXG4gICAgbGV0IG9sZFZhbHVlID0gdGhpcy5yZXBvcnRJbWFnZTtcclxuICAgIHRoaXMuZm9ybS5yZXBvcnRJbWFnZSA9IHZhbHVlO1xyXG4gICAgaWYgKG9sZFZhbHVlICE9IHZhbHVlKSB7XHJcbiAgICAgIHRoaXMucHJvcGVydHlDaGFuZ2VkKFwicmVwb3J0SW1hZ2VcIiwgdmFsdWUsIHt9KTtcclxuICAgIH1cclxuICB9XHJcbiAgcHVibGljIGdldCBmb3JtTmFtZSgpOiBzdHJpbmcge1xyXG4gICAgcmV0dXJuIHRoaXMuZm9ybS5mb3JtTmFtZTtcclxuICB9XHJcbiAgcHVibGljIHNldCBmb3JtTmFtZSh2YWx1ZTogc3RyaW5nKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLmZvcm0uZm9ybU5hbWU7XHJcbiAgICB0aGlzLmZvcm0uZm9ybU5hbWUgPSB2YWx1ZTtcclxuICAgIGlmIChvbGRWYWx1ZSAhPSB2YWx1ZSkge1xyXG4gICAgICB0aGlzLnByb3BlcnR5Q2hhbmdlZChcImZvcm1OYW1lXCIsIHZhbHVlLCB7fSk7XHJcbiAgICB9XHJcbiAgfVxyXG4gIHB1YmxpYyBnZXQgZ3JpZENvbHVtbnMoKTogbnVtYmVyIHtcclxuICAgIHJldHVybiB0aGlzLl9ncmlkQ29sdW1ucztcclxuICB9XHJcbiAgcHVibGljIHNldCBncmlkQ29sdW1ucyh2YWx1ZTogbnVtYmVyKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9ncmlkQ29sdW1ucztcclxuICAgIGlmICh0eXBlb2YgdmFsdWUgIT0gXCJudW1iZXJcIiA/IE51bWJlcih2YWx1ZSkgPCAxMiA6IHZhbHVlIDwgMTIpIHtcclxuICAgICAgdGhpcy5fZ3JpZENvbHVtbnMgPSAxMjtcclxuICAgIH0gZWxzZSB7XHJcbiAgICAgIHRoaXMuX2dyaWRDb2x1bW5zID0gdmFsdWU7XHJcbiAgICB9XHJcbiAgICBpZiAob2xkVmFsdWUgIT0gdmFsdWUpIHtcclxuICAgICAgdGhpcy5wcm9wZXJ0eUNoYW5nZWQoXCJncmlkQ29sdW1uc1wiLCB2YWx1ZSwge30pO1xyXG4gICAgfVxyXG4gIH1cclxuICBwdWJsaWMgZ2V0IGdyaWRWZXJ0aWNhbFN0ZXAoKTogbnVtYmVyIHtcclxuICAgIHJldHVybiB0aGlzLl9ncmlkVmVydGljYWxTdGVwO1xyXG4gIH1cclxuICBwdWJsaWMgc2V0IGdyaWRWZXJ0aWNhbFN0ZXAodmFsdWU6IG51bWJlcikge1xyXG4gICAgbGV0IG9sZFZhbHVlID0gdGhpcy5fZ3JpZFZlcnRpY2FsU3RlcDtcclxuICAgIGlmICh2YWx1ZSA8PSAxKSB7XHJcbiAgICAgIHRoaXMuX2dyaWRWZXJ0aWNhbFN0ZXAgPSAxO1xyXG4gICAgfSBlbHNlIGlmICh0aGlzLmZvcm0/LnBhZ2VzLmxlbmd0aCA+IDAgJiYgdmFsdWUgPiB0aGlzLmZvcm0ucGFnZXNbdGhpcy5mb3JtLnBhZ2VzLmxlbmd0aCAtIDFdLmNvbnRlbnRBcmVhSGVpZ2h0KSB7XHJcbiAgICAgIHRoaXMuX2dyaWRWZXJ0aWNhbFN0ZXAgPSB0aGlzLmZvcm0ucGFnZXNbdGhpcy5mb3JtLnBhZ2VzLmxlbmd0aCAtIDFdLmNvbnRlbnRBcmVhSGVpZ2h0O1xyXG4gICAgfSBlbHNlIHtcclxuICAgICAgdGhpcy5fZ3JpZFZlcnRpY2FsU3RlcCA9IHZhbHVlO1xyXG4gICAgfVxyXG4gICAgaWYgKG9sZFZhbHVlICE9IHZhbHVlKSB7XHJcbiAgICAgIHRoaXMucHJvcGVydHlDaGFuZ2VkKFwiZ3JpZFZlcnRpY2FsU3RlcFwiLCB2YWx1ZSwge30pO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgZ2V0IHBhZGRpbmcoKTogU3RpUGFkZGluZyB7XHJcbiAgICByZXR1cm4gdGhpcy5fcGFkZGluZztcclxuICB9XHJcblxyXG4gIHNldCBwYWRkaW5nKHZhbHVlOiBTdGlQYWRkaW5nKSB7XHJcbiAgICBsZXQgb2xkT2JqZWN0ID0gdGhpcy5fcGFkZGluZy5jbG9uZSgpO1xyXG4gICAgdGhpcy5fcGFkZGluZyA9IHZhbHVlO1xyXG4gICAgdGhpcy5fcGFkZGluZy5jaGFuZ2VzSW50ZXJjZXB0b3IgPSB0aGlzO1xyXG4gICAgdGhpcy5wcm9wZXJ0eUNoYW5nZWQoXCJwYWRkaW5nXCIsIHZhbHVlLCBvbGRPYmplY3QpO1xyXG4gIH1cclxuXHJcbiAgZ2V0IGxhYmVsKCk6IFN0aUxhYmVsU2V0dGluZ3Mge1xyXG4gICAgcmV0dXJuIHRoaXMuX2xhYmVsO1xyXG4gIH1cclxuXHJcbiAgc2V0IGxhYmVsKHZhbHVlOiBTdGlMYWJlbFNldHRpbmdzKSB7XHJcbiAgICB0aGlzLl9sYWJlbCA9IHZhbHVlO1xyXG4gIH1cclxuXHJcbiAgZ2V0IGRlc2NyaXB0aW9uKCk6IFN0aURlc2NyaXB0aW9uU2V0dGluZ3Mge1xyXG4gICAgcmV0dXJuIHRoaXMuX2Rlc2NyaXB0aW9uO1xyXG4gIH1cclxuXHJcbiAgc2V0IGRlc2NyaXB0aW9uKHZhbHVlOiBTdGlEZXNjcmlwdGlvblNldHRpbmdzKSB7XHJcbiAgICB0aGlzLl9kZXNjcmlwdGlvbiA9IHZhbHVlO1xyXG4gIH1cclxuXHJcbiAgZ2V0IGlubmVyVGV4dCgpOiBTdGlJbm5lclRleHRTZXR0aW5ncyB7XHJcbiAgICByZXR1cm4gdGhpcy5faW5uZXJUZXh0O1xyXG4gIH1cclxuXHJcbiAgc2V0IGlubmVyVGV4dCh2YWx1ZTogU3RpSW5uZXJUZXh0U2V0dGluZ3MpIHtcclxuICAgIHRoaXMuX2lubmVyVGV4dCA9IHZhbHVlO1xyXG4gIH1cclxuXHJcbiAgZ2V0IGRhdGVUaW1lRm9ybWF0KCk6IHN0cmluZyB7XHJcbiAgICByZXR1cm4gdGhpcy5fZGF0ZVRpbWVGb3JtYXQ7XHJcbiAgfVxyXG5cclxuICBzZXQgZGF0ZVRpbWVGb3JtYXQodmFsdWU6IHN0cmluZykge1xyXG4gICAgbGV0IG9sZFZhbHVlID0gdGhpcy5fZGF0ZVRpbWVGb3JtYXQ7XHJcbiAgICB0aGlzLl9kYXRlVGltZUZvcm1hdCA9IHZhbHVlO1xyXG4gICAgaWYgKG9sZFZhbHVlICE9IHZhbHVlKSB7XHJcbiAgICAgIHRoaXMucHJvcGVydHlDaGFuZ2VkKFwiZGF0ZVRpbWVGb3JtYXRcIiwgdmFsdWUsIG9sZFZhbHVlKTtcclxuICAgIH1cclxuICB9XHJcbiAgZ2V0IGRhdGVGb3JtYXQoKTogc3RyaW5nIHtcclxuICAgIHJldHVybiB0aGlzLl9kYXRlRm9tYXQ7XHJcbiAgfVxyXG4gIHNldCBkYXRlRm9ybWF0KHZhbHVlOiBzdHJpbmcpIHtcclxuICAgIGxldCBvbGRWYWx1ZSA9IHRoaXMuX2RhdGVGb21hdDtcclxuICAgIHRoaXMuX2RhdGVGb21hdCA9IHZhbHVlO1xyXG4gICAgaWYgKG9sZFZhbHVlICE9IHZhbHVlKSB7XHJcbiAgICAgIHRoaXMucHJvcGVydHlDaGFuZ2VkKFwiZGF0ZUZvcm1hdFwiLCB2YWx1ZSwgb2xkVmFsdWUpO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgZ2V0IHRpbWVGb3JtYXQoKTogc3RyaW5nIHtcclxuICAgIHJldHVybiB0aGlzLl90aW1lRm9ybWF0O1xyXG4gIH1cclxuXHJcbiAgc2V0IHRpbWVGb3JtYXQodmFsdWU6IHN0cmluZykge1xyXG4gICAgbGV0IG9sZFZhbHVlID0gdGhpcy5fdGltZUZvcm1hdDtcclxuICAgIHRoaXMuX3RpbWVGb3JtYXQgPSB2YWx1ZTtcclxuICAgIGlmIChvbGRWYWx1ZSAhPSB2YWx1ZSkge1xyXG4gICAgICB0aGlzLnByb3BlcnR5Q2hhbmdlZChcInRpbWVGb3JtYXRcIiwgdmFsdWUsIG9sZFZhbHVlKTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIGdldCBjdXJyZW5jeSgpOiBzdHJpbmcge1xyXG4gICAgcmV0dXJuIHRoaXMuX2N1cnJlbmN5O1xyXG4gIH1cclxuXHJcbiAgc2V0IGN1cnJlbmN5KHZhbHVlOiBzdHJpbmcpIHtcclxuICAgIGxldCBvbGRWYWx1ZSA9IHRoaXMuX2N1cnJlbmN5O1xyXG4gICAgdGhpcy5fY3VycmVuY3kgPSB2YWx1ZTtcclxuICAgIGlmIChvbGRWYWx1ZSAhPSB2YWx1ZSkge1xyXG4gICAgICB0aGlzLnByb3BlcnR5Q2hhbmdlZChcImN1cnJlbmN5XCIsIHZhbHVlLCBvbGRWYWx1ZSk7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBnZXQgY3VycmVuY3lGb3JtYXQoKTogU3RpRGlzcGxheUN1cnJlbmN5QXMge1xyXG4gICAgcmV0dXJuIHRoaXMuX2N1cnJlbmN5Rm9ybWF0O1xyXG4gIH1cclxuXHJcbiAgc2V0IGN1cnJlbmN5Rm9ybWF0KHZhbHVlOiBTdGlEaXNwbGF5Q3VycmVuY3lBcykge1xyXG4gICAgbGV0IG9sZFZhbHVlID0gdGhpcy5fY3VycmVuY3lGb3JtYXQ7XHJcbiAgICB0aGlzLl9jdXJyZW5jeUZvcm1hdCA9IHZhbHVlO1xyXG4gICAgaWYgKG9sZFZhbHVlICE9IHZhbHVlKSB7XHJcbiAgICAgIHRoaXMucHJvcGVydHlDaGFuZ2VkKFwiY3VycmVuY3lGb3JtYXRcIiwgdmFsdWUsIG9sZFZhbHVlKTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIGdldCB1bml0QWxpZ25tZW50KCk6IFN0aVVuaXRBbGlnbm1lbnQge1xyXG4gICAgcmV0dXJuIHRoaXMuX3VuaXRBbGlnbm1lbnQ7XHJcbiAgfVxyXG5cclxuICBzZXQgdW5pdEFsaWdubWVudCh2YWx1ZTogU3RpVW5pdEFsaWdubWVudCkge1xyXG4gICAgbGV0IG9sZFZhbHVlID0gdGhpcy5fdW5pdEFsaWdubWVudDtcclxuICAgIHRoaXMuX3VuaXRBbGlnbm1lbnQgPSB2YWx1ZTtcclxuICAgIGlmIChvbGRWYWx1ZSAhPSB2YWx1ZSkge1xyXG4gICAgICB0aGlzLnByb3BlcnR5Q2hhbmdlZChcInVuaXRBbGlnbm1lbnRcIiwgdmFsdWUsIG9sZFZhbHVlKTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIGdldCB0aG91c2FuZFNlcGFyYXRvcigpOiBTdGlUaG91c2FuZFNlcGFyYXRvciB7XHJcbiAgICByZXR1cm4gdGhpcy5fdGhvdXNhbmRTZXBhcmF0b3I7XHJcbiAgfVxyXG5cclxuICBzZXQgdGhvdXNhbmRTZXBhcmF0b3IodmFsdWU6IFN0aVRob3VzYW5kU2VwYXJhdG9yKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl90aG91c2FuZFNlcGFyYXRvcjtcclxuICAgIHRoaXMuX3Rob3VzYW5kU2VwYXJhdG9yID0gdmFsdWU7XHJcbiAgICBpZiAob2xkVmFsdWUgIT0gdmFsdWUpIHtcclxuICAgICAgdGhpcy5wcm9wZXJ0eUNoYW5nZWQoXCJ0aG91c2FuZFNlcGFyYXRvclwiLCB2YWx1ZSwgb2xkVmFsdWUpO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgZ2V0IGRlY2ltYWxEaWdpdHMoKTogbnVtYmVyIHtcclxuICAgIHJldHVybiB0aGlzLl9kZWNpbWFsRGlnaXRzO1xyXG4gIH1cclxuXHJcbiAgc2V0IGRlY2ltYWxEaWdpdHModmFsdWU6IG51bWJlcikge1xyXG4gICAgbGV0IG9sZFZhbHVlID0gdGhpcy5fZGVjaW1hbERpZ2l0cztcclxuICAgIGlmICh2YWx1ZSA8PSAwKSB7XHJcbiAgICAgIHRoaXMuX2RlY2ltYWxEaWdpdHMgPSAwO1xyXG4gICAgfSBlbHNlIHtcclxuICAgICAgdGhpcy5fZGVjaW1hbERpZ2l0cyA9IHZhbHVlO1xyXG4gICAgfVxyXG4gICAgaWYgKG9sZFZhbHVlICE9IHZhbHVlKSB7XHJcbiAgICAgIHRoaXMucHJvcGVydHlDaGFuZ2VkKFwiZGVjaW1hbERpZ2l0c1wiLCB2YWx1ZSwgb2xkVmFsdWUpO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHJvcGVydHlDaGFuZ2VkKHByb3BOYW1lOiBzdHJpbmcsIHZhbHVlOiBhbnksIG9sZE9iamVjdDogYW55KSB7XHJcbiAgICB0aGlzLmZvcm0ucGFnZXMuZm9yRWFjaCgocCkgPT5cclxuICAgICAgcC5hbGxFbGVtZW50cy5mb3JFYWNoKChlbCkgPT4ge1xyXG4gICAgICAgIGVsLnNldFByb3BlcnR5KHByb3BOYW1lLCB2YWx1ZVtcImNsb25lXCJdID8gdmFsdWUuY2xvbmUoKSA6IHZhbHVlLCBvbGRPYmplY3QpO1xyXG4gICAgICB9KVxyXG4gICAgKTtcclxuXHJcbiAgICBpZiAocHJvcE5hbWUudG9Mb3dlckNhc2UoKS5pbmRleE9mKFwiY29sb3JcIikgPT0gLTEpIHtcclxuICAgICAgdGhpcy5mb3JtLmZvcm1FdmVudHMubmV4dCh7IG5hbWU6IFwiVXBkYXRlQWxsU2l6ZXNcIiB9KTtcclxuICAgIH1cclxuXHJcbiAgICBpZiAocHJvcE5hbWUgPT0gXCJ0aG91c2FuZFNlcGFyYXRvclwiIHx8IHByb3BOYW1lID09IFwiZGVjaW1hbERpZ2l0c1wiKSB7XHJcbiAgICAgIHRoaXMuZm9ybS5mb3JtRXZlbnRzLm5leHQoeyBuYW1lOiBcIlVwZGF0ZUZvcm1cIiB9KTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIHB1YmxpYyBzYXZlVG9Kc29uT2JqZWN0KG9wdGlvbnM6IGFueSk6IFN0aUpzb24ge1xyXG4gICAgbGV0IGpzb24gPSBuZXcgU3RpSnNvbigpO1xyXG4gICAganNvbi5hZGRQcm9wZXJ0eUpPYmplY3QoXCJMYWJlbFwiLCB0aGlzLmxhYmVsLnNhdmVUb0pzb25PYmplY3Qob3B0aW9ucykpO1xyXG4gICAganNvbi5hZGRQcm9wZXJ0eUpPYmplY3QoXCJEZXNjcmlwdGlvblwiLCB0aGlzLmRlc2NyaXB0aW9uLnNhdmVUb0pzb25PYmplY3Qob3B0aW9ucykpO1xyXG4gICAganNvbi5hZGRQcm9wZXJ0eUpPYmplY3QoXCJJbm5lclRleHRcIiwgdGhpcy5pbm5lclRleHQuc2F2ZVRvSnNvbk9iamVjdChvcHRpb25zKSk7XHJcbiAgICBqc29uLmFkZFByb3BlcnR5U3RyaW5nKFwiVGltZUZvcm1hdFwiLCB0aGlzLnRpbWVGb3JtYXQpO1xyXG4gICAganNvbi5hZGRQcm9wZXJ0eVN0cmluZyhcIkRhdGVGb3JtYXRcIiwgdGhpcy5kYXRlRm9ybWF0KTtcclxuICAgIGpzb24uYWRkUHJvcGVydHlTdHJpbmcoXCJEYXRlVGltZUZvcm1hdFwiLCB0aGlzLmRhdGVUaW1lRm9ybWF0KTtcclxuICAgIGpzb24uYWRkUHJvcGVydHlOdW1iZXIoXCJEZWNpbWFsRGlnaXRzXCIsIHRoaXMuZGVjaW1hbERpZ2l0cyk7XHJcbiAgICBqc29uLmFkZFByb3BlcnR5TnVtYmVyKFwiR3JpZENvbHVtbnNcIiwgdGhpcy5ncmlkQ29sdW1ucyk7XHJcbiAgICBqc29uLmFkZFByb3BlcnR5TnVtYmVyKFwiR3JpZFZlcnRpY2FsU3RlcFwiLCB0aGlzLmdyaWRWZXJ0aWNhbFN0ZXApO1xyXG4gICAganNvbi5hZGRQcm9wZXJ0eVN0cmluZyhcIkN1cnJlbmN5XCIsIHRoaXMuY3VycmVuY3kpO1xyXG4gICAganNvbi5hZGRQcm9wZXJ0eUVudW0oXCJDdXJyZW5jeUZvcm1hdFwiLCBTdGlEaXNwbGF5Q3VycmVuY3lBcywgdGhpcy5jdXJyZW5jeUZvcm1hdCk7XHJcbiAgICBqc29uLmFkZFByb3BlcnR5RW51bShcIlVuaXRBbGlnbm1lbnRcIiwgU3RpVW5pdEFsaWdubWVudCwgdGhpcy51bml0QWxpZ25tZW50KTtcclxuICAgIGpzb24uYWRkUHJvcGVydHlFbnVtKFwiVGhvdXNhbmRTZXBhcmF0b3JcIiwgU3RpVGhvdXNhbmRTZXBhcmF0b3IsIHRoaXMudGhvdXNhbmRTZXBhcmF0b3IpO1xyXG4gICAganNvbi5hZGRQcm9wZXJ0eUpPYmplY3QoXCJQYWRkaW5nXCIsIHRoaXMucGFkZGluZy5zYXZlVG9Kc29uT2JqZWN0KG9wdGlvbnMpKTtcclxuICAgIGpzb24uYWRkUHJvcGVydHlTdHJpbmcoXCJDdWx0dXJlXCIsIHRoaXMuY3VsdHVyZSk7XHJcbiAgICByZXR1cm4ganNvbjtcclxuICB9XHJcbiAgcHVibGljIGxvYWRGb3JtSnNvblN0cmluZyh0ZXh0OiBzdHJpbmcpIHtcclxuICAgIGxldCBqT2JqZWN0ID0gbmV3IFN0aUpzb24oKTtcclxuICAgIGpPYmplY3QuZGVzZXJpYWxpemUodGV4dCk7XHJcbiAgICB0aGlzLmxvYWRGcm9tSnNvbk9iamVjdChqT2JqZWN0KTtcclxuICB9XHJcbiAgcHVibGljIGxvYWRGcm9tSnNvbk9iamVjdChqc29uOiBTdGlKc29uKSB7XHJcbiAgICBmb3IgKGxldCBwcm9wZXJ0eSBvZiBqc29uLnByb3BlcnRpZXMoKSkge1xyXG4gICAgICBzd2l0Y2ggKHByb3BlcnR5Lm5hbWUpIHtcclxuICAgICAgICBjYXNlIFwiTGFiZWxcIjpcclxuICAgICAgICAgIHRoaXMuX2xhYmVsID0gbmV3IFN0aUxhYmVsU2V0dGluZ3ModGhpcyk7XHJcbiAgICAgICAgICB0aGlzLl9sYWJlbC5sb2FkRnJvbUpzb25PYmplY3QocHJvcGVydHkudmFsdWUpO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIkRlc2NyaXB0aW9uXCI6XHJcbiAgICAgICAgICB0aGlzLl9kZXNjcmlwdGlvbiA9IG5ldyBTdGlEZXNjcmlwdGlvblNldHRpbmdzKHRoaXMpO1xyXG4gICAgICAgICAgdGhpcy5fZGVzY3JpcHRpb24ubG9hZEZyb21Kc29uT2JqZWN0KHByb3BlcnR5LnZhbHVlKTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJJbm5lclRleHRcIjpcclxuICAgICAgICAgIHRoaXMuX2lubmVyVGV4dCA9IG5ldyBTdGlJbm5lclRleHRTZXR0aW5ncyh0aGlzKTtcclxuICAgICAgICAgIHRoaXMuX2lubmVyVGV4dC5sb2FkRnJvbUpzb25PYmplY3QocHJvcGVydHkudmFsdWUpO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIlRpbWVGb3JtYXRcIjpcclxuICAgICAgICAgIHRoaXMudGltZUZvcm1hdCA9IHByb3BlcnR5LnZhbHVlO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIkRhdGVGb3JtYXRcIjpcclxuICAgICAgICAgIHRoaXMuZGF0ZUZvcm1hdCA9IHByb3BlcnR5LnZhbHVlO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIkRhdGVUaW1lRm9ybWF0XCI6XHJcbiAgICAgICAgICB0aGlzLmRhdGVUaW1lRm9ybWF0ID0gcHJvcGVydHkudmFsdWU7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiRGVjaW1hbERpZ2l0c1wiOlxyXG4gICAgICAgICAgdGhpcy5kZWNpbWFsRGlnaXRzID0gcHJvcGVydHkudmFsdWU7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiQ3VsdHVyZVwiOlxyXG4gICAgICAgICAgdGhpcy5jdWx0dXJlID0gcHJvcGVydHkudmFsdWU7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiR3JpZENvbHVtbnNcIjpcclxuICAgICAgICAgIHRoaXMuZ3JpZENvbHVtbnMgPSBwcm9wZXJ0eS52YWx1ZSA8IDEyID8gMTIgOiBwcm9wZXJ0eS52YWx1ZTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJHcmlkVmVydGljYWxTdGVwXCI6XHJcbiAgICAgICAgICB0aGlzLmdyaWRWZXJ0aWNhbFN0ZXAgPSBwcm9wZXJ0eS52YWx1ZTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJDdXJyZW5jeVwiOlxyXG4gICAgICAgICAgdGhpcy5fY3VycmVuY3kgPSBwcm9wZXJ0eS52YWx1ZTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJDdXJyZW5jeUZvcm1hdFwiOlxyXG4gICAgICAgICAgdGhpcy5fY3VycmVuY3lGb3JtYXQgPSBFbnVtLnBhcnNlKFN0aURpc3BsYXlDdXJyZW5jeUFzLCBwcm9wZXJ0eS52YWx1ZSk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiVW5pdEFsaWdubWVudFwiOlxyXG4gICAgICAgICAgdGhpcy5fdW5pdEFsaWdubWVudCA9IEVudW0ucGFyc2UoU3RpVW5pdEFsaWdubWVudCwgcHJvcGVydHkudmFsdWUpO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIlNlcGFyYXRvclwiOlxyXG4gICAgICAgIGNhc2UgXCJUaG91c2FuZFNlcGFyYXRvclwiOlxyXG4gICAgICAgICAgdGhpcy5fdGhvdXNhbmRTZXBhcmF0b3IgPSBFbnVtLnBhcnNlKFN0aVRob3VzYW5kU2VwYXJhdG9yLCBwcm9wZXJ0eS52YWx1ZSk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiUGFkZGluZ1wiOlxyXG4gICAgICAgICAgdGhpcy5fcGFkZGluZyA9IG5ldyBTdGlQYWRkaW5nKCk7XHJcbiAgICAgICAgICB0aGlzLl9wYWRkaW5nLmxvYWRGcm9tSnNvbk9iamVjdChwcm9wZXJ0eS52YWx1ZSk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgfVxyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHVibGljIGFwcGx5U2V0dGluZ3MoZWxlbWVudDogU3RpU2V0UHJvcGVydHkpIHtcclxuICAgIGVsZW1lbnQuc2V0UHJvcGVydHkoXCJsYWJlbC5mb250LmZhbWlseVwiLCB0aGlzLmxhYmVsLmZvbnQuZmFtaWx5LCBudWxsKTtcclxuICAgIGVsZW1lbnQuc2V0UHJvcGVydHkoXCJsYWJlbC5mb250LnN0eWxlXCIsIHRoaXMubGFiZWwuZm9udC5jbG9uZVN0eWxlLCBudWxsKTtcclxuICAgIGVsZW1lbnQuc2V0UHJvcGVydHkoXCJsYWJlbC5mb250LnNpemVcIiwgdGhpcy5sYWJlbC5mb250LnNpemUsIG51bGwpO1xyXG4gICAgZWxlbWVudC5zZXRQcm9wZXJ0eShcImxhYmVsLmNvbG9yXCIsIHRoaXMubGFiZWwuY29sb3IsIG51bGwpO1xyXG4gICAgZWxlbWVudC5zZXRQcm9wZXJ0eShcImxhYmVsLmFsaWdubWVudFwiLCB0aGlzLmxhYmVsLmFsaWdubWVudCwgbnVsbCk7XHJcbiAgICBlbGVtZW50LnNldFByb3BlcnR5KFwibGFiZWwud2lkdGhcIiwgdGhpcy5sYWJlbC53aWR0aCwgbnVsbCk7XHJcbiAgICBlbGVtZW50LnNldFByb3BlcnR5KFwicGFkZGluZ1wiLCB0aGlzLnBhZGRpbmcsIG51bGwpO1xyXG5cclxuICAgIGVsZW1lbnQuc2V0UHJvcGVydHkoXCJkZXNjcmlwdGlvbi5mb250LmZhbWlseVwiLCB0aGlzLmRlc2NyaXB0aW9uLmZvbnQuZmFtaWx5LCBudWxsKTtcclxuICAgIGVsZW1lbnQuc2V0UHJvcGVydHkoXCJkZXNjcmlwdGlvbi5mb250LnN0eWxlXCIsIHRoaXMuZGVzY3JpcHRpb24uZm9udC5jbG9uZVN0eWxlLCBudWxsKTtcclxuICAgIGVsZW1lbnQuc2V0UHJvcGVydHkoXCJkZXNjcmlwdGlvbi5mb250LnNpemVcIiwgdGhpcy5kZXNjcmlwdGlvbi5mb250LnNpemUsIG51bGwpO1xyXG4gICAgZWxlbWVudC5zZXRQcm9wZXJ0eShcImRlc2NyaXB0aW9uLmNvbG9yXCIsIHRoaXMuZGVzY3JpcHRpb24uY29sb3IuY2xvbmUoKSwgbnVsbCk7XHJcblxyXG4gICAgZWxlbWVudC5zZXRQcm9wZXJ0eShcImlubmVyVGV4dC5mb250LmZhbWlseVwiLCB0aGlzLmlubmVyVGV4dC5mb250LmZhbWlseSwgbnVsbCk7XHJcbiAgICBlbGVtZW50LnNldFByb3BlcnR5KFwiaW5uZXJUZXh0LmZvbnQuc3R5bGVcIiwgdGhpcy5pbm5lclRleHQuZm9udC5jbG9uZVN0eWxlLCBudWxsKTtcclxuICAgIGVsZW1lbnQuc2V0UHJvcGVydHkoXCJpbm5lclRleHQuZm9udC5zaXplXCIsIHRoaXMuaW5uZXJUZXh0LmZvbnQuc2l6ZSwgbnVsbCk7XHJcbiAgICBlbGVtZW50LnNldFByb3BlcnR5KFwiaW5uZXJUZXh0LmNvbG9yXCIsIHRoaXMuaW5uZXJUZXh0LmNvbG9yLmNsb25lKCksIG51bGwpO1xyXG4gICAgZWxlbWVudC5zZXRQcm9wZXJ0eShcImlubmVyVGV4dC5iYWNrZ3JvdW5kQ29sb3JcIiwgdGhpcy5pbm5lclRleHQuYmFja2dyb3VuZENvbG9yLmNsb25lKCksIG51bGwpO1xyXG4gICAgZWxlbWVudC5zZXRQcm9wZXJ0eShcImlubmVyVGV4dC5ib3JkZXJDb2xvclwiLCB0aGlzLmlubmVyVGV4dC5ib3JkZXJDb2xvci5jbG9uZSgpLCBudWxsKTtcclxuICAgIGVsZW1lbnQuc2V0UHJvcGVydHkoXCJpbm5lclRleHQuYm9yZGVyV2VpZ2h0XCIsIHRoaXMuaW5uZXJUZXh0LmJvcmRlcldlaWdodCwgbnVsbCk7XHJcbiAgICBlbGVtZW50LnNldFByb3BlcnR5KFwiaW5uZXJUZXh0LmNoZWNrQ29sb3JcIiwgdGhpcy5pbm5lclRleHQuY2hlY2tDb2xvci5jbG9uZSgpLCBudWxsKTtcclxuICAgIGVsZW1lbnQuc2V0UHJvcGVydHkoXCJpbm5lclRleHQuY29udGVudEFsaWdubWVudFwiLCB0aGlzLmlubmVyVGV4dC5jb250ZW50QWxpZ25tZW50LCBudWxsKTtcclxuXHJcbiAgICBlbGVtZW50LnNldFByb3BlcnR5KFwidGltZUZvcm1hdFwiLCB0aGlzLnRpbWVGb3JtYXQsIG51bGwpO1xyXG4gICAgZWxlbWVudC5zZXRQcm9wZXJ0eShcImRhdGVGb3JtYXRcIiwgdGhpcy5kYXRlRm9ybWF0LCBudWxsKTtcclxuICAgIGVsZW1lbnQuc2V0UHJvcGVydHkoXCJkYXRlVGltZUZvcm1hdFwiLCB0aGlzLmRhdGVUaW1lRm9ybWF0LCBudWxsKTtcclxuXHJcbiAgICBlbGVtZW50LnNldFByb3BlcnR5KFwiY3VycmVuY3lcIiwgdGhpcy5jdXJyZW5jeSwgbnVsbCk7XHJcbiAgICBlbGVtZW50LnNldFByb3BlcnR5KFwiY3VycmVuY3lGb3JtYXRcIiwgdGhpcy5jdXJyZW5jeUZvcm1hdCwgbnVsbCk7XHJcbiAgICBlbGVtZW50LnNldFByb3BlcnR5KFwidW5pdEFsaWdubWVudFwiLCB0aGlzLnVuaXRBbGlnbm1lbnQsIG51bGwpO1xyXG4gICAgZWxlbWVudC5zZXRQcm9wZXJ0eShcInRob3VzYW5kU2VwYXJhdG9yXCIsIHRoaXMudGhvdXNhbmRTZXBhcmF0b3IsIG51bGwpO1xyXG4gICAgZWxlbWVudC5zZXRQcm9wZXJ0eShcImRlY2ltYWxEaWdpdHNcIiwgdGhpcy5kZWNpbWFsRGlnaXRzLCBudWxsKTtcclxuICB9XHJcbn1cclxuIl19