import { StiBorder } from "../properties/StiBorder";
import { StiPen } from "../properties/StiPen";
import StiRectangleGeometry from "../properties/StiRectangleGeometry";
import Color from "../system/Color";
import { Enum } from "../system/Enum";
import { StiTextHorAlignment, StiHorizontalAlignment } from "../system/enums";
import { StiFormElement } from "./base/StiFormElement";
export class StiTextElement extends StiFormElement {
    constructor() {
        super();
        this.type = "TextElement";
        this.htmlTextString = "";
        this.textColor = Color.black();
        this.textHorizontalAlignment = StiTextHorAlignment.Left;
        this.border = new StiBorder(StiPen.dimGraySolid(), false, false, false, false);
        this.showBorderEditor = true;
        this.geometry = new StiRectangleGeometry(100, 35);
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyString("HtmlTextString", this.htmlTextString);
        jObject.addPropertyEnum("TextHorizontalAlignment", StiTextHorAlignment, this.textHorizontalAlignment);
        jObject.addPropertyJObject("Border", this.border.saveToJsonObject(options));
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "HtmlTextString":
                    this.htmlTextString = property.value;
                    break;
                case "TextHorizontalAlignment":
                    this.textHorizontalAlignment = Enum.parse(StiTextHorAlignment, property.value);
                    break;
                case "Border":
                    this.border = new StiBorder();
                    this.border.loadFromJsonObject(property.value);
                    break;
            }
        }
        this.isAdded = true;
    }
    htmlStyle() {
        return `color:${this.textColor.toHtmlColor()};text-align:${Enum.getName(StiHorizontalAlignment, this.textHorizontalAlignment)}`;
    }
}
//# sourceMappingURL=data:application/json;base64,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