import StiPadding from "../properties/StiPadding";
import StiRectangleGeometry from "../properties/StiRectangleGeometry";
import { StiLocalizationService } from "../services/sti-localization.service";
import Color from "../system/Color";
import { Enum } from "../system/Enum";
import { StiButtonType, StiButtonSendType } from "../system/enums";
import { Font } from "../system/Font";
import { StiFormElement } from "./base/StiFormElement";
import { StiBackgroundedTextItem } from "./text/StiBackgroundedTextItem";
export class StiButtonElement extends StiFormElement {
    constructor() {
        super();
        this.type = "ButtonElement";
        this.tooltip = "";
        this.submissionMessage = "Thank you! Your submission has been sent.";
        this.text = new StiBackgroundedTextItem(StiLocalizationService.get("Buttons", "Submit"), new Font("Segoe UI", 14), Color.black(), Color.lightGray());
        this.buttonType = StiButtonType.SendForm;
        this.formSendURL = "";
        this.buttonSendType = StiButtonSendType.XFDF;
        this.geometry = new StiRectangleGeometry(100, 40);
        this.padding = new StiPadding(4, 0, 4, 0, this);
    }
    canUpdateProperty(propName) {
        return !(propName.indexOf("padding") >= 0);
    }
    getUsedFonts(usedFonts) {
        super.getUsedFonts(usedFonts);
        usedFonts.add(this.text.font.family, this.arrayOfStylesToString(this.text.font.style), this.text.font.size);
    }
    getDefaultEditableContent() {
        return this.text;
    }
    setProperty(propName, value, oldObject) {
        super.setProperty(propName, value, oldObject);
        if (propName.startsWith("label.font") || propName == "label.color") {
            this.text.setProperty(propName.replace("label.", ""), value.clone ? value.clone() : value, oldObject);
        }
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyString("Tooltip", this.tooltip);
        jObject.addPropertyJObject("Text", this.text.saveToJsonObject(options));
        jObject.addPropertyEnum("ButtonType", StiButtonType, this.buttonType);
        jObject.addPropertyString("FormSendURL", this.formSendURL);
        jObject.addPropertyEnum("ButtonSendType", StiButtonSendType, this.buttonSendType);
        jObject.addPropertyString("SubmissionMessage", this.submissionMessage);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Text":
                    this.text = new StiBackgroundedTextItem();
                    this.text.loadFromJsonObject(property.value);
                    break;
                case "Tooltip":
                    this.tooltip = property.value;
                    break;
                case "ButtonType":
                    this.buttonType = Enum.parse(StiButtonType, property.value);
                    break;
                case "FormSendURL":
                    this.formSendURL = property.value;
                    break;
                case "ButtonSendType":
                    this.buttonSendType = Enum.parse(StiButtonSendType, property.value);
                    break;
                case "SubmissionMessage":
                    this.submissionMessage = property.value;
                    break;
            }
        }
    }
    htmlStyle() {
        return `${this.text.htmlStyle()};
    )}`;
    }
}
//# sourceMappingURL=data:application/json;base64,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