import { Component, ViewChild } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-export.service";
import * as i3 from "../../services/sti-toolbar-resizer.service";
import * as i4 from "@angular/common";
import * as i5 from "../page.component/page.component";
export class WorkspaceComponent {
    constructor(model, exportService, toolbarResizerService) {
        this.model = model;
        this.exportService = exportService;
        this.toolbarResizerService = toolbarResizerService;
    }
    get padding() {
        if (this.toolbarResizerService.isMinimizeMode) {
            return 20 + "px";
        }
        else
            return 0 + "px";
    }
    get pages() {
        return this.model.form?.pages;
    }
    onClick(event) {
        let elements = document.elementsFromPoint(event.clientX, event.clientY);
        if (!elements.find((elem) => elem?.classList.contains("page")) &&
            !elements.find((elem) => elem?.classList.contains("page-navigation"))) {
            this.model.selectedComponent = null;
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: WorkspaceComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiExportService }, { token: i3.StiToolbarResizerService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: WorkspaceComponent, selector: "sti-workspace", viewQueries: [{ propertyName: "workspaceEl", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div class="main-container" [style.paddingLeft]="this.padding" (click)="onClick($event)">
      <div #element class="workspace" [style.transform]="model.getScale()" [style.transform-origin]="'left top'">
        <app-page [page]="page" *ngFor="let page of pages" (click)="onClick($event)"></app-page>
        <!-- <sti-toolbar-resizer [style.visibility]="this.model.previewMode ? 'hidden' : ''"></sti-toolbar-resizer> -->
      </div>
    </div>

    <style>
      .workspace {
        width: fit-content;
        height: 100%;
        position: relative;
      }
      .center {
        text-align: center;
      }
      .main-container {
        height: 100%;
        width: 100%;
        padding-top: 10px;
        padding-right: 20px;
      }
    </style>
  `, isInline: true, styles: ["\n      .workspace {\n        width: fit-content;\n        height: 100%;\n        position: relative;\n      }\n      .center {\n        text-align: center;\n      }\n      .main-container {\n        height: 100%;\n        width: 100%;\n        padding-top: 10px;\n        padding-right: 20px;\n      }\n    "], dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "component", type: i5.PageComponent, selector: "app-page", inputs: ["page"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: WorkspaceComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-workspace",
                    template: `
    <div class="main-container" [style.paddingLeft]="this.padding" (click)="onClick($event)">
      <div #element class="workspace" [style.transform]="model.getScale()" [style.transform-origin]="'left top'">
        <app-page [page]="page" *ngFor="let page of pages" (click)="onClick($event)"></app-page>
        <!-- <sti-toolbar-resizer [style.visibility]="this.model.previewMode ? 'hidden' : ''"></sti-toolbar-resizer> -->
      </div>
    </div>

    <style>
      .workspace {
        width: fit-content;
        height: 100%;
        position: relative;
      }
      .center {
        text-align: center;
      }
      .main-container {
        height: 100%;
        width: 100%;
        padding-top: 10px;
        padding-right: 20px;
      }
    </style>
  `,
                }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiExportService }, { type: i3.StiToolbarResizerService }], propDecorators: { workspaceEl: [{
                type: ViewChild,
                args: ["element"]
            }] } });
//# sourceMappingURL=data:application/json;base64,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