import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "@angular/platform-browser";
import * as i3 from "../../services/http-client.service";
import * as i4 from "@angular/common";
export class StiPdfPreviewComponent {
    constructor(model, sanitizer, httpService) {
        this.model = model;
        this.sanitizer = sanitizer;
        this.httpService = httpService;
    }
    ngOnDestroy() {
        if (this.model.selectedComponent) {
            this.model.selectedComponent.element.needToSelectComponent = true;
        }
    }
    ngAfterViewInit() {
        setTimeout(() => {
            let currentForm = this.model.currentFormState;
            let data = {
                action: "GeneratePDF",
                form: currentForm,
                settings: {
                    usePdfA: false,
                    readOnly: false,
                },
            };
            this.httpService.post(this.model.requestUrl, data, "byteArray", { showProgress: true }).subscribe((data) => {
                let pdfBytes = new Int8Array(data);
                this.model.showProgress = false;
                let blob = new Blob([pdfBytes], { type: "application/pdf" });
                let toolbar = this.model.isWebView ? "#toolbar=0" : "";
                this.src = this.sanitizer.bypassSecurityTrustResourceUrl(URL.createObjectURL(blob) + toolbar);
            });
        }, 0);
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiPdfPreviewComponent, deps: [{ token: i1.StiModelService }, { token: i2.DomSanitizer }, { token: i3.StiHttpClientService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiPdfPreviewComponent, selector: "sti-pdf-preview", ngImport: i0, template: ` <embed *ngIf="src" [src]="src" style="width: 100%;height: 100%" type="application/pdf" /> `, isInline: true, styles: [""], dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiPdfPreviewComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-pdf-preview", template: ` <embed *ngIf="src" [src]="src" style="width: 100%;height: 100%" type="application/pdf" /> ` }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.DomSanitizer }, { type: i3.StiHttpClientService }] });
//# sourceMappingURL=data:application/json;base64,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